<!-- Stats Cards Row 1 - Key Metrics -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 lg:gap-6 mb-6 w-full">
    <!-- Card 1: Total Penjualan -->
    <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-blue-100 text-sm font-medium">Total Penjualan</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-dollar-sign text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2">Rp <?php echo e(number_format($stats['total_sales'] ?? 0, 0, ',', '.')); ?></h3>
            <div class="flex items-center text-sm">
                <span class="bg-white/20 px-2 py-1 rounded-md mr-2">
                    <i class="fas fa-arrow-<?php echo e(($stats['sales_growth'] ?? 0) >= 0 ? 'up' : 'down'); ?> text-xs"></i>
                </span>
                <span class="text-blue-100"><?php echo e(abs($stats['sales_growth'] ?? 0)); ?>% dari bulan lalu</span>
            </div>
        </div>
    </div>

    <!-- Card 2: Total Pembelian -->
    <div class="bg-gradient-to-br from-green-500 to-green-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-green-100 text-sm font-medium">Total Pembelian</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-shopping-cart text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2">Rp <?php echo e(number_format($stats['total_purchases'] ?? 0, 0, ',', '.')); ?></h3>
            <div class="flex items-center text-sm">
                <span class="bg-white/20 px-2 py-1 rounded-md mr-2">
                    <i class="fas fa-arrow-<?php echo e(($stats['purchases_growth'] ?? 0) >= 0 ? 'up' : 'down'); ?> text-xs"></i>
                </span>
                <span class="text-green-100"><?php echo e(abs($stats['purchases_growth'] ?? 0)); ?>% dari bulan lalu</span>
            </div>
        </div>
    </div>

    <!-- Card 3: Total Order -->
    <div class="bg-gradient-to-br from-orange-500 to-orange-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-orange-100 text-sm font-medium">Total Order</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-clipboard-list text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2"><?php echo e($stats['total_orders'] ?? 0); ?></h3>
            <div class="flex items-center text-sm">
                <span class="bg-white/20 px-2 py-1 rounded-md mr-2">
                    <i class="fas fa-arrow-<?php echo e(($stats['orders_growth'] ?? 0) >= 0 ? 'up' : 'down'); ?> text-xs"></i>
                </span>
                <span class="text-orange-100"><?php echo e(abs($stats['orders_growth'] ?? 0)); ?>% dari bulan lalu</span>
            </div>
        </div>
    </div>

    <!-- Card 4: Stock Alert -->
    <div class="bg-gradient-to-br from-red-500 to-red-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-red-100 text-sm font-medium">Stock Alert</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-exclamation-triangle text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2"><?php echo e($stats['total_low_stock'] ?? 0); ?></h3>
            <div class="flex items-center gap-3 text-sm">
                <span class="text-red-100">Materials: <?php echo e($stats['low_stock_materials'] ?? 0); ?></span>
                <span class="text-red-200">•</span>
                <span class="text-red-100">Spareparts: <?php echo e($stats['low_stock_spareparts'] ?? 0); ?></span>
            </div>
        </div>
    </div>
</div>

<!-- Additional Stats Cards Row 2 -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 lg:gap-6 mb-6">
    <!-- Card 5: Total Produk -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Total Produk</p>
            <div class="bg-purple-100 dark:bg-purple-900/30 rounded-lg p-2.5">
                <i class="fas fa-box text-purple-600 dark:text-purple-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2"><?php echo e($stats['total_products'] ?? 0); ?></h3>
        <div class="flex items-center text-sm">
            <span class="px-2 py-1 rounded-md mr-2 <?php echo e(($stats['products_growth'] ?? 0) >= 0 ? 'bg-green-100 text-green-700 dark:bg-green-900/30 dark:text-green-400' : 'bg-red-100 text-red-700 dark:bg-red-900/30 dark:text-red-400'); ?>">
                <i class="fas fa-arrow-<?php echo e(($stats['products_growth'] ?? 0) >= 0 ? 'up' : 'down'); ?> text-xs"></i>
            </span>
            <span class="text-gray-500 dark:text-gray-400"><?php echo e(abs($stats['products_growth'] ?? 0)); ?>% dari bulan lalu</span>
        </div>
    </div>

    <!-- Card 6: Produksi Aktif -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Produksi Aktif</p>
            <div class="bg-indigo-100 dark:bg-indigo-900/30 rounded-lg p-2.5">
                <i class="fas fa-cogs text-indigo-600 dark:text-indigo-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2"><?php echo e($stats['active_productions'] ?? 0); ?></h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">
            Sedang dalam proses pengerjaan
        </p>
    </div>

    <!-- Card 7: Piutang -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Total Piutang</p>
            <div class="bg-yellow-100 dark:bg-yellow-900/30 rounded-lg p-2.5">
                <i class="fas fa-file-invoice-dollar text-yellow-600 dark:text-yellow-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">Rp <?php echo e(number_format($stats['total_receivable_amount'] ?? 0, 0, ',', '.')); ?></h3>
        <p class="text-sm <?php echo e(($stats['overdue_receivables'] ?? 0) > 0 ? 'text-red-600 dark:text-red-400' : 'text-gray-500 dark:text-gray-400'); ?>">
            Jatuh tempo: <span class="font-semibold"><?php echo e($stats['overdue_receivables'] ?? 0); ?></span>
        </p>
    </div>

    <!-- Card 8: Nilai Inventory -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Nilai Inventory</p>
            <div class="bg-teal-100 dark:bg-teal-900/30 rounded-lg p-2.5">
                <i class="fas fa-warehouse text-teal-600 dark:text-teal-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">Rp <?php echo e(number_format($stats['total_inventory_value'] ?? 0, 0, ',', '.')); ?></h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">
            Materials & Spareparts
        </p>
    </div>
</div>

<!-- Alert Card - Menunggu Konfirmasi Customer -->
<?php if(($stats['completed_production_pending_confirmation'] ?? 0) > 0): ?>
<div class="mb-6">
    <div class="bg-gradient-to-r from-amber-500 to-orange-500 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-40 h-40 bg-white/10 rounded-full -mr-20 -mt-20"></div>
        <div class="absolute bottom-0 left-0 w-32 h-32 bg-white/5 rounded-full -ml-16 -mb-16"></div>
        <div class="relative z-10 flex items-center justify-between">
            <div class="flex-1">
                <div class="flex items-center mb-3">
                    <div class="bg-white/20 rounded-lg p-2.5 mr-3">
                        <i class="fas fa-exclamation-triangle text-white text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold mb-1">Menunggu Konfirmasi Customer</h3>
                        <p class="text-amber-100 text-sm">Produksi selesai, menunggu konfirmasi customer</p>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <div>
                        <p class="text-3xl font-bold mb-1"><?php echo e($stats['completed_production_pending_confirmation'] ?? 0); ?></p>
                        <p class="text-amber-100 text-xs">Order menunggu</p>
                    </div>
                    <a href="<?php echo e(route('admin.handover.index')); ?>" 
                       class="inline-flex items-center px-4 py-2 bg-white/20 hover:bg-white/30 rounded-lg font-medium text-sm transition-colors backdrop-blur-sm">
                        <span>Lihat Detail</span>
                        <i class="fas fa-arrow-right ml-2 text-xs"></i>
                    </a>
                </div>
            </div>
            <div class="hidden lg:block ml-6">
                <div class="bg-white/20 rounded-full p-6 backdrop-blur-sm">
                    <i class="fas fa-hourglass-half text-white text-4xl"></i>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/partials/dashboard-stats-cards.blade.php ENDPATH**/ ?>