

<?php $__env->startSection('content'); ?>
    <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
        <!-- Mobile Filter Toggle Button -->
        <div class="lg:hidden mb-4">
            <button onclick="toggleMobileFilter()" id="mobileFilterToggle"
                class="w-full bg-blue-600 hover:bg-blue-700 text-white font-medium py-3 px-4 rounded-lg transition duration-200 flex items-center justify-between shadow-md">
                <span class="flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z">
                        </path>
                    </svg>
                    Filter Produk
                </span>
                <svg id="filterToggleIcon" class="w-5 h-5 transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                </svg>
            </button>
        </div>

        <div class="flex flex-col lg:flex-row gap-4 sm:gap-6">
            <!-- Sidebar Filter -->
            <div id="mobileFilterSidebar" x-data="{ open: true }" class="w-full lg:w-1/4 hidden lg:block">
                <div class="bg-white rounded-lg border border-gray-200 shadow-sm lg:sticky lg:top-20">
                    <!-- Filter Header dengan Toggle (Desktop Only) -->
                    <button @click="open = !open" class="hidden lg:flex w-full px-5 py-4 items-center justify-between border-b border-gray-200 hover:bg-gray-50 transition-colors rounded-t-lg">
                        <h5 class="text-base font-semibold text-gray-900 flex items-center gap-2">
                            <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z">
                                </path>
                            </svg>
                            Filter Produk
                        </h5>
                        <svg class="w-4 h-4 text-gray-500 transition-transform duration-200" :class="open ? 'rotate-180' : ''" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>

                    <!-- Filter Content (Collapsible) -->
                    <div x-show="open" x-collapse class="p-5 lg:max-h-[calc(100vh-12rem)] overflow-y-auto custom-scrollbar">

                        <form id="filterForm" method="GET" action="<?php echo e(route('best-selling')); ?>">
                            <!-- Filter Kategori -->
                            <div class="mb-5" x-data="{ categoryOpen: true }">
                                <button type="button" @click="categoryOpen = !categoryOpen" class="w-full flex items-center justify-between mb-3 py-2">
                                    <h6 class="text-sm font-semibold text-gray-900 flex items-center gap-2">
                                        <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                        </svg>
                                        Kategori Produk
                                    </h6>
                                    <svg class="w-4 h-4 text-gray-400 transition-transform duration-200" :class="categoryOpen ? 'rotate-180' : ''" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                <div x-show="categoryOpen" x-collapse class="space-y-1.5">
                                <!-- Semua Kategori -->
                                <label class="flex items-center cursor-pointer hover:bg-blue-50 p-2.5 rounded-md transition-colors duration-150 group">
                                    <input type="radio" name="category" value=""
                                        <?php echo e(request('category') == '' ? 'checked' : ''); ?>

                                        class="w-4 h-4 text-blue-600 focus:ring-2 focus:ring-blue-500 border-gray-300">
                                    <span class="ml-3 text-sm text-gray-700 font-medium group-hover:text-blue-600 transition-colors">
                                        Semua Kategori
                                    </span>
                                </label>

                                <!-- Kategori Dikelompokkan berdasarkan Parent -->
                                <?php $__currentLoopData = $parentCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $parentSubCategories = $subCategories->where('parent_id', $parent->id);
                                    ?>
                                    
                                    <!-- Parent Category (Clickable) -->
                                    <div>
                                        <label class="flex items-center cursor-pointer hover:bg-blue-50 p-2.5 rounded-md transition-colors duration-150 group">
                                            <input type="radio" name="category" value="<?php echo e($parent->id); ?>"
                                                <?php echo e(request('category') == $parent->id ? 'checked' : ''); ?>

                                                class="w-4 h-4 text-blue-600 focus:ring-2 focus:ring-blue-500 border-gray-300">
                                            <span class="ml-3 text-sm text-gray-700 font-medium group-hover:text-blue-600 transition-colors flex items-center gap-2 flex-1">
                                                <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-6l-2-2H5a2 2 0 00-2 2z"></path>
                                                </svg>
                                                <span class="flex-1"><?php echo e($parent->name); ?></span>
                                                <?php if(isset($parent->total_product_count) && $parent->total_product_count > 0): ?>
                                                    <span class="text-xs bg-blue-100 text-blue-700 px-2 py-0.5 rounded font-medium">
                                                        <?php echo e($parent->total_product_count); ?>  
                                                    </span>
                                                <?php endif; ?>
                                            </span>
                                        </label>
                                    </div>

                                    <?php if($parent->children && $parent->children->count() > 0): ?>
                                        <!-- Sub Categories -->
                                        <div x-data="{ open: <?php echo e(request('category') == $parent->id || $parent->children->contains('id', request('category')) ? 'true' : 'false'); ?> }" class="ml-7 mt-1 space-y-1">
                                            <button type="button" @click="open = !open" class="w-full flex items-center justify-between text-left py-1.5 px-2 hover:bg-gray-50 rounded transition-colors duration-150">
                                                <span class="text-xs text-gray-500 flex items-center gap-1.5">
                                                    <svg class="w-3 h-3 transition-transform duration-200" :class="open ? 'rotate-180' : ''" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                                    </svg>
                                                    <span>Sub Kategori (<?php echo e($parent->children->count()); ?>)</span>
                                                </span>
                                            </button>
                                            <div x-show="open" x-collapse class="space-y-1 ml-1">
                                                <?php $__currentLoopData = $parent->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <label class="flex items-center cursor-pointer hover:bg-blue-50 p-2 rounded-md transition-colors duration-150 group">
                                                        <input type="radio" name="category" value="<?php echo e($subCategory->id); ?>"
                                                            <?php echo e(request('category') == $subCategory->id ? 'checked' : ''); ?>

                                                            class="w-4 h-4 text-blue-600 focus:ring-2 focus:ring-blue-500 border-gray-300">
                                                        <span class="ml-3 text-sm text-gray-600 group-hover:text-blue-600 transition-colors flex items-center gap-2 flex-1">
                                                            <span class="flex-1"><?php echo e($subCategory->name); ?></span>
                                                            <?php if(isset($subCategory->product_count) && $subCategory->product_count > 0): ?>
                                                                <span class="text-xs text-gray-400">
                                                                    (<?php echo e($subCategory->product_count); ?>)
                                                                </span>
                                                            <?php endif; ?>
                                                        </span>
                                                    </label>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>

                            <!-- Filter Harga -->
                            <div class="mb-5" x-data="{ priceOpen: true }">
                                <button type="button" @click="priceOpen = !priceOpen" class="w-full flex items-center justify-between mb-3 py-2">
                                    <h6 class="text-sm font-semibold text-gray-900 flex items-center gap-2">
                                        <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                        </svg>
                                        Rentang Harga
                                    </h6>
                                    <svg class="w-4 h-4 text-gray-400 transition-transform duration-200" :class="priceOpen ? 'rotate-180' : ''" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                <div x-show="priceOpen" x-collapse class="space-y-3">
                                <div>
                                    <label class="block text-xs font-medium text-gray-700 mb-1.5">Harga Minimum</label>
                                    <div class="relative">
                                        <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500 text-sm">Rp</span>
                                        <input type="number" name="min_price" placeholder="0"
                                            value="<?php echo e(request('min_price')); ?>"
                                            class="w-full pl-10 pr-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-sm transition-colors">
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-700 mb-1.5">Harga Maksimum</label>
                                    <div class="relative">
                                        <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500 text-sm">Rp</span>
                                        <input type="number" name="max_price" placeholder="Tidak terbatas"
                                            value="<?php echo e(request('max_price')); ?>"
                                            class="w-full pl-10 pr-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-sm transition-colors">
                                    </div>
                                </div>
                                </div>
                            </div>

                            <!-- Tombol Apply Filter -->
                            <div class="space-y-2 pt-4 border-t border-gray-200">
                                <button type="submit"
                                    class="w-full bg-blue-600 hover:bg-blue-700 text-white font-medium py-2.5 px-4 rounded-md transition-colors duration-150 flex items-center justify-center gap-2 shadow-sm hover:shadow">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                    <span>Terapkan Filter</span>
                                </button>
                                <a href="<?php echo e(route('best-selling')); ?>"
                                    class="w-full border border-gray-300 hover:border-gray-400 hover:bg-gray-50 text-gray-700 font-medium py-2.5 px-4 rounded-md transition-colors duration-150 flex items-center justify-center gap-2">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                    </svg>
                                    <span>Reset Semua</span>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="w-full lg:w-3/4">
                <!-- Header & Search -->
                <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-3 sm:gap-4 mb-4 sm:mb-6">
                    <div>
                        <h4 class="text-xl sm:text-2xl font-bold text-gray-800 mb-1">Produk Terlaris</h4>
                        <span class="text-sm sm:text-base text-gray-500"><?php echo e($totalItems); ?> produk terlaris ditemukan</span>
                    </div>

                    <!-- Search Bar -->
                    <div class="w-full md:w-80">
                        <form method="GET" action="<?php echo e(route('best-selling')); ?>">
                            <?php $__currentLoopData = request()->except('search'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="relative">
                                <input type="text" name="search" placeholder="Cari produk..."
                                    value="<?php echo e(request('search')); ?>"
                                    class="w-full pl-10 pr-4 py-2 text-sm sm:text-base border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <svg class="absolute left-3 top-2.5 w-5 h-5 text-gray-400" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                </svg>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Active Filters -->
                <div class="flex flex-wrap gap-2 mb-4 sm:mb-6">
                    <?php if(request('category')): ?>
                        <?php
                            $selectedCategoryId = request('category');
                            $selectedCategory = $subCategories->firstWhere('id', $selectedCategoryId) 
                                ?? $parentCategories->firstWhere('id', $selectedCategoryId);
                        ?>
                        <?php if($selectedCategory): ?>
                            <span class="inline-flex items-center gap-1.5 px-3 py-1.5 bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-200 rounded-full text-sm font-medium">
                                <i class="fas fa-tag text-xs"></i>
                                <?php if($selectedCategory->parent): ?>
                                    <span class="text-blue-600 dark:text-blue-300"><?php echo e($selectedCategory->parent->name); ?></span>
                                    <span class="text-blue-400">›</span>
                                <?php endif; ?>
                                <span><?php echo e($selectedCategory->name); ?></span>
                                <a href="<?php echo e(route('best-selling', request()->except('category'))); ?>" class="hover:text-blue-900 dark:hover:text-blue-100 ml-1">
                                    <i class="fas fa-times text-xs"></i>
                                </a>
                            </span>
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php if(request('search')): ?>
                        <span
                            class="inline-flex items-center gap-1 px-3 py-1 bg-cyan-100 text-cyan-800 rounded-full text-sm">
                            "<?php echo e(request('search')); ?>"
                            <a href="<?php echo e(route('best-selling', request()->except('search'))); ?>" class="hover:text-cyan-900">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M6 18L18 6M6 6l12 12"></path>
                                </svg>
                            </a>
                        </span>
                    <?php endif; ?>

                    <?php if(request('min_price') || request('max_price')): ?>
                        <span
                            class="inline-flex items-center gap-1 px-3 py-1 bg-gray-100 text-gray-800 rounded-full text-sm">
                            Harga:
                            <?php echo e(request('min_price') ? 'Rp ' . number_format(request('min_price'), 0, ',', '.') : '0'); ?>

                            -
                            <?php echo e(request('max_price') ? 'Rp ' . number_format(request('max_price'), 0, ',', '.') : '∞'); ?>

                            <a href="<?php echo e(route('best-selling', request()->except(['min_price', 'max_price']))); ?>"
                                class="hover:text-gray-900">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M6 18L18 6M6 6l12 12"></path>
                                </svg>
                            </a>
                        </span>
                    <?php endif; ?>
                </div>

                <?php if($products->count() > 0): ?>
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-3 sm:gap-4 mb-6 sm:mb-8">
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="product-card-wrapper group">
                                <a href="<?php echo e(route('product_details', $product->id)); ?>" class="block">
                                    <div
                                        class="bg-white border border-gray-200 overflow-hidden rounded-lg shadow-md hover:shadow-xl transition-shadow duration-300 flex flex-col h-full">
                                        <!-- Product Image -->
                                        <div class="relative aspect-square overflow-hidden bg-white flex-shrink-0">
                                            <?php if($product->product_image): ?>
                                                <img src="<?php echo e(asset('uploads/products/' . $product->product_image)); ?>"
                                                    alt="<?php echo e($product->product_title); ?>"
                                                    class="product-image w-full h-full object-contain shadow-inner">
                                            <?php elseif($product->images->isNotEmpty()): ?>
                                                <img src="<?php echo e(asset('uploads/products/' . $product->images->first()->image_path)); ?>"
                                                    alt="<?php echo e($product->product_title); ?>"
                                                    class="product-image w-full h-full object-contain shadow-inner">
                                            <?php else: ?>
                                                <div class="w-full h-full flex items-center justify-center bg-gray-100">
                                                    <i class="fas fa-image text-gray-400 text-4xl"></i>
                                                </div>
                                            <?php endif; ?>

                                            <!-- TERLARIS Badge -->
                                            <div class="absolute top-2 left-2 z-10">
                                                <span class="bg-red-600 text-white text-xs font-bold px-2 py-1 rounded">TERLARIS</span>
                                            </div>
                                        </div>

                                        <!-- Product Info -->
                                        <div class="p-2 sm:p-3 flex-1 flex flex-col">
                                            <!-- Product Name -->
                                            <h3 class="product-title text-xs sm:text-sm font-semibold text-gray-800 mb-0.5 sm:mb-1 line-clamp-2 min-h-[2rem] sm:min-h-[2.5rem]">
                                                <?php echo e($product->product_title); ?>

                                            </h3>

                                            <!-- Category -->
                                            <?php if($product->category): ?>
                                                <p class="text-[10px] sm:text-xs text-gray-500 mb-0.5 sm:mb-1"><?php echo e($product->category->name); ?></p>
                                            <?php endif; ?>

                                            <!-- Price -->
                                            <div class="mt-0.5 sm:mt-1 mb-0.5 sm:mb-1">
                                                <p class="text-sm sm:text-base md:text-lg font-bold text-blue-600">
                                                    Rp<?php echo e(number_format($product->product_prices ?? 0, 0, ',', '.')); ?>

                                                </p>
                                            </div>

                                            <!-- Sold Count (Selalu ditampilkan untuk konsistensi tinggi card) -->
                                            <div class="flex items-center gap-1 sm:gap-2 text-[10px] sm:text-xs mt-auto">
                                                <span class="text-gray-500">Terjual:</span>
                                                <span class="font-medium text-green-600">
                                                    <?php echo e($product->sold_count ?? 0); ?> unit
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Pagination -->
                    <div class="flex justify-center mt-8 product-pagination">
                        <?php echo e($products->links()); ?>

                    </div>
                <?php else: ?>
                    <!-- No Products Found -->
                    <div class="text-center py-16">
                        <svg class="mx-auto w-24 h-24 text-gray-300 mb-4" fill="none" stroke="currentColor"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4">
                            </path>
                        </svg>
                        <h5 class="text-xl font-semibold text-gray-700 mb-2">Tidak ada produk terlaris ditemukan</h5>
                        <p class="text-gray-500 mb-6">Coba ubah filter atau kata kunci pencarian Anda</p>
                        <a href="<?php echo e(route('best-selling')); ?>"
                            class="inline-block bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-6 rounded-lg transition duration-200">
                            Lihat Semua Produk Terlaris
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <style>
        /* Style pagination - memastikan konsistensi */
        .product-pagination nav {
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        /* Halaman aktif sudah menggunakan bg-blue-600 di template */
        .product-pagination a:hover {
            background-color: #f9fafb;
        }

        /* Custom Scrollbar untuk filter kategori */
        .custom-scrollbar::-webkit-scrollbar {
            width: 6px;
        }

        .custom-scrollbar::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 10px;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 10px;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }

        /* Dark mode scrollbar */
        .dark .custom-scrollbar::-webkit-scrollbar-track {
            background: #374151;
        }

        .dark .custom-scrollbar::-webkit-scrollbar-thumb {
            background: #4b5563;
        }

        .dark .custom-scrollbar::-webkit-scrollbar-thumb:hover {
            background: #6b7280;
        }
    </style>

    <script>
        // Toggle Mobile Filter
        function toggleMobileFilter() {
            const sidebar = document.getElementById('mobileFilterSidebar');
            const icon = document.getElementById('filterToggleIcon');
            
            if (sidebar.classList.contains('hidden')) {
                sidebar.classList.remove('hidden');
                icon.style.transform = 'rotate(180deg)';
            } else {
                sidebar.classList.add('hidden');
                icon.style.transform = 'rotate(0deg)';
            }
        }

        // Close mobile filter saat submit (opsional)
        function closeMobileFilterOnSubmit() {
            if (window.innerWidth < 1024) { // lg breakpoint
                setTimeout(() => {
                    const sidebar = document.getElementById('mobileFilterSidebar');
                    const icon = document.getElementById('filterToggleIcon');
                    if (sidebar && !sidebar.classList.contains('hidden')) {
                        sidebar.classList.add('hidden');
                        icon.style.transform = 'rotate(0deg)';
                    }
                }, 300);
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            // Auto submit filter saat kategori berubah
            const categoryInputs = document.querySelectorAll('input[name="category"]');
            categoryInputs.forEach(input => {
                input.addEventListener('change', function() {
                    document.getElementById('filterForm').submit();
                    closeMobileFilterOnSubmit();
                });
            });

            // Auto submit filter saat harga berubah (dengan delay)
            const priceInputs = document.querySelectorAll('input[name="min_price"], input[name="max_price"]');
            let timeout;
            priceInputs.forEach(input => {
                input.addEventListener('input', function() {
                    clearTimeout(timeout);
                    timeout = setTimeout(() => {
                        document.getElementById('filterForm').submit();
                        closeMobileFilterOnSubmit();
                    }, 1000);
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/home/best-selling.blade.php ENDPATH**/ ?>