

<?php $__env->startSection('title', 'Detail Produk'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="<?php echo e(route('admin.master.products.index')); ?>" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Detail Produk Jasa</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5"><?php echo e($product->product_title); ?></p>
            </div>
        </div>
        <div class="flex items-center space-x-2">
            <a href="<?php echo e(route('admin.master.products.preview-template', $product->id)); ?>" target="_blank"
                class="flex items-center justify-center px-4 py-2 bg-purple-500 hover:bg-purple-600 text-white font-medium rounded-lg transition-colors duration-200">
                <i class="fas fa-file-pdf mr-2 text-sm"></i>
                <span>Preview</span>
            </a>
            <a href="<?php echo e(route('admin.master.products.export-template', $product->id)); ?>"
                class="flex items-center justify-center px-4 py-2 bg-gray-500 hover:bg-gray-600 text-white font-medium rounded-lg transition-colors duration-200">
                <i class="fas fa-file-download mr-2 text-sm"></i>
                <span>Download PDF</span>
            </a>
            <a href="<?php echo e(route('admin.master.products.edit', $product->id)); ?>"
                class="flex items-center justify-center px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                <i class="fas fa-edit mr-2 text-sm"></i>
                <span>Edit</span>
            </a>
        </div>
    </div>

    <!-- Main Product Card -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300 shadow-sm">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 p-4">
            <!-- Left Side: Image Gallery -->
            <div class="lg:col-span-1">
                <div class="space-y-3">
                    <!-- Main Image -->
                    <div class="relative group">
                        <div class="rounded-lg overflow-hidden bg-gray-50 dark:bg-gray-700/50 border-2 border-gray-200 dark:border-gray-600 flex items-center justify-center transition-all duration-200" style="min-height: 300px; max-height: 380px;">
                            <?php if($product->product_image && file_exists(public_path('uploads/products/' . $product->product_image))): ?>
                                <img src="<?php echo e(asset('uploads/products/' . $product->product_image)); ?>"
                                    alt="<?php echo e($product->product_title); ?>" id="mainImage"
                                    class="max-w-full max-h-full w-auto h-auto object-contain transition-transform duration-300 group-hover:scale-105" 
                                    style="background: transparent; padding: 1rem;">
                            <?php else: ?>
                                <div class="flex flex-col items-center justify-center h-64 text-gray-400 dark:text-gray-500">
                                    <i class="fas fa-image text-3xl mb-2 opacity-50"></i>
                                    <span class="text-xs font-medium">Tidak ada gambar</span>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Image Counter -->
                        <?php
                            $totalImages = ($product->images && $product->images->count() > 0) ? $product->images->count() + 1 : (($product->product_image) ? 1 : 0);
                        ?>
                        <?php if($totalImages > 1): ?>
                            <div class="absolute top-3 right-3 bg-gradient-to-r from-blue-600 to-indigo-600 text-white px-3 py-1.5 rounded-full text-xs font-semibold shadow-lg flex items-center gap-1.5">
                                <i class="fas fa-images text-xs"></i>
                                <span><?php echo e($totalImages); ?> gambar</span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Thumbnail Gallery -->
                    <?php if($totalImages > 1): ?>
                        <div class="space-y-2">
                            <h3 class="text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wide flex items-center gap-2">
                                <i class="fas fa-th text-blue-600 dark:text-blue-400"></i>
                                Galeri Gambar
                            </h3>
                            <div class="overflow-x-auto pb-2 scrollbar-thin scrollbar-thumb-gray-300 scrollbar-track-gray-100 dark:scrollbar-thumb-gray-600 dark:scrollbar-track-gray-800">
                                <div class="flex gap-2 min-w-max">
                                    <!-- Gambar Utama sebagai Thumbnail -->
                                    <?php if($product->product_image && file_exists(public_path('uploads/products/' . $product->product_image))): ?>
                                        <div class="flex-shrink-0 aspect-square w-20 h-20 rounded-lg overflow-hidden border-2 border-blue-500 dark:border-blue-400 shadow-md transition-all duration-200 cursor-pointer thumbnail-item active group"
                                            onclick="changeMainImage('<?php echo e(asset('uploads/products/' . $product->product_image)); ?>', this)"
                                            data-image-src="<?php echo e(asset('uploads/products/' . $product->product_image)); ?>">
                                            <img src="<?php echo e(asset('uploads/products/' . $product->product_image)); ?>"
                                                alt="Gambar Utama"
                                                class="w-full h-full object-contain bg-gray-50 dark:bg-gray-700/50 p-1 group-hover:scale-110 transition-transform duration-200">
                                        </div>
                                    <?php endif; ?>
                                    
                                    <!-- Gambar Tambahan - Tampilkan SEMUA -->
                                    <?php if($product->images && $product->images->count() > 0): ?>
                                        <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(file_exists(public_path('uploads/products/' . $image->image_path))): ?>
                                                <div class="flex-shrink-0 aspect-square w-20 h-20 rounded-lg overflow-hidden border-2 border-gray-200 dark:border-gray-600 hover:border-blue-500 dark:hover:border-blue-400 shadow-sm transition-all duration-200 cursor-pointer thumbnail-item group"
                                                    onclick="changeMainImage('<?php echo e(asset('uploads/products/' . $image->image_path)); ?>', this)"
                                                    data-image-src="<?php echo e(asset('uploads/products/' . $image->image_path)); ?>">
                                                    <img src="<?php echo e(asset('uploads/products/' . $image->image_path)); ?>"
                                                        alt="Gambar Tambahan"
                                                        class="w-full h-full object-contain bg-gray-50 dark:bg-gray-700/50 p-1 group-hover:scale-110 transition-transform duration-200">
                                                </div>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Right Side: Product Details -->
            <div class="lg:col-span-2 space-y-3">
                <!-- Product Title & Category -->
                <div class="space-y-2 pb-3 border-b border-gray-200 dark:border-gray-700">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900 dark:text-white leading-tight mb-2">
                            <?php echo e($product->product_title); ?>

                        </h2>
                        <div class="flex items-center flex-wrap gap-2">
                            <?php if($product->category): ?>
                            <span class="inline-flex items-center px-3 py-1 rounded-md text-xs font-semibold bg-blue-100 dark:bg-blue-900/40 text-blue-800 dark:text-blue-300 border border-blue-200 dark:border-blue-800">
                                <i class="fas fa-tag mr-1.5 text-xs"></i>
                                <?php echo e($product->category->name); ?>

                            </span>
                            <?php endif; ?>
                            <?php if($product->is_active): ?>
                                <span class="inline-flex items-center px-3 py-1 rounded-md text-xs font-semibold bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-300 border border-green-200 dark:border-green-800">
                                    <i class="fas fa-check-circle mr-1.5 text-xs"></i>
                                    Aktif
                                </span>
                            <?php else: ?>
                                <span class="inline-flex items-center px-3 py-1 rounded-md text-xs font-semibold bg-red-100 dark:bg-red-900/40 text-red-800 dark:text-red-300 border border-red-200 dark:border-red-800">
                                    <i class="fas fa-times-circle mr-1.5 text-xs"></i>
                                    Nonaktif
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Price & Service Fee Section -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                    <div class="bg-gradient-to-br from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 p-3 rounded-lg border-2 border-blue-200 dark:border-blue-800 shadow-sm">
                        <h3 class="text-xs font-semibold text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1.5 flex items-center gap-2">
                            <i class="fas fa-tag text-blue-600 dark:text-blue-400"></i>
                            Harga Jual Produk
                        </h3>
                        <p class="text-xl font-bold text-gray-900 dark:text-white">
                            Rp <?php echo e(number_format($product->product_prices ?? 0, 0, ',', '.')); ?>

                        </p>
                    </div>
                    <?php if($product->service_fee): ?>
                        <div class="bg-gradient-to-br from-green-50 to-emerald-50 dark:from-green-900/20 dark:to-emerald-900/20 p-3 rounded-lg border-2 border-green-200 dark:border-green-800 shadow-sm">
                            <h3 class="text-xs font-semibold text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1.5 flex items-center gap-2">
                                <i class="fas fa-tools text-green-600 dark:text-green-400"></i>
                                Upah Jasa Pengerjaan
                            </h3>
                            <p class="text-xl font-bold text-green-700 dark:text-green-400">
                                Rp <?php echo e(number_format($product->service_fee, 0, ',', '.')); ?>

                            </p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Description -->
                <?php if($product->product_description): ?>
                    <div class="bg-gray-50 dark:bg-gray-700/50 p-3 rounded-lg border border-gray-200 dark:border-gray-600">
                        <h3 class="text-sm font-semibold text-gray-900 dark:text-white mb-2 flex items-center gap-2">
                            <i class="fas fa-align-left text-gray-600 dark:text-gray-400"></i>
                            Deskripsi Produk
                        </h3>
                        <p class="text-sm text-gray-700 dark:text-gray-300 leading-relaxed"><?php echo e($product->product_description); ?></p>
                    </div>
                <?php endif; ?>

                <!-- Additional Info Cards -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                    <?php if($product->product_work_duration): ?>
                        <div class="bg-gray-50 dark:bg-gray-700/50 p-3 rounded-lg border border-gray-200 dark:border-gray-600">
                            <h4 class="text-xs font-semibold text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1.5 flex items-center gap-2">
                                <i class="far fa-clock text-blue-600 dark:text-blue-400"></i>
                                Estimasi Pengerjaan
                            </h4>
                            <p class="text-sm text-gray-900 dark:text-white font-semibold"><?php echo e($product->product_work_duration); ?></p>
                        </div>
                    <?php endif; ?>

                    <?php if($product->product_garansi): ?>
                        <div class="bg-gray-50 dark:bg-gray-700/50 p-3 rounded-lg border border-gray-200 dark:border-gray-600">
                            <h4 class="text-xs font-semibold text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1.5 flex items-center gap-2">
                                <i class="fas fa-shield-alt text-green-600 dark:text-green-400"></i>
                                Garansi
                            </h4>
                            <p class="text-sm text-gray-900 dark:text-white font-semibold"><?php echo e($product->product_garansi); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Additional Information Sections -->
    <div class="mt-4 space-y-3">
        <!-- Specifications Section -->
        <?php if($product->specifications && $product->specifications->count() > 0): ?>
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300 shadow-sm">
                <div class="bg-gradient-to-r from-orange-50 to-amber-50 dark:from-orange-900/20 dark:to-amber-900/20 px-4 py-3 border-b border-gray-200 dark:border-gray-600">
                    <h3 class="text-sm font-semibold text-gray-900 dark:text-white flex items-center">
                        <i class="fas fa-list-alt mr-2 text-orange-600 dark:text-orange-400"></i>
                        Spesifikasi Produk
                        <span class="ml-2 text-xs font-normal text-gray-500 dark:text-gray-400">(<?php echo e($product->specifications->count()); ?> item)</span>
                    </h3>
                </div>
                <div class="p-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                        <?php $__currentLoopData = $product->specifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-start gap-3 py-2 px-3 bg-gray-50 dark:bg-gray-700/30 rounded-lg border border-gray-200 dark:border-gray-600 hover:bg-gray-100 dark:hover:bg-gray-700/50 transition-colors">
                                <span class="text-sm font-medium text-gray-600 dark:text-gray-400 min-w-[120px] flex-shrink-0"><?php echo e($spec->key); ?>:</span>
                                <span class="text-sm font-semibold text-gray-900 dark:text-white"><?php echo e($spec->value); ?></span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Combined Materials & Spareparts Section -->
        <?php
            // Ambil data real dari database
            $allMaterials = $product->materials && $product->materials->count() > 0 
                ? $product->materials->map(function($m) {
                    return [
                        'item_type' => 'Bahan',
                        'name' => $m->name,
                        'quantity' => $m->quantity,
                        'unit' => $m->unit ?? 'pcs',
                        'type' => $m->type ?? 'material',
                    ];
                })->toArray()
                : [];
            
            $allSpareparts = $product->spareparts && $product->spareparts->count() > 0 
                ? $product->spareparts->map(function($s) {
                    return [
                        'item_type' => 'Sparepart',
                        'name' => $s->name,
                        'quantity' => $s->quantity,
                        'unit' => $s->unit ?? 'pcs',
                        'type' => $s->type ?? 'sparepart',
                    ];
                })->toArray()
                : [];
            
            // Gabungkan semua data
            $allItems = array_merge($allMaterials, $allSpareparts);
        ?>
        
        <?php if(!empty($allItems)): ?>
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300 shadow-sm">
                <div class="bg-gradient-to-r from-blue-50 to-green-50 dark:from-blue-900/20 dark:to-green-900/20 px-4 py-3 border-b border-gray-200 dark:border-gray-600">
                    <h3 class="text-sm font-semibold text-gray-900 dark:text-white flex items-center">
                        <i class="fas fa-boxes mr-2 text-blue-600 dark:text-blue-400"></i>
                        Bahan & Sparepart yang Digunakan
                        <span class="ml-2 text-xs font-normal text-gray-500 dark:text-gray-400">(Total: <?php echo e(count($allItems)); ?> item)</span>
                    </h3>
                </div>
                <div class="p-4">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-600">
                            <thead class="bg-gray-50 dark:bg-gray-700/50">
                                <tr>
                                    <th class="px-3 py-2.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider w-16">
                                        No
                                    </th>
                                    <th class="px-3 py-2.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider w-24">
                                        Tipe
                                    </th>
                                    <th class="px-3 py-2.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">
                                        Nama
                                    </th>
                                    <th class="px-3 py-2.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider w-24">
                                        Jumlah
                                    </th>
                                    <th class="px-3 py-2.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider w-28">
                                        Satuan
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-600">
                                <?php $__currentLoopData = $allItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="hover:bg-blue-50/30 dark:hover:bg-gray-700/80 transition-colors duration-200">
                                        <td class="px-3 py-2.5 text-center text-sm font-medium text-gray-500 dark:text-gray-400">
                                            <?php echo e($index + 1); ?>

                                        </td>
                                        <td class="px-3 py-2.5 text-center">
                                            <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-semibold <?php echo e($item['item_type'] == 'Bahan' ? 'bg-blue-100 dark:bg-blue-900/40 text-blue-800 dark:text-blue-300 border border-blue-200 dark:border-blue-800' : 'bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-300 border border-green-200 dark:border-green-800'); ?>">
                                                <?php echo e($item['item_type']); ?>

                                            </span>
                                        </td>
                                        <td class="px-3 py-2.5 text-sm font-medium text-gray-900 dark:text-gray-100">
                                            <?php echo e($item['name']); ?>

                                        </td>
                                        <td class="px-3 py-2.5 text-sm text-gray-900 dark:text-gray-100 text-center font-semibold">
                                            <?php echo e($item['quantity']); ?>

                                        </td>
                                        <td class="px-3 py-2.5 text-sm text-gray-900 dark:text-gray-100 text-center">
                                            <?php echo e($item['unit']); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<!-- Script untuk mengganti gambar utama saat klik thumbnail -->
<script>
    function changeMainImage(imageSrc, clickedElement) {
        const mainImage = document.getElementById('mainImage');
        if (mainImage && imageSrc) {
            // Update gambar utama dengan fade effect
            mainImage.style.opacity = '0.5';
            setTimeout(() => {
                mainImage.src = imageSrc;
                // Pastikan gambar tidak terpotong
                mainImage.style.maxWidth = '100%';
                mainImage.style.maxHeight = '100%';
                mainImage.style.width = 'auto';
                mainImage.style.height = 'auto';
                mainImage.style.objectFit = 'contain';
                mainImage.style.background = 'transparent';
                mainImage.style.padding = '1rem';
                mainImage.style.opacity = '1';
            }, 150);

            // Update active state pada thumbnail
            const allThumbnails = document.querySelectorAll('.thumbnail-item');
            allThumbnails.forEach(thumb => {
                thumb.classList.remove('active', 'border-blue-500', 'dark:border-blue-400', 'shadow-md');
                thumb.classList.add('border-gray-200', 'dark:border-gray-600');
            });

            // Set thumbnail yang diklik sebagai active
            if (clickedElement) {
                clickedElement.classList.add('active', 'border-blue-500', 'dark:border-blue-400', 'shadow-md');
                clickedElement.classList.remove('border-gray-200', 'dark:border-gray-600');
            }
        }
    }

    // Initialize: Set thumbnail pertama (gambar utama) sebagai active
    document.addEventListener('DOMContentLoaded', function() {
        const firstThumbnail = document.querySelector('.thumbnail-item');
        if (firstThumbnail) {
            firstThumbnail.classList.add('active', 'border-blue-500', 'dark:border-blue-400', 'shadow-md');
            firstThumbnail.classList.remove('border-gray-200', 'dark:border-gray-600');
        }
        
        // Add transition dan pastikan gambar tidak terpotong
        const mainImage = document.getElementById('mainImage');
        if (mainImage) {
            mainImage.style.transition = 'opacity 0.15s ease-in-out, transform 0.3s ease-in-out';
            mainImage.style.maxWidth = '100%';
            mainImage.style.maxHeight = '100%';
            mainImage.style.width = 'auto';
            mainImage.style.height = 'auto';
            mainImage.style.objectFit = 'contain';
            mainImage.style.background = 'transparent';
            mainImage.style.padding = '1rem';
        }
    });
</script>

<style>
    /* Custom Scrollbar untuk thumbnail gallery */
    .scrollbar-thin::-webkit-scrollbar {
        height: 6px;
    }
    .scrollbar-thin::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }
    .scrollbar-thin::-webkit-scrollbar-thumb {
        background: #cbd5e1;
        border-radius: 10px;
    }
    .scrollbar-thin::-webkit-scrollbar-thumb:hover {
        background: #94a3b8;
    }
    .dark .scrollbar-thin::-webkit-scrollbar-track {
        background: #374151;
    }
    .dark .scrollbar-thin::-webkit-scrollbar-thumb {
        background: #4b5563;
    }
    .dark .scrollbar-thin::-webkit-scrollbar-thumb:hover {
        background: #6b7280;
    }
</style>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/master/products/show.blade.php ENDPATH**/ ?>