

<?php $__env->startSection('title', 'My Orders'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen py-6 sm:py-8">
    <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
        <!-- Header -->
        <div class="mb-6 sm:mb-8">
            <div class="flex flex-col md:flex-row md:justify-between md:items-center gap-4">
                <div>
                    <h1 class="text-2xl sm:text-3xl font-bold text-gray-900">Pesanan Saya</h1>
                    <p class="mt-1 text-sm sm:text-base text-gray-600">Riwayat dan status pesanan Anda</p>
                </div>
                <div class="flex gap-2 sm:gap-3">
                    <a href="<?php echo e(route('all')); ?>" 
                        class="inline-flex items-center px-3 sm:px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                        </svg>
                        Belanja Lagi
                    </a>
                </div>
            </div>
        </div>

        <?php if(session('error')): ?>
            <div class="mb-6 p-4 bg-red-50 border-l-4 border-red-500 rounded">
                <div class="flex items-center">
                    <svg class="h-5 w-5 text-red-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                    </svg>
                    <p class="text-sm font-medium text-red-800"><?php echo e(session('error')); ?></p>
                </div>
            </div>
        <?php endif; ?>

        <!-- Search and Filter -->
        <div class="bg-white rounded-lg border border-gray-200 p-4 sm:p-6 mb-6">
            <div class="flex flex-col md:flex-row gap-3 sm:gap-4">
                <div class="flex-1">
                    <div class="relative">
                        <input type="text" id="searchInput" placeholder="Cari ID pesanan, produk, atau informasi lainnya..." 
                            class="w-full pl-10 pr-4 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none">
                        <svg class="absolute left-3 top-2.5 w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                    </div>
                </div>
                <div class="md:w-48">
                    <select id="orderStatusFilter" class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none">
                        <option value="">Semua Status Pesanan</option>
                        <option value="diterima">Diterima</option>
                        <option value="ditolak">Ditolak</option>
                        <option value="menunggu">Menunggu</option>
                    </select>
                </div>
                <div class="md:w-48">
                    <select id="paymentStatusFilter" class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none">
                        <option value="">Semua Status Pembayaran</option>
                        <option value="selesai">Selesai</option>
                        <option value="diproses">Diproses</option>
                        <option value="menunggu_verifikasi">Menunggu Verifikasi</option>
                        <option value="menunggu">Menunggu</option>
                        <option value="gagal">Gagal</option>
                        <option value="dibatalkan">Dibatalkan</option>
                    </select>
                </div>
                <div class="md:w-48">
                    <select id="productionStatusFilter" class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none">
                        <option value="">Semua Status Produksi</option>
                        <option value="selesai">Selesai</option>
                        <option value="dalam_proses">Dalam Proses</option>
                        <option value="menunggu">Menunggu</option>
                        <option value="dibatalkan">Dibatalkan</option>
                    </select>
                </div>
                <div class="md:w-40">
                    <select id="paymentMethodFilter" class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none">
                        <option value="">Semua Metode</option>
                        <option value="transfer">Transfer</option>
                        <option value="midtrans">E-Wallet/QRIS</option>
                        <option value="dp">DP</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Desktop Table View -->
        <div class="hidden lg:block bg-white rounded-lg border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead class="bg-blue-50 border-b border-gray-200">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">No</th>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">ID Pesanan</th>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Produk</th>
                            <th class="px-4 py-3 text-center text-xs font-semibold text-gray-700 uppercase tracking-wider">Qty</th>
                            <th class="px-4 py-3 text-center text-xs font-semibold text-gray-700 uppercase tracking-wider">Total Harga</th>
                            <th class="px-4 py-3 text-center text-xs font-semibold text-gray-700 uppercase tracking-wider">Metode Bayar</th>
                            <th class="px-4 py-3 text-center text-xs font-semibold text-gray-700 uppercase tracking-wider">Status Pesanan</th>
                            <th class="px-4 py-3 text-center text-xs font-semibold text-gray-700 uppercase tracking-wider">Status Pembayaran</th>
                            <th class="px-4 py-3 text-center text-xs font-semibold text-gray-700 uppercase tracking-wider">Status Produksi</th>
                            <th class="px-4 py-3 text-center text-xs font-semibold text-gray-700 uppercase tracking-wider">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50 transition-colors"
                                data-order-id="<?php echo e($order->id); ?>"
                                data-product="<?php echo e(strtolower($order->product->product_title ?? '')); ?>"
                                data-order-status="<?php echo e(strtolower($order->order_status ?? '')); ?>"
                                data-payment-status="<?php echo e(strtolower($order->status ?? '')); ?>"
                                data-production-status="<?php echo e(strtolower($order->production_status ?? '')); ?>"
                                data-payment-method="<?php echo e(strtolower($order->payment_method ?? '')); ?>">
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-900">
                                    <?php echo e($loop->iteration + $orders->firstItem() - 1); ?>

                                </td>
                                <td class="px-4 py-3 whitespace-nowrap">
                                    <span class="text-sm font-semibold text-gray-900">#<?php echo e($order->id); ?></span>
                                </td>
                                <td class="px-4 py-3">
                                    <div class="flex items-center">
                                        <?php if($order->product->product_image ?? false): ?>
                                            <img src="<?php echo e(asset('uploads/products/' . $order->product->product_image)); ?>" 
                                                alt="<?php echo e($order->product->product_title); ?>" 
                                                class="w-12 h-12 rounded-lg object-contain mr-3 bg-gray-50 p-1">
                                        <?php endif; ?>
                                        <span class="text-sm text-gray-900"><?php echo e($order->product->product_title ?? 'N/A'); ?></span>
                                    </div>
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-900 text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        <?php echo e($order->quantity); ?>

                                    </span>
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm font-semibold text-blue-600 text-center">
                                    <?php echo e($order->formatted_total_price); ?>

                                </td>
                                <!-- Metode Pembayaran -->
                                <td class="px-4 py-3 whitespace-nowrap text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                        <?php echo e($order->payment_method === 'transfer' ? 'bg-blue-100 text-blue-800' : 
                                           ($order->payment_method === 'dp' ? 'bg-orange-100 text-orange-800' : 'bg-gray-100 text-gray-800')); ?>">
                                        <?php echo e(ucfirst($order->payment_method)); ?>

                                    </span>
                                </td>
                                <!-- Status Pesanan -->
                                <td class="px-4 py-3 whitespace-nowrap text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                        <?php echo e($order->order_status === 'diterima'
                                            ? 'bg-green-100 text-green-800'
                                            : ($order->order_status === 'ditolak'
                                                ? 'bg-red-100 text-red-800'
                                                : 'bg-yellow-100 text-yellow-800')); ?>">
                                        <?php echo e($order->order_status_label); ?>

                                    </span>
                                </td>
                                <!-- Status Pembayaran -->
                                <td class="px-4 py-3 whitespace-nowrap text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                        <?php echo e($order->status === 'selesai'
                                            ? 'bg-green-100 text-green-800'
                                            : ($order->status === 'gagal'
                                                ? 'bg-red-100 text-red-800'
                                                : ($order->status === 'dibatalkan'
                                                    ? 'bg-gray-100 text-gray-800'
                                                    : 'bg-yellow-100 text-yellow-800'))); ?>">
                                        <?php echo e($order->status_label); ?>

                                    </span>
                                </td>
                                <!-- Status Produksi -->
                                <td class="px-4 py-3 whitespace-nowrap text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                        <?php echo e($order->production_status === 'selesai'
                                            ? 'bg-green-100 text-green-800'
                                            : ($order->production_status === 'dalam_proses'
                                                ? 'bg-blue-100 text-blue-800'
                                                : ($order->production_status === 'dibatalkan'
                                                    ? 'bg-gray-100 text-gray-800'
                                                    : 'bg-yellow-100 text-yellow-800'))); ?>">
                                        <?php echo e($order->production_status_label); ?>

                                    </span>
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-center">
                                    <div class="flex items-center justify-center space-x-1.5">
                                        <!-- Lihat Detail -->
                                        <a href="<?php echo e(route('my.orders.show', $order)); ?>"
                                            class="inline-flex items-center px-2.5 py-1.5 bg-blue-100 text-blue-700 rounded-md hover:bg-blue-200 transition-colors text-xs"
                                            title="Lihat Detail">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                            </svg>
                                        </a>

                                        <!-- Upload / Lihat Bukti untuk Transfer Bank -->
                                        <?php if($order->payment_method === 'transfer'): ?>
                                            <?php
                                                $hasProofFile = !empty($order->proof_file);
                                                $proofExists = false;
                                                if ($hasProofFile) {
                                                    try {
                                                        $proofExists = \Illuminate\Support\Facades\Storage::disk('uploads')->exists($order->proof_file);
                                                    } catch (\Exception $e) {
                                                        $proofExists = false;
                                                    }
                                                }
                                            ?>
                                            <?php if(!$proofExists): ?>
                                                <a href="<?php echo e(route('orders.confirm.form', $order)); ?>"
                                                    class="inline-flex items-center px-2.5 py-1.5 bg-orange-100 text-orange-700 rounded-md hover:bg-orange-200 transition-colors text-xs"
                                                    title="Upload Bukti Pembayaran">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                                    </svg>
                                                </a>
                                            <?php else: ?>
                                                <?php
                                                    try {
                                                        $proofUrl = route('orders.proof', $order->id);
                                                    } catch (\Exception $e) {
                                                        $proofUrl = asset('uploads/' . $order->proof_file);
                                                    }
                                                ?>
                                                <a href="<?php echo e($proofUrl); ?>" target="_blank"
                                                    class="inline-flex items-center px-2.5 py-1.5 bg-green-100 text-green-700 rounded-md hover:bg-green-200 transition-colors text-xs"
                                                    title="Lihat Bukti Pembayaran"
                                                    onclick="return checkProofFile(event, '<?php echo e($proofUrl); ?>');">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                    </svg>
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <!-- Upload / Lihat Bukti untuk DP -->
                                        <?php if($order->payment_method === 'dp'): ?>
                                            <?php
                                                $hasProofFile = !empty($order->proof_file);
                                                $proofExists = false;
                                                if ($hasProofFile) {
                                                    try {
                                                        $proofExists = \Illuminate\Support\Facades\Storage::disk('uploads')->exists($order->proof_file);
                                                    } catch (\Exception $e) {
                                                        $proofExists = false;
                                                    }
                                                }
                                            ?>
                                            <?php if(!$proofExists): ?>
                                                <a href="<?php echo e(route('orders.confirm.form', $order)); ?>"
                                                    class="inline-flex items-center px-2.5 py-1.5 bg-orange-100 text-orange-700 rounded-md hover:bg-orange-200 transition-colors text-xs"
                                                    title="Upload Bukti Pembayaran DP">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                                    </svg>
                                                </a>
                                            <?php else: ?>
                                                <?php
                                                    try {
                                                        $proofUrl = route('orders.proof', $order->id);
                                                    } catch (\Exception $e) {
                                                        $proofUrl = asset('uploads/' . $order->proof_file);
                                                    }
                                                ?>
                                                <a href="<?php echo e($proofUrl); ?>" target="_blank"
                                                    class="inline-flex items-center px-2.5 py-1.5 bg-green-100 text-green-700 rounded-md hover:bg-green-200 transition-colors text-xs"
                                                    title="Lihat Bukti Pembayaran DP"
                                                    onclick="return checkProofFile(event, '<?php echo e($proofUrl); ?>');">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                    </svg>
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <!-- Retry Payment / Change Payment Method untuk Midtrans yang gagal -->
                                        <?php if($order->payment_method === 'midtrans' && $order->status !== 'selesai' && $order->midtrans_status !== 'settlement'): ?>
                                            <button onclick="showPaymentOptions(<?php echo e($order->id); ?>)"
                                                class="inline-flex items-center px-2.5 py-1.5 bg-purple-100 text-purple-700 rounded-md hover:bg-purple-200 transition-colors text-xs"
                                                title="Ulangi Pembayaran / Ganti Metode">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                                </svg>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="10" class="px-6 py-16 text-center">
                                    <svg class="mx-auto w-16 h-16 text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                                    </svg>
                                    <p class="text-base font-medium text-gray-600 mb-3">Belum ada pesanan</p>
                                    <a href="<?php echo e(route('all')); ?>"
                                        class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                                        </svg>
                                        Belanja Sekarang
                                    </a>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Mobile Card View -->
        <div class="lg:hidden space-y-4">
            <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="bg-white rounded-lg border border-gray-200 overflow-hidden"
                    data-order-id="<?php echo e($order->id); ?>"
                    data-product="<?php echo e(strtolower($order->product->product_title ?? '')); ?>"
                    data-order-status="<?php echo e(strtolower($order->order_status ?? '')); ?>"
                    data-payment-status="<?php echo e(strtolower($order->status ?? '')); ?>"
                    data-production-status="<?php echo e(strtolower($order->production_status ?? '')); ?>"
                    data-payment-method="<?php echo e(strtolower($order->payment_method ?? '')); ?>">
                    <!-- Card Header -->
                    <div class="px-4 py-3 bg-blue-50 border-b border-gray-200 flex items-center justify-between">
                        <div class="flex items-center gap-2">
                            <span class="text-xs font-medium text-gray-500">No. <?php echo e($loop->iteration + $orders->firstItem() - 1); ?></span>
                            <span class="text-xs text-gray-400">•</span>
                            <span class="text-sm font-semibold text-gray-900">#<?php echo e($order->id); ?></span>
                        </div>
                        <a href="<?php echo e(route('my.orders.show', $order)); ?>"
                            class="inline-flex items-center px-2 py-1 bg-blue-100 text-blue-700 rounded-md hover:bg-blue-200 transition-colors text-xs">
                            <svg class="w-3.5 h-3.5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                            </svg>
                            Detail
                        </a>
                    </div>

                    <!-- Card Body -->
                    <div class="p-4 space-y-4">
                        <!-- Product Info -->
                        <div class="flex items-start gap-3">
                            <?php if($order->product->product_image ?? false): ?>
                                <img src="<?php echo e(asset('uploads/products/' . $order->product->product_image)); ?>" 
                                    alt="<?php echo e($order->product->product_title); ?>" 
                                    class="w-20 h-20 rounded-lg object-contain bg-gray-50 p-1 flex-shrink-0">
                            <?php endif; ?>
                            <div class="flex-1 min-w-0">
                                <h3 class="text-sm font-semibold text-gray-900 mb-1 line-clamp-2"><?php echo e($order->product->product_title ?? 'N/A'); ?></h3>
                                <div class="flex items-center gap-2 mt-2">
                                    <span class="text-xs text-gray-600">Qty:</span>
                                    <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        <?php echo e($order->quantity); ?>

                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Price & Payment Method -->
                        <div class="grid grid-cols-2 gap-3 pt-3 border-t border-gray-200">
                            <div>
                                <p class="text-xs text-gray-600 mb-1">Total Harga</p>
                                <p class="text-sm font-bold text-blue-600"><?php echo e($order->formatted_total_price); ?></p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-600 mb-1">Metode Bayar</p>
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium 
                                    <?php echo e($order->payment_method === 'transfer' ? 'bg-blue-100 text-blue-800' : 
                                       ($order->payment_method === 'dp' ? 'bg-orange-100 text-orange-800' : 'bg-gray-100 text-gray-800')); ?>">
                                    <?php echo e(ucfirst($order->payment_method)); ?>

                                </span>
                            </div>
                        </div>

                        <!-- Status Info -->
                        <div class="space-y-2 pt-3 border-t border-gray-200">
                            <div class="flex items-center justify-between">
                                <span class="text-xs text-gray-600">Status Pesanan</span>
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                                    <?php echo e($order->order_status === 'diterima'
                                        ? 'bg-green-100 text-green-800'
                                        : ($order->order_status === 'ditolak'
                                            ? 'bg-red-100 text-red-800'
                                            : 'bg-yellow-100 text-yellow-800')); ?>">
                                    <?php echo e($order->order_status_label); ?>

                                </span>
                            </div>
                            <div class="flex items-center justify-between">
                                <span class="text-xs text-gray-600">Status Pembayaran</span>
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                                    <?php echo e($order->status === 'selesai'
                                        ? 'bg-green-100 text-green-800'
                                        : ($order->status === 'gagal'
                                            ? 'bg-red-100 text-red-800'
                                            : ($order->status === 'dibatalkan'
                                                ? 'bg-gray-100 text-gray-800'
                                                : 'bg-yellow-100 text-yellow-800'))); ?>">
                                    <?php echo e($order->status_label); ?>

                                </span>
                            </div>
                            <div class="flex items-center justify-between">
                                <span class="text-xs text-gray-600">Status Produksi</span>
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                                    <?php echo e($order->production_status === 'selesai'
                                        ? 'bg-green-100 text-green-800'
                                        : ($order->production_status === 'dalam_proses'
                                            ? 'bg-blue-100 text-blue-800'
                                            : ($order->production_status === 'dibatalkan'
                                                ? 'bg-gray-100 text-gray-800'
                                                : 'bg-yellow-100 text-yellow-800'))); ?>">
                                    <?php echo e($order->production_status_label); ?>

                                </span>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="flex items-center gap-2 pt-3 border-t border-gray-200">
                            <!-- Upload / Lihat Bukti untuk Transfer Bank -->
                            <?php if($order->payment_method === 'transfer'): ?>
                                <?php
                                    $hasProofFile = !empty($order->proof_file);
                                    $proofExists = false;
                                    if ($hasProofFile) {
                                        try {
                                            $proofExists = \Illuminate\Support\Facades\Storage::disk('uploads')->exists($order->proof_file);
                                        } catch (\Exception $e) {
                                            $proofExists = false;
                                        }
                                    }
                                ?>
                                <?php if(!$proofExists): ?>
                                    <a href="<?php echo e(route('orders.confirm.form', $order)); ?>"
                                        class="flex-1 inline-flex items-center justify-center px-3 py-2 bg-orange-100 text-orange-700 rounded-md hover:bg-orange-200 transition-colors text-xs font-medium">
                                        <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                        </svg>
                                        Upload Bukti
                                    </a>
                                <?php else: ?>
                                    <?php
                                        try {
                                            $proofUrl = route('orders.proof', $order->id);
                                        } catch (\Exception $e) {
                                            $proofUrl = asset('uploads/' . $order->proof_file);
                                        }
                                    ?>
                                    <a href="<?php echo e($proofUrl); ?>" target="_blank"
                                        class="flex-1 inline-flex items-center justify-center px-3 py-2 bg-green-100 text-green-700 rounded-md hover:bg-green-200 transition-colors text-xs font-medium"
                                        onclick="return checkProofFile(event, '<?php echo e($proofUrl); ?>');">
                                        <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                        Lihat Bukti
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>

                            <!-- Upload / Lihat Bukti untuk DP -->
                            <?php if($order->payment_method === 'dp'): ?>
                                <?php
                                    $hasProofFile = !empty($order->proof_file);
                                    $proofExists = false;
                                    if ($hasProofFile) {
                                        try {
                                            $proofExists = \Illuminate\Support\Facades\Storage::disk('uploads')->exists($order->proof_file);
                                        } catch (\Exception $e) {
                                            $proofExists = false;
                                        }
                                    }
                                ?>
                                <?php if(!$proofExists): ?>
                                    <a href="<?php echo e(route('orders.confirm.form', $order)); ?>"
                                        class="flex-1 inline-flex items-center justify-center px-3 py-2 bg-orange-100 text-orange-700 rounded-md hover:bg-orange-200 transition-colors text-xs font-medium">
                                        <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                        </svg>
                                        Upload Bukti DP
                                    </a>
                                <?php else: ?>
                                    <?php
                                        try {
                                            $proofUrl = route('orders.proof', $order->id);
                                        } catch (\Exception $e) {
                                            $proofUrl = asset('uploads/' . $order->proof_file);
                                        }
                                    ?>
                                    <a href="<?php echo e($proofUrl); ?>" target="_blank"
                                        class="flex-1 inline-flex items-center justify-center px-3 py-2 bg-green-100 text-green-700 rounded-md hover:bg-green-200 transition-colors text-xs font-medium"
                                        onclick="return checkProofFile(event, '<?php echo e($proofUrl); ?>');">
                                        <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                        Lihat Bukti
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>

                            <!-- Retry Payment untuk Midtrans -->
                            <?php if($order->payment_method === 'midtrans' && $order->status !== 'selesai' && $order->midtrans_status !== 'settlement'): ?>
                                <button onclick="showPaymentOptions(<?php echo e($order->id); ?>)"
                                    class="flex-1 inline-flex items-center justify-center px-3 py-2 bg-purple-100 text-purple-700 rounded-md hover:bg-purple-200 transition-colors text-xs font-medium">
                                    <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                    </svg>
                                    Ulangi Bayar
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="bg-white rounded-lg border border-gray-200 p-8 text-center">
                    <svg class="mx-auto w-16 h-16 text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                    </svg>
                    <p class="text-base font-medium text-gray-600 mb-3">Belum ada pesanan</p>
                    <a href="<?php echo e(route('all')); ?>"
                        class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                        </svg>
                        Belanja Sekarang
                    </a>
                </div>
            <?php endif; ?>
        </div>

        <!-- Pagination -->
        <?php if($orders->count() > 0): ?>
            <div class="mt-6 flex justify-center">
                <?php echo e($orders->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>

<!-- SweetAlert2 CDN -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- Midtrans Snap JS -->
<?php if(config('midtrans.client_key')): ?>
<script src="<?php echo e(config('midtrans.is_production') ? 'https://app.midtrans.com/snap/snap.js' : 'https://app.sandbox.midtrans.com/snap/snap.js'); ?>" 
        data-client-key="<?php echo e(config('midtrans.client_key')); ?>"
        onerror="console.error('Gagal memuat Midtrans Snap JS')">
</script>
<?php else: ?>
<script>
    console.warn('Midtrans Client Key belum dikonfigurasi');
</script>
<?php endif; ?>

<?php if(session('success')): ?>
    <script>
        Swal.fire({
            title: 'Berhasil!',
            text: '<?php echo e(session('success')); ?>',
            icon: 'success',
            timer: 3000,
            timerProgressBar: true,
            showConfirmButton: false,
            position: 'center',
            allowOutsideClick: false
        });
    </script>
<?php endif; ?>

<?php if(session('error')): ?>
    <script>
        Swal.fire({
            title: 'Error!',
            text: '<?php echo e(session('error')); ?>',
            icon: 'error',
            timer: 3000,
            timerProgressBar: true,
            showConfirmButton: false,
            position: 'center',
            allowOutsideClick: false
        });
    </script>
<?php endif; ?>

<script>
    // Function untuk menangani error saat membuka bukti pembayaran
    function checkProofFile(event, url) {
        // Biarkan link terbuka normal, jika error akan ditangani oleh browser
        // Jika halaman kosong, kemungkinan route tidak ditemukan atau file tidak ada
        return true;
    }

    // Deteksi jika halaman bukti pembayaran kosong setelah dibuka
    window.addEventListener('message', function(event) {
        if (event.data === 'proof_file_error') {
            Swal.fire({
                title: 'File Tidak Ditemukan',
                text: 'Bukti pembayaran tidak dapat dibuka. Pastikan file ada di storage dan symlink sudah dibuat.',
                icon: 'error',
                confirmButtonText: 'OK'
            });
        }
    });

    // Function untuk menampilkan opsi pembayaran
    function showPaymentOptions(orderId) {
        Swal.fire({
            title: 'Opsi Pembayaran',
            text: 'Pilih aksi yang ingin dilakukan',
            icon: 'question',
            showCancelButton: true,
            showDenyButton: true,
            confirmButtonText: '<i class="fas fa-redo mr-2"></i>Ulangi Midtrans',
            denyButtonText: '<i class="fas fa-exchange-alt mr-2"></i>Ganti Metode',
            cancelButtonText: 'Batal',
            confirmButtonColor: '#7c3aed',
            denyButtonColor: '#f59e0b',
            cancelButtonColor: '#6b7280',
        }).then((result) => {
            if (result.isConfirmed) {
                // Retry Midtrans payment
                retryMidtransPayment(orderId);
            } else if (result.isDenied) {
                // Change payment method
                showChangePaymentMethod(orderId);
            }
        });
    }

    // Function untuk retry Midtrans payment
    function retryMidtransPayment(orderId) {
        Swal.fire({
            title: 'Memproses...',
            text: 'Sedang membuat token pembayaran',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        fetch(`/my-orders/${orderId}/retry-midtrans`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success && data.snap_token) {
                Swal.close();
                // Buka Midtrans popup
                if (typeof snap !== 'undefined') {
                    snap.pay(data.snap_token, {
                        onSuccess: function(result) {
                            const orderId = data.order_id || result.order_id;
                            const successUrl = '<?php echo e(route("orders.success", ":id")); ?>'.replace(':id', orderId);
                            window.location.href = successUrl;
                        },
                        onPending: function(result) {
                            const orderId = data.order_id || result.order_id;
                            Swal.fire({
                                title: 'Pembayaran Pending',
                                text: 'Pembayaran sedang diproses. Silakan tunggu konfirmasi.',
                                icon: 'info',
                                confirmButtonText: 'OK'
                            }).then(() => {
                                const successUrl = '<?php echo e(route("orders.success", ":id")); ?>'.replace(':id', orderId);
                                window.location.href = successUrl;
                            });
                        },
                        onError: function(result) {
                            Swal.fire('Error', 'Terjadi kesalahan dalam pembayaran. Silakan coba lagi.', 'error');
                            console.error('Midtrans error:', result);
                        },
                        onClose: function() {
                            Swal.fire({
                                title: 'Ditutup',
                                text: 'Anda menutup pembayaran sebelum selesai.',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                    });
                } else {
                    Swal.fire('Error', 'Midtrans Snap belum dimuat. Silakan refresh halaman.', 'error');
                }
            } else {
                Swal.fire('Error', data.message || 'Gagal membuat token pembayaran', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire('Error', 'Terjadi kesalahan server', 'error');
        });
    }

    // Function untuk menampilkan form ganti metode pembayaran
    function showChangePaymentMethod(orderId) {
        Swal.fire({
            title: 'Ganti Metode Pembayaran',
            html: `
                <div class="text-left">
                    <p class="mb-4 text-sm text-gray-600">Pilih metode pembayaran baru:</p>
                    <div class="space-y-3">
                        <label class="flex items-center p-3 border-2 border-gray-300 rounded-lg cursor-pointer hover:border-blue-500 hover:bg-blue-50 transition-all">
                            <input type="radio" name="payment_method" value="transfer" class="mr-3" checked>
                            <div>
                                <span class="font-medium text-gray-800 block">Transfer Bank</span>
                                <p class="text-xs text-gray-500">BCA, BNI, Mandiri, BRI</p>
                            </div>
                        </label>
                        <label class="flex items-center p-3 border-2 border-gray-300 rounded-lg cursor-pointer hover:border-blue-500 hover:bg-blue-50 transition-all">
                            <input type="radio" name="payment_method" value="midtrans" class="mr-3">
                            <div>
                                <span class="font-medium text-gray-800 block">E-Wallet / QRIS</span>
                                <p class="text-xs text-gray-500">GoPay, OVO, Dana, QRIS</p>
                            </div>
                        </label>
                        <label class="flex items-center p-3 border-2 border-gray-300 rounded-lg cursor-pointer hover:border-orange-500 hover:bg-orange-50 transition-all">
                            <input type="radio" name="payment_method" value="dp" class="mr-3">
                            <div>
                                <span class="font-medium text-gray-800 block">Pembayaran DP</span>
                                <p class="text-xs text-gray-500">Bayar sebagian sekarang</p>
                            </div>
                        </label>
                    </div>
                </div>
            `,
            showCancelButton: true,
            confirmButtonText: 'Ganti',
            cancelButtonText: 'Batal',
            confirmButtonColor: '#f59e0b',
            cancelButtonColor: '#6b7280',
            preConfirm: () => {
                const selectedMethod = document.querySelector('input[name="payment_method"]:checked');
                if (!selectedMethod) {
                    Swal.showValidationMessage('Pilih metode pembayaran');
                    return false;
                }
                return selectedMethod.value;
            }
        }).then((result) => {
            if (result.isConfirmed && result.value) {
                changePaymentMethod(orderId, result.value);
            }
        });
    }

    // Function untuk change payment method
    function changePaymentMethod(orderId, newMethod) {
        Swal.fire({
            title: 'Memproses...',
            text: 'Sedang mengubah metode pembayaran',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        const formData = new FormData();
        formData.append('new_payment_method', newMethod);

        fetch(`/my-orders/${orderId}/change-payment-method`, {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => {
            const contentType = response.headers.get('content-type');
            if (contentType && contentType.includes('application/json')) {
                return response.json();
            } else {
                // Redirect response
                return response.text().then(() => ({ redirect: true, url: response.url }));
            }
        })
        .then(data => {
            if (data.redirect) {
                window.location.href = data.url || '/my-orders';
            } else if (data.success) {
                if (data.snap_token && newMethod === 'midtrans') {
                    // Buka Midtrans popup
                    Swal.close();
                    if (typeof snap !== 'undefined') {
                        snap.pay(data.snap_token, {
                            onSuccess: function(result) {
                                const orderId = data.order_id || result.order_id;
                                const successUrl = '<?php echo e(route("orders.success", ":id")); ?>'.replace(':id', orderId);
                                window.location.href = successUrl;
                            },
                            onPending: function(result) {
                                const orderId = data.order_id || result.order_id;
                                Swal.fire({
                                    title: 'Pembayaran Pending',
                                    text: 'Pembayaran sedang diproses. Silakan tunggu konfirmasi.',
                                    icon: 'info',
                                    confirmButtonText: 'OK'
                                }).then(() => {
                                    const successUrl = '<?php echo e(route("orders.success", ":id")); ?>'.replace(':id', orderId);
                                    window.location.href = successUrl;
                                });
                            },
                            onError: function(result) {
                                Swal.fire('Error', 'Terjadi kesalahan dalam pembayaran. Silakan coba lagi.', 'error');
                                console.error('Midtrans error:', result);
                            },
                            onClose: function() {
                                Swal.fire({
                                    title: 'Ditutup',
                                    text: 'Anda menutup pembayaran sebelum selesai.',
                                    icon: 'warning',
                                    confirmButtonText: 'OK'
                                });
                            }
                        });
                    } else {
                        Swal.fire('Error', 'Midtrans Snap belum dimuat. Silakan refresh halaman.', 'error');
                    }
                } else {
                    Swal.fire('Sukses', data.message || 'Metode pembayaran berhasil diubah', 'success').then(() => {
                        window.location.reload();
                    });
                }
            } else {
                Swal.fire('Error', data.message || 'Gagal mengubah metode pembayaran', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire('Error', 'Terjadi kesalahan server', 'error');
        });
    }

    // Search functionality
    document.getElementById('searchInput').addEventListener('input', function() {
        applyFilters();
    });

    // Filter functionality
    document.getElementById('orderStatusFilter').addEventListener('change', function() {
        applyFilters();
    });

    document.getElementById('paymentStatusFilter').addEventListener('change', function() {
        applyFilters();
    });

    document.getElementById('productionStatusFilter').addEventListener('change', function() {
        applyFilters();
    });

    document.getElementById('paymentMethodFilter').addEventListener('change', function() {
        applyFilters();
    });

    function applyFilters() {
        const searchTerm = document.getElementById('searchInput').value.toLowerCase();
        const orderStatus = document.getElementById('orderStatusFilter').value.toLowerCase();
        const paymentStatus = document.getElementById('paymentStatusFilter').value.toLowerCase();
        const productionStatus = document.getElementById('productionStatusFilter').value.toLowerCase();
        const paymentMethod = document.getElementById('paymentMethodFilter').value.toLowerCase();

        // Filter desktop table rows
        const desktopRows = document.querySelectorAll('tbody tr');
        desktopRows.forEach(row => {
            const orderId = row.dataset.orderId || '';
            const product = row.dataset.product || '';
            const text = row.textContent.toLowerCase();
            
            // Search filter
            const matchesSearch = !searchTerm || 
                text.includes(searchTerm) || 
                orderId.includes(searchTerm) ||
                product.includes(searchTerm);
            
            // Status filters - handle exact match
            const rowOrderStatus = (row.dataset.orderStatus || '').toLowerCase();
            const rowPaymentStatus = (row.dataset.paymentStatus || '').toLowerCase();
            const rowProductionStatus = (row.dataset.productionStatus || '').toLowerCase();
            const rowPaymentMethod = (row.dataset.paymentMethod || '').toLowerCase();
            
            const matchesOrderStatus = !orderStatus || rowOrderStatus === orderStatus;
            const matchesPaymentStatus = !paymentStatus || rowPaymentStatus === paymentStatus;
            const matchesProductionStatus = !productionStatus || rowProductionStatus === productionStatus;
            const matchesPaymentMethod = !paymentMethod || rowPaymentMethod === paymentMethod;

            if (matchesSearch && matchesOrderStatus && matchesPaymentStatus && matchesProductionStatus && matchesPaymentMethod) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });

        // Filter mobile cards
        const mobileCards = document.querySelectorAll('.lg\\:hidden .space-y-4 > div');
        mobileCards.forEach(card => {
            const orderId = card.dataset.orderId || '';
            const product = card.dataset.product || '';
            const text = card.textContent.toLowerCase();
            
            // Search filter
            const matchesSearch = !searchTerm || 
                text.includes(searchTerm) || 
                orderId.includes(searchTerm) ||
                product.includes(searchTerm);
            
            // Status filters - handle exact match
            const cardOrderStatus = (card.dataset.orderStatus || '').toLowerCase();
            const cardPaymentStatus = (card.dataset.paymentStatus || '').toLowerCase();
            const cardProductionStatus = (card.dataset.productionStatus || '').toLowerCase();
            const cardPaymentMethod = (card.dataset.paymentMethod || '').toLowerCase();
            
            const matchesOrderStatus = !orderStatus || cardOrderStatus === orderStatus;
            const matchesPaymentStatus = !paymentStatus || cardPaymentStatus === paymentStatus;
            const matchesProductionStatus = !productionStatus || cardProductionStatus === productionStatus;
            const matchesPaymentMethod = !paymentMethod || cardPaymentMethod === paymentMethod;

            if (matchesSearch && matchesOrderStatus && matchesPaymentStatus && matchesProductionStatus && matchesPaymentMethod) {
                card.style.display = '';
            } else {
                card.style.display = 'none';
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/user/orders/index.blade.php ENDPATH**/ ?>