<!-- Quick Stats & Quick Actions -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-4 lg:gap-6 mb-6">
    <!-- Quick Actions -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-bolt text-yellow-600 dark:text-yellow-400 mr-2"></i>
                Quick Actions
            </h3>
        </div>
        <div class="space-y-3">
            <a href="<?php echo e(route('teknisi.productions.index')); ?>" 
               class="flex items-center justify-between p-4 bg-gradient-to-r from-blue-50 to-blue-100 dark:from-blue-900/20 dark:to-blue-900/10 rounded-lg hover:from-blue-100 hover:to-blue-200 dark:hover:from-blue-900/30 dark:hover:to-blue-900/20 transition-all duration-200 border border-blue-200 dark:border-blue-800 group">
                <div class="flex items-center">
                    <div class="bg-blue-600 dark:bg-blue-700 rounded-lg p-2 mr-3 group-hover:scale-110 transition-transform">
                        <i class="fas fa-cogs text-white text-sm"></i>
                    </div>
                    <div>
                        <p class="font-semibold text-gray-900 dark:text-white text-sm">Produksi Saya</p>
                        <p class="text-xs text-gray-600 dark:text-gray-400"><?php echo e($stats['my_planning_productions'] ?? 0); ?> planning menunggu</p>
                    </div>
                </div>
                <i class="fas fa-chevron-right text-gray-400 group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors"></i>
            </a>
            
            <a href="<?php echo e(route('teknisi.materials.index')); ?>" 
               class="flex items-center justify-between p-4 bg-gradient-to-r from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg hover:from-green-100 hover:to-green-200 dark:hover:from-green-900/30 dark:hover:to-green-900/20 transition-all duration-200 border border-green-200 dark:border-green-800 group">
                <div class="flex items-center">
                    <div class="bg-green-600 dark:bg-green-700 rounded-lg p-2 mr-3 group-hover:scale-110 transition-transform">
                        <i class="fas fa-box text-white text-sm"></i>
                    </div>
                    <div>
                        <p class="font-semibold text-gray-900 dark:text-white text-sm">Stock Bahan</p>
                        <p class="text-xs text-gray-600 dark:text-gray-400">
                            <?php if(($stats['low_stock_materials'] ?? 0) > 0): ?>
                                <span class="text-red-600 dark:text-red-400 font-medium"><?php echo e($stats['low_stock_materials'] ?? 0); ?> bahan kurang</span>
                            <?php else: ?>
                                Stock aman
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
                <i class="fas fa-chevron-right text-gray-400 group-hover:text-green-600 dark:group-hover:text-green-400 transition-colors"></i>
            </a>
            
            <a href="<?php echo e(route('teknisi.spareparts.index')); ?>" 
               class="flex items-center justify-between p-4 bg-gradient-to-r from-purple-50 to-purple-100 dark:from-purple-900/20 dark:to-purple-900/10 rounded-lg hover:from-purple-100 hover:to-purple-200 dark:hover:from-purple-900/30 dark:hover:to-purple-900/20 transition-all duration-200 border border-purple-200 dark:border-purple-800 group">
                <div class="flex items-center">
                    <div class="bg-purple-600 dark:bg-purple-700 rounded-lg p-2 mr-3 group-hover:scale-110 transition-transform">
                        <i class="fas fa-tools text-white text-sm"></i>
                    </div>
                    <div>
                        <p class="font-semibold text-gray-900 dark:text-white text-sm">Stock Sparepart</p>
                        <p class="text-xs text-gray-600 dark:text-gray-400">
                            <?php if(($stats['low_stock_spareparts'] ?? 0) > 0): ?>
                                <span class="text-red-600 dark:text-red-400 font-medium"><?php echo e($stats['low_stock_spareparts'] ?? 0); ?> sparepart kurang</span>
                            <?php else: ?>
                                Stock aman
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
                <i class="fas fa-chevron-right text-gray-400 group-hover:text-purple-600 dark:group-hover:text-purple-400 transition-colors"></i>
            </a>

            <a href="<?php echo e(route('teknisi.quotations.index')); ?>" 
               class="flex items-center justify-between p-4 bg-gradient-to-r from-orange-50 to-orange-100 dark:from-orange-900/20 dark:to-orange-900/10 rounded-lg hover:from-orange-100 hover:to-orange-200 dark:hover:from-orange-900/30 dark:hover:to-orange-900/20 transition-all duration-200 border border-orange-200 dark:border-orange-800 group">
                <div class="flex items-center">
                    <div class="bg-orange-600 dark:bg-orange-700 rounded-lg p-2 mr-3 group-hover:scale-110 transition-transform">
                        <i class="fas fa-calculator text-white text-sm"></i>
                    </div>
                    <div>
                        <p class="font-semibold text-gray-900 dark:text-white text-sm">Estimasi</p>
                        <p class="text-xs text-gray-600 dark:text-gray-400">
                            <?php if(($stats['pending_quotations'] ?? 0) > 0): ?>
                                <span class="text-orange-600 dark:text-orange-400 font-medium"><?php echo e($stats['pending_quotations'] ?? 0); ?> penawaran menunggu</span>
                            <?php else: ?>
                                Tidak ada penawaran baru
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
                <i class="fas fa-chevron-right text-gray-400 group-hover:text-orange-600 dark:group-hover:text-orange-400 transition-colors"></i>
            </a>
        </div>
    </div>

    <!-- Usage Summary -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-chart-line text-indigo-600 dark:text-indigo-400 mr-2"></i>
                Penggunaan Bulan Ini
            </h3>
            <span class="text-xs text-gray-500 dark:text-gray-400"><?php echo e(now()->format('M Y')); ?></span>
        </div>
        <div class="space-y-4">
            <div class="p-4 bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg border border-green-200 dark:border-green-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-medium text-green-700 dark:text-green-300 mb-1 uppercase tracking-wide">Total Biaya Bahan</p>
                    <div class="bg-green-500 rounded-lg p-2">
                        <i class="fas fa-box text-white text-sm"></i>
                    </div>
                </div>
                <p class="text-2xl font-bold text-green-900 dark:text-green-200 mb-1">
                    Rp <?php echo e(number_format($stats['monthly_material_usage'] ?? 0, 0, ',', '.')); ?>

                </p>
                <p class="text-xs text-green-600 dark:text-green-400">Penggunaan bahan baku bulan ini</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-purple-50 to-purple-100 dark:from-purple-900/20 dark:to-purple-900/10 rounded-lg border border-purple-200 dark:border-purple-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-medium text-purple-700 dark:text-purple-300 mb-1 uppercase tracking-wide">Total Biaya Sparepart</p>
                    <div class="bg-purple-500 rounded-lg p-2">
                        <i class="fas fa-tools text-white text-sm"></i>
                    </div>
                </div>
                <p class="text-2xl font-bold text-purple-900 dark:text-purple-200 mb-1">
                    Rp <?php echo e(number_format($stats['monthly_sparepart_usage'] ?? 0, 0, ',', '.')); ?>

                </p>
                <p class="text-xs text-purple-600 dark:text-purple-400">Penggunaan sparepart bulan ini</p>
            </div>
            <div class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between">
                    <p class="text-xs font-medium text-gray-700 dark:text-gray-300">Total Penggunaan</p>
                    <p class="text-lg font-bold text-gray-900 dark:text-white">
                        Rp <?php echo e(number_format(($stats['monthly_material_usage'] ?? 0) + ($stats['monthly_sparepart_usage'] ?? 0), 0, ',', '.')); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Pending Tasks -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-tasks text-red-600 dark:text-red-400 mr-2"></i>
                Tugas Menunggu
            </h3>
            <?php
                $totalPendingTasks = ($stats['my_planning_productions'] ?? 0) + ($stats['my_pending_approvals'] ?? 0) + ($stats['pending_quotations'] ?? 0);
            ?>
            <?php if($totalPendingTasks > 0): ?>
            <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-red-100 dark:bg-red-900/30 text-red-700 dark:text-red-400 text-sm font-bold">
                <?php echo e($totalPendingTasks); ?>

            </span>
            <?php endif; ?>
        </div>
        <div class="space-y-3">
            <?php if(($stats['my_planning_productions'] ?? 0) > 0): ?>
            <a href="<?php echo e(route('teknisi.productions.index', ['planning_status' => 'planning'])); ?>" 
               class="flex items-center justify-between p-4 bg-gradient-to-r from-blue-50 to-blue-100 dark:from-blue-900/20 dark:to-blue-900/10 rounded-lg transition-all border border-blue-200 dark:border-blue-800 group">
                <div class="flex items-center">
                    <div class="bg-blue-500 rounded-lg p-2 mr-3 group-hover:scale-110 transition-transform">
                        <i class="fas fa-edit text-white text-sm"></i>
                    </div>
                    <span class="text-sm font-medium text-blue-900 dark:text-blue-200">Planning Perlu Dibuat</span>
                </div>
                <span class="text-lg font-bold text-blue-900 dark:text-blue-200 bg-white/50 dark:bg-gray-700/50 px-3 py-1 rounded-lg"><?php echo e($stats['my_planning_productions'] ?? 0); ?></span>
            </a>
            <?php endif; ?>

            <?php if(($stats['my_pending_approvals'] ?? 0) > 0): ?>
            <a href="<?php echo e(route('teknisi.productions.index', ['planning_status' => 'pending_approval'])); ?>" 
               class="flex items-center justify-between p-4 bg-gradient-to-r from-yellow-50 to-yellow-100 dark:from-yellow-900/20 dark:to-yellow-900/10 rounded-lg transition-all border border-yellow-200 dark:border-yellow-800 group">
                <div class="flex items-center">
                    <div class="bg-yellow-500 rounded-lg p-2 mr-3 group-hover:scale-110 transition-transform">
                        <i class="fas fa-clock text-white text-sm"></i>
                    </div>
                    <span class="text-sm font-medium text-yellow-900 dark:text-yellow-200">Planning Menunggu Approval</span>
                </div>
                <span class="text-lg font-bold text-yellow-900 dark:text-yellow-200 bg-white/50 dark:bg-gray-700/50 px-3 py-1 rounded-lg"><?php echo e($stats['my_pending_approvals'] ?? 0); ?></span>
            </a>
            <?php endif; ?>

            <?php if(($stats['pending_quotations'] ?? 0) > 0): ?>
            <a href="<?php echo e(route('teknisi.quotations.index')); ?>" 
               class="flex items-center justify-between p-4 bg-gradient-to-r from-orange-50 to-orange-100 dark:from-orange-900/20 dark:to-orange-900/10 rounded-lg transition-all border border-orange-200 dark:border-orange-800 group">
                <div class="flex items-center">
                    <div class="bg-orange-500 rounded-lg p-2 mr-3 group-hover:scale-110 transition-transform">
                        <i class="fas fa-calculator text-white text-sm"></i>
                    </div>
                    <span class="text-sm font-medium text-orange-900 dark:text-orange-200">Penawaran Perlu Estimasi</span>
                </div>
                <span class="text-lg font-bold text-orange-900 dark:text-orange-200 bg-white/50 dark:bg-gray-700/50 px-3 py-1 rounded-lg"><?php echo e($stats['pending_quotations'] ?? 0); ?></span>
            </a>
            <?php endif; ?>

            <?php if($totalPendingTasks === 0): ?>
            <div class="text-center py-8">
                <div class="w-16 h-16 mx-auto mb-3 bg-green-100 dark:bg-green-900/30 rounded-full flex items-center justify-center">
                    <i class="fas fa-check-circle text-green-600 dark:text-green-400 text-2xl"></i>
                </div>
                <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Tidak ada tugas menunggu</p>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/teknisi/partials/dashboard-quick-stats.blade.php ENDPATH**/ ?>