

<?php $__env->startSection('title', 'Laporan Pembelian'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Laporan Pembelian</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    Analisis dan monitoring data pembelian bahan dan sparepart
                    <?php if(request('start_date') || request('end_date')): ?>
                        | Periode: 
                        <?php echo e(request('start_date') ? \Carbon\Carbon::parse(request('start_date'))->format('d M Y') : 'Awal'); ?> - 
                        <?php echo e(request('end_date') ? \Carbon\Carbon::parse(request('end_date'))->format('d M Y') : 'Akhir'); ?>

                    <?php endif; ?>
                </p>
            </div>
            <div class="flex items-center gap-2">
                <a href="<?php echo e(route('admin.reports.purchases.export', request()->query())); ?>" 
                   class="inline-flex items-center justify-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                    <i class="fas fa-file-excel mr-2 text-xs"></i>
                    Export Excel
                </a>
                <a href="<?php echo e(route('admin.reports.purchases.pdf', request()->query())); ?>" 
                   class="inline-flex items-center justify-center px-4 py-2 bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                    <i class="fas fa-file-pdf mr-2 text-xs"></i>
                    Export PDF
                </a>
            </div>
        </div>
    </div>

    <!-- Notifikasi Modern -->
    <?php if (isset($component)) { $__componentOriginal08a8786da7acaa0d17ad66b17276ca17 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal08a8786da7acaa0d17ad66b17276ca17 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin-notification','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-notification'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal08a8786da7acaa0d17ad66b17276ca17)): ?>
<?php $attributes = $__attributesOriginal08a8786da7acaa0d17ad66b17276ca17; ?>
<?php unset($__attributesOriginal08a8786da7acaa0d17ad66b17276ca17); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal08a8786da7acaa0d17ad66b17276ca17)): ?>
<?php $component = $__componentOriginal08a8786da7acaa0d17ad66b17276ca17; ?>
<?php unset($__componentOriginal08a8786da7acaa0d17ad66b17276ca17); ?>
<?php endif; ?>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Pembelian</p>
                    <h2 class="text-xl font-bold text-indigo-600 dark:text-indigo-400">Rp <?php echo e(number_format($totalAmount, 0, ',', '.')); ?></h2>
                </div>
                <div class="p-2.5 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg">
                    <i class="fas fa-money-bill-wave text-indigo-600 dark:text-indigo-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Transaksi</p>
                    <h2 class="text-xl font-bold text-emerald-600 dark:text-emerald-400"><?php echo e(number_format($totalTransactions, 0, ',', '.')); ?></h2>
                </div>
                <div class="p-2.5 bg-emerald-100 dark:bg-emerald-900/40 rounded-lg">
                    <i class="fas fa-shopping-cart text-emerald-600 dark:text-emerald-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Item</p>
                    <h2 class="text-xl font-bold text-cyan-600 dark:text-cyan-400"><?php echo e(number_format($totalItems, 0, ',', '.')); ?> unit</h2>
                </div>
                <div class="p-2.5 bg-cyan-100 dark:bg-cyan-900/40 rounded-lg">
                    <i class="fas fa-boxes text-cyan-600 dark:text-cyan-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Rata-rata/Transaksi</p>
                    <h2 class="text-xl font-bold text-amber-600 dark:text-amber-400">Rp <?php echo e($totalTransactions > 0 ? number_format($totalAmount / $totalTransactions, 0, ',', '.') : '0'); ?></h2>
                </div>
                <div class="p-2.5 bg-amber-100 dark:bg-amber-900/40 rounded-lg">
                    <i class="fas fa-chart-line text-amber-600 dark:text-amber-400 text-lg"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Chart Section -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-4 transition-colors duration-300">
        <div class="flex items-center mb-4">
            <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg mr-2">
                <i class="fas fa-chart-bar text-indigo-600 dark:text-indigo-400 text-sm"></i>
            </div>
            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Trend Pembelian 12 Bulan Terakhir</h3>
        </div>
        <div class="relative h-80">
            <canvas id="purchasesChart"></canvas>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-4">
        <form method="GET" action="<?php echo e(route('admin.reports.purchases')); ?>" id="filterForm" class="space-y-4">
            <!-- Search Bar -->
            <div class="relative flex-1">
                <input type="text" name="supplier" id="supplierInput" value="<?php echo e(request('supplier')); ?>" placeholder="Cari nama supplier..."
                    class="form-input-search" />
                <i class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                <?php if(request('supplier')): ?>
                    <button type="button" onclick="clearFilter('supplier')"
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 hover:text-gray-600 dark:hover:text-gray-300">
                        <i class="fas fa-times"></i>
                    </button>
                <?php endif; ?>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                <div class="relative">
                    <input type="date" name="start_date" id="startDateInput" value="<?php echo e(request('start_date')); ?>" onchange="submitFilter()"
                        class="w-full pl-10 pr-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200 text-sm h-10"
                        placeholder="Tanggal Mulai">
                    <i class="fas fa-calendar-alt absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                </div>

                <div class="relative">
                    <input type="date" name="end_date" id="endDateInput" value="<?php echo e(request('end_date')); ?>" onchange="submitFilter()"
                        class="w-full pl-10 pr-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200 text-sm h-10"
                        placeholder="Tanggal Akhir">
                    <i class="fas fa-calendar-alt absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                </div>

                <div class="relative">
                    <select name="purchase_type" id="purchaseTypeFilter" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Tipe</option>
                        <option value="material" <?php echo e(request('purchase_type') == 'material' ? 'selected' : ''); ?>>Bahan</option>
                        <option value="sparepart" <?php echo e(request('purchase_type') == 'sparepart' ? 'selected' : ''); ?>>Sparepart</option>
                        <option value="mixed" <?php echo e(request('purchase_type') == 'mixed' ? 'selected' : ''); ?>>Campuran</option>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <div class="flex items-center gap-2">
                    <button type="button" onclick="submitFilter()" class="flex-1 flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 h-10 text-sm">
                        <i class="fas fa-search mr-2 text-xs"></i>
                        Filter
                    </button>
                    <?php if(request()->hasAny(['start_date', 'end_date', 'supplier', 'purchase_type'])): ?>
                        <button type="button" onclick="clearAllFilters()" 
                           class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                           title="Reset filter">
                            <i class="fas fa-redo text-sm"></i>
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </form>
    </div>

    <!-- Active Filters Info -->
    <?php if(request()->hasAny(['start_date', 'end_date', 'supplier', 'purchase_type'])): ?>
        <div class="mb-4 bg-emerald-50 dark:bg-emerald-900/20 border border-emerald-200 dark:border-emerald-700 rounded-lg p-4">
            <div class="flex flex-wrap items-center gap-2">
                <span class="text-sm font-medium text-emerald-800 dark:text-emerald-200">Filter Aktif:</span>
                
                <?php if(request('supplier')): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-emerald-100 text-emerald-800 dark:bg-emerald-800 dark:text-emerald-200">
                        <i class="fas fa-search mr-1"></i>
                        Supplier: "<?php echo e(request('supplier')); ?>"
                        <button onclick="clearFilter('supplier')" class="ml-2 hover:text-emerald-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                <?php endif; ?>
                
                <?php if(request('start_date') || request('end_date')): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800 dark:bg-orange-800 dark:text-orange-200">
                        <i class="fas fa-calendar-alt mr-1"></i>
                        Periode: <?php echo e(request('start_date') ? date('d M Y', strtotime(request('start_date'))) : 'Awal'); ?> - <?php echo e(request('end_date') ? date('d M Y', strtotime(request('end_date'))) : 'Akhir'); ?>

                        <button onclick="clearDateFilter()" class="ml-2 hover:text-orange-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                <?php endif; ?>
                
                <?php if(request('purchase_type')): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-200">
                        <i class="fas fa-tag mr-1"></i>
                        Tipe: <?php echo e(ucfirst(request('purchase_type'))); ?>

                        <button onclick="clearFilter('purchase_type')" class="ml-2 hover:text-blue-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                <?php endif; ?>
                
                <button onclick="clearAllFilters()" 
                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200 hover:bg-red-200 dark:hover:bg-red-700 transition-colors">
                    <i class="fas fa-times-circle mr-1"></i>
                    Hapus Semua Filter
                </button>
            </div>
        </div>
    <?php endif; ?>

    <!-- Data Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
            <div class="flex items-center">
                <div class="p-2 bg-emerald-100 dark:bg-emerald-900/40 rounded-lg mr-2">
                    <i class="fas fa-table text-emerald-600 dark:text-emerald-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Data Pembelian</h3>
            </div>
        </div>
        <div class="overflow-x-auto custom-scrollbar">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Tanggal</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Kode Pembelian</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Supplier</th>
                        <th class="px-6 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Tipe</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Item Dibeli</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Total Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Catatan</th>
                        <th class="px-6 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white"><?php echo e($purchase->purchase_date ? $purchase->purchase_date->format('d/m/Y') : '-'); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white"><?php echo e($purchase->purchase_code); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white"><?php echo e($purchase->supplier_name); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium <?php echo e($purchase->purchase_type == 'material' ? 'bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300' : ($purchase->purchase_type == 'sparepart' ? 'bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300' : 'bg-purple-100 dark:bg-purple-900/40 text-purple-700 dark:text-purple-300')); ?>">
                                    <?php echo e(ucfirst($purchase->purchase_type)); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-white">
                                <?php if($purchase->items && $purchase->items->count() > 0): ?>
                                    <div class="space-y-1">
                                        <?php $__currentLoopData = $purchase->items->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="text-xs">
                                                <span class="font-medium"><?php echo e($item->item_name ?? '-'); ?></span>
                                                <span class="text-gray-500">(<?php echo e($item->quantity); ?> <?php echo e($item->unit ?? 'pcs'); ?>)</span>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($purchase->items->count() > 3): ?>
                                            <div class="text-xs text-gray-500">+<?php echo e($purchase->items->count() - 3); ?> item lainnya</div>
                                        <?php endif; ?>
                                    </div>
                                <?php else: ?>
                                    <span class="text-gray-400">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900 dark:text-white text-right">Rp <?php echo e(number_format($purchase->total_amount, 0, ',', '.')); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white"><?php echo e(Str::limit($purchase->notes ?? '-', 30)); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                <a href="<?php echo e(route('admin.transaksi.purchases.show', $purchase)); ?>" 
                                   class="inline-flex items-center justify-center w-8 h-8 text-indigo-600 dark:text-indigo-400 hover:text-indigo-700 dark:hover:text-indigo-300 hover:bg-indigo-50 dark:hover:bg-indigo-900/20 rounded transition-colors duration-200"
                                   title="Detail">
                                    <i class="fas fa-eye text-sm"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3">
                                        <i class="fas fa-shopping-bag text-3xl text-gray-400 dark:text-gray-500"></i>
                                    </div>
                                    <p class="text-gray-500 dark:text-gray-400 font-medium mb-1">Tidak ada data pembelian</p>
                                    <p class="text-gray-400 dark:text-gray-500 text-sm">Belum ada data pembelian yang ditemukan.</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <!-- Pagination -->
        <?php if($purchases->hasPages()): ?>
            <div
                class="flex items-center justify-between px-4 py-3 border-t border-gray-200 dark:border-gray-700 text-sm bg-gray-50 dark:bg-gray-800">
        
                <!-- Info -->
                <div class="text-gray-600 dark:text-gray-400">
                    Menampilkan
                    <span class="font-medium"><?php echo e($purchases->firstItem()); ?></span>
                    –
                    <span class="font-medium"><?php echo e($purchases->lastItem()); ?></span>
                    dari
                    <span class="font-medium"><?php echo e($purchases->total()); ?></span>
                    data pembelian
                </div>
        
                <!-- Pagination -->
                <div>
                    <?php echo e($purchases->onEachSide(1)->links()); ?>

                </div>
            </div>
        <?php endif; ?>

    </div>

    <script>
        // Submit filter dengan parameter yang bersih
        function submitFilter() {
            const params = new URLSearchParams();
            
            // Ambil nilai dari setiap input/select
            const supplier = document.getElementById('supplierInput')?.value?.trim() || '';
            const startDate = document.getElementById('startDateInput')?.value || '';
            const endDate = document.getElementById('endDateInput')?.value || '';
            const purchaseType = document.getElementById('purchaseTypeFilter')?.value || '';
            
            // Hanya tambahkan parameter yang memiliki nilai
            if (supplier) {
                params.append('supplier', supplier);
            }
            if (startDate) {
                params.append('start_date', startDate);
            }
            if (endDate) {
                params.append('end_date', endDate);
            }
            if (purchaseType) {
                params.append('purchase_type', purchaseType);
            }
            
            // Redirect dengan parameter yang bersih
            const url = '<?php echo e(route("admin.reports.purchases")); ?>' + (params.toString() ? '?' + params.toString() : '');
            window.location.href = url;
        }

        // Clear individual filter
        function clearFilter(filterName) {
            const url = new URL(window.location);
            url.searchParams.delete(filterName);
            window.location.href = url.toString();
        }

        // Clear date filter
        function clearDateFilter() {
            const url = new URL(window.location);
            url.searchParams.delete('start_date');
            url.searchParams.delete('end_date');
            window.location.href = url.toString();
        }

        // Clear all filters
        function clearAllFilters() {
            window.location.href = '<?php echo e(route("admin.reports.purchases")); ?>';
        }

        // Submit form search dengan Enter
        document.addEventListener('DOMContentLoaded', function() {
            const supplierInput = document.getElementById('supplierInput');
            if (supplierInput) {
                supplierInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                        submitFilter();
                    }
                });
            }
        });
    </script>

    <style>
        /* Konsisten Style untuk semua Index Pages */
        .form-input-search,
        .form-select {
            height: 40px !important;
            min-height: 40px !important;
            max-height: 40px !important;
            box-sizing: border-box !important;
            line-height: 1.5 !important;
            padding: 0 2.5rem 0 2.5rem !important;
            margin: 0 !important;
        }
        
        .form-input-search {
            width: 100%;
            padding-left: 2.5rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            transition: all 0.2s;
        }
        
        .dark .form-input-search {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-input-search:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
        
        .form-select {
            width: 100%;
            padding-left: 1rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            transition: all 0.2s;
        }
        
        .dark .form-select {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-select:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
    </style>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('purchasesChart').getContext('2d');
    const purchasesChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($chartData->map(function($item) { 
                return Carbon\Carbon::create($item->year, $item->month, 1)->format('M Y'); 
            })); ?>,
            datasets: [{
                label: 'Total Pembelian (Rp)',
                data: <?php echo json_encode($chartData->pluck('total')); ?>,
                backgroundColor: 'rgba(99, 102, 241, 0.6)',
                borderColor: 'rgba(99, 102, 241, 1)',
                borderWidth: 2,
                borderRadius: 6,
                borderSkipped: false,
            }, {
                label: 'Jumlah Transaksi',
                data: <?php echo json_encode($chartData->pluck('count')); ?>,
                backgroundColor: 'rgba(245, 158, 11, 0.6)',
                borderColor: 'rgba(245, 158, 11, 1)',
                borderWidth: 2,
                borderRadius: 6,
                borderSkipped: false,
                yAxisID: 'y1'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: {
                mode: 'index',
                intersect: false,
            },
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        usePointStyle: true,
                        padding: 20,
                        font: {
                            size: 12,
                            weight: '500'
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.9)',
                    titleColor: 'white',
                    bodyColor: 'white',
                    borderColor: 'rgba(255, 255, 255, 0.1)',
                    borderWidth: 1,
                    cornerRadius: 8,
                    displayColors: true,
                    callbacks: {
                        label: function(context) {
                            if (context.datasetIndex === 0) {
                                return 'Total Pembelian: Rp ' + context.parsed.y.toLocaleString('id-ID');
                            } else {
                                return 'Jumlah Transaksi: ' + context.parsed.y + ' transaksi';
                            }
                        }
                    }
                }
            },
            scales: {
                y: {
                    type: 'linear',
                    display: true,
                    position: 'left',
                    title: {
                        display: true,
                        text: 'Total Pembelian (Rp)',
                        color: '#6B7280',
                        font: {
                            size: 12,
                            weight: '500'
                        }
                    },
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)',
                        drawBorder: false
                    },
                    ticks: {
                        color: '#6B7280',
                        callback: function(value) {
                            return 'Rp ' + value.toLocaleString('id-ID');
                        }
                    }
                },
                y1: {
                    type: 'linear',
                    display: true,
                    position: 'right',
                    title: {
                        display: true,
                        text: 'Jumlah Transaksi',
                        color: '#6B7280',
                        font: {
                            size: 12,
                            weight: '500'
                        }
                    },
                    grid: {
                        drawOnChartArea: false,
                        drawBorder: false
                    },
                    ticks: {
                        color: '#6B7280'
                    }
                },
                x: {
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)',
                        drawBorder: false
                    },
                    ticks: {
                        color: '#6B7280',
                        font: {
                            size: 11
                        }
                    }
                }
            },
            animation: {
                duration: 1000,
                easing: 'easeInOutQuart'
            }
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/reports/purchases.blade.php ENDPATH**/ ?>