

<?php $__env->startSection('title', 'Buku Besar'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Header -->
        <div class="mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Buku Besar</h1>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                        Laporan buku besar per akun dengan saldo awal, debit, kredit, dan saldo akhir
                    </p>
                </div>
                <?php if(isset($accountCode) && $accountCode): ?>
                <div class="flex items-center gap-2">
                    <a href="<?php echo e(route('admin.reports.general-ledger.export', request()->all())); ?>" class="inline-flex items-center justify-center px-3 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-file-excel mr-2 text-xs"></i>
                        Export Excel
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Filter Form -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6 mb-6">
            <form method="GET" action="<?php echo e(route('admin.reports.general-ledger')); ?>" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kode Akun</label>
                    <select name="kd_perk" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">-- Pilih Akun --</option>
                        <?php $__currentLoopData = $accounts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($account->kd_perk); ?>" <?php echo e(request('kd_perk') == $account->kd_perk ? 'selected' : ''); ?>>
                                <?php echo e($account->kd_perk); ?> - <?php echo e($account->nama_perkiraan); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tanggal Awal</label>
                    <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tanggal Akhir</label>
                    <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div class="flex items-end">
                    <button type="submit" class="w-full px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-search mr-2"></i>Filter
                    </button>
                </div>
            </form>
        </div>

        <!-- Report Content -->
        <?php if(isset($accountCode) && $accountCode): ?>
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
                <!-- Header Info -->
                <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                    <div class="text-center mb-4">
                        <h2 class="text-xl font-bold text-gray-800 dark:text-white">POLJAMTECH</h2>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Jl. Lkr. Barat 3 No.1, Bagan Pete, Kec. Kota Baru, Kota Jambi, Jambi 36361</p>
                    </div>
                    <div class="flex items-center justify-between">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-800 dark:text-white">Buku Besar</h3>
                            <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                                <strong>Nama Akun:</strong> <?php echo e($accountName); ?> | 
                                <strong>Kode Akun:</strong> <?php echo e($accountCode); ?> | 
                                <strong>POS SALDO:</strong> <?php echo e($balancePosition); ?>

                            </p>
                        </div>
                    </div>
                </div>

                <div class="p-6">
                    <div class="overflow-x-auto">
                        <table class="w-full border border-gray-300 dark:border-gray-600">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                                <tr>
                                    <th class="px-4 py-3 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600">NO</th>
                                    <th class="px-4 py-3 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600">TANGGAL</th>
                                    <th class="px-4 py-3 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600">BUKTI TRANSAKSI</th>
                                    <th class="px-4 py-3 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600">KETERANGAN</th>
                                    <th class="px-4 py-3 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600">DEBET</th>
                                    <th class="px-4 py-3 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600">KREDIT</th>
                                    <th class="px-4 py-3 text-center text-xs font-semibold uppercase border-b border-gray-300 dark:border-gray-600">SALDO</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Saldo Awal -->
                                <tr class="bg-blue-50 dark:bg-blue-900/20">
                                    <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600">-</td>
                                    <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600">-</td>
                                    <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600">-</td>
                                    <td class="px-4 py-3 text-sm border-r border-gray-300 dark:border-gray-600 font-semibold">Saldo awal</td>
                                    <td class="px-4 py-3 text-right text-sm border-r border-gray-300 dark:border-gray-600">-</td>
                                    <td class="px-4 py-3 text-right text-sm border-r border-gray-300 dark:border-gray-600">-</td>
                                    <td class="px-4 py-3 text-right text-sm font-semibold">
                                        <?php if($openingBalance != 0): ?>
                                            <?php echo e(number_format($openingBalance, 0, ',', '.')); ?>

                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                </tr>

                                <?php $__currentLoopData = $ledgerData ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="border-b border-gray-200 dark:border-gray-600">
                                        <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600"><?php echo e($index + 1); ?></td>
                                        <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600">
                                            <?php echo e($entry['tanggal'] ? \Carbon\Carbon::parse($entry['tanggal'])->format('d-M-y') : '-'); ?>

                                        </td>
                                        <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600"><?php echo e($entry['bukti_transaksi'] ?: '-'); ?></td>
                                        <td class="px-4 py-3 text-sm border-r border-gray-300 dark:border-gray-600"><?php echo e($entry['keterangan'] ?: '-'); ?></td>
                                        <td class="px-4 py-3 text-right text-sm border-r border-gray-300 dark:border-gray-600">
                                            <?php echo e($entry['debit'] > 0 ? number_format($entry['debit'], 0, ',', '.') : '-'); ?>

                                        </td>
                                        <td class="px-4 py-3 text-right text-sm border-r border-gray-300 dark:border-gray-600">
                                            <?php echo e($entry['kredit'] > 0 ? number_format($entry['kredit'], 0, ',', '.') : '-'); ?>

                                        </td>
                                        <td class="px-4 py-3 text-right text-sm font-semibold">
                                            <?php if(abs($entry['saldo']) > 0.01): ?>
                                                <?php echo e(number_format($entry['saldo'], 0, ',', '.')); ?>

                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-12 text-center">
                <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3 mx-auto">
                    <i class="fas fa-book text-3xl text-gray-400 dark:text-gray-500"></i>
                </div>
                <p class="text-gray-500 dark:text-gray-400 font-medium mb-1">Pilih Kode Akun</p>
                <p class="text-gray-400 dark:text-gray-500 text-sm">Silakan pilih kode akun untuk melihat buku besar</p>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/reports/general-ledger.blade.php ENDPATH**/ ?>