

<?php $__env->startSection('content'); ?>
    <section class="py-6 sm:py-8 lg:py-12">
        <div class="max-w-5xl mx-auto px-4">
            <!-- Header -->
            <div class="text-center mb-8 sm:mb-10">
                <h2 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-2 sm:mb-3">FAQ - Pertanyaan Umum</h2>
                <p class="text-sm sm:text-base text-gray-600">
                    Temukan jawaban dari pertanyaan yang sering diajukan seputar produk dan layanan kami.
                </p>
            </div>

            <!-- FAQ Accordion -->
            <div class="space-y-3 sm:space-y-4" x-data="{ open: null }">
                <?php
                    $faqs = [
                        [
                            'q' => 'Apa saja jenis mesin yang dapat Anda produksi?',
                            'a' =>
                                'Kami memproduksi berbagai jenis mesin untuk kebutuhan industri dan usaha, baik mesin standar maupun mesin yang disesuaikan dengan kebutuhan produksi.',
                        ],
                        [
                            'q' => 'Apakah mesin dapat disesuaikan dengan kebutuhan saya?',
                            'a' =>
                                'Ya, mesin dapat disesuaikan dengan kebutuhan Anda. Kami membantu menyesuaikan desain, kapasitas, dan fitur agar sesuai dengan proses kerja yang diinginkan.',
                        ],
                        [
                            'q' => 'Berapa lama waktu pembuatan mesin custom?',
                            'a' =>
                                'Waktu pembuatan mesin bervariasi tergantung tingkat kompleksitas dan kebutuhan yang disepakati. Estimasi waktu akan diinformasikan setelah proses konsultasi.',
                        ],
                        [
                            'q' => 'Apakah tersedia layanan after sales dan maintenance?',
                            'a' =>
                                'Kami menyediakan layanan purna jual untuk memastikan mesin dapat beroperasi dengan baik, termasuk dukungan teknis dan perawatan sesuai kebutuhan.',
                        ],
                        [
                            'q' => 'Bagaimana cara memesan atau berkonsultasi mengenai mesin?',
                            'a' =>
                                'Anda dapat menghubungi kami untuk berkonsultasi mengenai kebutuhan mesin yang diinginkan. Tim kami akan membantu memahami kebutuhan Anda, memberikan arahan solusi yang sesuai, serta menjelaskan proses pemesanan secara jelas.',
                        ],
                        [
                            'q' => 'Apakah mesin dilengkapi dengan garansi?',
                            'a' =>
                                'Setiap mesin dilengkapi dengan garansi sesuai ketentuan yang berlaku, sebagai bentuk komitmen kami terhadap kualitas produk.',
                        ],
                        [
                            'q' => 'Apakah bisa melihat demo mesin sebelum membeli?',
                            'a' =>
                                'Kami dapat menyediakan informasi atau gambaran penggunaan mesin sebelum pembelian, sehingga Anda dapat memahami fungsi dan cara kerjanya.',
                        ],
                        [
                            'q' => 'Apakah menerima upgrade atau modifikasi mesin yang sudah ada?',
                            'a' =>
                                'Kami melayani upgrade atau modifikasi mesin yang sudah ada untuk meningkatkan kinerja dan menyesuaikan dengan kebutuhan terbaru.',
                        ],
                    ];
                ?>

                <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white rounded-lg border border-gray-200 overflow-hidden">
                        <button @click="open === <?php echo e($index); ?> ? open = null : open = <?php echo e($index); ?>"
                            class="w-full flex justify-between items-center text-left px-4 sm:px-5 py-3 sm:py-4 transition-colors duration-200"
                            :class="open === <?php echo e($index); ?> ? 'text-blue-600 font-semibold bg-blue-50' : 'text-gray-800 font-medium hover:bg-gray-50'">
                            <span class="text-sm sm:text-base pr-4"><?php echo e($faq['q']); ?></span>
                            <svg x-show="open !== <?php echo e($index); ?>" xmlns="http://www.w3.org/2000/svg"
                                class="w-5 h-5 text-gray-500 transition-transform duration-300 flex-shrink-0" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
                            </svg>
                            <svg x-show="open === <?php echo e($index); ?>" xmlns="http://www.w3.org/2000/svg"
                                class="w-5 h-5 text-blue-600 transition-transform duration-300 flex-shrink-0" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M20 12H4" />
                            </svg>
                        </button>
                        <div x-show="open === <?php echo e($index); ?>" x-collapse
                            class="px-4 sm:px-5 pb-4 sm:pb-5 text-sm sm:text-base text-gray-600 leading-relaxed border-t border-gray-200">
                            <?php echo e($faq['a']); ?>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Call to Action -->
            <div class="text-center mt-8 sm:mt-12">
                <p class="text-sm sm:text-base text-gray-600 mb-3">Masih ada pertanyaan lain?</p>
                <a href="<?php echo e(route('kontak')); ?>"
                    class="inline-flex items-center gap-2 bg-blue-600 text-white font-medium px-5 sm:px-6 py-2.5 sm:py-3 rounded-lg hover:bg-blue-700 transition-colors duration-200">
                    <svg class="w-4 h-4 sm:w-5 sm:h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                    Hubungi Kami
                </a>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/home/konsultasi.blade.php ENDPATH**/ ?>