<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>
        <?php echo $__env->yieldContent('title', 'Dashboard Admin'); ?> - POLJAM TECH
    </title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/jpeg" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="shortcut icon" type="image/jpeg" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="icon" type="image/jpeg" sizes="32x32" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="icon" type="image/jpeg" sizes="16x16" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    
    <!-- CRITICAL: Restore sidebar state IMMEDIATELY - Must be first script -->
    <script>
    (function() {
        // Run immediately, blocking - before any rendering
        const savedState = localStorage.getItem('adminSidebarState');
        const isHidden = savedState === 'hidden';
        
        // Inject blocking style immediately to prevent ANY flash
        const style = document.createElement('style');
        style.id = 'sidebar-blocking-style';
        style.textContent = `
            #sidebar { 
                transition: none !important; 
                transform: ${isHidden ? 'translateX(-100%)' : 'translateX(0)'} !important;
            }
            #mainContent { 
                transition: none !important; 
                margin-left: ${isHidden ? '0' : '256px'} !important;
            }
            #adminNavbar {
                transition: none !important;
                left: ${isHidden ? '0' : '256px'} !important;
            }
        `;
        document.head.insertBefore(style, document.head.firstChild);
        
        // Set flag for later use
        window.__sidebarState = { isHidden: isHidden, restored: false };
    })();
    </script>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
        }
    </script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
    <link rel="stylesheet" href="<?php echo e(asset('css/admin.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/tooltip-fix.css')); ?>">
    
    <style>
        /* Alpine.js x-cloak - Hide elements until Alpine is initialized */
        [x-cloak] { 
            display: none !important; 
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }

        /* Dark mode custom styles */
        .dark {
            color-scheme: dark;
        }

        /* Ensure dark mode works properly */
        html.dark {
            background-color: #111827;
        }

        html.dark body {
            background-color: #111827;
        }

        /* Tooltip Fix - CSS yang lebih sederhana */
        .tooltip-fix {
            position: relative;
            display: inline-block;
        }

        .tooltip-fix .tooltip-content {
            position: absolute;
            top: 100%;
            left: 50%;
            transform: translateX(-50%);
            margin-top: 0.5rem;
            padding: 0.5rem 0.75rem;
            font-size: 0.75rem;
            font-weight: 500;
            color: white;
            background-color: #1f2937;
            border-radius: 0.375rem;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            pointer-events: none;
            z-index: 9999;
            white-space: nowrap;
            min-width: 60px;
            text-align: center;
        }

        /* Hover state yang lebih eksplisit */
        .tooltip-fix:hover .tooltip-content {
            opacity: 1;
            visibility: visible;
            transform: translateX(-50%) translateY(0.25rem);
        }

        /* Dark mode */
        .dark .tooltip-fix .tooltip-content {
            background-color: #111827;
            color: #f9fafb;
        }

        /* Arrow untuk tooltip */
        .tooltip-fix .tooltip-content::before {
            content: '';
            position: absolute;
            top: -0.25rem;
            left: 50%;
            transform: translateX(-50%);
            width: 0;
            height: 0;
            border-left: 0.25rem solid transparent;
            border-right: 0.25rem solid transparent;
            border-bottom: 0.25rem solid #1f2937;
        }

        .dark .tooltip-fix .tooltip-content::before {
            border-bottom-color: #111827;
        }

        /* Keep content container simple - no special styling needed */
        
        /* Global Pagination Style - Konsisten di semua halaman admin */
        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 0.5rem;
            flex-wrap: wrap;
            margin-top: 1.5rem;
        }
        
        .pagination > * {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .pagination a,
        .pagination span {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 2.5rem;
            height: 2.5rem;
            padding: 0 0.75rem;
            font-size: 0.875rem;
            font-weight: 500;
            color: #4b5563;
            background-color: white;
            border: 1px solid #e5e7eb;
            border-radius: 0.5rem;
            transition: all 0.2s;
            text-decoration: none;
        }
        
        .pagination a:hover {
            background-color: #f3f4f6;
            border-color: #d1d5db;
            color: #1f2937;
        }
        
        .pagination .active span {
            background-color: #3b82f6;
            border-color: #3b82f6;
            color: white;
            font-weight: 600;
        }
        
        .pagination .disabled span {
            color: #9ca3af;
            background-color: #f9fafb;
            border-color: #e5e7eb;
            cursor: not-allowed;
        }
        
        /* Dark mode pagination */
        .dark .pagination a,
        .dark .pagination span {
            color: #d1d5db;
            background-color: #1f2937;
            border-color: #374151;
        }
        
        .dark .pagination a:hover {
            background-color: #374151;
            border-color: #4b5563;
            color: #f9fafb;
        }
        
        .dark .pagination .active span {
            background-color: #3b82f6;
            border-color: #3b82f6;
            color: white;
        }
        
        .dark .pagination .disabled span {
            color: #6b7280;
            background-color: #111827;
            border-color: #374151;
        }
        
        /* Prevent content overflow */
        #mainContent {
            max-width: 100vw;
            box-sizing: border-box;
            overflow-x: hidden;
        }
        
        body, html {
            overflow-x: hidden;
        }
        
        main, main > div {
            max-width: 100%;
            box-sizing: border-box;
        }
        
        /* Smooth transitions for sidebar toggle (not on load) */
        #sidebar {
            transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        #mainContent {
            transition: margin-left 0.3s cubic-bezier(0.4, 0, 0.2, 1), width 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        /* Smooth overlay transition */
        #sidebarOverlay {
            transition: opacity 0.3s cubic-bezier(0.4, 0, 0.2, 1), visibility 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        /* Consistent spacing between navbar and content */
        /* Navbar: py-2.5 sm:py-3 + icon + button padding = ~3.125rem mobile, ~3.375rem desktop */
        /* Add comfortable spacing so content doesn't feel cramped */
        main > div {
            padding-top: 5rem !important; /* Navbar height (~3.125rem) + comfortable spacing (1.875rem) */
        }
        
        @media (min-width: 640px) {
            main > div {
                padding-top: 5.25rem !important; /* Navbar height (~3.375rem) + comfortable spacing (1.875rem) */
            }
        }
        
        @media (min-width: 1024px) {
            main > div {
                padding-top: 5.5rem !important; /* Extra spacing on larger screens for better readability */
            }
        }
    </style>

    <!-- Restore sidebar state and remove blocking style -->
    <script>
    (function() {
        function restoreSidebarState() {
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            
            if (!sidebar || !mainContent) {
                requestAnimationFrame(restoreSidebarState);
                return;
            }
            
            const isMobile = window.innerWidth < 1024;
            if (isMobile) {
                // Remove blocking style
                const blockingStyle = document.getElementById('sidebar-blocking-style');
                if (blockingStyle) blockingStyle.remove();
                if (window.__sidebarState) window.__sidebarState.restored = true;
                return;
            }
            
            // Get saved state (from early script or localStorage)
            const savedState = window.__sidebarState ? window.__sidebarState.isHidden : (localStorage.getItem('adminSidebarState') === 'hidden');
            
            // Ensure no transition during restore
            sidebar.style.transition = 'none';
            mainContent.style.transition = 'none';
            
            if (savedState) {
                sidebar.classList.add('-translate-x-full');
                sidebar.style.transform = 'translateX(-100%)';
                mainContent.classList.remove('ml-64');
                mainContent.classList.add('ml-0');
                mainContent.style.marginLeft = '0';
            } else {
                sidebar.classList.remove('-translate-x-full');
                sidebar.style.transform = '';
                mainContent.classList.remove('ml-0');
                mainContent.classList.add('ml-64');
                mainContent.style.marginLeft = '';
            }
            
            // Update navbar position immediately
            const navbar = document.getElementById('adminNavbar');
            if (navbar) {
                if (savedState) {
                    navbar.style.left = '0';
                } else {
                    navbar.style.left = '256px';
                }
            }
            
            // Remove blocking style and re-enable smooth transitions after a delay
            setTimeout(function() {
                const blockingStyle = document.getElementById('sidebar-blocking-style');
                if (blockingStyle) blockingStyle.remove();
                sidebar.style.transition = '';
                mainContent.style.transition = '';
                if (window.__sidebarState) window.__sidebarState.restored = true;
            }, 100);
        }
        
        // Run as soon as possible
        if (document.body) {
            restoreSidebarState();
        } else {
            document.addEventListener('DOMContentLoaded', restoreSidebarState);
        }
    })();
    </script>

</head>

<body class="bg-gray-100 dark:bg-gray-900 transition-colors duration-300">

    <!-- Loader Overlay -->
    <div id="loader"
        style="position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(255,255,255,0.7);z-index:50;text-align:center;line-height:100vh;display:none;">
        <div
            style="display:inline-block;width:64px;height:64px;border:4px solid #d1d5db;border-top-color:#3b82f6;border-radius:50%;animation:spin 1s linear infinite;">
        </div>
    </div>

    <?php echo $__env->make('admin.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div id="mainContent" class="ml-0 lg:ml-64 flex flex-col min-h-screen">
        <?php echo $__env->make('admin.partials.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="flex-1 overflow-x-hidden w-full" style="min-width: 0;">
            <div class="p-4 sm:p-6 md:p-8 lg:p-12">
                <div class="w-full max-w-full" style="min-width: 0;">
            <?php if (! empty(trim($__env->yieldContent('content')))): ?>
                <?php echo $__env->yieldContent('content'); ?>
            <?php else: ?>
                <p class="text-gray-600 dark:text-gray-300">Selamat datang di admin panel.</p>
            <?php endif; ?>
                </div>
            </div>
        </main>

        <?php echo $__env->make('admin.partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>


    <?php echo $__env->make('admin.partials.scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Stack untuk scripts dari views -->
    <?php echo $__env->yieldPushContent('scripts'); ?>

    <!-- Yield untuk scripts dari views -->
    <?php echo $__env->yieldContent('scripts'); ?>

    <script src="//unpkg.com/alpinejs" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="<?php echo e(asset('js/notifications.js')); ?>?v=<?php echo e(time()); ?>"></script>
    <script src="<?php echo e(asset('js/tooltip-fix.js')); ?>"></script>

    <!-- Simple Layout Handler - Fix content width on zoom/resize -->
    <script>
    (function() {
        function fixLayout() {
            const mainContent = document.getElementById('mainContent');
            const sidebar = document.getElementById('sidebar');
            if (!mainContent || !sidebar) return;
            
            const isMobile = window.innerWidth < 1024;
            if (isMobile) {
                mainContent.style.width = '';
                mainContent.style.maxWidth = '';
                return;
            }
            
            const viewportWidth = window.innerWidth;
            const sidebarWidth = 256;
            const isHidden = sidebar.classList.contains('-translate-x-full');
            
            if (isHidden) {
                mainContent.style.width = viewportWidth + 'px';
                mainContent.style.maxWidth = viewportWidth + 'px';
                mainContent.style.marginLeft = '0';
            } else {
                mainContent.style.width = (viewportWidth - sidebarWidth) + 'px';
                mainContent.style.maxWidth = (viewportWidth - sidebarWidth) + 'px';
                mainContent.style.marginLeft = '';
            }
        }
        
        // Make it globally accessible
        window.fixAdminLayout = fixLayout;
        
        let resizeTimeout;
        window.addEventListener('resize', function() {
            clearTimeout(resizeTimeout);
            resizeTimeout = setTimeout(fixLayout, 100);
        });
        
        // Fix on load (after sidebar state is restored)
        function initLayout() {
            if (window.__sidebarState && window.__sidebarState.restored) {
                fixLayout();
            } else {
                setTimeout(initLayout, 50);
            }
        }
        
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', function() {
                setTimeout(initLayout, 100);
            });
        } else {
            setTimeout(initLayout, 150);
        }
    })();
    </script>

</body>

</html>
<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/layouts/admin.blade.php ENDPATH**/ ?>