<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['type' => 'success', 'message' => null, 'autoClose' => true, 'duration' => 4000]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['type' => 'success', 'message' => null, 'autoClose' => true, 'duration' => 4000]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $message = $message ?? (session('success') ?? session('error') ?? session('add_message') ?? session('update_message') ?? session('delete_message'));
    $type = session('success') || session('add_message') || session('update_message') ? 'success' : (session('error') || session('delete_message') ? 'error' : $type);
    
    $config = [
        'success' => [
            'bg' => 'bg-gradient-to-r from-green-500 to-emerald-600',
            'icon' => 'fas fa-check-circle',
            'iconBg' => 'bg-white/20',
        ],
        'error' => [
            'bg' => 'bg-gradient-to-r from-red-500 to-rose-600',
            'icon' => 'fas fa-exclamation-circle',
            'iconBg' => 'bg-white/20',
        ],
        'warning' => [
            'bg' => 'bg-gradient-to-r from-yellow-500 to-amber-600',
            'icon' => 'fas fa-exclamation-triangle',
            'iconBg' => 'bg-white/20',
        ],
        'info' => [
            'bg' => 'bg-gradient-to-r from-blue-500 to-cyan-600',
            'icon' => 'fas fa-info-circle',
            'iconBg' => 'bg-white/20',
        ],
    ];
    
    $style = $config[$type] ?? $config['success'];
?>

<?php if($message): ?>
<div x-data="{ show: true }" 
     x-show="show" 
     x-transition:enter="transition transform ease-out duration-500"
     x-transition:enter-start="-translate-y-10 opacity-0 scale-95" 
     x-transition:enter-end="translate-y-0 opacity-100 scale-100"
     x-transition:leave="transition transform ease-in duration-300"
     x-transition:leave-start="translate-y-0 opacity-100 scale-100" 
     x-transition:leave-end="-translate-y-10 opacity-0 scale-95"
     <?php if($autoClose): ?> x-init="setTimeout(() => show = false, <?php echo e($duration); ?>)" <?php endif; ?>
     class="fixed top-6 left-1/2 transform -translate-x-1/2 z-[9999] w-[90%] sm:w-[500px] <?php echo e($style['bg']); ?> text-white shadow-2xl rounded-xl px-6 py-4 flex items-center justify-between space-x-3 backdrop-blur-sm"
     style="animation: slideDown 0.5s ease-out;">
    <div class="flex items-center space-x-3 flex-1 min-w-0">
        <div class="flex items-center justify-center w-10 h-10 <?php echo e($style['iconBg']); ?> rounded-full flex-shrink-0">
            <i class="<?php echo e($style['icon']); ?> text-lg text-white"></i>
        </div>
        <div class="flex-1 font-semibold text-sm sm:text-base leading-relaxed break-words">
            <?php echo $message; ?>

        </div>
    </div>
    <button @click="show = false" 
            class="flex-shrink-0 hover:bg-white/20 rounded-full p-1.5 transition-all duration-200 hover:scale-110 active:scale-95 ml-2">
        <i class="fas fa-times text-white text-sm"></i>
    </button>
</div>

<style>
    @keyframes slideDown {
        from {
            transform: translate(-50%, -100%);
            opacity: 0;
        }
        to {
            transform: translate(-50%, 0);
            opacity: 1;
        }
    }
</style>
<?php endif; ?>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/components/admin-notification.blade.php ENDPATH**/ ?>