

<?php $__env->startSection('title', $product->product_title . ' - Portfolio'); ?>

<?php $__env->startSection('content'); ?>
    <div class="min-h-screen bg-gray-50">
        <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4 py-6 sm:py-8">

            <!-- 1. Hero Section (Judul + Badge Portfolio) -->
            <div class="mb-6 sm:mb-8">
                <!-- Breadcrumb -->
                <nav class="mb-4 text-xs sm:text-sm">
                    <ol class="flex items-center space-x-1.5 sm:space-x-2 text-gray-600 overflow-x-auto scrollbar-hide">
                        <li><a href="/" class="hover:text-blue-600 transition whitespace-nowrap">Home</a></li>
                        <li><span class="mx-1 sm:mx-2">›</span></li>
                        <li><a href="<?php echo e(route('index')); ?>#portfolio" class="hover:text-blue-600 transition whitespace-nowrap">Portfolio</a></li>
                        <li><span class="mx-1 sm:mx-2">›</span></li>
                        <li class="text-blue-600 font-medium truncate max-w-[200px] sm:max-w-none"><?php echo e($product->product_title); ?></li>
                    </ol>
                </nav>

                <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 border border-gray-200">
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                        <div class="flex-1">
                            <div class="flex items-center gap-3 mb-2">
                                <h1 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900"><?php echo e($product->product_title); ?></h1>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-bold bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-md">
                                    <i class="fas fa-award mr-1.5"></i>PORTFOLIO
                                </span>
                            </div>
                            <?php if($product->category): ?>
                            <div class="flex items-center gap-2">
                                <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    <i class="fas fa-tag mr-1.5 text-xs"></i>
                                    <?php echo e($product->category->name); ?>

                                </span>
                                <span class="text-xs text-gray-500">
                                    <i class="fas fa-check-circle text-green-600 mr-1"></i>
                                    <?php echo e($totalProduced ?? 0); ?> unit telah diproduksi
                                </span>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="grid lg:grid-cols-3 gap-4 sm:gap-6">
                <!-- Left Section: Main Content (2 columns) -->
                <div class="lg:col-span-2 space-y-4 sm:space-y-6">

                    <!-- 2. Gallery (Foto produk + produksi + instalasi) -->
                    <div class="bg-white rounded-lg shadow-md overflow-hidden border border-gray-200">
                        <div class="p-4 sm:p-6">
                            <h2 class="text-lg sm:text-xl font-bold text-gray-900 mb-4 flex items-center gap-2">
                                <i class="fas fa-images text-blue-600"></i>
                                Galeri Produk
                            </h2>
                            
                            <!-- Main Image -->
                            <div class="mb-4">
                                <button onclick="openGallery(0)"
                                    class="w-full bg-gray-50 rounded-lg overflow-hidden cursor-zoom-in group">
                                    <img src="<?php echo e(asset('uploads/products/' . $product->product_image)); ?>"
                                        alt="<?php echo e($product->product_title); ?>" id="portfolioMainImage"
                                        class="w-full h-[300px] sm:h-[400px] md:h-[500px] object-contain p-4 sm:p-6 group-hover:scale-105 transition-transform duration-500">
                                </button>
                            </div>

                            <!-- Thumbnail Grid -->
                            <?php if($product->images->count() > 0): ?>
                            <div class="grid grid-cols-3 sm:grid-cols-4 md:grid-cols-6 gap-2 sm:gap-3">
                                <!-- Main Image Thumbnail -->
                                <button onclick="changeMainImage('<?php echo e(asset('uploads/products/' . $product->product_image)); ?>', 0)"
                                    class="thumbnail-btn aspect-square bg-white rounded-lg border-2 border-blue-500 overflow-hidden hover:border-blue-600 active:scale-95 transition-all shadow-sm">
                                    <img src="<?php echo e(asset('uploads/products/' . $product->product_image)); ?>"
                                        alt="<?php echo e($product->product_title); ?>"
                                        class="w-full h-full object-contain p-1.5">
                                </button>

                                <!-- Additional Images -->
                                <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button onclick="changeMainImage('<?php echo e(asset('uploads/products/' . $img->image_path)); ?>', <?php echo e($index + 1); ?>)"
                                    class="thumbnail-btn aspect-square bg-white rounded-lg border-2 border-gray-200 overflow-hidden hover:border-blue-500 active:scale-95 transition-all shadow-sm">
                                    <img src="<?php echo e(asset('uploads/products/' . $img->image_path)); ?>"
                                        alt="Gambar tambahan"
                                        class="w-full h-full object-contain p-1.5">
                                </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <!-- Dummy Production Photos -->
                                <?php for($i = 0; $i < 3; $i++): ?>
                                <div class="aspect-square bg-gradient-to-br from-gray-100 to-gray-200 rounded-lg border-2 border-gray-200 overflow-hidden flex items-center justify-center shadow-sm">
                                    <div class="text-center p-2">
                                        <i class="fas fa-cog text-gray-400 text-xl mb-1"></i>
                                        <p class="text-[8px] sm:text-xs text-gray-500">Foto Produksi</p>
                                    </div>
                                </div>
                                <?php endfor; ?>

                                <!-- Dummy Installation Photos -->
                                <?php for($i = 0; $i < 2; $i++): ?>
                                <div class="aspect-square bg-gradient-to-br from-blue-50 to-indigo-50 rounded-lg border-2 border-gray-200 overflow-hidden flex items-center justify-center shadow-sm">
                                    <div class="text-center p-2">
                                        <i class="fas fa-tools text-blue-400 text-xl mb-1"></i>
                                        <p class="text-[8px] sm:text-xs text-gray-500">Foto Instalasi</p>
                                    </div>
                                </div>
                                <?php endfor; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- 4. Deskripsi Lengkap (Overview + Latar Belakang) -->
                    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 border border-gray-200">
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900 mb-4 flex items-center gap-2">
                            <i class="fas fa-info-circle text-blue-600"></i>
                            Deskripsi Lengkap
                        </h2>
                        <div class="space-y-4 text-sm sm:text-base text-gray-700 leading-relaxed">
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Overview</h3>
                                <p><?php echo e($product->product_description ?? 'Mesin Pembelah Pinang adalah solusi teknologi modern untuk meningkatkan efisiensi proses pembelahan pinang. Dirancang khusus untuk memenuhi kebutuhan industri pengolahan pinang dengan kapasitas tinggi dan kualitas hasil yang konsisten.'); ?></p>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Latar Belakang</h3>
                                <p>Mesin ini dikembangkan berdasarkan kebutuhan industri pengolahan pinang yang memerlukan proses pembelahan yang cepat, akurat, dan aman. Dengan teknologi terbaru, mesin ini mampu memproses pinang dalam jumlah besar dengan hasil yang seragam dan mengurangi risiko cedera pada operator.</p>
                            </div>
                        </div>
                    </div>

                    <!-- 5. Cara Kerja / Prinsip Kerja -->
                    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 border border-gray-200">
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900 mb-4 flex items-center gap-2">
                            <i class="fas fa-cogs text-blue-600"></i>
                            Cara Kerja / Prinsip Kerja
                        </h2>
                        <div class="space-y-3 text-sm sm:text-base text-gray-700 leading-relaxed">
                            <p>Mesin Pembelah Pinang bekerja dengan prinsip mekanis yang dirancang khusus untuk memproses pinang secara efisien:</p>
                            <ol class="list-decimal list-inside space-y-2 ml-2">
                                <li><strong>Input Material:</strong> Pinang dimasukkan melalui hopper yang dirancang ergonomis untuk memudahkan operator.</li>
                                <li><strong>Proses Pembelahan:</strong> Sistem pisau berputar dengan presisi tinggi membelah pinang sesuai ukuran yang diinginkan.</li>
                                <li><strong>Pengaturan Kecepatan:</strong> Kecepatan pembelahan dapat disesuaikan sesuai kebutuhan produksi melalui panel kontrol.</li>
                                <li><strong>Output Hasil:</strong> Pinang yang sudah dibelah dikeluarkan melalui conveyor belt untuk proses selanjutnya.</li>
                                <li><strong>Sistem Keamanan:</strong> Mesin dilengkapi dengan safety switch dan emergency stop untuk melindungi operator.</li>
                            </ol>
                        </div>
                    </div>

                    <!-- 6. Penggunaan & Aplikasi -->
                    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 border border-gray-200">
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900 mb-4 flex items-center gap-2">
                            <i class="fas fa-industry text-blue-600"></i>
                            Penggunaan & Aplikasi
                        </h2>
                        <div class="space-y-4">
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Industri yang Cocok</h3>
                                <ul class="list-disc list-inside space-y-1 text-sm sm:text-base text-gray-700 ml-2">
                                    <li>Industri pengolahan pinang skala menengah dan besar</li>
                                    <li>Pabrik pengolahan hasil perkebunan</li>
                                    <li>UMKM pengolahan produk pinang</li>
                                    <li>Industri makanan dan minuman berbahan pinang</li>
                                </ul>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Manfaat untuk Bisnis</h3>
                                <ul class="list-disc list-inside space-y-1 text-sm sm:text-base text-gray-700 ml-2">
                                    <li>Meningkatkan produktivitas hingga 300% dibanding proses manual</li>
                                    <li>Mengurangi biaya tenaga kerja hingga 60%</li>
                                    <li>Hasil pembelahan lebih konsisten dan seragam</li>
                                    <li>Mengurangi waste material hingga 15%</li>
                                    <li>Meningkatkan kualitas produk akhir</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- 7. Spesifikasi Lengkap -->
                    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 border border-gray-200">
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900 mb-4 flex items-center gap-2">
                            <i class="fas fa-list-alt text-blue-600"></i>
                            Spesifikasi Lengkap
                        </h2>
                        <div class="space-y-3">
                            <?php if($product->specifications->count() > 0): ?>
                                <?php $__currentLoopData = $product->specifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex flex-col sm:flex-row sm:items-center justify-between py-2 border-b border-gray-100 last:border-0">
                                    <div class="text-sm sm:text-base font-medium text-gray-700 mb-1 sm:mb-0"><?php echo e($spec->key); ?></div>
                                    <div class="text-sm sm:text-base text-gray-900"><?php echo e($spec->value); ?></div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <!-- Dummy Specifications -->
                                <div class="space-y-3">
                                    <div class="flex flex-col sm:flex-row sm:items-center justify-between py-2 border-b border-gray-100">
                                        <div class="text-sm sm:text-base font-medium text-gray-700 mb-1 sm:mb-0">Dimensi Mesin</div>
                                        <div class="text-sm sm:text-base text-gray-900">Panjang 120 cm x Lebar 80 cm x Tinggi 150 cm</div>
                                    </div>
                                    <div class="flex flex-col sm:flex-row sm:items-center justify-between py-2 border-b border-gray-100">
                                        <div class="text-sm sm:text-base font-medium text-gray-700 mb-1 sm:mb-0">Kapasitas Produksi</div>
                                        <div class="text-sm sm:text-base text-gray-900">200-300 kg/jam</div>
                                    </div>
                                    <div class="flex flex-col sm:flex-row sm:items-center justify-between py-2 border-b border-gray-100">
                                        <div class="text-sm sm:text-base font-medium text-gray-700 mb-1 sm:mb-0">Daya Listrik</div>
                                        <div class="text-sm sm:text-base text-gray-900">2 HP (1500 Watt)</div>
                                    </div>
                                    <div class="flex flex-col sm:flex-row sm:items-center justify-between py-2 border-b border-gray-100">
                                        <div class="text-sm sm:text-base font-medium text-gray-700 mb-1 sm:mb-0">Material Rangka</div>
                                        <div class="text-sm sm:text-base text-gray-900">Besi Baja Karbon</div>
                                    </div>
                                    <div class="flex flex-col sm:flex-row sm:items-center justify-between py-2 border-b border-gray-100">
                                        <div class="text-sm sm:text-base font-medium text-gray-700 mb-1 sm:mb-0">Material Pisau</div>
                                        <div class="text-sm sm:text-base text-gray-900">Stainless Steel 304</div>
                                    </div>
                                    <div class="flex flex-col sm:flex-row sm:items-center justify-between py-2">
                                        <div class="text-sm sm:text-base font-medium text-gray-700 mb-1 sm:mb-0">Berat Mesin</div>
                                        <div class="text-sm sm:text-base text-gray-900">150 kg</div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- 8. Bukti Kerja (Testimoni + Foto Klien) -->
                    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 border border-gray-200">
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900 mb-4 flex items-center gap-2">
                            <i class="fas fa-star text-blue-600"></i>
                            Bukti Kerja
                        </h2>
                        
                        <!-- Testimonials -->
                        <div class="mb-6">
                            <h3 class="font-semibold text-gray-900 mb-3">Testimoni Klien</h3>
                            <div class="space-y-4">
                                <!-- Testimoni 1 -->
                                <div class="bg-gray-50 rounded-lg p-4 border border-gray-200">
                                    <div class="flex items-start gap-3">
                                        <div class="flex-shrink-0 w-12 h-12 bg-blue-600 rounded-full flex items-center justify-center text-white font-bold">
                                            AS
                                        </div>
                                        <div class="flex-1">
                                            <div class="flex items-center gap-2 mb-1">
                                                <h4 class="font-semibold text-gray-900">Ahmad Santoso</h4>
                                                <div class="flex text-yellow-400 text-xs">
                                                    <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>
                                                </div>
                                            </div>
                                            <p class="text-xs text-gray-500 mb-2">Pemilik Pabrik Pinang, Medan</p>
                                            <p class="text-sm text-gray-700 leading-relaxed">"Mesin ini sangat membantu meningkatkan produktivitas kami. Hasil pembelahan lebih rapi dan konsisten. Proses produksi kami menjadi lebih efisien dan menghemat banyak waktu."</p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Testimoni 2 -->
                                <div class="bg-gray-50 rounded-lg p-4 border border-gray-200">
                                    <div class="flex items-start gap-3">
                                        <div class="flex-shrink-0 w-12 h-12 bg-green-600 rounded-full flex items-center justify-center text-white font-bold">
                                            BD
                                        </div>
                                        <div class="flex-1">
                                            <div class="flex items-center gap-2 mb-1">
                                                <h4 class="font-semibold text-gray-900">Budi Darmawan</h4>
                                                <div class="flex text-yellow-400 text-xs">
                                                    <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>
                                                </div>
                                            </div>
                                            <p class="text-xs text-gray-500 mb-2">Direktur CV Sejahtera, Bandung</p>
                                            <p class="text-sm text-gray-700 leading-relaxed">"Kualitas mesin sangat baik dan tahan lama. Setelah 2 tahun penggunaan, mesin masih berjalan dengan baik. Pelayanan purna jual juga sangat memuaskan."</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Client Photos -->
                        <div>
                            <h3 class="font-semibold text-gray-900 mb-3">Foto di Lokasi Klien</h3>
                            <div class="grid grid-cols-2 sm:grid-cols-3 gap-3">
                                <?php for($i = 0; $i < 3; $i++): ?>
                                <div class="aspect-square bg-gradient-to-br from-gray-100 to-gray-200 rounded-lg border-2 border-gray-200 overflow-hidden flex items-center justify-center">
                                    <div class="text-center p-3">
                                        <i class="fas fa-building text-gray-400 text-2xl mb-2"></i>
                                        <p class="text-xs text-gray-500">Foto Instalasi</p>
                                        <p class="text-[10px] text-gray-400 mt-1">Klien <?php echo e($i + 1); ?></p>
                                    </div>
                                </div>
                                <?php endfor; ?>
                            </div>
                        </div>
                    </div>

                    <!-- 9. Proses Produksi (Opsional) -->
                    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 border border-gray-200">
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900 mb-4 flex items-center gap-2">
                            <i class="fas fa-industry text-blue-600"></i>
                            Proses Produksi
                        </h2>
                        <div class="space-y-4">
                            <p class="text-sm sm:text-base text-gray-700 leading-relaxed">Setiap mesin yang kami produksi melalui tahapan quality control yang ketat untuk memastikan kualitas terbaik:</p>
                            <div class="grid sm:grid-cols-2 gap-4">
                                <div class="bg-blue-50 rounded-lg p-4 border border-blue-100">
                                    <div class="flex items-center gap-2 mb-2">
                                        <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center text-white font-bold text-sm">1</div>
                                        <h4 class="font-semibold text-gray-900">Perancangan & Engineering</h4>
                                    </div>
                                    <p class="text-xs sm:text-sm text-gray-700">Desain detail dan perhitungan teknis yang akurat</p>
                                </div>
                                <div class="bg-blue-50 rounded-lg p-4 border border-blue-100">
                                    <div class="flex items-center gap-2 mb-2">
                                        <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center text-white font-bold text-sm">2</div>
                                        <h4 class="font-semibold text-gray-900">Fabrication</h4>
                                    </div>
                                    <p class="text-xs sm:text-sm text-gray-700">Pembuatan komponen dengan presisi tinggi</p>
                                </div>
                                <div class="bg-blue-50 rounded-lg p-4 border border-blue-100">
                                    <div class="flex items-center gap-2 mb-2">
                                        <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center text-white font-bold text-sm">3</div>
                                        <h4 class="font-semibold text-gray-900">Assembly</h4>
                                    </div>
                                    <p class="text-xs sm:text-sm text-gray-700">Perakitan komponen dengan standar industri</p>
                                </div>
                                <div class="bg-blue-50 rounded-lg p-4 border border-blue-100">
                                    <div class="flex items-center gap-2 mb-2">
                                        <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center text-white font-bold text-sm">4</div>
                                        <h4 class="font-semibold text-gray-900">Quality Control</h4>
                                    </div>
                                    <p class="text-xs sm:text-sm text-gray-700">Pengujian dan inspeksi kualitas menyeluruh</p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <!-- Right Section: Quick Info Card (Sidebar - 1 column) -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-lg shadow-lg border border-gray-200 p-4 sm:p-5 md:p-6 lg:sticky lg:top-6">

                        <!-- Status Badge -->
                        <div class="mb-4">
                            <span class="inline-flex items-center px-3 py-1.5 rounded-full text-xs font-bold bg-green-100 text-green-800 border border-green-200">
                                <i class="fas fa-check-circle mr-1.5"></i>
                                Sudah Diproduksi
                            </span>
                        </div>

                        <!-- Price -->
                        <div class="mb-4 sm:mb-6 pb-4 sm:pb-6 border-b border-gray-200">
                            <p class="text-xs sm:text-sm text-gray-600 mb-1.5 sm:mb-2">Harga</p>
                            <p class="text-2xl sm:text-3xl font-bold text-blue-600">
                                Rp <?php echo e(number_format($product->product_prices, 0, ',', '.')); ?>

                            </p>
                        </div>

                        <!-- Quick Info -->
                        <div class="mb-6 space-y-3">
                            <?php if($product->product_work_duration): ?>
                            <div class="flex items-center text-sm text-gray-700">
                                <i class="far fa-clock w-5 text-blue-600"></i>
                                <span class="ml-2"><?php echo e($product->product_work_duration); ?></span>
                            </div>
                            <?php endif; ?>
                            <?php if($product->product_garansi): ?>
                            <div class="flex items-center text-sm text-gray-700">
                                <i class="fas fa-shield-alt w-5 text-blue-600"></i>
                                <span class="ml-2"><?php echo e($product->product_garansi); ?></span>
                            </div>
                            <?php endif; ?>
                            <div class="flex items-center text-sm text-gray-700">
                                <i class="fas fa-box w-5 text-blue-600"></i>
                                <span class="ml-2"><?php echo e($totalProduced ?? 0); ?> unit telah diproduksi</span>
                            </div>
                        </div>

                        <!-- 10. CTA Section - Simplified -->
                        <div class="space-y-3">
                            <div class="bg-gradient-to-br from-blue-50 to-indigo-50 rounded-lg p-4 border border-blue-100 mb-4">
                                <p class="text-sm font-semibold text-gray-900 mb-1 text-center">Tertarik dengan produk ini?</p>
                                <p class="text-xs text-gray-600 text-center">Pesan langsung atau ajukan penawaran custom</p>
                            </div>

                            <!-- Primary CTA: Pesan Sekarang (Langsung ke Checkout) -->
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(route('checkout.form', $product->id)); ?>"
                                    class="w-full bg-blue-600 text-white px-6 py-3.5 rounded-lg font-semibold hover:bg-blue-700 transition-all duration-300 flex items-center justify-center shadow-md hover:shadow-lg">
                                    <i class="fas fa-shopping-cart mr-2"></i>
                                    Pesan Sekarang
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>"
                                    class="w-full bg-blue-600 text-white px-6 py-3.5 rounded-lg font-semibold hover:bg-blue-700 transition-all duration-300 flex items-center justify-center shadow-md hover:shadow-lg">
                                    <i class="fas fa-shopping-cart mr-2"></i>
                                    Pesan Sekarang
                                </a>
                            <?php endif; ?>

                            <!-- Secondary CTA: Lihat Detail Produk (untuk custom/penawaran) -->
                            <a href="<?php echo e(route('product_details', $product->id)); ?>"
                                class="w-full border-2 border-blue-600 text-blue-700 px-6 py-3.5 rounded-lg font-semibold hover:bg-blue-50 transition-all duration-300 flex items-center justify-center">
                                <i class="fas fa-info-circle mr-2"></i>
                                Lihat Detail & Penawaran
                            </a>

                            <!-- Tertiary CTA: Konsultasi -->
                            <a href="<?php echo e(route('konsultasi')); ?>"
                                class="w-full bg-gray-100 text-gray-800 px-6 py-3.5 rounded-lg font-medium hover:bg-gray-200 transition-all duration-300 flex items-center justify-center">
                                <i class="fas fa-headset mr-2"></i>
                                Konsultasi Gratis
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- 11. Related Products -->
            <?php if($relatedProducts->count() > 0): ?>
            <div class="mt-8 sm:mt-12">
                <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 border border-gray-200">
                    <h2 class="text-lg sm:text-xl font-bold text-gray-900 mb-4 sm:mb-6 flex items-center gap-2">
                        <i class="fas fa-th-large text-blue-600"></i>
                        Produk Terkait
                    </h2>
                    <div class="grid grid-cols-2 sm:grid-cols-2 md:grid-cols-4 gap-3 sm:gap-4">
                        <?php $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('portfolio.detail', $related->id)); ?>" class="group">
                            <div class="bg-white border border-gray-200 rounded-lg overflow-hidden shadow-sm hover:shadow-md transition-shadow duration-300">
                                <div class="aspect-square overflow-hidden bg-white">
                                    <?php if($related->product_image): ?>
                                        <img src="<?php echo e(asset('uploads/products/' . $related->product_image)); ?>"
                                            alt="<?php echo e($related->product_title); ?>"
                                            class="w-full h-full object-contain p-2 group-hover:scale-105 transition-transform duration-300">
                                    <?php elseif($related->images->isNotEmpty()): ?>
                                        <img src="<?php echo e(asset('uploads/products/' . $related->images->first()->image_path)); ?>"
                                            alt="<?php echo e($related->product_title); ?>"
                                            class="w-full h-full object-contain p-2 group-hover:scale-105 transition-transform duration-300">
                                    <?php else: ?>
                                        <div class="w-full h-full flex items-center justify-center bg-gray-100">
                                            <i class="fas fa-image text-gray-400 text-2xl"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="p-3">
                                    <h4 class="text-xs sm:text-sm font-semibold text-gray-800 mb-1 line-clamp-2 group-hover:text-blue-600 transition-colors"><?php echo e($related->product_title); ?></h4>
                                    <?php if($related->category): ?>
                                    <p class="text-[10px] sm:text-xs text-gray-500 mb-2"><?php echo e($related->category->name); ?></p>
                                    <?php endif; ?>
                                    <p class="text-sm font-bold text-blue-600">Rp <?php echo e(number_format($related->product_prices ?? 0, 0, ',', '.')); ?></p>
                                </div>
                            </div>
                        </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>

        </div>
    </div>

    <!-- Gallery Modal (Similar to product_details) -->
    <div id="galleryModal" class="fixed inset-0 bg-black bg-opacity-95 z-[100] hidden items-center justify-center p-2 md:p-4"
        onclick="closeGallery()">
        <div class="relative w-full max-w-6xl h-full max-h-screen flex flex-col min-h-0" onclick="event.stopPropagation()">
            <div class="flex items-center justify-between mb-2 md:mb-4 flex-shrink-0 px-2 md:px-0 py-2">
                <h3 class="text-white text-sm md:text-lg font-semibold truncate pr-4"><?php echo e($product->product_title); ?></h3>
                <button onclick="closeGallery()" class="text-white hover:text-gray-300 transition flex-shrink-0 z-20 bg-black bg-opacity-50 rounded-full p-2">
                    <svg class="w-5 h-5 md:w-6 md:h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <div class="flex-1 flex items-center justify-center mb-2 md:mb-4 overflow-hidden min-h-0 relative px-2" style="min-height: 200px;">
                <img id="galleryMainImage" src="" alt="Product Image"
                    class="w-full h-full max-w-full max-h-full object-contain rounded-lg block transition-opacity duration-300"
                    style="max-height: calc(100vh - 200px);">
            </div>
        </div>
    </div>

    <script>
        // Gallery Images Array
        const galleryImages = [
            '<?php echo e(asset('uploads/products/' . $product->product_image)); ?>',
            <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                '<?php echo e(asset('uploads/products/' . $img->image_path)); ?>',
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ];
        let currentImageIndex = 0;

        function changeMainImage(imageSrc, index) {
            document.getElementById('portfolioMainImage').src = imageSrc;
            currentImageIndex = index;
            const thumbnails = document.querySelectorAll('.thumbnail-btn');
            thumbnails.forEach((thumb, i) => {
                if (i === index) {
                    thumb.classList.remove('border-gray-200');
                    thumb.classList.add('border-blue-500');
                } else {
                    thumb.classList.remove('border-blue-500');
                    thumb.classList.add('border-gray-200');
                }
            });
        }

        function openGallery(index) {
            currentImageIndex = index || 0;
            const modal = document.getElementById('galleryModal');
            const mainImage = document.getElementById('galleryMainImage');
            if (mainImage && galleryImages.length > 0) {
                modal.classList.remove('hidden');
                modal.classList.add('flex');
                document.body.style.overflow = 'hidden';
                mainImage.src = galleryImages[currentImageIndex];
            }
        }

        function closeGallery() {
            const modal = document.getElementById('galleryModal');
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.style.overflow = 'auto';
        }

        // Removed handleAskProduct - now using direct link to product_details

        // Keyboard navigation
        document.addEventListener('keydown', function(e) {
            const modal = document.getElementById('galleryModal');
            if (!modal.classList.contains('hidden')) {
                if (e.key === 'Escape') {
                    closeGallery();
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/home/portfolio-detail.blade.php ENDPATH**/ ?>