

<?php $__env->startSection('title', 'Detail Penjualan #' . $sale->id); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="<?php echo e(route('admin.transaksi.sales.index')); ?>" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Detail Penjualan #<?php echo e($sale->id); ?></h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    Dibuat pada <?php echo e($sale->created_at->format('d M Y H:i')); ?>

                </p>
            </div>
        </div>
        <div class="flex items-center space-x-2">
            <!-- Dropdown Cetak Invoice -->
            <div class="relative group">
                <button class="flex items-center bg-blue-500 hover:bg-blue-600 text-white font-medium py-2 px-4 rounded-lg transition-colors duration-200">
                    <i class="fas fa-print mr-2 text-sm"></i>
                    <span>Cetak Invoice</span>
                    <i class="fas fa-chevron-down ml-2 text-xs"></i>
                </button>
                <div class="absolute right-0 mt-2 w-56 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 shadow-lg opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                    <div class="py-2">
                        <a href="<?php echo e(route('admin.print.sale.invoice', $sale)); ?>" target="_blank"
                            class="flex items-center px-4 py-2.5 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <i class="fas fa-eye mr-3 text-blue-600 dark:text-blue-400"></i>
                            <div>
                                <div class="font-medium">Lihat & Print</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">Preview sebelum cetak</div>
                            </div>
                        </a>
                        <a href="<?php echo e(route('admin.print.sale.invoice.download', $sale)); ?>"
                            class="flex items-center px-4 py-2.5 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <i class="fas fa-file-download mr-3 text-green-600 dark:text-green-400"></i>
                            <div>
                                <div class="font-medium">Download PDF</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">Simpan file PDF</div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Product Image -->
    <?php if($sale->product && $sale->product->product_image): ?>
        <div class="mb-6 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center gap-4">
                <div class="flex-shrink-0">
                    <img src="<?php echo e(asset('uploads/products/' . $sale->product->product_image)); ?>"
                        alt="<?php echo e($sale->product->product_title); ?>"
                        class="w-32 h-32 object-contain rounded-lg"
                        style="background: transparent;">
                </div>
                <div class="flex-1">
                    <h3 class="text-lg font-semibold text-gray-800 dark:text-white mb-1"><?php echo e($sale->product->product_title ?? 'N/A'); ?></h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Produk Penjualan</p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Main Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <!-- Customer Information -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                    <i class="fas fa-user text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Pembeli</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Nama:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($sale->order->customer_name ?? 'N/A'); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Email:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100 break-all"><?php echo e($sale->order->customer_email ?? 'N/A'); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Telepon:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($sale->order->phone_number ?? 'N/A'); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Alamat:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($sale->order->address ?? 'N/A'); ?></span>
                </div>
            </div>
        </div>

        <!-- Sale Details -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                    <i class="fas fa-box text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Detail Penjualan</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Produk:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e(Str::limit($sale->product->product_title ?? 'N/A', 30)); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Quantity:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($sale->quantity); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Harga:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">Rp <?php echo e(number_format($sale->unit_price, 0, ',', '.')); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Total:</span>
                    <span class="text-xs font-semibold text-green-600 dark:text-green-400">Rp <?php echo e(number_format($sale->total_price, 0, ',', '.')); ?></span>
                </div>
            </div>
        </div>

        <!-- Status Information -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg mr-2">
                    <i class="fas fa-cog text-yellow-600 dark:text-yellow-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Status</h3>
            </div>
            
            <!-- Sale Status -->
            <div class="mb-3">
                <label class="text-xs font-medium text-gray-600 dark:text-gray-400 block mb-1.5">Status Penjualan</label>
                <?php
                    $statusConfig = [
                        'selesai' => [
                            'bg' => 'bg-green-100 dark:bg-green-900/40',
                            'text' => 'text-green-700 dark:text-green-300',
                            'icon' => 'fa-check-circle'
                        ],
                        'dibatalkan' => [
                            'bg' => 'bg-red-100 dark:bg-red-900/40',
                            'text' => 'text-red-700 dark:text-red-300',
                            'icon' => 'fa-times-circle'
                        ],
                    ];
                    $config = $statusConfig[$sale->status] ?? [
                        'bg' => 'bg-yellow-100 dark:bg-yellow-900/40',
                        'text' => 'text-yellow-700 dark:text-yellow-300',
                        'icon' => 'fa-clock'
                    ];
                ?>
                <div class="w-full px-2.5 py-1.5 text-xs border border-gray-300 dark:border-gray-600 rounded-md bg-gray-50 dark:bg-gray-700/50 text-gray-900 dark:text-white">
                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md <?php echo e($config['bg']); ?> <?php echo e($config['text']); ?>">
                        <i class="fas <?php echo e($config['icon']); ?> text-xs"></i>
                        <span><?php echo e(ucfirst($sale->status)); ?></span>
                    </span>
                </div>
            </div>

            <!-- Payment Method -->
            <div class="mb-3">
                <label class="text-xs font-medium text-gray-600 dark:text-gray-400 block mb-1.5">Metode Pembayaran</label>
                <?php
                    $paymentMethodColors = [
                        'transfer' => 'bg-blue-100 dark:bg-blue-900/40 text-blue-800 dark:text-blue-300',
                        'qris' => 'bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-300',
                        'dp' => 'bg-purple-100 dark:bg-purple-900/40 text-purple-800 dark:text-purple-300',
                        'cod' => 'bg-orange-100 dark:bg-orange-900/40 text-orange-800 dark:text-orange-300',
                    ];
                    $methodClass = $paymentMethodColors[strtolower($sale->payment_method ?? '')] ?? 'bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300';
                ?>
                <div class="w-full px-2.5 py-1.5 text-xs border border-gray-300 dark:border-gray-600 rounded-md bg-gray-50 dark:bg-gray-700/50 text-gray-900 dark:text-white">
                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md <?php echo e($methodClass); ?>">
                        <?php echo e(strtoupper($sale->payment_method ?? 'N/A')); ?>

                    </span>
                </div>
            </div>

            <!-- Sale Date -->
            <div>
                <label class="text-xs font-medium text-gray-600 dark:text-gray-400 block mb-1.5">Tanggal Penjualan</label>
                <div class="w-full px-2.5 py-1.5 text-xs border border-gray-300 dark:border-gray-600 rounded-md bg-gray-50 dark:bg-gray-700/50 text-gray-900 dark:text-white">
                    <?php echo e($sale->sale_date ? $sale->sale_date->format('d M Y H:i') : 'N/A'); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Order Information -->
    <?php if($sale->order): ?>
    <div class="mt-4 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
        <div class="flex items-center mb-3">
            <div class="p-2 bg-purple-100 dark:bg-purple-900/40 rounded-lg mr-2">
                <i class="fas fa-receipt text-purple-600 dark:text-purple-400 text-sm"></i>
            </div>
            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Order</h3>
        </div>
        <div class="space-y-2">
            <div class="flex items-start">
                <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Order ID:</span>
                <a href="<?php echo e(route('admin.master.orders.show', $sale->order->id)); ?>" 
                   class="text-xs text-blue-600 dark:text-blue-400 hover:underline">
                    #<?php echo e($sale->order->id); ?>

                </a>
            </div>
            <?php if($sale->user_id): ?>
            <div class="flex items-start">
                <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">User ID:</span>
                <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($sale->user_id); ?></span>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Notes Section -->
    <?php if(!empty($sale->notes)): ?>
    <div class="mt-4 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
        <div class="flex items-center mb-3">
            <div class="p-2 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg mr-2">
                <i class="fas fa-sticky-note text-yellow-600 dark:text-yellow-400 text-sm"></i>
            </div>
            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Catatan</h3>
        </div>
        <div class="bg-gray-50 dark:bg-gray-700/50 rounded-lg p-3 border border-gray-200 dark:border-gray-600">
            <p class="text-xs text-gray-700 dark:text-gray-300 leading-relaxed"><?php echo e($sale->notes); ?></p>
        </div>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/transaksi/sales/show.blade.php ENDPATH**/ ?>