

<?php $__env->startSection('title', 'Jurnal Umum'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Header -->
        <div class="mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Jurnal Umum</h1>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                        Input dan pengelolaan data jurnal umum dengan format Excel-like
                    </p>
                </div>
                <div class="flex items-center gap-2">
                    <button onclick="openInputModal()" class="inline-flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-plus mr-2 text-xs"></i>
                        Input Data
                    </button>
                    <button onclick="generateReport()" class="inline-flex items-center justify-center px-3 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-sync-alt mr-2 text-xs"></i>
                        Refresh Data
                    </button>
                    <button onclick="exportReport('excel')" class="inline-flex items-center justify-center px-3 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-file-excel mr-2 text-xs"></i>
                        Export Excel
                    </button>
                    <button onclick="exportReport('pdf')" class="inline-flex items-center justify-center px-3 py-2 bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-file-pdf mr-2 text-xs"></i>
                        Export PDF
                    </button>
                </div>
            </div>
        </div>

        <!-- Notifikasi Modern -->
        <?php if (isset($component)) { $__componentOriginal08a8786da7acaa0d17ad66b17276ca17 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal08a8786da7acaa0d17ad66b17276ca17 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin-notification','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-notification'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal08a8786da7acaa0d17ad66b17276ca17)): ?>
<?php $attributes = $__attributesOriginal08a8786da7acaa0d17ad66b17276ca17; ?>
<?php unset($__attributesOriginal08a8786da7acaa0d17ad66b17276ca17); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal08a8786da7acaa0d17ad66b17276ca17)): ?>
<?php $component = $__componentOriginal08a8786da7acaa0d17ad66b17276ca17; ?>
<?php unset($__componentOriginal08a8786da7acaa0d17ad66b17276ca17); ?>
<?php endif; ?>

        <?php if(session('error')): ?>
            <div class="mb-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg text-sm">
                <i class="fas fa-exclamation-circle mr-2"></i><?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <div class="mb-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 px-4 py-3 rounded-lg text-sm">
                <i class="fas fa-check-circle mr-2"></i><?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <!-- Report Display Section -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                            <i class="fas fa-file-alt text-green-600 dark:text-green-400 text-sm"></i>
                        </div>
                        <h3 class="text-base font-semibold text-gray-800 dark:text-white">Laporan Jurnal Umum</h3>
                    </div>
                </div>
            </div>

            <div id="reportContent" class="p-6">
                <div class="text-center py-12">
                    <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3 mx-auto">
                        <i class="fas fa-spinner fa-spin text-3xl text-blue-600 dark:text-blue-400"></i>
                    </div>
                    <p class="text-blue-600 dark:text-blue-400 font-medium mb-1">Memuat Laporan...</p>
                    <p class="text-blue-500 dark:text-blue-500 text-sm">Mengambil data dari database</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Input Data Modal -->
    <div id="inputModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50 hidden">
        <div class="relative top-20 mx-auto p-5 border w-11/12 max-w-7xl shadow-lg rounded-lg bg-white dark:bg-gray-800">
            <!-- Modal Header -->
            <div class="flex items-center justify-between pb-4 border-b border-gray-200 dark:border-gray-600 mb-4">
                <div class="flex items-center">
                    <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                        <i class="fas fa-table text-blue-600 dark:text-blue-400 text-sm"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 dark:text-white">Input Jurnal Umum (Format Excel-like)</h3>
                </div>
                <button onclick="closeInputModal()" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>

            <!-- Modal Body -->
            <div class="mb-4">
                <div class="flex items-center justify-end gap-2 mb-4">
                    <button onclick="addNewRow()" class="inline-flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-plus mr-2 text-xs"></i>
                        Tambah Baris
                    </button>
                    <button onclick="saveAllData()" class="inline-flex items-center justify-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-save mr-2 text-xs"></i>
                        Simpan Semua
                    </button>
                    <button onclick="clearAllRows()" class="inline-flex items-center justify-center px-3 py-2 bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-trash mr-2 text-xs"></i>
                        Hapus Semua
                    </button>
                </div>

                <div class="overflow-x-auto custom-scrollbar table-container">
                    <table id="journalTable" class="w-full" style="min-width: 1800px; table-layout: fixed;">
                        <thead class="bg-gray-50 dark:bg-gray-700 sticky top-0 z-10">
                            <tr>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-r border-gray-200 dark:border-gray-600" rowspan="2" style="width: 60px;">
                                    <input type="checkbox" id="selectAll" onchange="toggleSelectAll()" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                </th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-r border-gray-200 dark:border-gray-600" rowspan="2" style="width: 80px;">No</th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-r border-gray-200 dark:border-gray-600" rowspan="2" style="width: 140px;">Tgl Transaksi</th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-r border-gray-200 dark:border-gray-600" rowspan="2" style="width: 140px;">Bukti Transaksi</th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200" colspan="7">Transaksi</th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200" colspan="2">Info Balance</th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200" rowspan="2" style="width: 120px;">Aksi</th>
                            </tr>
                            <tr>
                                <!-- Sub-columns for Transaksi (Sesuai Excel PERSIS) -->
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 220px;">Keterangan</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 170px;">Nama Perkiraan</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 120px;">Kd_Perk</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 140px;">Customer</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 120px;">Kode</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 170px;">Nama Proyek</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 120px;">Kd Project</th>
                                <!-- Sub-columns for Info Balance -->
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 140px;">DEBIT</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 140px;">KREDIT</th>
                            </tr>
                        </thead>
                        <tbody id="journalBody" class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            <!-- Rows will be dynamically added here -->
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Modal Footer -->
            <div class="flex items-center justify-end gap-2 pt-4 border-t border-gray-200 dark:border-gray-600">
                <button onclick="closeInputModal()" class="inline-flex items-center justify-center px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                    <i class="fas fa-times mr-2 text-xs"></i>
                    Tutup
                </button>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        let rowCounter = 1;
        let journalData = [];

        // Modal functions
        function openInputModal() {
            document.getElementById('inputModal').classList.remove('hidden');
            // Load saved data when opening modal
            loadSavedData();
        }

        function closeInputModal() {
            document.getElementById('inputModal').classList.add('hidden');
        }

        // Close modal when clicking outside
        window.onclick = function(event) {
            const modal = document.getElementById('inputModal');
            if (event.target == modal) {
                closeInputModal();
            }
        }

        // Add new row to the journal table
        function addNewRow() {
            const tbody = document.getElementById('journalBody');
            const row = document.createElement('tr');
            row.className = 'journal-row hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200';
            row.setAttribute('data-row-id', rowCounter);

            row.innerHTML = `
                <td class="px-4 py-3 text-center border-r border-gray-200 dark:border-gray-600">
                    <input type="checkbox" class="row-checkbox w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600" onchange="updateRowSelection()">
                </td>
                <td class="px-4 py-3 text-center text-sm font-medium text-gray-900 dark:text-white border-r border-gray-200 dark:border-gray-600">${rowCounter}</td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="date" class="journal-input date-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="tanggal_transaksi">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="bukti_transaksi">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="keterangan">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="nama_perkiraan" readonly>
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <select class="journal-input account-select w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="kd_perk" onchange="onAccountChange(this)">
                        <option value="">-- Pilih Akun --</option>
                        <?php $__currentLoopData = $chartOfAccounts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($account->kode_akun); ?>" data-nama="<?php echo e($account->nama_akun); ?>"><?php echo e($account->kode_akun); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="customer">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="kode">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="nama_proyek" readonly>
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <select class="journal-input project-select w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="kd_project" onchange="onProjectChange(this)">
                        <option value="">-- Pilih Proyek --</option>
                        <?php $__currentLoopData = $projects ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($project->kode_bantu); ?>" data-nama="<?php echo e($project->nama_proyek); ?>"><?php echo e($project->kode_bantu); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input amount-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-right font-mono transition-all duration-200" data-column="debit" oninput="formatCurrency(this); validateBalance(this)" inputmode="numeric" pattern="[0-9]*[.,]?[0-9]*">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input amount-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-right font-mono transition-all duration-200" data-column="kredit" oninput="formatCurrency(this); validateBalance(this)" inputmode="numeric" pattern="[0-9]*[.,]?[0-9]*">
                </td>
                <td class="px-4 py-3 text-center">
                    <button onclick="deleteRow(${rowCounter})" class="inline-flex items-center justify-center w-10 h-10 text-red-600 hover:text-white hover:bg-red-600 dark:hover:bg-red-500 rounded-lg transition-all duration-200 shadow-sm hover:shadow-md" title="Hapus Baris">
                        <i class="fas fa-trash text-sm"></i>
                    </button>
                </td>
            `;

            tbody.appendChild(row);
            rowCounter++;

            // Add keyboard navigation
            addKeyboardNavigation(row);
        }

        // Handle account dropdown change
        function onAccountChange(selectElement) {
            const row = selectElement.closest('tr');
            const selectedOption = selectElement.options[selectElement.selectedIndex];
            const namaPerkiraanInput = row.querySelector('input[data-column="nama_perkiraan"]');
            
            if (selectedOption.value && selectedOption.dataset.nama) {
                namaPerkiraanInput.value = selectedOption.dataset.nama;
            } else {
                namaPerkiraanInput.value = '';
            }
        }

        // Handle project dropdown change
        function onProjectChange(selectElement) {
            const row = selectElement.closest('tr');
            const selectedOption = selectElement.options[selectElement.selectedIndex];
            const namaProyekInput = row.querySelector('input[data-column="nama_proyek"]');
            
            if (selectedOption.value && selectedOption.dataset.nama) {
                namaProyekInput.value = selectedOption.dataset.nama;
            } else {
                namaProyekInput.value = '';
            }
        }

        // Delete row
        async function deleteRow(rowId) {
            const row = document.querySelector(`[data-row-id="${rowId}"]`);
            
            if (!row) {
                alert('Baris tidak ditemukan');
                return;
            }

            const entryId = row.getAttribute('data-entry-id');

            if (!confirm('Apakah Anda yakin ingin menghapus baris ini?')) {
                return;
            }

            // If row has entryId (saved in database), delete from database
            if (entryId) {
                try {
                    let csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
                    
                    if (!csrfToken) {
                        const csrfCookie = document.cookie.split(';').find(cookie => cookie.trim().startsWith('XSRF-TOKEN='));
                        if (csrfCookie) {
                            csrfToken = decodeURIComponent(csrfCookie.split('=')[1]);
                        }
                    }

                    if (!csrfToken) {
                        alert('CSRF token tidak ditemukan. Silakan refresh halaman dan coba lagi.');
                        return;
                    }

                    const response = await fetch('<?php echo e(route("admin.reports.financial.ajax")); ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': csrfToken,
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json'
                        },
                        body: JSON.stringify({
                            action: 'delete',
                            id: entryId
                        })
                    });

                    // Check if response is OK
                    if (!response.ok) {
                        const errorText = await response.text();
                        console.error('Delete response error:', errorText);
                        throw new Error(`HTTP ${response.status}: ${errorText.substring(0, 100)}`);
                    }

                    // Try to parse JSON response
                    let result;
                    try {
                        const responseText = await response.text();
                        result = JSON.parse(responseText);
                    } catch (parseError) {
                        console.error('JSON parse error:', parseError);
                        throw new Error('Invalid response format from server');
                    }

                    if (result.success) {
                        // Remove row from DOM
                        row.remove();
                        updateRowNumbers();
                        // Refresh report
                        generateReport();
                        // Show success message
                        alert('Baris berhasil dihapus');
                    } else {
                        alert('Error: ' + (result.error || 'Gagal menghapus baris'));
                    }
                } catch (error) {
                    console.error('Delete error:', error);
                    alert('Terjadi kesalahan saat menghapus baris: ' + error.message);
                }
            } else {
                // If row is not saved yet, just remove from DOM
                row.remove();
                updateRowNumbers();
            }
        }

        // Clear all rows
        function clearAllRows() {
            if (confirm('Apakah Anda yakin ingin menghapus semua baris?')) {
                document.getElementById('journalBody').innerHTML = '';
                rowCounter = 1;
                journalData = [];
            }
        }

        // Update row numbers after deletion
        function updateRowNumbers() {
            const rows = document.querySelectorAll('.journal-row');
            rows.forEach((row, index) => {
                const numberCell = row.querySelector('td:nth-child(2)');
                if (numberCell) {
                    numberCell.textContent = index + 1;
                }
            });
            rowCounter = rows.length + 1;
        }

        // Toggle select all checkboxes
        function toggleSelectAll() {
            const selectAllCheckbox = document.getElementById('selectAll');
            const checkboxes = document.querySelectorAll('.row-checkbox');

            checkboxes.forEach(checkbox => {
                checkbox.checked = selectAllCheckbox.checked;
            });

            updateRowSelection();
        }

        // Update row selection
        function updateRowSelection() {
            const checkboxes = document.querySelectorAll('.row-checkbox');
            const selectAllCheckbox = document.getElementById('selectAll');

            const checkedBoxes = document.querySelectorAll('.row-checkbox:checked');
            selectAllCheckbox.checked = checkboxes.length > 0 && checkedBoxes.length === checkboxes.length;
            selectAllCheckbox.indeterminate = checkedBoxes.length > 0 && checkedBoxes.length < checkboxes.length;
        }

        // Format currency input
        function formatCurrency(input) {
            let value = input.value.replace(/[^\d]/g, '');

            if (value && value.length > 0) {
                let numValue = parseFloat(value);

                if (!isNaN(numValue) && numValue >= 0 && numValue <= 999999999999.99) {
                    input.value = numValue.toLocaleString('id-ID', {
                        maximumFractionDigits: 2,
                        minimumFractionDigits: 0
                    });
                } else if (numValue > 999999999999.99) {
                    numValue = 999999999999.99;
                    input.value = numValue.toLocaleString('id-ID', {
                        maximumFractionDigits: 2,
                        minimumFractionDigits: 0
                    });
                    showValidationMessage(input.closest('tr'), 'Maksimal nominal: Rp 999.999.999.999,99', 'warning');
                }
            } else {
                input.value = '';
            }
        }

        // Validate debit/credit balance
        function validateBalance(changedInput) {
            const row = changedInput.closest('tr');
            const debitInput = row.querySelector('[data-column="debit"]');
            const kreditInput = row.querySelector('[data-column="kredit"]');

            if (changedInput === debitInput && debitInput.value && kreditInput.value) {
                kreditInput.value = '';
                showValidationMessage(row, 'Debit diisi, Kredit dikosongkan otomatis', 'info');
            } else if (changedInput === kreditInput && kreditInput.value && debitInput.value) {
                debitInput.value = '';
                showValidationMessage(row, 'Kredit diisi, Debit dikosongkan otomatis', 'info');
            }

            validateRow(row);
        }

        // Show validation message
        function showValidationMessage(row, message, type = 'error') {
            const existingMessage = row.querySelector('.validation-message');
            if (existingMessage) {
                existingMessage.remove();
            }

            const messageDiv = document.createElement('div');
            messageDiv.className = `validation-message text-xs mt-1 px-2 py-1 rounded ${
                type === 'error' ? 'bg-red-100 text-red-700' :
                type === 'warning' ? 'bg-yellow-100 text-yellow-700' :
                'bg-blue-100 text-blue-700'
            }`;
            messageDiv.textContent = message;

            row.parentNode.insertBefore(messageDiv, row.nextSibling);

            setTimeout(() => {
                if (messageDiv.parentNode) {
                    messageDiv.remove();
                }
            }, 3000);
        }

        // Validate entire row
        function validateRow(row) {
            const inputs = row.querySelectorAll('.journal-input');
            let isValid = true;
            let hasData = false;

            // Check if row has any data
            inputs.forEach(input => {
                const value = input.value.trim();
                if (value) {
                    hasData = true;
                }
            });

            // If row has any data, validate required fields and debit/kredit
            if (hasData) {
                const tanggalInput = row.querySelector('[data-column="tanggal_transaksi"]');
                const keteranganInput = row.querySelector('[data-column="keterangan"]');
                const debitInput = row.querySelector('[data-column="debit"]');
                const kreditInput = row.querySelector('[data-column="kredit"]');

                // Check required fields: Tanggal Transaksi
                if (!tanggalInput || !tanggalInput.value.trim()) {
                    if (tanggalInput) {
                        tanggalInput.classList.add('border-red-500');
                    }
                    isValid = false;
                } else if (tanggalInput) {
                    tanggalInput.classList.remove('border-red-500');
                }

                // Check required fields: Keterangan
                if (!keteranganInput || !keteranganInput.value.trim()) {
                    if (keteranganInput) {
                        keteranganInput.classList.add('border-red-500');
                    }
                    isValid = false;
                } else if (keteranganInput) {
                    keteranganInput.classList.remove('border-red-500');
                }

                    // Check debit/kredit
                    const debitValue = debitInput ? debitInput.value.replace(/[^\d]/g, '') : '';
                    const kreditValue = kreditInput ? kreditInput.value.replace(/[^\d]/g, '') : '';
                    
                    // Convert to numbers, treat 0 as empty
                    const debitNum = debitValue ? parseFloat(debitValue) : 0;
                    const kreditNum = kreditValue ? parseFloat(kreditValue) : 0;

                    // Check if both are empty (both 0 or empty string)
                    if (debitNum === 0 && kreditNum === 0) {
                        if (debitInput) debitInput.classList.add('border-red-500');
                        if (kreditInput) kreditInput.classList.add('border-red-500');
                        isValid = false;
                    } else {
                        if (debitInput) debitInput.classList.remove('border-red-500');
                        if (kreditInput) kreditInput.classList.remove('border-red-500');
                        
                        // Check if both have value > 0 (not allowed)
                        if (debitNum > 0 && kreditNum > 0) {
                            if (debitInput) debitInput.classList.add('border-red-500');
                            if (kreditInput) kreditInput.classList.add('border-red-500');
                            isValid = false;
                        }
                    }
            } else {
                // Row is empty, remove all error styles
                inputs.forEach(input => {
                    input.classList.remove('border-red-500');
                });
            }

            return isValid;
        }

        // Validate all rows before save
        function validateAllRows() {
            const rows = document.querySelectorAll('.journal-row');
            let allValid = true;
            let hasAnyData = false;
            let invalidRows = [];
            let errorMessages = [];

            rows.forEach((row, index) => {
                const inputs = row.querySelectorAll('.journal-input');
                let rowHasData = false;
                
                // Check if row has any data
                inputs.forEach(input => {
                    if (input.value && input.value.trim()) {
                        rowHasData = true;
                        hasAnyData = true;
                    }
                });

                // Only validate rows that have data
                if (rowHasData) {
                    const tanggalInput = row.querySelector('[data-column="tanggal_transaksi"]');
                    const keteranganInput = row.querySelector('[data-column="keterangan"]');
                    const debitInput = row.querySelector('[data-column="debit"]');
                    const kreditInput = row.querySelector('[data-column="kredit"]');
                    
                    let rowErrors = [];
                    let rowValid = true;

                    // Check required fields
                    if (!tanggalInput || !tanggalInput.value.trim()) {
                        rowErrors.push('Tanggal Transaksi harus diisi');
                        if (tanggalInput) tanggalInput.classList.add('border-red-500');
                        rowValid = false;
                    } else if (tanggalInput) {
                        tanggalInput.classList.remove('border-red-500');
                    }
                    
                    if (!keteranganInput || !keteranganInput.value.trim()) {
                        rowErrors.push('Keterangan harus diisi');
                        if (keteranganInput) keteranganInput.classList.add('border-red-500');
                        rowValid = false;
                    } else if (keteranganInput) {
                        keteranganInput.classList.remove('border-red-500');
                    }

                    // Check debit/kredit
                    const debitValue = debitInput ? debitInput.value.replace(/[^\d]/g, '') : '';
                    const kreditValue = kreditInput ? kreditInput.value.replace(/[^\d]/g, '') : '';
                    
                    // Convert to numbers, treat 0 as empty
                    const debitNum = debitValue ? parseFloat(debitValue) : 0;
                    const kreditNum = kreditValue ? parseFloat(kreditValue) : 0;

                    // Check if both are empty (both 0 or empty string)
                    if (debitNum === 0 && kreditNum === 0) {
                        rowErrors.push('Minimal salah satu Debit atau Kredit harus diisi');
                        if (debitInput) debitInput.classList.add('border-red-500');
                        if (kreditInput) kreditInput.classList.add('border-red-500');
                        rowValid = false;
                    } else {
                        if (debitInput) debitInput.classList.remove('border-red-500');
                        if (kreditInput) kreditInput.classList.remove('border-red-500');
                        
                        // Check if both have value > 0 (not allowed)
                        if (debitNum > 0 && kreditNum > 0) {
                            rowErrors.push('Debit dan Kredit tidak boleh diisi bersamaan');
                            if (debitInput) debitInput.classList.add('border-red-500');
                            if (kreditInput) kreditInput.classList.add('border-red-500');
                            rowValid = false;
                        }
                    }

                    if (!rowValid) {
                        allValid = false;
                        invalidRows.push(index + 1);
                        errorMessages.push(`Baris ${index + 1}: ${rowErrors.join(', ')}`);
                    }
                }
            });

            if (!hasAnyData) {
                alert('Tidak ada data untuk disimpan');
                return false;
            }

            if (!allValid) {
                const message = `Mohon perbaiki kesalahan validasi pada baris: ${invalidRows.join(', ')}\n\nDetail:\n${errorMessages.join('\n')}`;
                alert(message);
                return false;
            }

            return true;
        }

        // Add keyboard navigation (Excel-like)
        function addKeyboardNavigation(row) {
            const inputs = row.querySelectorAll('.journal-input');

            inputs.forEach((input, index) => {
                input.addEventListener('keydown', function(e) {
                    const currentRow = this.closest('tr');
                    let nextInput = null;

                    switch(e.key) {
                        case 'ArrowRight':
                            if (this.selectionStart === this.value.length) {
                                nextInput = inputs[index + 1] || getNextRowInput(currentRow, 0);
                            }
                            break;
                        case 'ArrowLeft':
                            if (this.selectionStart === 0) {
                                nextInput = inputs[index - 1] || getPrevRowInput(currentRow, inputs.length - 1);
                            }
                            break;
                        case 'ArrowDown':
                            nextInput = getNextRowInput(currentRow, index);
                            break;
                        case 'ArrowUp':
                            nextInput = getPrevRowInput(currentRow, index);
                            break;
                        case 'Enter':
                            e.preventDefault();
                            nextInput = getNextRowInput(currentRow, index);
                            if (!nextInput) {
                                addNewRow();
                                setTimeout(() => {
                                    const newRow = document.querySelector('.journal-row:last-child');
                                    const newInputs = newRow.querySelectorAll('.journal-input');
                                    if (newInputs[index]) {
                                        newInputs[index].focus();
                                    }
                                }, 100);
                            }
                            break;
                    }

                    if (nextInput) {
                        e.preventDefault();
                        nextInput.focus();
                        nextInput.select();
                    }
                });
            });
        }

        // Get next row input
        function getNextRowInput(currentRow, currentIndex) {
            const nextRow = currentRow.nextElementSibling;
            if (nextRow) {
                const nextInputs = nextRow.querySelectorAll('.journal-input');
                return nextInputs[currentIndex] || null;
            }
            return null;
        }

        // Get previous row input
        function getPrevRowInput(currentRow, currentIndex) {
            const prevRow = currentRow.previousElementSibling;
            if (prevRow) {
                const prevInputs = prevRow.querySelectorAll('.journal-input');
                return prevInputs[currentIndex] || null;
            }
            return null;
        }

        // Save all data
        async function saveAllData() {
            if (!validateAllRows()) {
                alert('Mohon perbaiki kesalahan validasi sebelum menyimpan');
                return;
            }

            const rows = document.querySelectorAll('.journal-row');
            journalData = [];

            rows.forEach(row => {
                const entryId = row.getAttribute('data-entry-id');
                const rowData = {};
                const inputs = row.querySelectorAll('.journal-input');

                // Skip if row is empty
                let hasData = false;
                inputs.forEach(input => {
                    if (input.value && input.value.trim()) {
                        hasData = true;
                    }
                });

                if (!hasData) {
                    return; // Skip empty rows
                }

                // Include entry ID if exists (for update)
                if (entryId) {
                    rowData.id = entryId;
                }

                inputs.forEach(input => {
                    const column = input.getAttribute('data-column');
                    let value = input.value;

                    if (input.classList.contains('amount-input') && value) {
                        const cleanValue = value.replace(/[^\d]/g, '');
                        const numValue = cleanValue ? parseFloat(cleanValue) : 0;
                        // Only save if value > 0, otherwise null (treat 0 as empty)
                        value = numValue > 0 ? numValue : null;
                    } else if (value && value.trim() === '') {
                        value = null;
                    } else if (!value) {
                        value = null;
                    }

                    rowData[column] = value;
                });

                if (Object.values(rowData).some(val => val !== null && val !== '' && val !== 'id')) {
                    journalData.push(rowData);
                }
            });

            if (journalData.length === 0) {
                alert('Tidak ada data untuk disimpan');
                return;
            }

            try {
                let csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');

                if (!csrfToken) {
                    const csrfCookie = document.cookie.split(';').find(cookie => cookie.trim().startsWith('XSRF-TOKEN='));
                    if (csrfCookie) {
                        csrfToken = decodeURIComponent(csrfCookie.split('=')[1]);
                    }
                }

                if (!csrfToken) {
                    alert('CSRF token tidak ditemukan. Silakan refresh halaman dan coba lagi.');
                    return;
                }

                const requestData = {
                    action: 'save',
                    entries: journalData,
                    _token: csrfToken
                };

                const response = await fetch('<?php echo e(route("admin.reports.financial.ajax")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken,
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json, text/plain, */*'
                    },
                    credentials: 'same-origin',
                    body: JSON.stringify(requestData)
                });

                if (!response.ok) {
                    let errorMessage = 'HTTP Error: ' + response.status;
                    const contentType = response.headers.get('content-type');

                    try {
                        const errorText = await response.text();
                        if (errorText.includes('CSRF token mismatch') || errorText.includes('419')) {
                            errorMessage = 'CSRF token error. Silakan refresh halaman dan coba lagi.';
                        } else if (contentType && contentType.includes('text/html')) {
                            errorMessage = 'Sesi telah berakhir. Silakan refresh halaman.';
                        }
                    } catch (e) {
                        errorMessage += ' - Tidak dapat membaca detail error';
                    }

                    alert(errorMessage);
                    return;
                }

                const result = await response.json();

                if (result.success) {
                    alert(result.message);
                    // Refresh report after save
                    generateReport();
                    // Reload saved data to update entry IDs
                    loadSavedData();
                } else {
                    alert('Error: ' + (result.error || 'Terjadi kesalahan'));
                }
            } catch (error) {
                console.error('Save error:', error);
                alert('Terjadi kesalahan saat menyimpan data: ' + error.message);
            }
        }

        // Generate report
        async function generateReport() {
            const reportContent = document.getElementById('reportContent');

            reportContent.innerHTML = `
                <div class="text-center py-12">
                    <div class="w-16 h-16 bg-blue-100 dark:bg-blue-900/20 rounded-full flex items-center justify-center mb-3 mx-auto">
                        <i class="fas fa-spinner fa-spin text-3xl text-blue-600 dark:text-blue-400"></i>
                    </div>
                    <p class="text-blue-600 dark:text-blue-400 font-medium mb-1">Memuat Laporan...</p>
                    <p class="text-blue-500 dark:text-blue-500 text-sm">Mengambil data dari database</p>
                </div>
            `;

            try {
                let csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');

                if (!csrfToken) {
                    const csrfCookie = document.cookie.split(';').find(cookie => cookie.trim().startsWith('XSRF-TOKEN='));
                    if (csrfCookie) {
                        csrfToken = decodeURIComponent(csrfCookie.split('=')[1]);
                    }
                }

                const response = await fetch('<?php echo e(route("admin.reports.financial.ajax")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken || '',
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    },
                    credentials: 'same-origin',
                    body: JSON.stringify({
                        action: 'load'
                    })
                });

                // Check response status
                if (!response.ok) {
                    let errorText = '';
                    try {
                        errorText = await response.text();
                        console.error('Response error:', errorText);
                    } catch (e) {
                        errorText = 'Unable to read error response';
                    }
                    
                    // Try to parse as JSON if possible
                    let errorJson = null;
                    try {
                        errorJson = JSON.parse(errorText);
                    } catch (e) {
                        // Not JSON, use text
                    }
                    
                    if (errorJson && errorJson.error) {
                        throw new Error(errorJson.error);
                    } else {
                        throw new Error(`HTTP ${response.status}: ${errorText.substring(0, 200)}`);
                    }
                }

                // Get response text first
                const responseText = await response.text();
                console.log('Response text:', responseText);

                let result;
                try {
                    result = JSON.parse(responseText);
                } catch (jsonError) {
                    console.error('JSON parse error:', jsonError);
                    console.error('Response was:', responseText);
                    throw new Error('Invalid response format from server. Expected JSON. Response: ' + responseText.substring(0, 100));
                }

                const reportData = result.entries || [];

                if (!Array.isArray(reportData)) {
                    throw new Error('Invalid data format received from server.');
                }

                if (reportData.length === 0) {
                    reportContent.innerHTML = `
                        <div class="text-center py-12">
                            <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3 mx-auto">
                                <i class="fas fa-file-alt text-3xl text-gray-400 dark:text-gray-500"></i>
                            </div>
                            <p class="text-gray-500 dark:text-gray-400 font-medium mb-1">Belum ada laporan</p>
                            <p class="text-gray-400 dark:text-gray-500 text-sm">Klik tombol "Input Data" untuk menambahkan data jurnal</p>
                        </div>
                    `;
                    return;
                }

                let reportHTML = `
                    <div class="mb-6 text-center">
                        <h2 class="text-2xl font-bold text-gray-800 dark:text-white mb-2">Laporan Jurnal Umum</h2>
                        <p class="text-gray-600 dark:text-gray-400">Periode: ${new Date().toLocaleDateString('id-ID')}</p>
                        <p class="text-gray-500 dark:text-gray-500 text-sm mt-1">Total Entries: ${reportData.length}</p>
                    </div>

                    <div class="overflow-x-auto custom-scrollbar" style="max-width: 100%;">
                        <table class="w-full border border-gray-300 dark:border-gray-600" style="min-width: 1400px;">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                                <tr>
                                    <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-b border-r border-gray-300 dark:border-gray-600" rowspan="2">No</th>
                                    <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-b border-r border-gray-300 dark:border-gray-600" rowspan="2">Tgl Transaksi</th>
                                    <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-b border-r border-gray-300 dark:border-gray-600" rowspan="2">Bukti Transaksi</th>
                                <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-b" colspan="7">Transaksi</th>
                                <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-b" colspan="2">Info Balance</th>
                                </tr>
                                <tr>
                                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-300 dark:border-gray-600">Keterangan</th>
                                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-300 dark:border-gray-600">Nama Perkiraan</th>
                                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-300 dark:border-gray-600">Kd_Perk</th>
                                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-300 dark:border-gray-600">Customer</th>
                                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-300 dark:border-gray-600">Kode</th>
                                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-300 dark:border-gray-600">Nama Proyek</th>
                                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-300 dark:border-gray-600">Kd Project</th>
                                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-300 dark:border-gray-600">DEBIT</th>
                                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-600 dark:text-gray-300">KREDIT</th>
                                </tr>
                            </thead>
                            <tbody>
                `;

                let totalDebit = 0;
                let totalKredit = 0;
                let runningSaldo = 0;

                reportData.forEach((item, index) => {
                    try {
                        const debitValue = item.debit ? parseFloat(item.debit) : 0;
                        const kreditValue = item.kredit ? parseFloat(item.kredit) : 0;

                        const validDebit = isNaN(debitValue) ? 0 : debitValue;
                        const validKredit = isNaN(kreditValue) ? 0 : kreditValue;

                        totalDebit += validDebit;
                        totalKredit += validKredit;

                        // Calculate running saldo
                        runningSaldo = runningSaldo + validDebit - validKredit;

                        reportHTML += `
                            <tr class="border-b border-gray-200 dark:border-gray-600">
                                <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600">${index + 1}</td>
                                <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600">${item.tanggal_transaksi ? new Date(item.tanggal_transaksi).toLocaleDateString('id-ID') : '-'}</td>
                                <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600">${item.bukti_transaksi || '-'}</td>
                                <td class="px-4 py-3 text-sm border-r border-gray-300 dark:border-gray-600">${item.keterangan || '-'}</td>
                                <td class="px-4 py-3 text-sm border-r border-gray-300 dark:border-gray-600">${item.nama_perkiraan || '-'}</td>
                                <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600">${item.kd_perk || '-'}</td>
                                <td class="px-4 py-3 text-sm border-r border-gray-300 dark:border-gray-600">${item.customer || '-'}</td>
                                <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600">${item.kode || '-'}</td>
                                <td class="px-4 py-3 text-sm border-r border-gray-300 dark:border-gray-600">${item.nama_proyek || '-'}</td>
                                <td class="px-4 py-3 text-center text-sm border-r border-gray-300 dark:border-gray-600">${item.kd_project || '-'}</td>
                                <td class="px-4 py-3 text-right text-sm font-semibold text-green-600 border-r border-gray-300 dark:border-gray-600">${validDebit ? 'Rp ' + validDebit.toLocaleString('id-ID') : '-'}</td>
                                <td class="px-4 py-3 text-right text-sm font-semibold text-red-600">${validKredit ? 'Rp ' + validKredit.toLocaleString('id-ID') : '-'}</td>
                            </tr>
                        `;
                    } catch (itemError) {
                        console.error('Error processing report item:', item, itemError);
                    }
                });

                reportHTML += `
                            </tbody>
                            <tfoot class="bg-gray-50 dark:bg-gray-700">
                                <tr>
                                    <td colspan="10" class="px-4 py-3 text-right text-sm font-semibold border-t border-gray-300 dark:border-gray-600">TOTAL</td>
                                    <td class="px-4 py-3 text-right text-sm font-bold text-green-600 border-t border-r border-gray-300 dark:border-gray-600">Rp ${totalDebit.toLocaleString('id-ID')}</td>
                                    <td class="px-4 py-3 text-right text-sm font-bold text-red-600 border-t border-gray-300 dark:border-gray-600">Rp ${totalKredit.toLocaleString('id-ID')}</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <div class="mt-6 grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div class="bg-blue-50 dark:bg-blue-900/20 p-4 rounded-lg">
                            <h4 class="font-semibold text-blue-800 dark:text-blue-200 mb-2">Ringkasan</h4>
                            <p class="text-sm text-blue-700 dark:text-blue-300">
                                Total Debit: <span class="font-bold">Rp ${totalDebit.toLocaleString('id-ID')}</span><br>
                                Total Kredit: <span class="font-bold">Rp ${totalKredit.toLocaleString('id-ID')}</span><br>
                                Selisih: <span class="font-bold ${totalDebit === totalKredit ? 'text-green-600' : 'text-red-600'}">Rp ${(totalDebit - totalKredit).toLocaleString('id-ID')}</span>
                            </p>
                        </div>
                        <div class="bg-green-50 dark:bg-green-900/20 p-4 rounded-lg">
                            <h4 class="font-semibold text-green-800 dark:text-green-200 mb-2">Status</h4>
                            <p class="text-sm ${totalDebit === totalKredit ? 'text-green-700 dark:text-green-300' : 'text-red-700 dark:text-red-300'}">
                                ${totalDebit === totalKredit ? '✓ Jurnal Balance' : '✗ Jurnal Tidak Balance'}
                            </p>
                        </div>
                        <div class="bg-purple-50 dark:bg-purple-900/20 p-4 rounded-lg">
                            <h4 class="font-semibold text-purple-800 dark:text-purple-200 mb-2">Info</h4>
                            <p class="text-sm text-purple-700 dark:text-purple-300">
                                Dicetak pada: ${new Date().toLocaleString('id-ID')}<br>
                                Oleh: <?php echo e(auth()->user()->name ?? 'Admin'); ?>

                            </p>
                        </div>
                    </div>
                `;

                reportContent.innerHTML = reportHTML;

            } catch (error) {
                console.error('Report generation error:', error);

                let errorMessage = 'Terjadi kesalahan saat membuat laporan';
                let errorDetails = '';

                if (error.message) {
                    errorDetails = error.message;
                    if (error.message.includes('CSRF token expired')) {
                        errorMessage = 'Sesi telah berakhir';
                        errorDetails = 'Silakan refresh halaman dan coba lagi';
                    } else if (error.message.includes('fetch')) {
                        errorMessage = 'Gagal mengambil data dari server';
                        errorDetails = 'Periksa koneksi internet dan coba lagi';
                    }
                }

                reportContent.innerHTML = `
                    <div class="text-center py-12">
                        <div class="w-16 h-16 bg-red-100 dark:bg-red-900/20 rounded-full flex items-center justify-center mb-3 mx-auto">
                            <i class="fas fa-exclamation-triangle text-3xl text-red-400 dark:text-red-500"></i>
                        </div>
                        <p class="text-red-500 dark:text-red-400 font-medium mb-1">Error generating report</p>
                        <p class="text-red-400 dark:text-red-500 text-sm">${errorMessage}</p>
                        ${errorDetails ? `<p class="text-red-300 dark:text-red-600 text-xs mt-2">${errorDetails}</p>` : ''}
                        <div class="mt-4">
                            <button onclick="generateReport()" class="inline-flex items-center px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors duration-200">
                                <i class="fas fa-redo mr-2"></i>
                                Coba Lagi
                            </button>
                        </div>
                    </div>
                `;
            }
        }

        // Export report
        async function exportReport(type) {
            try {
                let csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
                
                if (!csrfToken) {
                    alert('CSRF token tidak ditemukan. Silakan refresh halaman dan coba lagi.');
                    return;
                }

                let exportUrl = '';
                if (type === 'excel') {
                    exportUrl = '<?php echo e(route("admin.reports.financial.export")); ?>';
                } else if (type === 'pdf') {
                    exportUrl = '<?php echo e(route("admin.reports.financial.pdf")); ?>';
                } else {
                    alert('Tipe export tidak valid');
                    return;
                }

                window.open(exportUrl, '_blank');
            } catch (error) {
                console.error('Export error:', error);
                alert('Terjadi kesalahan saat mengekspor: ' + error.message);
            }
        }

        // Load saved data from server
        async function loadSavedData() {
            try {
                const response = await fetch('<?php echo e(route("admin.reports.financial.ajax")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify({
                        action: 'load'
                    })
                });

                const result = await response.json();

                const tbody = document.getElementById('journalBody');
                
                // Clear existing rows
                tbody.innerHTML = '';
                rowCounter = 1;

                if (result.entries && result.entries.length > 0) {
                    result.entries.forEach((entry, index) => {
                        addNewRow();

                        const row = tbody.lastElementChild;
                        // Set entry ID to prevent duplication
                        row.setAttribute('data-entry-id', entry.id);

                        const inputs = row.querySelectorAll('.journal-input');
                        const selects = row.querySelectorAll('select.journal-input');

                        // Fill dropdowns first
                        selects.forEach(select => {
                            const column = select.getAttribute('data-column');
                            if (entry[column]) {
                                select.value = entry[column];
                                // Trigger change event to auto-fill related fields
                                if (select.classList.contains('account-select')) {
                                    onAccountChange(select);
                                } else if (select.classList.contains('project-select')) {
                                    onProjectChange(select);
                                }
                            }
                        });

                        // Fill regular inputs
                        inputs.forEach(input => {
                            const column = input.getAttribute('data-column');
                            if (entry[column] !== null && entry[column] !== undefined && entry[column] !== '') {
                                if (input.classList.contains('amount-input')) {
                                    input.value = parseFloat(entry[column]).toLocaleString('id-ID');
                                } else if (input.classList.contains('date-input')) {
                                    input.value = entry[column];
                                } else {
                                    input.value = entry[column];
                                }
                            }
                        });
                    });
                }
                
                // Always add one empty row for new entry
                addNewRow();
            } catch (error) {
                console.error('Load error:', error);
                // Add empty row if error
                addNewRow();
            }
        }


        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            // Generate report on page load
            generateReport();

            // Add keyboard shortcuts
            document.addEventListener('keydown', function(e) {
                if (e.ctrlKey && e.key === 'Enter') {
                    e.preventDefault();
                    saveAllData();
                } else if (e.ctrlKey && e.key === 'n') {
                    e.preventDefault();
                    addNewRow();
                } else if (e.key === 'Escape') {
                    closeInputModal();
                }
            });
        });
    </script>

    <style>
        /* Modal Styles */
        #inputModal {
            z-index: 9999;
        }

        /* Journal Input Styles */
        .journal-input {
            transition: all 0.2s;
        }

        .journal-input:focus {
            box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.2);
            border-color: rgb(59, 130, 246);
        }

        /* Custom scrollbar for table */
        .custom-scrollbar {
            scrollbar-width: auto;
            scrollbar-color: rgb(156 163 175) rgb(243 244 246);
        }

        .dark .custom-scrollbar {
            scrollbar-color: rgb(107 114 128) rgb(31 41 55);
        }

        .custom-scrollbar::-webkit-scrollbar {
            width: 16px;
            height: 16px;
            background: rgb(243 244 246);
        }

        .dark .custom-scrollbar::-webkit-scrollbar {
            background: rgb(31 41 55);
        }

        .custom-scrollbar::-webkit-scrollbar-track {
            background: rgb(243 244 246);
            border-radius: 8px;
            margin: 4px;
        }

        .dark .custom-scrollbar::-webkit-scrollbar-track {
            background: rgb(31 41 55);
        }

        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: rgb(156 163 175);
            border-radius: 8px;
            border: 3px solid rgb(243 244 246);
            min-height: 40px;
        }

        .dark .custom-scrollbar::-webkit-scrollbar-thumb {
            background: rgb(107 114 128);
            border: 3px solid rgb(31 41 55);
        }

        .custom-scrollbar::-webkit-scrollbar-thumb:hover {
            background: rgb(107 114 128);
        }

        .dark .custom-scrollbar::-webkit-scrollbar-thumb:hover {
            background: rgb(75 85 99);
        }

        /* Table styling */
        #journalTable th {
            position: sticky;
            top: 0;
            background: rgb(249 250 251);
            z-index: 20;
            box-shadow: 0 2px 4px -1px rgba(0, 0, 0, 0.1);
        }

        .dark #journalTable th {
            background: rgb(31 41 55);
            box-shadow: 0 2px 4px -1px rgba(0, 0, 0, 0.3);
        }

        .journal-input {
            transition: all 0.2s ease-in-out;
            border-radius: 8px;
        }

        .journal-input:focus {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.15);
            border-color: rgb(59, 130, 246);
        }

        .dark .journal-input:focus {
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
        }

        .amount-input {
            font-family: 'SF Mono', 'Monaco', 'Inconsolata', 'Roboto Mono', 'Consolas', 'Courier New', monospace;
            font-weight: 500;
        }

        .journal-row {
            transition: all 0.15s ease-in-out;
        }

        .journal-row:hover {
            background-color: rgb(249 250 251);
            transform: translateY(-1px);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .dark .journal-row:hover {
            background-color: rgb(55 65 81);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.3);
        }

        #journalTable {
            table-layout: fixed !important;
            border-collapse: separate;
            border-spacing: 0;
            width: 1800px;
            min-width: 1800px;
        }

        #journalTable th,
        #journalTable td {
            border-right: 1px solid rgb(229 231 235);
            padding: 12px 16px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .dark #journalTable th,
        .dark #journalTable td {
            border-right: 1px solid rgb(55 65 81);
        }

        #journalTable input {
            white-space: nowrap;
            overflow: hidden;
        }

        .table-container {
            width: 100%;
            overflow-x: auto !important;
            overflow-y: visible;
            -webkit-overflow-scrolling: touch;
            border: 1px solid rgb(229 231 235);
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            position: relative;
        }

        .dark .table-container {
            border: 1px solid rgb(55 65 81);
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.3);
        }

        .content-wrapper {
            width: 100% !important;
            max-width: none !important;
            box-sizing: border-box;
            margin-left: 0 !important;
            overflow: visible !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/reports/financial.blade.php ENDPATH**/ ?>