

<?php $__env->startSection('title', 'Detail Chart of Account'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Header -->
        <div class="mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Detail Chart of Account</h1>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                        Informasi lengkap akun/perkiraan
                    </p>
                </div>
                <div class="flex items-center gap-2">
                    <a href="<?php echo e(route('admin.chart-of-accounts.edit', $chartOfAccount)); ?>"
                        class="px-4 py-2 bg-yellow-600 hover:bg-yellow-700 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-edit mr-2"></i>Edit
                    </a>
                    <a href="<?php echo e(route('admin.chart-of-accounts.index')); ?>"
                        class="px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-arrow-left mr-2"></i>Kembali
                    </a>
                </div>
            </div>
        </div>

        <!-- Detail Card -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6 mb-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Kode Akun</label>
                    <p class="text-lg font-semibold text-gray-800 dark:text-white"><?php echo e($chartOfAccount->kode_akun); ?></p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Nama Akun</label>
                    <p class="text-lg font-semibold text-gray-800 dark:text-white"><?php echo e($chartOfAccount->nama_akun); ?></p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Tabel Bantuan</label>
                    <p class="text-gray-800 dark:text-white"><?php echo e($chartOfAccount->tabel_bantuan ?? '-'); ?></p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Pos Saldo</label>
                    <span class="inline-block px-3 py-1 text-sm font-medium rounded <?php echo e($chartOfAccount->pos_saldo == 'DEBET' ? 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200' : 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200'); ?>">
                        <?php echo e($chartOfAccount->pos_saldo); ?>

                    </span>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Pos Laporan</label>
                    <span class="inline-block px-3 py-1 text-sm font-medium rounded <?php echo e($chartOfAccount->pos_laporan == 'NERACA' ? 'bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-200' : 'bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-200'); ?>">
                        <?php echo e($chartOfAccount->pos_laporan); ?>

                    </span>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Status</label>
                    <span class="inline-block px-3 py-1 text-sm font-medium rounded <?php echo e($chartOfAccount->is_active ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200'); ?>">
                        <?php echo e($chartOfAccount->is_active ? 'Aktif' : 'Nonaktif'); ?>

                    </span>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Saldo Awal Debet</label>
                    <p class="text-gray-800 dark:text-white"><?php echo e($chartOfAccount->saldo_awal_debet > 0 ? 'Rp ' . number_format($chartOfAccount->saldo_awal_debet, 0, ',', '.') : '-'); ?></p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Saldo Awal Kredit</label>
                    <p class="text-gray-800 dark:text-white"><?php echo e($chartOfAccount->saldo_awal_kredit > 0 ? 'Rp ' . number_format($chartOfAccount->saldo_awal_kredit, 0, ',', '.') : '-'); ?></p>
                </div>
                <?php if($chartOfAccount->keterangan): ?>
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Keterangan</label>
                    <p class="text-gray-800 dark:text-white"><?php echo e($chartOfAccount->keterangan); ?></p>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Journal Entries -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
            <h3 class="text-lg font-semibold text-gray-800 dark:text-white mb-4">
                Jurnal yang Menggunakan Akun Ini (<?php echo e($chartOfAccount->journal_entries_count ?? 0); ?>)
            </h3>
            <?php if($chartOfAccount->journal_entries_count > 0): ?>
                <p class="text-sm text-gray-600 dark:text-gray-400">
                    Akun ini digunakan dalam <?php echo e($chartOfAccount->journal_entries_count); ?> entri jurnal.
                    <a href="<?php echo e(route('admin.reports.financial')); ?>?search=<?php echo e($chartOfAccount->kode_akun); ?>" class="text-blue-600 hover:underline dark:text-blue-400">
                        Lihat di Jurnal Umum
                    </a>
                </p>
            <?php else: ?>
                <p class="text-sm text-gray-500 dark:text-gray-400">Belum ada jurnal yang menggunakan akun ini.</p>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/chart-of-accounts/show.blade.php ENDPATH**/ ?>