<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title'); ?> - Poljam Tech</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/jpeg" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="shortcut icon" type="image/jpeg" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="icon" type="image/jpeg" sizes="32x32" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="icon" type="image/jpeg" sizes="16x16" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="bg-white min-h-screen">
    <!-- Mobile Layout (default) -->
    <div class="lg:hidden flex items-center justify-center min-h-screen py-8 sm:py-12 px-4 sm:px-6">
        <div class="relative z-10 w-full max-w-md">
            <!-- Logo Section -->
            <div class="flex justify-center mb-12">
                <a href="<?php echo e(url('/')); ?>" class="flex-shrink-0">
                    <h3 class="text-4xl font-extrabold bg-gradient-to-r from-blue-400 to-cyan-400 bg-clip-text text-transparent">POLJAM TECH</h3>
                </a>
            </div>

            <!-- Title & Subtitle -->
            <div class="text-center mb-8 sm:mb-12">
                <h2 class="text-xl sm:text-2xl font-bold text-gray-900 mb-1.5"><?php echo $__env->yieldContent('title'); ?></h2>
                <p class="text-gray-600 text-xs sm:text-sm"><?php echo $__env->yieldContent('subtitle'); ?></p>
            </div>

            <!-- Content Section -->
            <div class="w-full">
                <?php echo $__env->yieldContent('content'); ?>
            </div>

            <!-- Footer Links -->
            <div class="mt-8">
                <?php echo $__env->yieldContent('footer_links'); ?>
            </div>

            <!-- Additional Info Section -->
            <div class="mt-12 text-center">
                <p class="text-gray-500 text-xs">
                    <?php echo $__env->yieldContent('additional_info'); ?>
                </p>
            </div>
        </div>
    </div>

    <!-- Desktop Layout (Split Screen) -->
    <div class="hidden lg:flex min-h-screen">
        <!-- Left Side: Background Image -->
        <div class="w-1/2 relative bg-cover bg-center bg-no-repeat" style="background-image: url('<?php echo e(asset('images/logo/login-poljamtech.jpeg')); ?>');">
            <!-- Content Overlay -->
            <div class="relative z-10 h-full flex flex-col justify-between p-12">
                <!-- Top: Logo -->
                <div>
                    <a href="<?php echo e(url('/')); ?>" class="inline-block">
                        <h3 class="text-4xl lg:text-5xl font-extrabold bg-gradient-to-r from-blue-400 to-cyan-400 bg-clip-text text-transparent drop-shadow-lg">POLJAM TECH</h3>
                    </a>
                </div>

                <!-- Bottom: Additional Info -->
                <div class="text-white drop-shadow-lg text-sm">
                    <p>🔒 Enterprise-Grade Security | Powered by Poljam Tech</p>
                </div>
            </div>
        </div>

        <!-- Right Side: Form -->
        <div class="w-1/2 bg-white flex items-center justify-center p-8 xl:p-12">
            <div class="w-full max-w-md">
                <!-- Title & Subtitle -->
                <div class="mb-6 lg:mb-8">
                    <h2 class="text-2xl lg:text-3xl font-bold text-gray-900 mb-2"><?php echo $__env->yieldContent('title'); ?></h2>
                    <p class="text-gray-600 text-sm lg:text-base"><?php echo $__env->yieldContent('subtitle'); ?></p>
                </div>

                <!-- Content Section -->
                <div class="w-full">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>

                <!-- Footer Links -->
                <div class="mt-6">
                    <?php echo $__env->yieldContent('footer_links'); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Error Alert Component -->
    <?php if($errors->any()): ?>
        <div id="error-alert" class="fixed top-6 right-6 z-50 w-full max-w-sm animate-slideIn">
            <div class="bg-red-50 border-l-4 border-red-500 p-5 rounded-xl shadow-2xl backdrop-blur-sm relative">
                <!-- Close Button -->
                <button type="button" onclick="closeErrorAlert()" 
                    class="absolute top-3 right-3 text-red-400 hover:text-red-600 transition-colors focus:outline-none">
                    <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                </button>
                <div class="flex items-start pr-6">
                    <div class="flex-shrink-0">
                        <svg class="h-6 w-6 text-red-500" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-sm font-bold text-red-800">Kesalahan Validasi</h3>
                        <div class="mt-3 text-sm text-red-700">
                            <ul class="space-y-1">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="flex items-center">
                                        <span class="inline-block w-1.5 h-1.5 bg-red-500 rounded-full mr-2"></span>
                                        <?php echo e($error); ?>

                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Success Alert Component -->
    <?php if(session('status')): ?>
        <div id="success-alert" class="fixed top-6 right-6 z-50 w-full max-w-sm animate-slideIn">
            <div class="bg-green-50 border-l-4 border-green-500 p-5 rounded-xl shadow-2xl backdrop-blur-sm relative">
                <!-- Close Button -->
                <button type="button" onclick="closeSuccessAlert()" 
                    class="absolute top-3 right-3 text-green-400 hover:text-green-600 transition-colors focus:outline-none">
                    <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                </button>
                <div class="flex items-center pr-6">
                    <svg class="h-6 w-6 text-green-500 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <div class="ml-4">
                        <p class="text-sm font-semibold text-green-800"><?php echo e(session('status')); ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <style>
        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateX(100px);
            }

            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        @keyframes slideOut {
            from {
                opacity: 1;
                transform: translateX(0);
            }

            to {
                opacity: 0;
                transform: translateX(100px);
            }
        }

        .animate-slideIn {
            animation: slideIn 0.3s ease-out;
        }

        .animate-slideOut {
            animation: slideOut 0.3s ease-out;
        }
    </style>

    <script>
        // Function to close error alert
        function closeErrorAlert() {
            const alert = document.getElementById('error-alert');
            if (alert) {
                alert.classList.add('animate-slideOut');
                setTimeout(() => {
                    alert.remove();
                }, 300);
            }
        }

        // Function to close success alert
        function closeSuccessAlert() {
            const alert = document.getElementById('success-alert');
            if (alert) {
                alert.classList.add('animate-slideOut');
                setTimeout(() => {
                    alert.remove();
                }, 300);
            }
        }

        // Auto-hide error alert after 8 seconds
        document.addEventListener('DOMContentLoaded', function() {
            const errorAlert = document.getElementById('error-alert');
            if (errorAlert) {
                setTimeout(() => {
                    closeErrorAlert();
                }, 8000); // Hide after 8 seconds
            }

            // Auto-hide success alert after 5 seconds
            const successAlert = document.getElementById('success-alert');
            if (successAlert) {
                setTimeout(() => {
                    closeSuccessAlert();
                }, 5000); // Hide after 5 seconds
            }
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/layouts/auth.blade.php ENDPATH**/ ?>