

<?php $__env->startSection('title', 'Review Penawaran Harga - Supervisor'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Notifikasi -->
    <?php if(session('success')): ?>
        <div x-data="{ show: true }" x-show="show" x-transition:enter="transition transform ease-out duration-500"
            x-transition:enter-start="-translate-y-10 opacity-0" x-transition:enter-end="translate-y-0 opacity-100"
            x-transition:leave="transition transform ease-in duration-500"
            x-transition:leave-start="translate-y-0 opacity-100" x-transition:leave-end="-translate-y-10 opacity-0"
            x-init="setTimeout(() => show = false, 4000)"
            class="fixed top-6 left-1/2 transform -translate-x-1/2 z-50 w-[90%] sm:w-[500px] bg-gradient-to-r from-green-500 to-emerald-600 text-white shadow-2xl rounded-xl px-6 py-4 flex items-center justify-between space-x-3">
            <div class="flex items-center space-x-3">
                <div class="flex items-center justify-center w-8 h-8 bg-white/20 rounded-full">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-white" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.707a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 10-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                    </svg>
                </div>
                <div class="flex-1 font-semibold text-sm sm:text-base">
                    <?php echo e(session('success')); ?>

                </div>
            </div>
            <button @click="show = false" class="hover:bg-white/20 rounded-full p-1 transition duration-200">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div x-data="{ show: true }" x-show="show" x-transition:enter="transition transform ease-out duration-500"
            x-transition:enter-start="-translate-y-10 opacity-0" x-transition:enter-end="translate-y-0 opacity-100"
            x-transition:leave="transition transform ease-in duration-500"
            x-transition:leave-start="translate-y-0 opacity-100" x-transition:leave-end="-translate-y-10 opacity-0"
            x-init="setTimeout(() => show = false, 4000)"
            class="fixed top-6 left-1/2 transform -translate-x-1/2 z-50 w-[90%] sm:w-[500px] bg-gradient-to-r from-red-500 to-pink-600 text-white shadow-2xl rounded-xl px-6 py-4 flex items-center justify-between space-x-3">
            <div class="flex items-center space-x-3">
                <div class="flex items-center justify-center w-8 h-8 bg-white/20 rounded-full">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-white" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                    </svg>
                </div>
                <div class="flex-1 font-semibold text-sm sm:text-base">
                    <?php echo e(session('error')); ?>

                </div>
            </div>
            <button @click="show = false" class="hover:bg-white/20 rounded-full p-1 transition duration-200">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>
    <?php endif; ?>

    <?php if(session('statusMessage')): ?>
    <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-4">
        <div class="flex items-center">
            <i class="fas fa-info-circle text-yellow-600 dark:text-yellow-400 mr-2"></i>
            <p class="text-sm text-yellow-800 dark:text-yellow-200"><?php echo e(session('statusMessage')); ?></p>
        </div>
    </div>
    <?php endif; ?>

    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800 dark:text-white mb-2">Review Penawaran Harga</h1>
        <p class="text-gray-600 dark:text-gray-400">Beri range harga yang sesuai untuk penawaran customer</p>
    </div>

    <!-- Quick Stats -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-clipboard-list text-blue-600 dark:text-blue-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Total Penawaran</p>
                    <p class="text-lg font-semibold text-gray-900 dark:text-white"><?php echo e($inquiries->total()); ?></p>
                </div>
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <div class="p-2 bg-purple-100 dark:bg-purple-900/40 rounded-lg">
                    <i class="fas fa-clock text-purple-600 dark:text-purple-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Menunggu Review</p>
                    <p class="text-lg font-semibold text-gray-900 dark:text-white"><?php echo e($inquiries->count()); ?></p>
                </div>
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg">
                    <i class="fas fa-handshake text-green-600 dark:text-green-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Status</p>
                    <p class="text-lg font-semibold text-gray-900 dark:text-white">Aktif</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Table Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="p-6">

            <?php if($inquiries->count() > 0): ?>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-600">
                        <tr>
                            <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Produk & Customer</th>
                            <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Permintaan</th>
                            <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Harga Base</th>
                            <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        <?php $__currentLoopData = $inquiries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inquiry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr id="inquiry-row-<?php echo e($inquiry->id); ?>" class="hover:bg-blue-50/50 dark:hover:bg-gray-700/80 transition-colors duration-200">
                            <td class="px-6 py-4">
                                <div class="flex items-start">
                                    <div class="flex-1">
                                        <div class="text-sm font-medium text-gray-900 dark:text-white mb-1">
                                            <?php echo e($inquiry->product->product_title ?? 'N/A'); ?>

                                        </div>
                                        <div class="text-xs text-gray-500 dark:text-gray-400 space-y-0.5">
                                            <div><i class="fas fa-user mr-1"></i><?php echo e($inquiry->name); ?></div>
                                            <div><i class="fas fa-envelope mr-1"></i><?php echo e($inquiry->email); ?></div>
                                            <div><i class="fas fa-phone mr-1"></i><?php echo e($inquiry->phone); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <?php
                                    $raw = $inquiry->message ?? '';
                                    $lines = preg_split("/(\r\n|\n|\r)/", $raw);
                                    $type = null; $addons = []; $hasAddonsLine = false;
                                    if (!empty($lines)) {
                                        $first = $lines[0] ?? '';
                                        $second = $lines[1] ?? '';
                                        if (substr($first, 0, 14) === '[REQUEST_TYPE]') { $type = trim(substr($first, 14)); }
                                        if (substr($second, 0, 8) === '[ADDONS]') {
                                            $hasAddonsLine = true;
                                            $matches = [];
                                            if (preg_match('/^\[ADDONS\]\s*(\[[\s\S]*\])$/', $second, $matches)) {
                                                $decoded = json_decode($matches[1], true);
                                                if (is_array($decoded)) { $addons = $decoded; }
                                            }
                                        }
                                    }
                                    $startIdx = 0; if ($type) { $startIdx++; } if ($hasAddonsLine) { $startIdx++; }
                                    if (!empty($lines) && isset($lines[$startIdx]) && trim($lines[$startIdx]) === '') { $startIdx++; }
                                    $plain = implode("\n", array_slice($lines, $startIdx));
                                    $badgeText = $type === 'custom_addon' ? 'Custom Add-on' : ($type === 'custom_new' ? 'Custom Baru' : ($type ? 'Katalog' : null));
                                    $badgeCls = $type === 'custom_addon' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/40 dark:text-yellow-200' : ($type === 'custom_new' ? 'bg-red-100 text-red-800 dark:bg-red-900/40 dark:text-red-200' : 'bg-blue-100 text-blue-800 dark:bg-blue-900/40 dark:text-blue-200');
                                ?>
                                <div class="space-y-2 max-w-md">
                                    <?php if($badgeText): ?>
                                        <span class="inline-flex items-center px-2 py-0.5 text-[10px] font-semibold rounded-full <?php echo e($badgeCls); ?>"><?php echo e($badgeText); ?></span>
                                    <?php endif; ?>
                                    <?php if(!empty($addons)): ?>
                                        <div class="text-xs text-gray-600 dark:text-gray-400">
                                            <i class="fas fa-tools mr-1"></i><span class="font-medium">Spesifikasi:</span>
                                            <div class="mt-1 pl-4 space-y-0.5">
                                                <?php $__currentLoopData = array_slice($addons, 0, 2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div>• <?php echo e(is_array($addon) ? ($addon['name'] ?? '-') : '-'); ?>: <?php echo e(is_array($addon) ? ($addon['value'] ?? '-') : '-'); ?></div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(count($addons) > 2): ?>
                                                    <div class="text-gray-500 dark:text-gray-500">+<?php echo e(count($addons) - 2); ?> lagi</div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <p class="text-sm text-gray-900 dark:text-white" style="display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden" title="<?php echo e($plain); ?>"><?php echo e($plain); ?></p>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-center">
                                <div class="text-sm font-semibold text-gray-900 dark:text-white">
                                    Rp <?php echo e(number_format($inquiry->product->product_prices ?? 0, 0, ',', '.')); ?>

                                </div>
                            </td>
                            <td class="px-6 py-4 text-center">
                                <button type="button" data-approve-btn="1"
                                    data-id='<?php echo e($inquiry->id); ?>'
                                    data-title='<?php echo json_encode($inquiry->product->product_title, 15, 512) ?>'
                                    data-base='<?php echo e((float)($inquiry->product->product_prices ?? 0)); ?>'
                                    data-materials='<?php echo json_encode($inquiry->materials_breakdown, 15, 512) ?>'
                                    data-spareparts='<?php echo json_encode($inquiry->spareparts_breakdown, 15, 512) ?>'
                                    data-labor='<?php echo e((float)($inquiry->labor_cost_total ?? $inquiry->labor_cost ?? 0)); ?>'
                                    data-total='<?php echo e((float)($inquiry->total_cost ?? 0)); ?>'
                                    data-suggest='<?php echo e((float)($inquiry->engineer_suggested_price ?? 0)); ?>'
                                    data-days='<?php echo e((int)($inquiry->estimated_days ?? $inquiry->lead_time_days ?? 0)); ?>'
                                    data-message='<?php echo json_encode($inquiry->message, 15, 512) ?>'
                                    onclick="openApprovalModalFromBtn(this)"
                                    class="inline-flex items-center justify-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-lg transition-colors duration-200 text-sm font-medium">
                                    <i class="fas fa-check mr-2"></i> Review Harga
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <?php else: ?>
            <div class="text-center py-12">
                <div class="flex flex-col items-center justify-center">
                    <div class="w-24 h-24 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-inbox text-4xl text-gray-400 dark:text-gray-500"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Tidak Ada Penawaran</h3>
                    <p class="text-gray-600 dark:text-gray-400">Tidak ada penawaran yang perlu di-review saat ini</p>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Pagination -->
        <?php if($inquiries->hasPages()): ?>
        <div class="px-6 py-4 border-t border-gray-200 dark:border-gray-700">
            <?php echo e($inquiries->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Approval Modal -->
<div id="approvalModal" class="fixed inset-0 bg-black/60 backdrop-blur-sm z-50 hidden items-center justify-center transition-opacity duration-300" onclick="if(event.target === this) closeApprovalModal()">
    <div class="flex items-center justify-center min-h-screen p-4" onclick="event.stopPropagation()">
        <div id="approvalModalContent" class="bg-white dark:bg-gray-800 rounded-2xl shadow-2xl max-w-4xl w-full max-h-[85vh] overflow-hidden flex flex-col transform transition-all duration-300 scale-95 opacity-0">
            <!-- Modal Header -->
            <div class="bg-gradient-to-r from-green-600 to-emerald-600 px-6 py-4 flex items-center justify-between flex-shrink-0">
                <div class="flex items-center space-x-3">
                    <div class="flex items-center justify-center w-10 h-10 bg-white/20 rounded-lg">
                        <i class="fas fa-handshake text-white text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-white">Review & Set Range Harga</h3>
                        <p class="text-xs text-green-100">Tentukan koridor harga untuk penawaran</p>
                    </div>
                </div>
                <button onclick="closeApprovalModal()" class="text-white/80 hover:text-white hover:bg-white/20 rounded-lg p-2 transition-all duration-200">
                    <i class="fas fa-times text-lg"></i>
                </button>
            </div>

            <!-- Modal Body - Scrollable -->
            <div class="flex-1 overflow-y-auto overscroll-contain" style="max-height: calc(85vh - 140px);">
                <form id="approvalForm" method="POST" class="p-5 space-y-4">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="inquiry_id" id="inquiry_id">

                    <!-- Informasi Produk -->
                    <div class="bg-gradient-to-br from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 rounded-lg p-4 border border-blue-200 dark:border-blue-800">
                        <div class="flex items-center space-x-2 mb-3">
                            <i class="fas fa-box text-blue-600 dark:text-blue-400 text-sm"></i>
                            <h4 class="text-xs font-semibold text-blue-900 dark:text-blue-100 uppercase tracking-wide">Informasi Produk</h4>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                            <div>
                                <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-2">Produk</label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <i class="fas fa-cube text-gray-400"></i>
                                    </div>
                                    <input type="text" id="product_title" class="w-full pl-10 pr-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all" disabled>
                                </div>
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-2">Harga Base</label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <i class="fas fa-tag text-gray-400"></i>
                                    </div>
                                    <input type="text" id="base_price" class="w-full pl-10 pr-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all font-semibold" disabled>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Permintaan Customer -->
                    <div class="bg-gradient-to-br from-purple-50 to-pink-50 dark:from-purple-900/20 dark:to-pink-900/20 rounded-lg p-4 border border-purple-200 dark:border-purple-800">
                        <div class="flex items-center space-x-2 mb-3">
                            <i class="fas fa-user-circle text-purple-600 dark:text-purple-400 text-sm"></i>
                            <h4 class="text-xs font-semibold text-purple-900 dark:text-purple-100 uppercase tracking-wide">Permintaan Customer</h4>
                        </div>
                        <div class="mb-2">
                            <span id="reqTypeSupBadge" class="hidden inline-flex items-center px-2.5 py-0.5 text-xs font-semibold rounded-full"></span>
                        </div>
                        <div id="addonSupList" class="text-xs text-gray-700 dark:text-gray-300 mb-2"></div>
                        <div>
                            <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1.5">
                                <i class="fas fa-comment-alt mr-1"></i> Pesan Customer
                            </label>
                            <textarea id="customerSupMessage" rows="2" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-all resize-none" readonly></textarea>
                        </div>
                    </div>

                    <!-- Estimasi Internal -->
                    <div class="bg-gradient-to-br from-amber-50 to-orange-50 dark:from-amber-900/20 dark:to-orange-900/20 rounded-lg p-4 border border-amber-200 dark:border-amber-800">
                        <div class="flex items-center space-x-2 mb-3">
                            <i class="fas fa-calculator text-amber-600 dark:text-amber-400 text-sm"></i>
                            <h4 class="text-xs font-semibold text-amber-900 dark:text-amber-100 uppercase tracking-wide">Estimasi Internal (Teknisi)</h4>
                        </div>
                        <div class="grid grid-cols-1 lg:grid-cols-2 gap-3 mb-3">
                            <div>
                                <div class="flex items-center space-x-2 mb-2">
                                    <i class="fas fa-boxes text-xs text-amber-600 dark:text-amber-400"></i>
                                    <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">Bahan</span>
                                </div>
                                <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
                                    <table class="w-full text-xs">
                                        <thead class="bg-gray-50 dark:bg-gray-700/50">
                                            <tr>
                                                <th class="px-3 py-2 text-left text-xs font-semibold text-gray-600 dark:text-gray-300">Nama</th>
                                                <th class="px-3 py-2 text-right text-xs font-semibold text-gray-600 dark:text-gray-300">Qty</th>
                                                <th class="px-3 py-2 text-center text-xs font-semibold text-gray-600 dark:text-gray-300">Unit</th>
                                                <th class="px-3 py-2 text-right text-xs font-semibold text-gray-600 dark:text-gray-300">Harga</th>
                                            </tr>
                                        </thead>
                                        <tbody id="materialsView" class="divide-y divide-gray-200 dark:divide-gray-700"></tbody>
                                    </table>
                                </div>
                            </div>
                            <div>
                                <div class="flex items-center space-x-2 mb-2">
                                    <i class="fas fa-cog text-xs text-amber-600 dark:text-amber-400"></i>
                                    <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">Sparepart</span>
                                </div>
                                <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
                                    <table class="w-full text-xs">
                                        <thead class="bg-gray-50 dark:bg-gray-700/50">
                                            <tr>
                                                <th class="px-3 py-2 text-left text-xs font-semibold text-gray-600 dark:text-gray-300">Nama</th>
                                                <th class="px-3 py-2 text-right text-xs font-semibold text-gray-600 dark:text-gray-300">Qty</th>
                                                <th class="px-3 py-2 text-center text-xs font-semibold text-gray-600 dark:text-gray-300">Unit</th>
                                                <th class="px-3 py-2 text-right text-xs font-semibold text-gray-600 dark:text-gray-300">Harga</th>
                                            </tr>
                                        </thead>
                                        <tbody id="sparepartsView" class="divide-y divide-gray-200 dark:divide-gray-700"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-2 pt-3 border-t border-amber-200 dark:border-amber-700">
                            <div class="bg-white dark:bg-gray-800 rounded-lg p-2.5 border border-gray-200 dark:border-gray-700">
                                <div class="text-xs text-gray-500 dark:text-gray-400 mb-0.5">Biaya Jasa</div>
                                <div id="laborView" class="text-xs font-bold text-gray-900 dark:text-white">Rp 0</div>
                            </div>
                            <div class="bg-white dark:bg-gray-800 rounded-lg p-2.5 border border-gray-200 dark:border-gray-700">
                                <div class="text-xs text-gray-500 dark:text-gray-400 mb-0.5">Total Internal</div>
                                <div id="totalView" class="text-xs font-bold text-gray-900 dark:text-white">Rp 0</div>
                            </div>
                            <div class="bg-white dark:bg-gray-800 rounded-lg p-2.5 border border-gray-200 dark:border-gray-700">
                                <div class="text-xs text-gray-500 dark:text-gray-400 mb-0.5">Usulan Teknisi</div>
                                <div id="suggestView" class="text-xs font-bold text-blue-600 dark:text-blue-400">Rp 0</div>
                            </div>
                            <div class="bg-white dark:bg-gray-800 rounded-lg p-2.5 border border-gray-200 dark:border-gray-700">
                                <div class="text-xs text-gray-500 dark:text-gray-400 mb-0.5">Estimasi Hari</div>
                                <div id="daysView" class="text-xs font-bold text-gray-900 dark:text-white">-</div>
                            </div>
                        </div>
                    </div>

                    <!-- Form Range Harga -->
                    <div class="bg-gradient-to-br from-green-50 to-emerald-50 dark:from-green-900/20 dark:to-emerald-900/20 rounded-lg p-4 border border-green-200 dark:border-green-800">
                        <div class="flex items-center space-x-2 mb-3">
                            <i class="fas fa-dollar-sign text-green-600 dark:text-green-400 text-sm"></i>
                            <h4 class="text-xs font-semibold text-green-900 dark:text-green-100 uppercase tracking-wide">Koridor Harga</h4>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-3 mb-3">
                            <div>
                                <label class="block text-xs font-semibold text-gray-700 dark:text-gray-300 mb-2">
                                    <i class="fas fa-arrow-down text-red-500 mr-1"></i> Harga Minimal (Min) <span class="text-red-500">*</span>
                                </label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 text-sm">Rp</span>
                                    </div>
                                    <input type="number" name="min_price" id="min_price" step="0.01" class="w-full pl-12 pr-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm focus:ring-2 focus:ring-green-500 focus:border-green-500 transition-all" required placeholder="0">
                                </div>
                                <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Harga terendah yang bisa diberikan</p>
                            </div>
                            <div>
                                <label class="block text-xs font-semibold text-gray-700 dark:text-gray-300 mb-1.5">
                                    <i class="fas fa-bullseye text-blue-500 mr-1"></i> Harga Target (Opsional)
                                </label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 text-sm">Rp</span>
                                    </div>
                                    <input type="number" name="target_price" id="target_price" step="0.01" class="w-full pl-12 pr-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all" placeholder="0">
                                </div>
                                <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Harga yang diharapkan</p>
                            </div>
                            <div>
                                <label class="block text-xs font-semibold text-gray-700 dark:text-gray-300 mb-1.5">
                                    <i class="fas fa-arrow-up text-green-500 mr-1"></i> Harga Maksimal (Max) <span class="text-red-500">*</span>
                                </label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 text-sm">Rp</span>
                                    </div>
                                    <input type="number" name="max_price" id="max_price" step="0.01" class="w-full pl-12 pr-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm focus:ring-2 focus:ring-green-500 focus:border-green-500 transition-all" required placeholder="0">
                                </div>
                                <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Harga tertinggi yang bisa diberikan</p>
                            </div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                            <div>
                                <label class="block text-xs font-semibold text-gray-700 dark:text-gray-300 mb-2">
                                    <i class="fas fa-calendar-alt text-indigo-500 mr-1"></i> Berlaku Hingga
                                </label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <i class="fas fa-calendar text-gray-400"></i>
                                    </div>
                                    <input type="date" name="validity_until" id="validity_until" class="w-full pl-10 pr-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition-all">
                                </div>
                                <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Tanggal masa berlaku penawaran</p>
                            </div>
                            <div>
                                <label class="block text-xs font-semibold text-gray-700 dark:text-gray-300 mb-1.5">
                                    <i class="fas fa-sticky-note text-amber-500 mr-1"></i> Catatan Supervisor
                                </label>
                                <textarea name="supervisor_note" id="supervisor_note" rows="2" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm focus:ring-2 focus:ring-amber-500 focus:border-amber-500 transition-all resize-none" placeholder="Keterangan tambahan tentang penawaran ini..."></textarea>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Modal Footer -->
            <div class="bg-gray-50 dark:bg-gray-900/50 px-5 py-3 border-t border-gray-200 dark:border-gray-700 flex items-center justify-end space-x-2 flex-shrink-0">
                <button type="button" onclick="closeApprovalModal()" class="px-4 py-2 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-300 dark:hover:bg-gray-600 transition-all duration-200 font-medium text-xs">
                    <i class="fas fa-times mr-1.5"></i> Batal
                </button>
                <button type="submit" form="approvalForm" class="px-5 py-2 bg-gradient-to-r from-green-600 to-emerald-600 hover:from-green-700 hover:to-emerald-700 text-white rounded-lg transition-all duration-200 font-semibold text-xs shadow-lg hover:shadow-xl transform hover:scale-105">
                    <i class="fas fa-check-circle mr-1.5"></i> Simpan & Teruskan
                </button>
            </div>
        </div>
    </div>
</div>

<style>
    /* Modal Animation */
    #approvalModal {
        backdrop-filter: blur(4px);
    }
    
    #approvalModalContent {
        transition: transform 0.3s ease-out, opacity 0.3s ease-out;
    }
    
    #approvalModalContent.scale-100 {
        transform: scale(1);
        opacity: 1;
    }
    
    #approvalModalContent.scale-95 {
        transform: scale(0.95);
        opacity: 0;
    }
    
    /* Scrollable Body Styling */
    #approvalModal .overflow-y-auto {
        scrollbar-width: thin;
        scrollbar-color: rgba(156, 163, 175, 0.5) transparent;
    }
    
    #approvalModal .overflow-y-auto::-webkit-scrollbar {
        width: 6px;
    }
    
    #approvalModal .overflow-y-auto::-webkit-scrollbar-track {
        background: transparent;
    }
    
    #approvalModal .overflow-y-auto::-webkit-scrollbar-thumb {
        background-color: rgba(156, 163, 175, 0.5);
        border-radius: 3px;
    }
    
    #approvalModal .overflow-y-auto::-webkit-scrollbar-thumb:hover {
        background-color: rgba(156, 163, 175, 0.7);
    }
    
    /* Form Input Styling */
    #approvalModal input[type="number"],
    #approvalModal input[type="date"],
    #approvalModal textarea {
        transition: all 0.2s ease-in-out;
    }
    
    #approvalModal input[type="number"]:focus,
    #approvalModal input[type="date"]:focus,
    #approvalModal textarea:focus {
        outline: none;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }
    
    /* Table Row Hover */
    #materialsView tr:hover,
    #sparepartsView tr:hover {
        background-color: rgba(249, 250, 251, 0.5);
    }
    
    .dark #materialsView tr:hover,
    .dark #sparepartsView tr:hover {
        background-color: rgba(55, 65, 81, 0.5);
    }
    
    /* Compact Section Spacing */
    #approvalModal .space-y-5 > * + * {
        margin-top: 1.25rem;
    }
</style>

<script>
function fmt(n){ return 'Rp ' + new Intl.NumberFormat('id-ID').format(Number(n||0)); }
function escapeHtml(str){ return String(str||'').replace(/[&<>"']/g, s=>({"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#39;"}[s])); }
function safeJson(s){ try { return s ? JSON.parse(s) : null; } catch(e){ return null; } }

function openApprovalModal(btn, inquiryId, productTitle, basePrice) {
    document.getElementById('inquiry_id').value = inquiryId;
    document.getElementById('product_title').value = productTitle;
    document.getElementById('base_price').value = fmt(basePrice);

    const rawMessage = btn.getAttribute('data-message') || '';
    try {
        let rm = rawMessage;
        try { rm = JSON.parse(rawMessage); } catch(e){ rm = rawMessage; }
        const typeMatch = rm.match(/\[REQUEST_TYPE\]\s*([A-Za-z0-9_\-]+)/);
        const addMatch = rm.match(/\[ADDONS\]\s*(\[[\s\S]*?\])/);
        const type = typeMatch ? typeMatch[1].trim() : null;
        let addons = [];
        if (addMatch) { try { addons = JSON.parse(addMatch[1]); } catch(e){} }
        let plain = rm.replace(/\[REQUEST_TYPE\][^\r\n]*/,'').replace(/\[ADDONS\][^\r\n]*/,'').trim();
        const badge = document.getElementById('reqTypeSupBadge');
        const addonList = document.getElementById('addonSupList');
        const msg = document.getElementById('customerSupMessage');
        msg.value = plain || rm;
        addonList.innerHTML = '';
        if (type){
            badge.classList.remove('hidden');
            const badgeText = type === 'custom_addon' ? 'Custom Add-on' : (type === 'custom_new' ? 'Custom Baru' : 'Katalog');
            const badgeCls = type==='custom_addon' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/40 dark:text-yellow-200' : (type==='custom_new' ? 'bg-red-100 text-red-800 dark:bg-red-900/40 dark:text-red-200' : 'bg-blue-100 text-blue-800 dark:bg-blue-900/40 dark:text-blue-200');
            badge.textContent = badgeText;
            badge.className = 'inline-flex items-center px-3 py-1 text-xs font-semibold rounded-full ' + badgeCls;
        } else {
            badge.classList.add('hidden');
        }
        if (Array.isArray(addons) && addons.length){
            addonList.innerHTML = '<div class="text-xs font-semibold text-gray-700 dark:text-gray-300 mb-2">Spesifikasi Tambahan</div>' + 
                '<div class="space-y-1">' + addons.map(a => `<div class="flex items-start"><span class="mr-2">•</span><span>${escapeHtml(a?.name||'-')}: <strong>${escapeHtml(a?.value||'-')}</strong></span></div>`).join('') + '</div>';
        }
    } catch(_){ }

    const materials = safeJson(btn.getAttribute('data-materials')) || [];
    const spareparts = safeJson(btn.getAttribute('data-spareparts')) || [];
    const labor = Number(btn.getAttribute('data-labor')||0);
    const total = Number(btn.getAttribute('data-total')||0);
    const suggest = Number(btn.getAttribute('data-suggest')||0);
    const days = btn.getAttribute('data-days')||'-';

    const mBody = document.getElementById('materialsView');
    const sBody = document.getElementById('sparepartsView');
    
    if (materials.length > 0) {
        mBody.innerHTML = materials.map(it=>`
            <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors">
                <td class="px-3 py-2 text-gray-900 dark:text-gray-100">${escapeHtml(it.name||'')}</td>
                <td class="px-3 py-2 text-right text-gray-700 dark:text-gray-300">${Number(it.qty||0)}</td>
                <td class="px-3 py-2 text-center text-gray-600 dark:text-gray-400">${escapeHtml(it.unit||'')}</td>
                <td class="px-3 py-2 text-right font-medium text-gray-900 dark:text-gray-100">${fmt(it.unit_cost||0)}</td>
            </tr>
        `).join('');
    } else {
        mBody.innerHTML = '<tr><td colspan="4" class="px-3 py-4 text-center text-xs text-gray-500 dark:text-gray-400">Tidak ada bahan</td></tr>';
    }
    
    if (spareparts.length > 0) {
        sBody.innerHTML = spareparts.map(it=>`
            <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors">
                <td class="px-3 py-2 text-gray-900 dark:text-gray-100">${escapeHtml(it.name||'')}</td>
                <td class="px-3 py-2 text-right text-gray-700 dark:text-gray-300">${Number(it.qty||0)}</td>
                <td class="px-3 py-2 text-center text-gray-600 dark:text-gray-400">${escapeHtml(it.unit||'')}</td>
                <td class="px-3 py-2 text-right font-medium text-gray-900 dark:text-gray-100">${fmt(it.unit_cost||0)}</td>
            </tr>
        `).join('');
    } else {
        sBody.innerHTML = '<tr><td colspan="4" class="px-3 py-4 text-center text-xs text-gray-500 dark:text-gray-400">Tidak ada sparepart</td></tr>';
    }
    
    document.getElementById('laborView').innerText = fmt(labor);
    document.getElementById('totalView').innerText = fmt(total);
    document.getElementById('suggestView').innerText = fmt(suggest);
    document.getElementById('daysView').innerText = days ? days + ' hari' : '-';

    document.getElementById('approvalForm').action = '/supervisor/quotations/' + inquiryId + '/approve';
    const modal = document.getElementById('approvalModal');
    const modalContent = document.getElementById('approvalModalContent');
    if (modal && modalContent) {
        modal.classList.remove('hidden');
        modal.classList.add('flex');
        // Trigger animation
        setTimeout(() => {
            modalContent.classList.remove('scale-95', 'opacity-0');
            modalContent.classList.add('scale-100', 'opacity-100');
        }, 10);
        document.body.style.overflow = 'hidden';
    }
}

function closeApprovalModal() {
    const modal = document.getElementById('approvalModal');
    const modalContent = document.getElementById('approvalModalContent');
    if (modal && modalContent) {
        modalContent.classList.remove('scale-100', 'opacity-100');
        modalContent.classList.add('scale-95', 'opacity-0');
        setTimeout(() => {
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.style.overflow = '';
        }, 300);
    }
}

// Format number inputs dengan validasi
function formatNumberInput(input) {
    input.addEventListener('input', function() {
        // Hapus karakter selain angka dan titik
        this.value = this.value.replace(/[^0-9.]/g, '');
        // Pastikan hanya satu titik desimal
        const parts = this.value.split('.');
        if (parts.length > 2) {
            this.value = parts[0] + '.' + parts.slice(1).join('');
        }
    });
    
    input.addEventListener('blur', function() {
        // Format dengan pemisah ribuan saat blur (opsional)
        const num = parseFloat(this.value);
        if (!isNaN(num) && num > 0) {
            // Biarkan nilai asli untuk form submission
        }
    });
}

// Inisialisasi format untuk semua input number
document.addEventListener('DOMContentLoaded', function() {
    const minPriceInput = document.getElementById('min_price');
    const maxPriceInput = document.getElementById('max_price');
    const targetPriceInput = document.getElementById('target_price');
    
    if (minPriceInput) formatNumberInput(minPriceInput);
    if (maxPriceInput) formatNumberInput(maxPriceInput);
    if (targetPriceInput) formatNumberInput(targetPriceInput);
    
    // Validasi form sebelum submit
    const approvalForm = document.getElementById('approvalForm');
    if (approvalForm) {
        approvalForm.addEventListener('submit', function(e) {
            const minPrice = parseFloat(document.getElementById('min_price').value) || 0;
            const maxPrice = parseFloat(document.getElementById('max_price').value) || 0;
            const targetPrice = parseFloat(document.getElementById('target_price').value) || 0;
            
            if (minPrice >= maxPrice) {
                e.preventDefault();
                Swal.fire({
                    icon: 'error',
                    title: 'Validasi Gagal',
                    text: 'Harga Maksimal harus lebih besar dari Harga Minimal',
                    confirmButtonText: 'OK'
                });
                return false;
            }
            
            if (targetPrice > 0 && (targetPrice < minPrice || targetPrice > maxPrice)) {
                e.preventDefault();
                Swal.fire({
                    icon: 'warning',
                    title: 'Validasi Gagal',
                    text: 'Harga Target harus berada di antara Harga Minimal dan Maksimal',
                    confirmButtonText: 'OK'
                });
                return false;
            }
        });
    }
});

function openApprovalModalFromBtn(el){
    try {
        const id = Number(el.getAttribute('data-id'));
        const title = JSON.parse(el.getAttribute('data-title')||'""');
        const base = Number(el.getAttribute('data-base')||0);
        openApprovalModal(el, id, title, base);
    } catch(_){
        const id = Number(el.dataset.id||el.getAttribute('data-id'));
        const title = el.dataset.title||el.getAttribute('data-title');
        const base = Number(el.dataset.base||el.getAttribute('data-base')||0);
        openApprovalModal(el, id, title, base);
    }
}

document.addEventListener('click', function(ev){
    const btn = ev.target.closest('[data-approve-btn]');
    if (!btn) return;
    ev.preventDefault();
    openApprovalModalFromBtn(btn);
});

// Handle highlight inquiry dari URL parameter
document.addEventListener('DOMContentLoaded', function() {
    const urlParams = new URLSearchParams(window.location.search);
    const highlightId = urlParams.get('highlight');
    
    if (highlightId) {
        // Scroll ke inquiry yang di-highlight setelah halaman load
        setTimeout(() => {
            const row = document.getElementById('inquiry-row-' + highlightId);
            if (row) {
                // Highlight row dengan border dan background
                row.classList.add('bg-yellow-50', 'dark:bg-yellow-900/20', 'border-l-4', 'border-yellow-500');
                
                // Scroll ke row
                row.scrollIntoView({ behavior: 'smooth', block: 'center' });
                
                // Hapus highlight setelah 5 detik
                setTimeout(() => {
                    row.classList.remove('bg-yellow-50', 'dark:bg-yellow-900/20', 'border-l-4', 'border-yellow-500');
                }, 5000);
                
                // Hapus parameter dari URL tanpa reload
                const newUrl = window.location.pathname;
                window.history.replaceState({}, '', newUrl);
            }
        }, 300);
    }
    
    // Initialize sidebar badge on page load
    if (window.notificationSystem && typeof window.notificationSystem.checkNotifications === 'function') {
        // Trigger immediate update
        setTimeout(() => {
            window.notificationSystem.checkNotifications();
        }, 500);
    }
});
</script>
<?php $__env->stopSection(); ?>






<?php echo $__env->make('layouts.supervisor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/quotations/index.blade.php ENDPATH**/ ?>