

<?php $__env->startSection('title', 'Laporan Laba Rugi Per Proyek'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Header -->
        <div class="mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Laporan Laba Rugi Per Proyek</h1>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                        Laporan laba rugi berdasarkan proyek
                    </p>
                </div>
                <?php if(isset($projectCode) && $projectCode): ?>
                <div class="flex items-center gap-2">
                    <a href="<?php echo e(route('admin.reports.profit-loss-project.export', request()->all())); ?>" class="inline-flex items-center justify-center px-3 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-file-excel mr-2 text-xs"></i>
                        Export Excel
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Filter Form -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6 mb-6">
            <form method="GET" action="<?php echo e(route('admin.reports.profit-loss-project')); ?>" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Proyek</label>
                    <select name="kd_project" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">-- Pilih Proyek --</option>
                        <?php $__currentLoopData = $projects ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($project->kd_project); ?>" <?php echo e(request('kd_project') == $project->kd_project ? 'selected' : ''); ?>>
                                <?php echo e($project->kd_project); ?> - <?php echo e($project->nama_proyek); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tanggal Awal</label>
                    <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tanggal Akhir</label>
                    <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div class="flex items-end">
                    <button type="submit" class="w-full px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-search mr-2"></i>Filter
                    </button>
                </div>
            </form>
        </div>

        <!-- Report Content -->
        <?php if(isset($projectCode) && $projectCode): ?>
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                    <h3 class="text-lg font-semibold text-gray-800 dark:text-white">LAPORAN LABA RUGI PER PROJECT</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Proyek: <strong><?php echo e($projectName); ?></strong></p>
                </div>

                <div class="p-6">
                    <div class="overflow-x-auto">
                        <table class="w-full border border-gray-300 dark:border-gray-600">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600">Keterangan</th>
                                    <th class="px-4 py-3 text-right text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600">Jumlah</th>
                                    <th class="px-4 py-3 text-right text-xs font-semibold uppercase border-b border-gray-300 dark:border-gray-600">TOTAL</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Pendapatan -->
                                <tr class="bg-blue-50 dark:bg-blue-900/20">
                                    <td class="px-4 py-3 font-semibold border-r border-gray-300 dark:border-gray-600" colspan="3">Pendapatan</td>
                                </tr>
                                <?php $__empty_1 = true; $__currentLoopData = $revenueAccounts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php if($account['amount'] > 0): ?>
                                        <tr>
                                            <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8"><?php echo e(strtoupper($account['nama_perkiraan'])); ?></td>
                                            <td class="px-4 py-2 text-right border-r border-gray-300 dark:border-gray-600"><?php echo e(number_format($account['amount'], 0, ',', '.')); ?></td>
                                            <td class="px-4 py-2 text-right"><?php echo e(number_format($account['amount'], 0, ',', '.')); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8 text-gray-400 italic" colspan="3">Tidak ada data pendapatan</td>
                                    </tr>
                                <?php endif; ?>
                                <tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                    <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">JUMLAH PENDAPATAN</td>
                                    <td class="px-4 py-3 text-right border-r border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($revenue, 0, ',', '.')); ?></td>
                                    <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($revenue, 0, ',', '.')); ?></td>
                                </tr>

                                <!-- Harga Pokok Penjualan -->
                                <tr class="bg-red-50 dark:bg-red-900/20">
                                    <td class="px-4 py-3 font-semibold border-r border-t border-gray-300 dark:border-gray-600" colspan="3">HARGA POKOK PENJUALAN</td>
                                </tr>
                                <?php $__empty_1 = true; $__currentLoopData = $cogsAccounts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php if($account['amount'] > 0): ?>
                                        <tr>
                                            <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8"><?php echo e(strtoupper($account['nama_perkiraan'])); ?></td>
                                            <td class="px-4 py-2 text-right border-r border-gray-300 dark:border-gray-600"><?php echo e(number_format($account['amount'], 0, ',', '.')); ?></td>
                                            <td class="px-4 py-2 text-right"><?php echo e(number_format($account['amount'], 0, ',', '.')); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8 text-gray-400 italic" colspan="3">Tidak ada data HPP</td>
                                    </tr>
                                <?php endif; ?>
                                <tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                    <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">HARGA POKOK PENJUALAN</td>
                                    <td class="px-4 py-3 text-right border-r border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($cogs, 0, ',', '.')); ?></td>
                                    <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($cogs, 0, ',', '.')); ?></td>
                                </tr>

                                <!-- Laba Bruto -->
                                <tr class="bg-green-50 dark:bg-green-900/20 font-semibold">
                                    <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">LABA BRUTO</td>
                                    <td class="px-4 py-3 text-right border-r border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($grossProfit, 0, ',', '.')); ?></td>
                                    <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($grossProfit, 0, ',', '.')); ?></td>
                                </tr>

                                <!-- Beban Administrasi & Umum -->
                                <tr class="bg-yellow-50 dark:bg-yellow-900/20">
                                    <td class="px-4 py-3 font-semibold border-r border-t border-gray-300 dark:border-gray-600" colspan="3">BEBAN ADMINISTRASI & UMUM</td>
                                </tr>
                                <?php $__empty_1 = true; $__currentLoopData = $expenseAccounts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php if($account['amount'] > 0): ?>
                                        <tr>
                                            <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8"><?php echo e(strtoupper($account['nama_perkiraan'])); ?></td>
                                            <td class="px-4 py-2 text-right border-r border-gray-300 dark:border-gray-600"><?php echo e(number_format($account['amount'], 0, ',', '.')); ?></td>
                                            <td class="px-4 py-2 text-right"><?php echo e(number_format($account['amount'], 0, ',', '.')); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8 text-gray-400 italic" colspan="3">Tidak ada data beban administrasi</td>
                                    </tr>
                                <?php endif; ?>
                                <tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                    <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">Jumlah Beban Administrasi Dan Umum</td>
                                    <td class="px-4 py-3 text-right border-r border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($operatingExpenses, 0, ',', '.')); ?></td>
                                    <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($operatingExpenses, 0, ',', '.')); ?></td>
                                </tr>

                                <!-- Laba (Rugi) Usaha -->
                                <tr class="bg-purple-50 dark:bg-purple-900/20 font-semibold">
                                    <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">LABA (RUGI) Usaha</td>
                                    <td class="px-4 py-3 text-right border-r border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($operatingProfit, 0, ',', '.')); ?></td>
                                    <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($operatingProfit, 0, ',', '.')); ?></td>
                                </tr>

                                <!-- Pendapatan (Beban) Lain-Lain -->
                                <tr class="bg-indigo-50 dark:bg-indigo-900/20">
                                    <td class="px-4 py-3 font-semibold border-r border-t border-gray-300 dark:border-gray-600" colspan="3">PENDAPATAN (BEBAN) LAIN - LAIN</td>
                                </tr>
                                <?php $__empty_1 = true; $__currentLoopData = $otherIncomeAccounts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php if($account['amount'] != 0): ?>
                                        <tr>
                                            <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8"><?php echo e(strtoupper($account['nama_perkiraan'])); ?></td>
                                            <td class="px-4 py-2 text-right border-r border-gray-300 dark:border-gray-600 <?php echo e($account['amount'] < 0 ? 'text-red-600' : ''); ?>">
                                                <?php echo e($account['amount'] != 0 ? number_format($account['amount'], 0, ',', '.') : '-'); ?>

                                            </td>
                                            <td class="px-4 py-2 text-right <?php echo e($account['amount'] < 0 ? 'text-red-600' : ''); ?>">
                                                <?php echo e($account['amount'] != 0 ? number_format($account['amount'], 0, ',', '.') : '-'); ?>

                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8 text-gray-400 italic" colspan="3">Tidak ada data pendapatan/beban lain</td>
                                    </tr>
                                <?php endif; ?>
                                <tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                    <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">JUMLAH PENDAPATAN (BEBAN) LAIN - LAIN</td>
                                    <td class="px-4 py-3 text-right border-r border-t border-gray-300 dark:border-gray-600 <?php echo e($otherIncome < 0 ? 'text-red-600' : ''); ?>">
                                        <?php echo e($otherIncome != 0 ? number_format($otherIncome, 0, ',', '.') : '-'); ?>

                                    </td>
                                    <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600 <?php echo e($otherIncome < 0 ? 'text-red-600' : ''); ?>">
                                        <?php echo e($otherIncome != 0 ? number_format($otherIncome, 0, ',', '.') : '-'); ?>

                                    </td>
                                </tr>

                                <!-- Laba (Rugi) Sebelum Pajak -->
                                <tr class="bg-orange-50 dark:bg-orange-900/20 font-semibold">
                                    <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">LABA (RUGI) SEBELUM PAJAK</td>
                                    <td class="px-4 py-3 text-right border-r border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($profitBeforeTax, 0, ',', '.')); ?></td>
                                    <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($profitBeforeTax, 0, ',', '.')); ?></td>
                                </tr>

                                <!-- Pajak Penghasilan -->
                                <tr class="bg-pink-50 dark:bg-pink-900/20">
                                    <td class="px-4 py-3 font-semibold border-r border-t border-gray-300 dark:border-gray-600" colspan="3">PAJAK PENGHASILAN</td>
                                </tr>
                                <?php $__empty_1 = true; $__currentLoopData = $taxAccounts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php if($account['amount'] > 0): ?>
                                        <tr>
                                            <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8"><?php echo e(strtoupper($account['nama_perkiraan'])); ?></td>
                                            <td class="px-4 py-2 text-right border-r border-gray-300 dark:border-gray-600"><?php echo e(number_format($account['amount'], 0, ',', '.')); ?></td>
                                            <td class="px-4 py-2 text-right"><?php echo e(number_format($account['amount'], 0, ',', '.')); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="px-4 py-2 border-r border-gray-300 dark:border-gray-600 pl-8 text-gray-400 italic" colspan="3">Tidak ada data pajak</td>
                                    </tr>
                                <?php endif; ?>
                                <tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                    <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">JUMLAH PPH</td>
                                    <td class="px-4 py-3 text-right border-r border-t border-gray-300 dark:border-gray-600"><?php echo e($tax > 0 ? number_format($tax, 0, ',', '.') : '-'); ?></td>
                                    <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600"><?php echo e($tax > 0 ? number_format($tax, 0, ',', '.') : '-'); ?></td>
                                </tr>

                                <!-- Laba Setelah Pajak -->
                                <tr class="bg-teal-50 dark:bg-teal-900/20 font-bold text-lg">
                                    <td class="px-4 py-3 border-r border-t border-gray-300 dark:border-gray-600">LABA SETELAH PAJAK</td>
                                    <td class="px-4 py-3 text-right border-r border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($netProfit, 0, ',', '.')); ?></td>
                                    <td class="px-4 py-3 text-right border-t border-gray-300 dark:border-gray-600"><?php echo e(number_format($netProfit, 0, ',', '.')); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-12 text-center">
                <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3 mx-auto">
                    <i class="fas fa-chart-line text-3xl text-gray-400 dark:text-gray-500"></i>
                </div>
                <p class="text-gray-500 dark:text-gray-400 font-medium mb-1">Pilih Proyek</p>
                <p class="text-gray-400 dark:text-gray-500 text-sm">Silakan pilih proyek untuk melihat laporan laba rugi</p>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/reports/profit-loss-project.blade.php ENDPATH**/ ?>