<!-- Sidebar -->
<aside id="sidebar"
    class="fixed left-0 top-0 h-full w-64 bg-slate-900 dark:bg-gray-900 text-gray-300 dark:text-gray-200 z-50 shadow-2xl overflow-y-auto scrollbar-hide transform -translate-x-full border-r border-slate-800 dark:border-gray-800">

    <!-- Style untuk menyembunyikan scrollbar -->
    <style>
        .scrollbar-hide::-webkit-scrollbar {
            display: none;
        }

        .scrollbar-hide {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }

        /* Mobile sidebar improvements */
        @media (max-width: 1023px) {
            #sidebar {
                box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            }
        }

        /* Badge notification styles - override Tailwind hidden class */
        #sidebar-productions-badge,
        #sidebar-quotations-badge {
            align-items: center;
            justify-content: center;
            min-width: 20px;
            height: 20px;
            padding: 0 6px;
            background-color: #ef4444;
            color: white;
            font-size: 11px;
            font-weight: bold;
            border-radius: 10px;
            line-height: 1;
            animation: pulse 2s infinite;
            box-shadow: 0 2px 4px rgba(239, 68, 68, 0.3);
        }

        /* Explicitly hide with !important when hidden class is present */
        #sidebar-productions-badge.hidden,
        #sidebar-quotations-badge.hidden {
            display: none !important;
            visibility: hidden !important;
        }

        /* Explicitly show with !important when hidden class is NOT present */
        #sidebar-productions-badge:not(.hidden),
        #sidebar-quotations-badge:not(.hidden) {
            display: inline-flex !important;
            visibility: visible !important;
            opacity: 1 !important;
        }

        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.8;
            }
        }

        /* Ensure logo gradient is not overridden by parent text color */
        #sidebar h3.bg-clip-text {
            color: transparent !important;
            background-image: linear-gradient(to right, #60a5fa, #22d3ee) !important;
            -webkit-background-clip: text !important;
            background-clip: text !important;
        }
    </style>

    <div class="p-5">
        <div class="flex items-center justify-between mb-6 pb-4 border-b border-slate-800 dark:border-gray-700">
            <!-- Logo -->
            <a href="<?php echo e(url('/')); ?>" class="flex-shrink-0 group">
                <h3 class="text-2xl font-extrabold bg-gradient-to-r from-blue-400 to-cyan-400 bg-clip-text text-transparent leading-tight whitespace-nowrap group-hover:from-blue-300 group-hover:to-cyan-300 transition-all duration-200 tracking-tight">POLJAM TECH</h3>
            </a>
            <!-- Close button for mobile -->
            <button onclick="toggleSidebar()"
                class="lg:hidden text-gray-400 hover:text-white transition-colors duration-200 p-1 rounded-lg hover:bg-slate-800">
                <i class="fas fa-times text-lg"></i>
            </button>
        </div>
        
        <nav>
            <ul class="space-y-0.5">
                <!-- Dashboard -->
                <li>
                    <a href="<?php echo e(route('supervisor.dashboard')); ?>"
                        class="flex items-center px-4 py-2.5 rounded-lg transition-all duration-200 group relative <?php echo e(request()->routeIs('supervisor.dashboard') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                        <div
                            class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200 <?php echo e(request()->routeIs('supervisor.dashboard') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                        </div>
                        <i
                            class="fas fa-home mr-3 text-base transition-colors duration-200 <?php echo e(request()->routeIs('supervisor.dashboard') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                        <span
                            class="text-sm font-medium transition-colors duration-200 <?php echo e(request()->routeIs('supervisor.dashboard') ? 'text-white' : 'group-hover:text-white'); ?>">Dashboard</span>
                    </a>
                </li>

                <!-- Persetujuan -->
                <li>
                    <div class="dropdown">
                        <button onclick="toggleDropdown('approvalDropdown', 'approvalIcon')"
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-lg transition-all duration-200 group relative
                            <?php echo e(request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                            <div
                                class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200
                                <?php echo e(request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                            </div>
                            <span class="flex items-center">
                                <i
                                    class="fas fa-check-circle mr-3 text-base transition-colors duration-200
                                <?php echo e(request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>">
                                </i>
                                <span
                                    class="text-sm font-medium transition-colors duration-200
                                    <?php echo e(request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'text-white' : 'group-hover:text-white'); ?>">
                                    Persetujuan
                                </span>
                            </span>
                            <i id="approvalIcon"
                                class="fas fa-chevron-right text-xs transition-transform duration-300
                                <?php echo e(request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'rotate-90 text-white' : 'text-gray-500'); ?>">
                            </i>
                        </button>
                        <ul id="approvalDropdown"
                            class="ml-4 mt-1 space-y-0.5 border-l-2 border-slate-800 dark:border-gray-700 pl-4
                            <?php echo e(request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'block' : 'hidden'); ?>">
                            <li>
                                <a href="<?php echo e(route('supervisor.productions.planning')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.productions.planning') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.productions.planning') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    <span class="flex-1">Planning</span>
                                    <span id="sidebar-productions-badge" class="hidden bg-red-500 text-white text-xs font-bold px-1.5 py-0.5 rounded-full min-w-[20px] text-center ml-auto"></span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.productions.completion')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.productions.completion') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.productions.completion') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    <span class="flex-1">Penyelesaian</span>
                                </a>
                            </li>
                            
                        </ul>
                    </div>
                </li>

                <!-- Review Penawaran Harga -->
                <li>
                    <a href="<?php echo e(route('supervisor.quotations.index')); ?>"
                        class="flex items-center px-4 py-2.5 rounded-lg transition-all duration-200 group relative <?php echo e(request()->routeIs('supervisor.quotations.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                        <div
                            class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200 <?php echo e(request()->routeIs('supervisor.quotations.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                        </div>
                        <i
                            class="fas fa-handshake mr-3 text-base transition-colors duration-200 <?php echo e(request()->routeIs('supervisor.quotations.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                        <span
                            class="flex-1 text-sm font-medium transition-colors duration-200 <?php echo e(request()->routeIs('supervisor.quotations.*') ? 'text-white' : 'group-hover:text-white'); ?>">Review Penawaran</span>
                        <span id="sidebar-quotations-badge" class="hidden bg-red-500 text-white text-xs font-bold px-1.5 py-0.5 rounded-full min-w-[20px] text-center ml-2"></span>
                    </a>
                </li>

                <!-- Monitoring -->
                <li>
                    <div class="dropdown">
                        <button onclick="toggleDropdown('monitoringDropdown', 'monitoringIcon')"
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-lg transition-all duration-200 group relative
                            <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                            <div
                                class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200
                                <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                            </div>
                            <span class="flex items-center">
                                <i
                                    class="fas fa-eye mr-3 text-base transition-colors duration-200
                                <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>">
                                </i>
                                <span
                                    class="text-sm font-medium transition-colors duration-200
                                    <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'text-white' : 'group-hover:text-white'); ?>">
                                    Monitoring
                                </span>
                            </span>
                            <i id="monitoringIcon"
                                class="fas fa-chevron-right text-xs transition-transform duration-300
                                <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'rotate-90 text-white' : 'text-gray-500'); ?>">
                            </i>
                        </button>
                        <ul id="monitoringDropdown"
                            class="ml-4 mt-1 space-y-0.5 border-l-2 border-slate-800 dark:border-gray-700 pl-4
                            <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'block' : 'hidden'); ?>">
                            <li>
                                <a href="<?php echo e(route('supervisor.monitoring.orders')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.monitoring.orders') && !request()->has('status') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.monitoring.orders') && !request()->has('status') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Semua Pesanan
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.monitoring.productions')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.monitoring.productions') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.monitoring.productions') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Semua Produksi
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.monitoring.sales')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.monitoring.sales') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.monitoring.sales') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Semua Penjualan
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.monitoring.purchases')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.monitoring.purchases') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.monitoring.purchases') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Semua Pembelian
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <!-- Laporan -->
                <li>
                    <div class="dropdown">
                        <button onclick="toggleDropdown('reportsDropdown', 'reportsIcon')"
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-lg transition-all duration-200 group relative
                            <?php echo e(request()->routeIs('supervisor.reports.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                            <div
                                class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200
                                <?php echo e(request()->routeIs('supervisor.reports.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                            </div>
                            <span class="flex items-center">
                                <i
                                    class="fas fa-file-alt mr-3 text-base transition-colors duration-200
                                <?php echo e(request()->routeIs('supervisor.reports.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                                <span
                                    class="text-sm font-medium transition-colors duration-200
                                <?php echo e(request()->routeIs('supervisor.reports.*') ? 'text-white' : 'group-hover:text-white'); ?>">Laporan</span>
                            </span>
                            <i id="reportsIcon"
                                class="fas fa-chevron-right text-xs transition-transform duration-300
                                <?php echo e(request()->routeIs('supervisor.reports.*') ? 'rotate-90 text-white' : 'text-gray-500'); ?>"></i>
                        </button>
                        <ul id="reportsDropdown"
                            class="ml-4 mt-1 space-y-0.5 border-l-2 border-slate-800 dark:border-gray-700 pl-4
                        <?php echo e(request()->routeIs('supervisor.reports.*') ? 'block' : 'hidden'); ?>">
                            <li>
                                <a href="<?php echo e(route('supervisor.reports.sales')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.reports.sales*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.reports.sales*') ? 'text-white rotate-90' : 'text-gray-600'); ?>"></i>
                                    Lap. Penjualan
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.reports.purchases')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.reports.purchases*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.reports.purchases*') ? 'text-white rotate-90' : 'text-gray-600'); ?>"></i>
                                    Lap. Pembelian
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.reports.productions')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.reports.productions*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.reports.productions*') ? 'text-white rotate-90' : 'text-gray-600'); ?>"></i>
                                    Lap. Produksi
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.reports.stock-limit')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.reports.stock-limit*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.reports.stock-limit*') ? 'text-white rotate-90' : 'text-gray-600'); ?>"></i>
                                    Lap. Barang Limit
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.reports.damaged-items')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.reports.damaged-items*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.reports.damaged-items*') ? 'text-white rotate-90' : 'text-gray-600'); ?>"></i>
                                    Lap. Barang Rusak
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.reports.financial')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('supervisor.reports.financial*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('supervisor.reports.financial*') ? 'text-white rotate-90' : 'text-gray-600'); ?>"></i>
                                    Lap. Keuangan
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <!-- Kalender -->
                <li>
                    <a href="<?php echo e(route('supervisor.calendar.index')); ?>"
                        class="flex items-center px-4 py-2.5 rounded-lg transition-all duration-200 group relative <?php echo e(request()->routeIs('supervisor.calendar.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                        <div
                            class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200 <?php echo e(request()->routeIs('supervisor.calendar.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                        </div>
                        <i
                            class="fas fa-calendar-alt mr-3 text-base transition-colors duration-200 <?php echo e(request()->routeIs('supervisor.calendar.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                        <span
                            class="text-sm font-medium transition-colors duration-200 <?php echo e(request()->routeIs('supervisor.calendar.*') ? 'text-white' : 'group-hover:text-white'); ?>">Kalender</span>
                    </a>
                </li>

                <!-- Analytics -->
                <li>
                    <a href="<?php echo e(route('supervisor.analytics.index')); ?>"
                        class="flex items-center px-4 py-2.5 rounded-lg transition-all duration-200 group relative <?php echo e(request()->routeIs('supervisor.analytics.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                        <div
                            class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200 <?php echo e(request()->routeIs('supervisor.analytics.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                        </div>
                        <i
                            class="fas fa-chart-line mr-3 text-base transition-colors duration-200 <?php echo e(request()->routeIs('supervisor.analytics.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                        <span
                            class="text-sm font-medium transition-colors duration-200 <?php echo e(request()->routeIs('supervisor.analytics.*') ? 'text-white' : 'group-hover:text-white'); ?>">Analytics</span>
                    </a>
                </li>
            </ul>
        </nav>
    </div>
</aside>

<!-- Mobile Overlay -->
<div id="sidebarOverlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden lg:hidden" style="opacity: 0; visibility: hidden;"></div>

<script>
    // Simple function to update navbar position
    function updateNavbarPosition() {
        const navbar = document.getElementById('supervisorNavbar');
        const sidebar = document.getElementById('sidebar');
        if (!navbar || !sidebar) return;
        
        const isMobile = window.innerWidth < 1024;
        if (isMobile) {
            navbar.style.left = '0';
            return;
        }
        
        const isHidden = sidebar.classList.contains('-translate-x-full');
        navbar.style.left = isHidden ? '0' : '256px';
    }
    
    // Smooth sidebar toggle
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        const mainContent = document.getElementById('mainContent');
        const isMobile = window.innerWidth < 1024;
        
        const isHidden = sidebar.classList.contains('-translate-x-full');
        
        if (isHidden) {
            // Show sidebar with smooth transition
            if (isMobile) {
                // Mobile: show overlay first, then sidebar
                overlay.classList.remove('hidden');
                overlay.style.opacity = '0';
                overlay.style.visibility = 'visible';
                void overlay.offsetHeight; // Force reflow
                overlay.style.opacity = '1';
                document.body.style.overflow = 'hidden';
                
                setTimeout(function() {
                    sidebar.classList.remove('-translate-x-full');
                    sidebar.style.transform = '';
                }, 10);
            } else {
                // Desktop: smooth transition
                sidebar.classList.remove('-translate-x-full');
                sidebar.style.transform = '';
                mainContent.classList.remove('ml-0');
                mainContent.classList.add('lg:ml-64');
                // Ensure margin is set for desktop
                if (window.innerWidth >= 1024) {
                    mainContent.style.marginLeft = '256px';
                } else {
                    mainContent.style.marginLeft = '';
                }
                localStorage.setItem('supervisorSidebarState', 'visible');
                
                // Update navbar position
                updateNavbarPosition();
                
                // Fix layout width after transition
                setTimeout(function() {
                    if (typeof window.fixSupervisorLayout === 'function') {
                        window.fixSupervisorLayout();
                    }
                }, 300);
            }
        } else {
            // Hide sidebar with smooth transition
            if (isMobile) {
                // Mobile: hide sidebar first, then overlay
                sidebar.classList.add('-translate-x-full');
                sidebar.style.transform = 'translateX(-100%)';
                
                setTimeout(function() {
                    overlay.style.opacity = '0';
                    setTimeout(function() {
                        overlay.classList.add('hidden');
                        overlay.style.visibility = 'hidden';
                    }, 300);
                }, 50);
                document.body.style.overflow = 'auto';
            } else {
                // Desktop: smooth transition
                sidebar.classList.add('-translate-x-full');
                sidebar.style.transform = 'translateX(-100%)';
                mainContent.classList.remove('lg:ml-64');
                mainContent.classList.add('ml-0');
                mainContent.style.marginLeft = '0';
                localStorage.setItem('supervisorSidebarState', 'hidden');
                
                // Update navbar position
                updateNavbarPosition();
                
                // Fix layout width - make content full width
                const viewportWidth = window.innerWidth;
                setTimeout(function() {
                    mainContent.style.width = viewportWidth + 'px';
                    mainContent.style.maxWidth = viewportWidth + 'px';
                    if (typeof window.fixSupervisorLayout === 'function') {
                        window.fixSupervisorLayout();
                    }
                }, 50);
            }
        }
    }

    // Close sidebar when clicking overlay
    document.getElementById('sidebarOverlay').addEventListener('click', function() {
        toggleSidebar();
    });

    // Close sidebar when clicking outside on mobile
    document.addEventListener('click', function(event) {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        const sidebarToggle = event.target.closest('[onclick="toggleSidebar()"]');

        if (window.innerWidth < 1024) {
            if (!sidebar.contains(event.target) && !sidebarToggle && !overlay.classList.contains('hidden')) {
                toggleSidebar();
            }
        }
    });

    // Handle window resize
    window.addEventListener('resize', function() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        const mainContent = document.getElementById('mainContent');

        if (window.innerWidth >= 1024) {
            const savedState = localStorage.getItem('supervisorSidebarState');
            const isHidden = savedState === 'hidden';
            
            if (isHidden) {
                sidebar.classList.add('-translate-x-full');
                sidebar.style.transform = 'translateX(-100%)';
                mainContent.classList.remove('lg:ml-64');
                mainContent.classList.add('ml-0');
                mainContent.style.marginLeft = '0';
            } else {
                sidebar.classList.remove('-translate-x-full');
                sidebar.style.transform = '';
                mainContent.classList.remove('ml-0');
                mainContent.classList.add('lg:ml-64');
                mainContent.style.marginLeft = '256px';
            }
            overlay.classList.add('hidden');
        } else {
            if (sidebar.classList.contains('-translate-x-full')) {
                sidebar.style.transform = '';
            }
            mainContent.classList.remove('lg:ml-64');
            mainContent.classList.add('ml-0');
            mainContent.style.marginLeft = '0';
            overlay.classList.add('hidden');
        }
        
        // Update navbar position on resize
        updateNavbarPosition();
    });
    
    // Initialize sidebar state on load
    function initSidebarState() {
        const sidebar = document.getElementById('sidebar');
        const mainContent = document.getElementById('mainContent');
        const navbar = document.getElementById('supervisorNavbar');
        
        if (!sidebar || !mainContent) {
            setTimeout(initSidebarState, 50);
            return;
        }
        
        const isMobile = window.innerWidth < 1024;
        if (isMobile) {
            // Mobile: sidebar should be hidden by default
            sidebar.classList.add('-translate-x-full');
            return;
        }
        
        // Desktop: restore state from localStorage or show by default
        const savedState = localStorage.getItem('supervisorSidebarState');
        const isHidden = savedState === 'hidden';
        
        if (!isHidden) {
            // Show sidebar by default if no saved state
            sidebar.classList.remove('-translate-x-full');
            sidebar.style.transform = '';
            mainContent.classList.remove('ml-0');
            mainContent.classList.add('lg:ml-64');
            // Ensure margin is set for desktop
            if (window.innerWidth >= 1024) {
                mainContent.style.marginLeft = '256px';
            } else {
                mainContent.style.marginLeft = '';
            }
            
            if (navbar) {
                navbar.style.left = '256px';
            }
        }
    }
    
    // Initialize navbar position on load
    function initNavbarPosition() {
        if (document.getElementById('supervisorNavbar') && document.getElementById('sidebar')) {
            updateNavbarPosition();
        } else {
            setTimeout(initNavbarPosition, 50);
        }
    }
    
    // Run initialization
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            initSidebarState();
            initNavbarPosition();
        });
    } else {
        initSidebarState();
        initNavbarPosition();
    }

    // Dropdown toggle functionality
    function toggleDropdown(dropdownId, iconId) {
        const dropdown = document.getElementById(dropdownId);
        const icon = document.getElementById(iconId);

        if (dropdown.classList.contains('hidden')) {
            dropdown.classList.remove('hidden');
            icon.classList.add('rotate-90');
        } else {
            dropdown.classList.add('hidden');
            icon.classList.remove('rotate-90');
        }
    }
</script>
<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/partials/sidebar.blade.php ENDPATH**/ ?>