<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php if(auth()->guard()->check()): ?>
        <meta name="user-authenticated" content="true">
        <meta name="user-type" content="<?php echo e(Auth::user()->user_type); ?>">
    <?php endif; ?>
    <title><?php echo $__env->yieldContent('title', 'Dashboard Supervisor - POLJAM TECH'); ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/jpeg" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="shortcut icon" type="image/jpeg" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="icon" type="image/jpeg" sizes="32x32" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="icon" type="image/jpeg" sizes="16x16" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    
    <!-- Tailwind CSS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- SweetAlert Helper - Inline untuk memastikan selalu tersedia -->
    <script>
    // SweetAlert Configuration
    const SwalConfig = {
        confirmButton: { class: 'px-6 py-2.5 rounded-lg font-semibold transition-all duration-200 shadow-lg hover:shadow-xl' },
        cancelButton: { class: 'px-6 py-2.5 rounded-lg font-semibold transition-all duration-200' },
        popup: { class: 'rounded-2xl shadow-2xl border border-gray-200 dark:border-gray-700' }
    };

    // Modern Confirm Dialog
    function showConfirm(options) {
        const {
            title = 'Konfirmasi',
            text = 'Apakah Anda yakin?',
            confirmText = 'Ya, Lanjutkan',
            cancelText = 'Batal',
            icon = 'question',
            confirmColor = '#3b82f6',
            onConfirm = null,
            onCancel = null,
            showLoader = false
        } = options;

        return Swal.fire({
            title: title,
            text: text,
            icon: icon,
            showCancelButton: true,
            confirmButtonColor: confirmColor,
            cancelButtonColor: '#6b7280',
            confirmButtonText: `<i class="fas fa-check mr-2"></i>${confirmText}`,
            cancelButtonText: `<i class="fas fa-times mr-2"></i>${cancelText}`,
            reverseButtons: true,
            allowOutsideClick: !showLoader,
            allowEscapeKey: !showLoader,
            customClass: {
                popup: SwalConfig.popup.class,
                confirmButton: SwalConfig.confirmButton.class,
                cancelButton: SwalConfig.cancelButton.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
            didOpen: () => { if (showLoader) Swal.showLoading(); }
        }).then((result) => {
            if (result.isConfirmed && onConfirm) {
                onConfirm(result);
            } else if (result.isDismissed && onCancel) {
                onCancel(result);
            }
            return result;
        });
    }

    // Modern Success Notification
    function showSuccess(message, title = 'Berhasil!', duration = 3000) {
        return Swal.fire({
            icon: 'success',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: false,
            customClass: {
                popup: SwalConfig.popup.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Error Notification
    function showError(message, title = 'Terjadi Kesalahan!', duration = 4000) {
        return Swal.fire({
            icon: 'error',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: true,
            confirmButtonText: '<i class="fas fa-times mr-2"></i>Tutup',
            confirmButtonColor: '#ef4444',
            customClass: {
                popup: SwalConfig.popup.class,
                confirmButton: SwalConfig.confirmButton.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Warning Notification
    function showWarning(message, title = 'Peringatan!', duration = 4000) {
        return Swal.fire({
            icon: 'warning',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: true,
            confirmButtonText: '<i class="fas fa-check mr-2"></i>Mengerti',
            confirmButtonColor: '#f59e0b',
            customClass: {
                popup: SwalConfig.popup.class,
                confirmButton: SwalConfig.confirmButton.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Info Notification
    function showInfo(message, title = 'Informasi', duration = 3000) {
        return Swal.fire({
            icon: 'info',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: false,
            customClass: {
                popup: SwalConfig.popup.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Loading Indicator
    function showLoading(title = 'Memproses...', text = 'Harap tunggu sebentar') {
        return Swal.fire({
            title: title,
            text: text,
            allowOutsideClick: false,
            allowEscapeKey: false,
            showConfirmButton: false,
            didOpen: () => { Swal.showLoading(); },
            customClass: {
                popup: SwalConfig.popup.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
        });
    }

    // Export functions globally
    window.showConfirm = showConfirm;
    window.showSuccess = showSuccess;
    window.showError = showError;
    window.showWarning = showWarning;
    window.showInfo = showInfo;
    window.showLoading = showLoading;
    </script>
    
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- CRITICAL: Restore sidebar state IMMEDIATELY - Must be first script -->
    <script>
    (function() {
        // Run immediately, blocking - before any rendering
        const savedState = localStorage.getItem('supervisorSidebarState');
        const isHidden = savedState === 'hidden';
        
        // Inject blocking style immediately to prevent ANY flash
        const style = document.createElement('style');
        style.id = 'sidebar-blocking-style';
        style.textContent = `
            #sidebar { 
                transition: none !important; 
                transform: ${isHidden ? 'translateX(-100%)' : 'translateX(0)'} !important;
            }
            #mainContent { 
                transition: none !important; 
                margin-left: ${isHidden ? '0' : '256px'} !important;
            }
            #supervisorNavbar {
                transition: none !important;
                left: ${isHidden ? '0' : '256px'} !important;
            }
        `;
        document.head.insertBefore(style, document.head.firstChild);
        
        // Set flag for later use
        window.__sidebarState = { isHidden: isHidden, restored: false };
    })();
    </script>
    
    <!-- Custom CSS -->
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="bg-gray-100 dark:bg-gray-900 transition-colors duration-300">
    <!-- Sidebar -->
    <?php echo $__env->make('supervisor.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div id="mainContent" class="ml-0 lg:ml-64 flex flex-col min-h-screen">
        <?php echo $__env->make('supervisor.partials.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Page Content -->
        <main class="flex-1 p-6 md:p-8 lg:p-12">
            <!-- Flash Notifications -->
            <?php echo $__env->make('partials.flash-notifications', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            
            <?php if (! empty(trim($__env->yieldContent('content')))): ?>
                <?php echo $__env->yieldContent('content'); ?>
            <?php else: ?>
                <p class="text-gray-600 dark:text-gray-300">Selamat datang di dashboard supervisor.</p>
            <?php endif; ?>
        </main>

        <!-- Footer -->
        <?php echo $__env->make('supervisor.partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <!-- Restore sidebar state and remove blocking style -->
    <script>
    (function() {
        function restoreSidebarState() {
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            
            if (!sidebar || !mainContent) {
                requestAnimationFrame(restoreSidebarState);
                return;
            }
            
            const isMobile = window.innerWidth < 1024;
            if (isMobile) {
                // Remove blocking style
                const blockingStyle = document.getElementById('sidebar-blocking-style');
                if (blockingStyle) blockingStyle.remove();
                if (window.__sidebarState) window.__sidebarState.restored = true;
                return;
            }
            
            // Get saved state (from early script or localStorage)
            const savedState = window.__sidebarState ? window.__sidebarState.isHidden : (localStorage.getItem('supervisorSidebarState') === 'hidden');
            
            // Ensure no transition during restore
            sidebar.style.transition = 'none';
            mainContent.style.transition = 'none';
            
            if (savedState) {
                sidebar.classList.add('-translate-x-full');
                sidebar.style.transform = 'translateX(-100%)';
                mainContent.classList.remove('lg:ml-64');
                mainContent.classList.add('ml-0');
                mainContent.style.marginLeft = '0';
            } else {
                sidebar.classList.remove('-translate-x-full');
                sidebar.style.transform = '';
                mainContent.classList.remove('ml-0');
                mainContent.classList.add('lg:ml-64');
                // Ensure margin is set for desktop
                if (window.innerWidth >= 1024) {
                    mainContent.style.marginLeft = '256px';
                } else {
                    mainContent.style.marginLeft = '';
                }
            }
            
            // Update navbar position immediately
            const navbar = document.getElementById('supervisorNavbar');
            if (navbar) {
                if (savedState) {
                    navbar.style.left = '0';
                } else {
                    navbar.style.left = '256px';
                }
            }

            // Remove blocking style and re-enable smooth transitions after a delay
            setTimeout(function() {
                const blockingStyle = document.getElementById('sidebar-blocking-style');
                if (blockingStyle) blockingStyle.remove();
                sidebar.style.transition = '';
                mainContent.style.transition = '';
                if (window.__sidebarState) window.__sidebarState.restored = true;
            }, 100);
        }
        
        // Run as soon as possible
        if (document.body) {
            restoreSidebarState();
        } else {
            document.addEventListener('DOMContentLoaded', restoreSidebarState);
        }
    })();
    </script>

    <!-- Simple Layout Handler - Fix content width on zoom/resize -->
    <script>
    (function() {
        function fixLayout() {
            const mainContent = document.getElementById('mainContent');
            const sidebar = document.getElementById('sidebar');
            if (!mainContent || !sidebar) return;
            
            const isMobile = window.innerWidth < 1024;
            if (isMobile) {
                mainContent.style.width = '';
                mainContent.style.maxWidth = '';
                return;
            }
            
            const viewportWidth = window.innerWidth;
            const sidebarWidth = 256;
            const isHidden = sidebar.classList.contains('-translate-x-full');
            
            if (isHidden) {
                mainContent.style.width = viewportWidth + 'px';
                mainContent.style.maxWidth = viewportWidth + 'px';
                mainContent.style.marginLeft = '0';
            } else {
                mainContent.style.width = (viewportWidth - sidebarWidth) + 'px';
                mainContent.style.maxWidth = (viewportWidth - sidebarWidth) + 'px';
                mainContent.style.marginLeft = '256px';
            }
        }

        // Make it globally accessible
        window.fixSupervisorLayout = fixLayout;
        
        let resizeTimeout;
        window.addEventListener('resize', function() {
            clearTimeout(resizeTimeout);
            resizeTimeout = setTimeout(fixLayout, 100);
        });
        
        // Fix on load (after sidebar state is restored)
        function initLayout() {
            if (window.__sidebarState && window.__sidebarState.restored) {
                fixLayout();
            } else {
                setTimeout(initLayout, 50);
            }
        }
        
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', function() {
                setTimeout(initLayout, 100);
            });
        } else {
            setTimeout(initLayout, 150);
        }
    })();
    </script>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="<?php echo e(asset('js/notifications.js')); ?>?v=<?php echo e(time()); ?>"></script>
    
    <!-- Ensure notification system is initialized after all scripts -->
    <script>
        // Initialize notification system for supervisor
        document.addEventListener('DOMContentLoaded', function() {
            console.log('[Supervisor Layout] DOMContentLoaded, initializing notification system...');
            
            // Ensure notification system is initialized
            if (!window.notificationSystem) {
                console.log('[Supervisor Layout] Creating new NotificationSystem instance...');
                window.notificationSystem = new NotificationSystem();
            } else {
                console.log('[Supervisor Layout] NotificationSystem already exists, checking notifications...');
                // Trigger immediate check
                if (typeof window.notificationSystem.checkNotifications === 'function') {
                    setTimeout(() => {
                        window.notificationSystem.checkNotifications();
                    }, 500);
                }
            }
            
            // Force re-bind events after page load
            setTimeout(() => {
                if (window.notificationSystem && typeof window.notificationSystem.bindEvents === 'function') {
                    console.log('[Supervisor Layout] Re-binding notification events...');
                    window.notificationSystem.bindEvents();
                }
            }, 500);
        });
        
        // Also try after window load as fallback
        window.addEventListener('load', () => {
            setTimeout(() => {
                if (window.notificationSystem && typeof window.notificationSystem.bindEvents === 'function') {
                    console.log('[Supervisor Layout] Re-binding notification events after page load...');
                    window.notificationSystem.bindEvents();
                }
                // Trigger check notifications to update badges
                if (window.notificationSystem && typeof window.notificationSystem.checkNotifications === 'function') {
                    window.notificationSystem.checkNotifications();
                }
            }, 500);
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>


<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/layouts/supervisor.blade.php ENDPATH**/ ?>