

<?php $__env->startSection('title', ($type ?? 'material') === 'sparepart' ? 'Detail Sparepart' : 'Detail Bahan'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="<?php echo e(route('admin.master.materials.index', isset($queryParams) ? $queryParams : [])); ?>" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white">
                <?php echo e(($type ?? 'material') === 'sparepart' ? 'Detail Sparepart' : 'Detail Bahan'); ?>

            </h1>
        </div>
        <div class="flex items-center space-x-2" style="display: flex; align-items: center; justify-content: center;">
            <a href="<?php echo e(route('admin.master.materials.edit', ['id' => ($type ?? 'material') === 'sparepart' ? $sparepart->id : $material->id, 'type' => $type ?? 'material'])); ?>?<?php echo e(http_build_query(request()->only(['page', 'search', 'type']))); ?>"
                class="inline-flex items-center justify-center w-9 h-9 text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded transition-colors duration-200"
                title="Edit">
                <i class="fas fa-edit text-base"></i>
            </a>
            <form action="<?php echo e(route('admin.master.materials.destroy', ['id' => ($type ?? 'material') === 'sparepart' ? $sparepart->id : $material->id, 'type' => $type ?? 'material'])); ?>" method="POST" class="inline m-0 p-0" style="display: inline-block; margin: 0; padding: 0;" onsubmit="return confirmDelete(event)">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" 
                    class="inline-flex items-center justify-center w-9 h-9 text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 hover:bg-red-50 dark:hover:bg-red-900/20 rounded transition-colors duration-200"
                    title="Hapus">
                    <i class="fas fa-trash text-base"></i>
                </button>
            </form>
        </div>
    </div>

    <!-- Main Card - Simplified -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
        <div class="flex flex-col lg:flex-row gap-4">
            <!-- Image Section -->
            <div class="flex-shrink-0">
                <?php if(($type ?? 'material') === 'sparepart'): ?>
                    <?php if($sparepart->image): ?>
                        <img src="<?php echo e(asset('uploads/spareparts/' . $sparepart->image)); ?>"
                            alt="<?php echo e($sparepart->name); ?>"
                            class="w-32 h-32 object-contain rounded-lg border border-gray-200 dark:border-gray-600"
                            style="background: transparent;">
                    <?php else: ?>
                        <div class="w-32 h-32 bg-gray-50 dark:bg-gray-700/50 rounded-lg flex items-center justify-center border border-gray-200 dark:border-gray-600">
                            <i class="fas fa-image text-gray-400 dark:text-gray-500 text-2xl"></i>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <?php if($material->image): ?>
                        <img src="<?php echo e(asset('uploads/materials/' . $material->image)); ?>"
                            alt="<?php echo e($material->name); ?>"
                            class="w-32 h-32 object-contain rounded-lg border border-gray-200 dark:border-gray-600"
                            style="background: transparent;">
                    <?php else: ?>
                        <div class="w-32 h-32 bg-gray-50 dark:bg-gray-700/50 rounded-lg flex items-center justify-center border border-gray-200 dark:border-gray-600">
                            <i class="fas fa-image text-gray-400 dark:text-gray-500 text-2xl"></i>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            <!-- Info Section -->
            <div class="flex-1">
                <!-- Title & Status -->
                <div class="flex items-start justify-between mb-3">
                    <div>
                        <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-1">
                            <?php echo e(($type ?? 'material') === 'sparepart' ? $sparepart->name : $material->name); ?>

                        </h2>
                        <div class="flex items-center gap-2 text-sm text-gray-600 dark:text-gray-400">
                            <i class="fas fa-barcode text-blue-600 dark:text-blue-400"></i>
                            <span><?php echo e(($type ?? 'material') === 'sparepart' ? ($sparepart->part_code ?? '-') : ($material->material_code ?? '-')); ?></span>
                        </div>
                    </div>
                    <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium
                        <?php echo e((($type ?? 'material') === 'sparepart' ? $sparepart->is_active : $material->is_active) ? 'bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-300' : 'bg-red-100 dark:bg-red-900/40 text-red-800 dark:text-red-300'); ?>">
                        <?php echo e((($type ?? 'material') === 'sparepart' ? $sparepart->is_active : $material->is_active) ? 'Aktif' : 'Nonaktif'); ?>

                    </span>
                </div>

                <!-- Info Grid - Compact -->
                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-3 mb-3">
                    <!-- Stok -->
                    <div class="flex items-center gap-2 p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                        <i class="fas fa-warehouse text-blue-600 dark:text-blue-400 text-sm"></i>
                        <div>
                            <p class="text-xs text-gray-500 dark:text-gray-400">Stok</p>
                            <p class="text-sm font-bold text-gray-900 dark:text-white">
                                <?php echo e(number_format(($type ?? 'material') === 'sparepart' ? $sparepart->stock : $material->stock, 0, ',', '.')); ?> <?php echo e((($type ?? 'material') === 'sparepart' ? $sparepart->unit : $material->unit) ?? 'pcs'); ?>

                            </p>
                        </div>
                    </div>

                    <!-- Harga -->
                    <div class="flex items-center gap-2 p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                        <i class="fas fa-tag text-green-600 dark:text-green-400 text-sm"></i>
                        <div>
                            <p class="text-xs text-gray-500 dark:text-gray-400">Harga</p>
                            <p class="text-sm font-bold text-gray-900 dark:text-white">
                                Rp <?php echo e(number_format((($type ?? 'material') === 'sparepart' ? $sparepart->price : $material->price) ?? 0, 0, ',', '.')); ?>

                            </p>
                        </div>
                    </div>

                    <!-- Satuan -->
                    <div class="flex items-center gap-2 p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                        <i class="fas fa-ruler-horizontal text-blue-600 dark:text-blue-400 text-sm"></i>
                        <div>
                            <p class="text-xs text-gray-500 dark:text-gray-400">Satuan</p>
                            <p class="text-sm font-bold text-gray-900 dark:text-white"><?php echo e((($type ?? 'material') === 'sparepart' ? $sparepart->unit : $material->unit) ?? '-'); ?></p>
                        </div>
                    </div>

                    <?php if(($type ?? 'material') === 'sparepart'): ?>
                        <!-- Brand -->
                        <div class="flex items-center gap-2 p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                            <i class="fas fa-copyright text-purple-600 dark:text-purple-400 text-sm"></i>
                            <div>
                                <p class="text-xs text-gray-500 dark:text-gray-400">Brand</p>
                                <p class="text-sm font-bold text-gray-900 dark:text-white"><?php echo e($sparepart->brand ?? '-'); ?></p>
                            </div>
                        </div>

                        <!-- Type -->
                        <div class="flex items-center gap-2 p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                            <i class="fas fa-tag text-indigo-600 dark:text-indigo-400 text-sm"></i>
                            <div>
                                <p class="text-xs text-gray-500 dark:text-gray-400">Type</p>
                                <p class="text-sm font-bold text-gray-900 dark:text-white"><?php echo e($sparepart->type ?? '-'); ?></p>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- Kategori -->
                        <div class="flex items-center gap-2 p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                            <i class="fas fa-layer-group text-purple-600 dark:text-purple-400 text-sm"></i>
                            <div>
                                <p class="text-xs text-gray-500 dark:text-gray-400">Kategori</p>
                                <p class="text-sm font-bold text-gray-900 dark:text-white"><?php echo e($material->category ?? '-'); ?></p>
                            </div>
                        </div>

                        <!-- Supplier -->
                        <div class="flex items-center gap-2 p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                            <i class="fas fa-truck text-orange-600 dark:text-orange-400 text-sm"></i>
                            <div>
                                <p class="text-xs text-gray-500 dark:text-gray-400">Supplier</p>
                                <p class="text-sm font-bold text-gray-900 dark:text-white"><?php echo e($material->supplier ?? '-'); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Damage Information - Dipindahkan lebih dekat dengan info produk -->
                <?php
                    $damagedStock = ($type ?? 'material') === 'sparepart' ? ($sparepart->damaged_stock ?? 0) : ($material->damaged_stock ?? 0);
                    $damageNotes = ($type ?? 'material') === 'sparepart' ? ($sparepart->damage_notes ?? null) : ($material->damage_notes ?? null);
                    $damageDate = ($type ?? 'material') === 'sparepart' ? ($sparepart->damage_date ?? null) : ($material->damage_date ?? null);
                    $totalStock = ($type ?? 'material') === 'sparepart' ? $sparepart->stock : $material->stock;
                ?>
                <?php if($damagedStock > 0): ?>
                    <div class="p-3 bg-red-50 dark:bg-red-900/20 rounded-lg border border-red-200 dark:border-red-800 mb-3">
                        <div class="flex items-center gap-2 mb-2">
                            <i class="fas fa-exclamation-triangle text-red-600 dark:text-red-400 text-sm"></i>
                            <p class="text-sm font-semibold text-red-800 dark:text-red-300">Informasi Kerusakan</p>
                        </div>
                        
                        <!-- Jumlah Unit Rusak -->
                        <div class="mb-2">
                            <div class="flex items-center gap-2 mb-1">
                                <p class="text-xs text-red-700 dark:text-red-400 font-medium">Jumlah Unit Rusak:</p>
                                <span class="text-xs font-bold text-red-800 dark:text-red-300">
                                    <?php echo e(number_format($damagedStock, 0, ',', '.')); ?> <?php echo e((($type ?? 'material') === 'sparepart' ? $sparepart->unit : $material->unit) ?? 'pcs'); ?>

                                </span>
                            </div>
                            <?php if($totalStock > 0): ?>
                                <?php
                                    $damagePercentage = ($damagedStock / $totalStock) * 100;
                                ?>
                                <p class="text-xs text-red-600 dark:text-red-400">
                                    dari <?php echo e(number_format($totalStock, 0, ',', '.')); ?> <?php echo e((($type ?? 'material') === 'sparepart' ? $sparepart->unit : $material->unit) ?? 'pcs'); ?> total (<?php echo e(number_format($damagePercentage, 2, ',', '.')); ?>% rusak)
                                </p>
                            <?php endif; ?>
                        </div>

                        <!-- Catatan Kerusakan -->
                        <?php if($damageNotes): ?>
                            <div class="mb-2">
                                <p class="text-xs text-red-700 dark:text-red-400 font-medium mb-1">Catatan Kerusakan</p>
                                <p class="text-xs text-red-800 dark:text-red-300 leading-relaxed bg-white dark:bg-gray-800 p-2 rounded border border-red-200 dark:border-red-700">
                                    <?php echo e($damageNotes); ?>

                                </p>
                            </div>
                        <?php endif; ?>

                        <!-- Tanggal Kerusakan -->
                        <?php if($damageDate): ?>
                            <div class="flex items-center gap-2">
                                <i class="fas fa-calendar-times text-red-600 dark:text-red-400 text-xs"></i>
                                <p class="text-xs text-red-700 dark:text-red-400">
                                    <span class="font-medium">Tanggal Kerusakan:</span> 
                                    <span class="text-red-800 dark:text-red-300"><?php echo e(\Carbon\Carbon::parse($damageDate)->format('d M Y')); ?></span>
                                </p>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <?php if(($type ?? 'material') === 'sparepart' && $sparepart->part_number): ?>
                    <!-- Part Number (Sparepart only) -->
                    <div class="flex items-center gap-2 p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600 mb-3">
                        <i class="fas fa-hashtag text-orange-600 dark:text-orange-400 text-sm"></i>
                        <div>
                            <p class="text-xs text-gray-500 dark:text-gray-400">Part Number</p>
                            <p class="text-sm font-bold text-gray-900 dark:text-white"><?php echo e($sparepart->part_number); ?></p>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Description -->
                <?php if((($type ?? 'material') === 'sparepart' && $sparepart->description) || (($type ?? 'material') === 'material' && $material->description)): ?>
                    <div class="p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600 mb-3">
                        <div class="flex items-center gap-2 mb-1">
                            <i class="fas fa-align-left text-gray-600 dark:text-gray-400 text-xs"></i>
                            <p class="text-xs font-semibold text-gray-500 dark:text-gray-400">Deskripsi</p>
                        </div>
                        <p class="text-xs text-gray-700 dark:text-gray-300 leading-relaxed">
                            <?php echo e(($type ?? 'material') === 'sparepart' ? $sparepart->description : $material->description); ?>

                        </p>
                    </div>
                <?php endif; ?>

                <!-- Timestamps - Compact -->
                <div class="flex flex-wrap items-center gap-4 pt-2 border-t border-gray-200 dark:border-gray-600">
                    <div class="flex items-center gap-2 text-xs text-gray-500 dark:text-gray-400">
                        <i class="fas fa-calendar-plus text-blue-600 dark:text-blue-400"></i>
                        <span>Dibuat: <?php echo e((($type ?? 'material') === 'sparepart' ? $sparepart->created_at : $material->created_at)?->format('d M Y, H:i') ?? '-'); ?> WIB</span>
                    </div>
                    <div class="flex items-center gap-2 text-xs text-gray-500 dark:text-gray-400">
                        <i class="fas fa-calendar-check text-green-600 dark:text-green-400"></i>
                        <span>Update: <?php echo e((($type ?? 'material') === 'sparepart' ? $sparepart->updated_at : $material->updated_at)?->format('d M Y, H:i') ?? '-'); ?> WIB</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function confirmDelete(event) {
            event.preventDefault();
            const form = event.target.closest('form');
            const itemType = '<?php echo e($type ?? 'material'); ?>';
            const itemName = itemType === 'sparepart' ? 'sparepart' : 'bahan';
            
            Swal.fire({
                title: 'Apakah Anda yakin?',
                text: `Anda akan menghapus ${itemName} ini secara permanen!`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal',
                customClass: {
                    popup: 'dark:bg-gray-800 dark:text-white',
                    confirmButton: 'bg-red-600 hover:bg-red-700',
                    cancelButton: 'bg-blue-600 hover:bg-blue-700'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/master/materials/show.blade.php ENDPATH**/ ?>