<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pesanan Sudah Dikonfirmasi - Order #{{ $order->id }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen py-8 sm:py-12">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="text-center mb-10">
                <div class="w-20 h-20 mx-auto mb-5 bg-blue-50 rounded-full flex items-center justify-center border-2 border-blue-100">
                    <svg class="w-10 h-10 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-3 leading-tight">
                    Pesanan Sudah Dikonfirmasi
                </h1>
                <p class="text-sm sm:text-base text-gray-600 leading-relaxed max-w-2xl mx-auto">
                    Pesanan ini sudah dikonfirmasi sebelumnya. Tidak perlu melakukan konfirmasi ulang.
                </p>
                <div class="mt-4 inline-flex items-center px-4 py-2 bg-blue-50 border border-blue-100 rounded-lg">
                    <span class="text-xs sm:text-sm text-blue-700 font-medium">Order ID: #{{ $order->id }}</span>
                </div>
            </div>

            <!-- Info Card -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm mb-6">
                <div class="px-6 py-4 border-b border-gray-200 bg-blue-50">
                    <h2 class="text-base font-semibold text-gray-900 flex items-center">
                        <svg class="w-5 h-5 mr-2.5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Informasi Konfirmasi
                    </h2>
                </div>
                <div class="p-6">
                    <!-- Product Info -->
                    @if($order->product)
                    <div class="flex items-start gap-4 mb-6 pb-6 border-b border-gray-100">
                        @php
                            $productImage = $order->product->product_image 
                                ? asset('uploads/products/' . $order->product->product_image)
                                : asset('images/no-image.png');
                        @endphp
                        <div class="flex-shrink-0">
                            <img src="{{ $productImage }}" alt="{{ $order->product->product_title }}" 
                                 class="w-20 h-20 sm:w-24 sm:h-24 object-contain rounded-lg border border-gray-200 bg-gray-50 p-2">
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="font-semibold text-gray-900 text-base mb-2 leading-tight">{{ $order->product->product_title ?? 'Produk' }}</h3>
                            <div class="space-y-1.5 text-sm">
                                <div class="flex items-center text-gray-600">
                                    <svg class="w-4 h-4 mr-2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                    </svg>
                                    <span>Jumlah: <strong class="text-gray-900">{{ $order->quantity }}</strong> unit</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Confirmation Details -->
                    <div class="space-y-4">
                        <div class="flex items-center justify-between py-2.5 px-4 bg-green-50 border border-green-200 rounded-lg">
                            <div class="flex items-center">
                                <svg class="w-5 h-5 mr-2.5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span class="text-sm font-medium text-gray-900">Status Pesanan</span>
                            </div>
                            <span class="text-sm font-semibold text-green-600">Selesai</span>
                        </div>

                        <div class="flex items-center justify-between py-2.5 px-4 bg-gray-50 border border-gray-200 rounded-lg">
                            <div class="flex items-center">
                                <svg class="w-5 h-5 mr-2.5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                </svg>
                                <span class="text-sm font-medium text-gray-900">Dikonfirmasi Pada</span>
                            </div>
                            <span class="text-sm text-gray-700 font-medium">{{ $order->customer_confirmed_at->format('d M Y, H:i') }}</span>
                        </div>

                        @if($order->customer_rating)
                        <div class="flex items-center justify-between py-2.5 px-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                            <div class="flex items-center">
                                <svg class="w-5 h-5 mr-2.5 text-yellow-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                                <span class="text-sm font-medium text-gray-900">Rating Anda</span>
                            </div>
                            <div class="flex items-center gap-1">
                                @for($i = 1; $i <= 5; $i++)
                                    <svg class="w-5 h-5 {{ $i <= $order->customer_rating ? 'text-yellow-400' : 'text-gray-300' }}" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                @endfor
                                <span class="ml-2 text-sm font-semibold text-gray-900">{{ $order->customer_rating }}/5</span>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Message Card -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm mb-6">
                <div class="px-6 py-4 border-b border-gray-200 bg-blue-50">
                    <h2 class="text-base font-semibold text-gray-900 flex items-center">
                        <svg class="w-5 h-5 mr-2.5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Informasi
                    </h2>
                </div>
                <div class="p-6">
                    <div class="text-center">
                        <p class="text-sm sm:text-base text-gray-700 leading-relaxed">
                            Pesanan #{{ $order->id }} sudah dikonfirmasi sebelumnya pada 
                            <strong>{{ $order->customer_confirmed_at->format('d M Y, H:i') }}</strong>. 
                            Tidak perlu melakukan konfirmasi ulang.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Close Button -->
            <div class="text-center">
                <button onclick="closePage()" 
                        class="inline-flex items-center justify-center px-8 py-3 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium rounded-lg transition-colors focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                    Tutup Halaman
                </button>
            </div>
        </div>
    </div>

    <script>
        function closePage() {
            // Coba tutup window jika dibuka dari popup/link eksternal
            if (window.opener || window.history.length <= 1) {
                window.close();
            } else {
                // Jika tidak bisa ditutup, redirect ke beranda
                window.location.href = '{{ route("index") }}';
            }
        }
    </script>
</body>
</html>
