{{-- 
    Tabel Gabungan Bahan & Sparepart dengan Checklist
    Variables: $production, $allItems (dari controller)
--}}

@php
    $orderQty = $production->quantity ?? $production->order->quantity ?? 1;
    $canCheckReceived = $production->planning_status === 'approved' && in_array($production->status, ['menunggu', 'dalam_proses']);
@endphp

<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border border-slate-200 dark:border-gray-700 overflow-hidden">
    <div class="px-4 py-3 bg-gradient-to-r from-indigo-600 to-purple-600">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <div class="w-10 h-10 bg-white/20 rounded-lg flex items-center justify-center mr-3">
                    <i class="fas fa-boxes text-white text-lg"></i>
                </div>
                <div>
                    <h2 class="text-lg font-bold text-white">Daftar Bahan & Sparepart</h2>
                    <p class="text-xs text-indigo-100">Total {{ $allItems->count() }} item untuk {{ $orderQty }} unit produk</p>
                </div>
            </div>
            @if($canCheckReceived)
            <div class="flex gap-2">
                <button type="button" onclick="confirmAllReceived()" class="px-3 py-1.5 bg-white/20 hover:bg-white/30 text-white text-xs font-medium rounded-lg transition-colors">
                    <i class="fas fa-check-double mr-1"></i> Konfirmasi Semua
                </button>
            </div>
            @endif
        </div>
    </div>

    <div class="p-4">
        @if($allItems->count() > 0)
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-slate-50 dark:bg-gray-700">
                    <tr>
                        @if($canCheckReceived)
                        <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase w-16">
                            <i class="fas fa-check-square mr-1"></i>Terima
                        </th>
                        @endif
                        <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Tipe</th>
                        <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Nama Item</th>
                        <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Jml/Unit</th>
                        <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Satuan</th>
                        <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Total Kebutuhan</th>
                        <th class="px-3 py-2 text-right text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Stok</th>
                        <th class="px-3 py-2 text-right text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Harga Satuan</th>
                        <th class="px-3 py-2 text-right text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Total Harga</th>
                        <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-200 dark:divide-gray-700">
                    @foreach($allItems as $item)
                    <tr class="hover:bg-slate-50 dark:hover:bg-gray-700/50 transition-colors {{ $item['is_additional'] ? 'bg-amber-50/50 dark:bg-amber-900/10' : '' }}">
                        @if($canCheckReceived)
                        <td class="px-3 py-2 text-center">
                            <label class="inline-flex items-center cursor-pointer">
                                <input type="checkbox" 
                                       class="item-received-checkbox w-5 h-5 text-green-600 bg-white border-2 border-gray-300 rounded focus:ring-green-500 focus:ring-2 cursor-pointer"
                                       data-type="{{ $item['type'] }}"
                                       data-id="{{ $item['id'] }}"
                                       {{ $item['is_received'] ? 'checked' : '' }}
                                       onchange="toggleItemReceived(this, '{{ $item['type'] }}', {{ $item['id'] }})">
                            </label>
                        </td>
                        @endif
                        <td class="px-3 py-2">
                            @if($item['type'] === 'material')
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-emerald-100 dark:bg-emerald-900/30 text-emerald-700 dark:text-emerald-300">
                                <i class="fas fa-box mr-1"></i> Bahan
                            </span>
                            @else
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 dark:bg-blue-900/30 text-blue-700 dark:text-blue-300">
                                <i class="fas fa-cog mr-1"></i> Sparepart
                            </span>
                            @endif
                            @if($item['is_additional'])
                            <span class="ml-1 inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium bg-amber-100 dark:bg-amber-900/30 text-amber-700 dark:text-amber-300">
                                Tambahan
                            </span>
                            @endif
                        </td>
                        <td class="px-3 py-2">
                            <div class="font-medium text-slate-900 dark:text-white">{{ $item['name'] }}</div>
                        </td>
                        <td class="px-3 py-2 text-center font-medium text-slate-900 dark:text-white">
                            {{ $item['quantity'] }}
                        </td>
                        <td class="px-3 py-2 text-center text-slate-600 dark:text-gray-400">
                            {{ $item['unit'] }}
                        </td>
                        <td class="px-3 py-2 text-center">
                            <span class="font-semibold text-indigo-600 dark:text-indigo-400">
                                {{ $item['total_needed'] }} {{ $item['unit'] }}
                            </span>
                            <div class="text-[10px] text-slate-500">({{ $item['quantity'] }} × {{ $orderQty }} unit)</div>
                        </td>
                        <td class="px-3 py-2 text-right">
                            <span class="{{ $item['stock_status'] === 'available' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }} font-medium">
                                {{ $item['current_stock'] }}
                            </span>
                        </td>
                        <td class="px-3 py-2 text-right text-slate-600 dark:text-gray-400">
                            Rp {{ number_format($item['unit_cost'], 0, ',', '.') }}
                        </td>
                        <td class="px-3 py-2 text-right font-semibold text-slate-900 dark:text-white">
                            Rp {{ number_format($item['total_cost'], 0, ',', '.') }}
                        </td>
                        <td class="px-3 py-2 text-center">
                            @if($item['stock_status'] === 'available')
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-300">
                                <i class="fas fa-check mr-1"></i> Tersedia
                            </span>
                            @else
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-100 dark:bg-red-900/30 text-red-700 dark:text-red-300">
                                <i class="fas fa-exclamation-triangle mr-1"></i> Perlu Beli
                            </span>
                            @endif
                            
                            @if($item['is_received'])
                            <div class="mt-1">
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-medium bg-emerald-100 dark:bg-emerald-900/30 text-emerald-700 dark:text-emerald-300">
                                    <i class="fas fa-check-circle mr-1"></i> Diterima
                                </span>
                            </div>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="bg-slate-100 dark:bg-gray-700">
                    <tr>
                        <td colspan="{{ $canCheckReceived ? 8 : 7 }}" class="px-3 py-2 text-right font-semibold text-slate-700 dark:text-gray-300">
                            Total Biaya:
                        </td>
                        <td class="px-3 py-2 text-right font-bold text-lg text-indigo-600 dark:text-indigo-400">
                            Rp {{ number_format($allItems->sum('total_cost'), 0, ',', '.') }}
                        </td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
        @else
        <div class="text-center py-8">
            <div class="w-16 h-16 mx-auto mb-4 bg-slate-100 dark:bg-gray-700 rounded-full flex items-center justify-center">
                <i class="fas fa-inbox text-slate-400 dark:text-gray-500 text-2xl"></i>
            </div>
            <p class="text-slate-500 dark:text-gray-400">Belum ada bahan atau sparepart yang ditambahkan.</p>
        </div>
        @endif
    </div>
</div>

{{-- Script untuk toggle checklist --}}
<script>
function toggleItemReceived(checkbox, type, id) {
    const isChecked = checkbox.checked;
    const route = type === 'material' 
        ? '{{ route("teknisi.productions.materials.toggle-received", [$production->id, "__ID__"]) }}'.replace('__ID__', id)
        : '{{ route("teknisi.productions.spareparts.toggle-received", [$production->id, "__ID__"]) }}'.replace('__ID__', id);
    
    fetch(route, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Update UI
            const row = checkbox.closest('tr');
            const statusCell = row.querySelector('td:last-child');
            
            if (data.is_received) {
                if (!statusCell.querySelector('.received-badge')) {
                    const badge = document.createElement('div');
                    badge.className = 'mt-1 received-badge';
                    badge.innerHTML = '<span class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-medium bg-emerald-100 dark:bg-emerald-900/30 text-emerald-700 dark:text-emerald-300"><i class="fas fa-check-circle mr-1"></i> Diterima</span>';
                    statusCell.appendChild(badge);
                }
            } else {
                const badge = statusCell.querySelector('.received-badge');
                if (badge) badge.remove();
            }
            
            showNotification(data.message, 'success');
        } else {
            checkbox.checked = !isChecked; // Revert
            showNotification(data.error || 'Terjadi kesalahan', 'error');
        }
    })
    .catch(error => {
        checkbox.checked = !isChecked; // Revert
        showNotification('Terjadi kesalahan jaringan', 'error');
    });
}

function confirmAllReceived() {
    if (!confirm('Konfirmasi semua item yang belum diterima?')) return;
    
    const checkboxes = document.querySelectorAll('.item-received-checkbox:not(:checked)');
    checkboxes.forEach(cb => {
        cb.checked = true;
        toggleItemReceived(cb, cb.dataset.type, cb.dataset.id);
    });
}

function showNotification(message, type) {
    const area = document.getElementById('notificationArea');
    if (!area) return;
    
    const notification = document.createElement('div');
    notification.className = `px-4 py-3 rounded-lg shadow-lg text-white text-sm font-medium transform transition-all duration-300 ${type === 'success' ? 'bg-green-500' : 'bg-red-500'}`;
    notification.innerHTML = `<i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'} mr-2"></i>${message}`;
    
    area.appendChild(notification);
    
    setTimeout(() => {
        notification.style.opacity = '0';
        setTimeout(() => notification.remove(), 300);
    }, 3000);
}
</script>

