@extends('layouts.teknisi')

@section('title', 'Produksi Saya - Teknisi')

@section('content')
<!-- Page Header -->
<div class="mb-6 sm:mb-8">
    <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white mb-2">Produksi Saya</h1>
    <p class="text-gray-600 dark:text-gray-400">Kelola semua produksi yang ditugaskan kepada Anda</p>
</div>

{{-- Notifikasi Modern --}}
@if (session('success') || session('error') || $errors->any())
    @php
        $message = session('success') ?? (session('error') ?? collect($errors->all())->join('<br>'));
        $icon = session('success') ? 'success' : 'error';
    @endphp
    @php
        $flashPayload = [
            'icon' => $icon,
            'title' => session('success') ? 'Sukses!' : 'Terjadi Kesalahan!',
            'html' => $message,
            'timer' => 4000,
            'timerProgressBar' => true,
            'showConfirmButton' => false,
            'position' => 'top-end',
        ];
    @endphp
    <div id="flashVars" data-payload='{{ e(json_encode($flashPayload)) }}' style="display:none"></div>
    <script>
        (function(){
            var el = document.getElementById('flashVars');
            if(!el) return;
            try {
                var payload = JSON.parse(el.getAttribute('data-payload'));
                Swal.fire(payload);
            } catch(err){
                console.error('Failed to parse flash payload', err);
            }
            el.remove();
        })();
    </script>
@endif

{{-- Quick Stats --}}
@php
    $totalProductions = $productions->total();
    $menungguCount = $productions->where('status', 'menunggu')->count();
    $dalamProsesCount = $productions->where('status', 'dalam_proses')->count();
    $pendingApprovalCount = $productions->where('planning_status', 'pending_approval')->count();
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide">Total Produksi</p>
                <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1">{{ $totalProductions }}</p>
            </div>
            <div class="p-3 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                <i class="fas fa-industry text-blue-600 dark:text-blue-400 text-xl"></i>
            </div>
        </div>
    </div>

    <a href="{{ route('teknisi.productions.index', ['status' => 'menunggu']) }}" 
        class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 hover:border-gray-300 dark:hover:border-gray-600 transition-all duration-200 cursor-pointer group">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide">Menunggu</p>
                <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1">{{ $menungguCount }}</p>
            </div>
            <div class="p-3 bg-gray-100 dark:bg-gray-700 rounded-lg group-hover:bg-gray-200 dark:group-hover:bg-gray-600 transition-colors">
                <i class="fas fa-pause text-gray-600 dark:text-gray-400 text-xl"></i>
            </div>
        </div>
    </a>

    <a href="{{ route('teknisi.productions.index', ['status' => 'dalam_proses']) }}" 
        class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 hover:border-gray-300 dark:hover:border-gray-600 transition-all duration-200 cursor-pointer group">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide">Dalam Proses</p>
                <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1">{{ $dalamProsesCount }}</p>
            </div>
            <div class="p-3 bg-purple-100 dark:bg-purple-900/40 rounded-lg group-hover:bg-purple-200 dark:group-hover:bg-purple-900/60 transition-colors">
                <i class="fas fa-cogs text-purple-600 dark:text-purple-400 text-xl"></i>
            </div>
        </div>
    </a>

    <a href="{{ route('teknisi.productions.index', ['planning_status' => 'pending_approval']) }}" 
        class="bg-white dark:bg-gray-800 rounded-lg border border-yellow-200 dark:border-yellow-800 p-4 border-l-4 border-l-yellow-500 hover:border-yellow-300 dark:hover:border-yellow-700 transition-all duration-200 cursor-pointer group">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide">Pending Approval</p>
                <p class="text-2xl font-bold text-yellow-600 dark:text-yellow-400 mt-1 group-hover:text-yellow-700 dark:group-hover:text-yellow-300 transition-colors">
                    {{ $pendingApprovalCount }}
                </p>
            </div>
            <div class="p-3 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg group-hover:bg-yellow-200 dark:group-hover:bg-yellow-900/60 transition-colors">
                <i class="fas fa-clock text-yellow-600 dark:text-yellow-400 text-xl"></i>
            </div>
        </div>
    </a>
</div>

<!-- Active Filters Info -->
@if (request('search') || request('status') || request('planning_status'))
    <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4">
        <div class="flex flex-wrap items-center gap-2">
            <span class="text-sm font-medium text-blue-800 dark:text-blue-200">Filter Aktif:</span>
            
            @if (request('search'))
                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-200">
                    <i class="fas fa-search mr-1"></i>
                    Pencarian: "{{ request('search') }}"
                    <button onclick="clearFilter('search')" class="ml-2 hover:text-blue-600">
                        <i class="fas fa-times"></i>
                    </button>
                </span>
            @endif
            
            @if (request('status'))
                @php
                    $statusLabels = [
                        'menunggu' => 'Menunggu',
                        'dalam_proses' => 'Dalam Proses'
                    ];
                    $statusLabel = $statusLabels[request('status')] ?? ucfirst(request('status'));
                @endphp
                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-200">
                    <i class="fas fa-filter mr-1"></i>
                    Status: {{ $statusLabel }}
                    <button onclick="clearFilter('status')" class="ml-2 hover:text-green-600">
                        <i class="fas fa-times"></i>
                    </button>
                </span>
            @endif
            
            @if (request('planning_status'))
                @php
                    $planningLabels = [
                        'planning' => 'Planning',
                        'pending_approval' => 'Pending Approval',
                        'approved' => 'Approved',
                        'rejected' => 'Rejected'
                    ];
                    $planningLabel = $planningLabels[request('planning_status')] ?? ucfirst(request('planning_status'));
                @endphp
                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800 dark:bg-purple-800 dark:text-purple-200">
                    <i class="fas fa-clipboard-check mr-1"></i>
                    Planning: {{ $planningLabel }}
                    <button onclick="clearFilter('planning_status')" class="ml-2 hover:text-purple-600">
                        <i class="fas fa-times"></i>
                    </button>
                </span>
            @endif
            
            <button onclick="clearAllFilters()" 
                class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200 hover:bg-red-200 dark:hover:bg-red-700 transition-colors">
                <i class="fas fa-times-circle mr-1"></i>
                Hapus Semua Filter
            </button>
        </div>
    </div>
    @endif

<!-- Header & Action Bar -->
<div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6 space-y-3 md:space-y-0">
    <div class="flex items-center gap-4">
        <h2 class="text-xl font-semibold text-gray-800 dark:text-white">Daftar Produksi</h2>
        <a href="{{ route('teknisi.productions.history') }}" 
           class="inline-flex items-center px-3 py-2 text-sm font-medium rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-600 transition-colors duration-200">
            <i class="fas fa-history mr-2"></i>
            History
        </a>
    </div>

    <!-- Filter & Search Form -->
    <form method="GET" action="{{ route('teknisi.productions.index') }}" id="filterForm" class="flex flex-col sm:flex-row items-stretch sm:items-center gap-2.5 w-full md:w-auto">
        <!-- Search Bar -->
        <div class="relative flex-1 sm:flex-initial sm:w-64">
            <input type="text" name="search" id="searchInput" value="{{ request('search') }}"
                        placeholder="Cari produk, customer, atau ID..."
                class="w-full pl-10 pr-4 py-2.5 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors text-sm" />
            <i class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-sm"></i>
            @if (request('search'))
                <button type="button" onclick="clearSearch()"
                    class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 hover:text-gray-600 dark:hover:text-gray-300 transition-colors">
                    <i class="fas fa-times text-sm"></i>
                </button>
                    @endif
            </div>
            
            <!-- Status Filter -->
        <div class="relative">
            <select name="status" id="statusFilter" onchange="submitFilter()" 
                class="w-full sm:w-auto pl-4 pr-10 py-2.5 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 appearance-none bg-white text-sm cursor-pointer transition-colors">
                    <option value="">Semua Status</option>
                <option value="menunggu" {{ request('status') === 'menunggu' ? 'selected' : '' }}>Menunggu</option>
                <option value="dalam_proses" {{ request('status') === 'dalam_proses' ? 'selected' : '' }}>Dalam Proses</option>
                </select>
            <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
            </div>

            <!-- Planning Status Filter -->
        <div class="relative">
            <select name="planning_status" id="planningStatusFilter" onchange="submitFilter()" 
                class="w-full sm:w-auto pl-4 pr-10 py-2.5 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 appearance-none bg-white text-sm cursor-pointer transition-colors">
                    <option value="">Semua Planning</option>
                <option value="planning" {{ request('planning_status') === 'planning' ? 'selected' : '' }}>Planning</option>
                <option value="pending_approval" {{ request('planning_status') === 'pending_approval' ? 'selected' : '' }}>Pending Approval</option>
                <option value="approved" {{ request('planning_status') === 'approved' ? 'selected' : '' }}>Approved</option>
                <option value="rejected" {{ request('planning_status') === 'rejected' ? 'selected' : '' }}>Rejected</option>
                </select>
            <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
            </div>

        <!-- Clear Filters Button -->
        @if (request('search') || request('status') || request('planning_status'))
            <button type="button" onclick="clearAllFilters()"
                class="inline-flex items-center justify-center px-3 py-2.5 text-sm font-medium rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-600 transition-colors duration-200 whitespace-nowrap">
                <i class="fas fa-times mr-1.5"></i>
                Reset
            </button>
        @endif
        </form>
    </div>

@if($productions->count() > 0)
<!-- Table Container -->
<div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-x-auto transition-colors duration-300">
            <table class="w-full">
        <thead class="bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-600">
                    <tr>
                <th class="px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300" style="width: 60px;">ID</th>
                <th class="px-5 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300" style="min-width: 200px;">Produk</th>
                <th class="px-4 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300" style="min-width: 150px;">Customer</th>
                <th class="px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300" style="width: 80px;">Qty</th>
                <th class="px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300" style="width: 120px;">Status</th>
                <th class="px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300" style="width: 130px;">Planning</th>
                <th class="px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300" style="width: 140px;">Bahan/Sparepart</th>
                <th class="px-4 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300" style="width: 120px;">Ditugaskan</th>
                <th class="px-5 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300" style="width: 100px;">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @foreach($productions as $production)
            <tr class="hover:bg-blue-50/50 dark:hover:bg-gray-700/80 transition-colors duration-200 {{ $production->has_unread_notification ?? false ? 'bg-blue-50/50 dark:bg-blue-900/20 border-l-4 border-l-blue-500 shadow-sm' : '' }}">
                <td class="px-4 py-4 text-center align-middle">
                    <div class="relative w-10 h-10 bg-gradient-to-br from-indigo-400 to-indigo-600 rounded-lg flex items-center justify-center text-white font-bold text-sm mx-auto">
                                    #{{ $production->id }}
                            @if($production->has_unread_notification ?? false)
                                <span class="absolute -top-1 -right-1 w-4 h-4 bg-red-500 rounded-full border-2 border-white dark:border-gray-800 flex items-center justify-center animate-pulse" title="Ada notifikasi baru">
                                    <span class="w-2 h-2 bg-white rounded-full"></span>
                                </span>
                            @endif
                            </div>
                        </td>
                <td class="px-5 py-4 align-middle">
                    <div class="flex items-center space-x-3">
                        <div class="flex-shrink-0 w-10 h-10 bg-blue-100 dark:bg-blue-900 rounded-lg flex items-center justify-center relative">
                                    <i class="fas fa-box text-blue-600 dark:text-blue-400"></i>
                            @if($production->has_unread_notification ?? false)
                                <span class="absolute -top-1 -right-1 w-3 h-3 bg-red-500 rounded-full border-2 border-white dark:border-gray-800 animate-pulse" title="Ada notifikasi baru"></span>
                            @endif
                                </div>
                                <div class="min-w-0 flex-1">
                                    <div class="flex items-center gap-2">
                                        <div class="text-sm font-semibold text-gray-900 dark:text-white truncate">
                                            {{ $production->product->product_title ?? 'N/A' }}
                                        </div>
                                        @if($production->has_unread_notification ?? false)
                                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-red-100 dark:bg-red-900/40 text-red-800 dark:text-red-300 animate-pulse" title="Ada notifikasi baru">
                                                <i class="fas fa-bell text-xs mr-1"></i>
                                                Baru
                                            </span>
                                        @endif
                                    </div>
                                    @if($production->notes)
                                        <div class="text-xs text-gray-500 dark:text-gray-400 truncate mt-0.5">
                                    <i class="fas fa-sticky-note mr-1"></i>{{ Str::limit($production->notes, 40) }}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </td>
                <td class="px-4 py-4 align-middle">
                            <div class="text-sm text-gray-900 dark:text-white">{{ $production->order->customer_name ?? 'N/A' }}</div>
                    @if($production->order->customer_email)
                        <div class="text-xs text-gray-500 dark:text-gray-400">{{ $production->order->customer_email }}</div>
                    @endif
                        </td>
                <td class="px-4 py-4 text-center align-middle">
                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-purple-100 dark:bg-purple-900/40 text-purple-800 dark:text-purple-300">
                                {{ $production->quantity }} unit
                            </span>
                        </td>
                <td class="px-4 py-4 text-center align-middle">
                    @php
                        $statusConfig = [
                            'menunggu' => [
                                'bg' => 'bg-gray-100 dark:bg-gray-700',
                                'text' => 'text-gray-700 dark:text-gray-300',
                                'icon' => 'fa-pause',
                                'label' => 'Menunggu'
                            ],
                            'dalam_proses' => [
                                'bg' => 'bg-purple-100 dark:bg-purple-900/40',
                                'text' => 'text-purple-700 dark:text-purple-300',
                                'icon' => 'fa-cogs',
                                'label' => 'Proses'
                            ],
                        ];
                        $config = $statusConfig[$production->status] ?? $statusConfig['menunggu'];
                    @endphp
                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md {{ $config['bg'] }} {{ $config['text'] }}">
                        <i class="fas {{ $config['icon'] }} text-xs {{ $production->status === 'dalam_proses' ? 'animate-spin' : '' }}"></i>
                        <span>{{ $config['label'] }}</span>
                                </span>
                        </td>
                <td class="px-4 py-4 text-center align-middle">
                            @if($production->planning_status === 'planning')
                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-blue-100 dark:bg-blue-900/40 text-blue-800 dark:text-blue-300">
                            <i class="fas fa-edit text-xs"></i>
                            <span>Planning</span>
                                </span>
                            @elseif($production->planning_status === 'pending_approval')
                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-yellow-100 dark:bg-yellow-900/40 text-yellow-800 dark:text-yellow-300">
                            <i class="fas fa-clock text-xs"></i>
                            <span>Pending</span>
                                </span>
                            @elseif($production->planning_status === 'approved')
                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-300">
                            <i class="fas fa-check-circle text-xs"></i>
                            <span>Approved</span>
                                </span>
                            @elseif($production->planning_status === 'rejected')
                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-red-100 dark:bg-red-900/40 text-red-800 dark:text-red-300">
                            <i class="fas fa-times-circle text-xs"></i>
                            <span>Rejected</span>
                                </span>
                            @endif
                        </td>
                <td class="px-4 py-4 text-center align-middle">
                            <div class="flex flex-col gap-1 items-center">
                                @if($production->materials_status === 'received')
                            <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded-md bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300">
                                <i class="fas fa-check text-xs"></i>
                                <span>Bahan</span>
                                    </span>
                                @elseif($production->materials_status === 'preparing')
                            <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded-md bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300">
                                <i class="fas fa-box text-xs"></i>
                                <span>Bahan</span>
                                    </span>
                                @elseif($production->materials_status === 'pending')
                            <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded-md bg-yellow-100 dark:bg-yellow-900/40 text-yellow-700 dark:text-yellow-300">
                                <i class="fas fa-clock text-xs"></i>
                                <span>Bahan</span>
                                    </span>
                                @endif
                                
                                @if($production->spareparts_status === 'received')
                            <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded-md bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300">
                                <i class="fas fa-check text-xs"></i>
                                <span>Sparepart</span>
                                    </span>
                                @elseif($production->spareparts_status === 'preparing')
                            <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded-md bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300">
                                <i class="fas fa-cog text-xs"></i>
                                <span>Sparepart</span>
                                    </span>
                                @elseif($production->spareparts_status === 'pending')
                            <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded-md bg-yellow-100 dark:bg-yellow-900/40 text-yellow-700 dark:text-yellow-300">
                                <i class="fas fa-clock text-xs"></i>
                                <span>Sparepart</span>
                                    </span>
                                @endif
                            </div>
                        </td>
                <td class="px-4 py-4 align-middle">
                            <div class="text-sm text-gray-900 dark:text-white">
                                {{ $production->assigned_at ? $production->assigned_at->format('d/m/Y') : 'N/A' }}
                            </div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">
                                {{ $production->updated_at->diffForHumans() }}
                            </div>
                        </td>
                <td class="px-5 py-4 text-center align-middle">
                                <a href="{{ route('teknisi.productions.show', $production) }}" 
                       class="inline-flex items-center justify-center px-3 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors shadow-sm"
                       title="Kelola Produksi">
                        <i class="fas fa-clipboard-list mr-1.5"></i>
                        <span>Kelola</span>
                    </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
    </div>

    <!-- Pagination -->
    <div class="mt-4">
        {{ $productions->links() }}
    </div>
    @else
    <!-- Empty State -->
    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-200 dark:border-gray-700 p-12">
        <div class="text-center">
            <div class="mx-auto w-24 h-24 bg-gradient-to-br from-blue-100 to-blue-200 dark:from-blue-900 dark:to-blue-800 rounded-full flex items-center justify-center mb-6">
                <i class="fas fa-cogs text-4xl text-blue-600 dark:text-blue-300"></i>
            </div>
            <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Belum Ada Produksi</h3>
            <p class="text-gray-600 dark:text-gray-400 max-w-md mx-auto mb-6">
                @if(request()->anyFilled(['search', 'status', 'planning_status']))
                    Tidak ada produksi yang sesuai dengan filter Anda.
                @else
                    Anda belum ditugaskan untuk produksi apapun. Admin akan menugaskan produksi kepada Anda ketika ada order yang memerlukan produksi.
                @endif
            </p>
            @if(request()->anyFilled(['search', 'status', 'planning_status']))
                <a href="{{ route('teknisi.productions.index') }}" 
                   class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg">
                    <i class="fas fa-redo mr-2"></i>Reset Filter
                </a>
            @endif
        </div>
    </div>
    @endif

@push('scripts')
<script>
// Submit filter dengan parameter yang bersih
function submitFilter() {
    const params = new URLSearchParams();
    
    // Ambil nilai dari setiap input/select
    const search = document.getElementById('searchInput')?.value?.trim() || '';
    const status = document.getElementById('statusFilter')?.value || '';
    const planningStatus = document.getElementById('planningStatusFilter')?.value || '';
    
    // Hanya tambahkan parameter yang memiliki nilai
    if (search) {
        params.append('search', search);
    }
    if (status) {
        params.append('status', status);
    }
    if (planningStatus) {
        params.append('planning_status', planningStatus);
    }
    
    // Redirect dengan parameter yang bersih
    const url = '{{ route("teknisi.productions.index") }}' + (params.toString() ? '?' + params.toString() : '');
    window.location.href = url;
                }
                
// Clear individual filter
function clearFilter(filterName) {
    const url = new URL(window.location);
    url.searchParams.delete(filterName);
    window.location.href = url.toString();
}

// Clear search
function clearSearch() {
    clearFilter('search');
                        }

// Clear all filters
function clearAllFilters() {
    window.location.href = '{{ route("teknisi.productions.index") }}';
    }
    
// Submit form search dengan Enter
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    if (searchInput) {
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                submitFilter();
    }
        });
    }
});
</script>
@endpush

@endsection
