<!-- Status Summaries Section -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-4 lg:gap-6 mb-6">
    <!-- Planning Status Summary -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-clipboard-list text-blue-600 dark:text-blue-400 mr-2"></i>
                Status Planning
            </h3>
            <a href="{{ route('teknisi.productions.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="grid grid-cols-2 gap-3">
            <div class="p-4 bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-900/20 dark:to-blue-900/10 rounded-lg border border-blue-200 dark:border-blue-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-blue-700 dark:text-blue-300 uppercase tracking-wide">Planning</p>
                    <i class="fas fa-edit text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-blue-900 dark:text-blue-200">{{ $stats['production_status_summary']['planning'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-yellow-50 to-yellow-100 dark:from-yellow-900/20 dark:to-yellow-900/10 rounded-lg border border-yellow-200 dark:border-yellow-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-yellow-700 dark:text-yellow-300 uppercase tracking-wide">Pending Approval</p>
                    <i class="fas fa-clock text-yellow-600 dark:text-yellow-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-yellow-900 dark:text-yellow-200">{{ $stats['production_status_summary']['pending_approval'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg border border-green-200 dark:border-green-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-green-700 dark:text-green-300 uppercase tracking-wide">Approved</p>
                    <i class="fas fa-check-circle text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-green-900 dark:text-green-200">{{ $stats['production_status_summary']['approved'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-red-50 to-red-100 dark:from-red-900/20 dark:to-red-900/10 rounded-lg border border-red-200 dark:border-red-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-red-700 dark:text-red-300 uppercase tracking-wide">Rejected</p>
                    <i class="fas fa-times-circle text-red-600 dark:text-red-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-red-900 dark:text-red-200">{{ $stats['production_status_summary']['rejected'] ?? 0 }}</p>
            </div>
        </div>
    </div>

    <!-- Completion Status Summary -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-check-double text-indigo-600 dark:text-indigo-400 mr-2"></i>
                Status Completion
            </h3>
            <a href="{{ route('teknisi.productions.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="grid grid-cols-2 gap-3">
            <div class="p-4 bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-700/50 dark:to-gray-700/30 rounded-lg border border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wide">Pending</p>
                    <i class="fas fa-hourglass-half text-gray-600 dark:text-gray-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $stats['completion_status_summary']['pending'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-yellow-50 to-yellow-100 dark:from-yellow-900/20 dark:to-yellow-900/10 rounded-lg border border-yellow-200 dark:border-yellow-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-yellow-700 dark:text-yellow-300 uppercase tracking-wide">Pending Approval</p>
                    <i class="fas fa-clock text-yellow-600 dark:text-yellow-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-yellow-900 dark:text-yellow-200">{{ $stats['completion_status_summary']['pending_approval'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg border border-green-200 dark:border-green-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-green-700 dark:text-green-300 uppercase tracking-wide">Approved</p>
                    <i class="fas fa-check-circle text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-green-900 dark:text-green-200">{{ $stats['completion_status_summary']['approved'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-red-50 to-red-100 dark:from-red-900/20 dark:to-red-900/10 rounded-lg border border-red-200 dark:border-red-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-red-700 dark:text-red-300 uppercase tracking-wide">Rejected</p>
                    <i class="fas fa-times-circle text-red-600 dark:text-red-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-red-900 dark:text-red-200">{{ $stats['completion_status_summary']['rejected'] ?? 0 }}</p>
            </div>
        </div>
    </div>
</div>

<!-- Production Status Summary -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-4 lg:gap-6 mb-6">
    <!-- Production Status -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-industry text-indigo-600 dark:text-indigo-400 mr-2"></i>
                Status Produksi
            </h3>
            <a href="{{ route('teknisi.productions.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="grid grid-cols-3 gap-3">
            <div class="p-4 bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-700/50 dark:to-gray-700/30 rounded-lg border border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wide">Menunggu</p>
                    <i class="fas fa-hourglass-half text-gray-600 dark:text-gray-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $stats['production_status_count']['menunggu'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-indigo-50 to-indigo-100 dark:from-indigo-900/20 dark:to-indigo-900/10 rounded-lg border border-indigo-200 dark:border-indigo-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-indigo-700 dark:text-indigo-300 uppercase tracking-wide">Dalam Proses</p>
                    <i class="fas fa-cog text-indigo-600 dark:text-indigo-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-indigo-900 dark:text-indigo-200">{{ $stats['production_status_count']['dalam_proses'] ?? 0 }}</p>
            </div>
            <div class="p-4 bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg border border-green-200 dark:border-green-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-green-700 dark:text-green-300 uppercase tracking-wide">Selesai</p>
                    <i class="fas fa-check-circle text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-green-900 dark:text-green-200">{{ $stats['production_status_count']['selesai'] ?? 0 }}</p>
            </div>
        </div>
    </div>

    <!-- Stock Status Summary -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-5">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-warehouse text-teal-600 dark:text-teal-400 mr-2"></i>
                Status Stock
            </h3>
            <a href="{{ route('teknisi.materials.index') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium">
                Lihat Semua <i class="fas fa-arrow-right ml-1 text-xs"></i>
            </a>
        </div>
        <div class="grid grid-cols-2 gap-3">
            <div class="p-4 bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-900/10 rounded-lg border border-green-200 dark:border-green-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-green-700 dark:text-green-300 uppercase tracking-wide">Materials</p>
                    <i class="fas fa-box text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-green-900 dark:text-green-200">
                    @if(($stats['low_stock_materials'] ?? 0) > 0)
                        <span class="text-red-600 dark:text-red-400">{{ $stats['low_stock_materials'] ?? 0 }}</span>
                    @else
                        <span class="text-green-600 dark:text-green-400">Aman</span>
                    @endif
                </p>
                <p class="text-xs text-green-600 dark:text-green-400 mt-1">
                    @if(($stats['low_stock_materials'] ?? 0) > 0)
                        Stock kurang
                    @else
                        Stock aman
                    @endif
                </p>
            </div>
            <div class="p-4 bg-gradient-to-br from-purple-50 to-purple-100 dark:from-purple-900/20 dark:to-purple-900/10 rounded-lg border border-purple-200 dark:border-purple-800">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-xs font-semibold text-purple-700 dark:text-purple-300 uppercase tracking-wide">Spareparts</p>
                    <i class="fas fa-tools text-purple-600 dark:text-purple-400 text-sm"></i>
                </div>
                <p class="text-2xl font-bold text-purple-900 dark:text-purple-200">
                    @if(($stats['low_stock_spareparts'] ?? 0) > 0)
                        <span class="text-red-600 dark:text-red-400">{{ $stats['low_stock_spareparts'] ?? 0 }}</span>
                    @else
                        <span class="text-purple-600 dark:text-purple-400">Aman</span>
                    @endif
                </p>
                <p class="text-xs text-purple-600 dark:text-purple-400 mt-1">
                    @if(($stats['low_stock_spareparts'] ?? 0) > 0)
                        Stock kurang
                    @else
                        Stock aman
                    @endif
                </p>
            </div>
        </div>
    </div>
</div>

