@extends('layouts.supervisor')

@section('title', 'Laporan Pembelian - Supervisor')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Laporan Pembelian</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    Analisis dan monitoring data pembelian bahan dan sparepart
                    @if(request('start_date') || request('end_date'))
                        | Periode: 
                        {{ request('start_date') ? \Carbon\Carbon::parse(request('start_date'))->format('d M Y') : 'Awal' }} - 
                        {{ request('end_date') ? \Carbon\Carbon::parse(request('end_date'))->format('d M Y') : 'Akhir' }}
                    @endif
                </p>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Pembelian</p>
                    <h2 class="text-xl font-bold text-indigo-600 dark:text-indigo-400">Rp {{ number_format($totalAmount, 0, ',', '.') }}</h2>
                </div>
                <div class="p-2.5 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg">
                    <i class="fas fa-money-bill-wave text-indigo-600 dark:text-indigo-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Transaksi</p>
                    <h2 class="text-xl font-bold text-emerald-600 dark:text-emerald-400">{{ number_format($totalTransactions, 0, ',', '.') }}</h2>
                </div>
                <div class="p-2.5 bg-emerald-100 dark:bg-emerald-900/40 rounded-lg">
                    <i class="fas fa-shopping-cart text-emerald-600 dark:text-emerald-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Item</p>
                    <h2 class="text-xl font-bold text-cyan-600 dark:text-cyan-400">{{ number_format($totalItems, 0, ',', '.') }} unit</h2>
                </div>
                <div class="p-2.5 bg-cyan-100 dark:bg-cyan-900/40 rounded-lg">
                    <i class="fas fa-boxes text-cyan-600 dark:text-cyan-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Rata-rata/Transaksi</p>
                    <h2 class="text-xl font-bold text-amber-600 dark:text-amber-400">Rp {{ $totalTransactions > 0 ? number_format($totalAmount / $totalTransactions, 0, ',', '.') : '0' }}</h2>
                </div>
                <div class="p-2.5 bg-amber-100 dark:bg-amber-900/40 rounded-lg">
                    <i class="fas fa-chart-line text-amber-600 dark:text-amber-400 text-lg"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-4">
        <form method="GET" action="{{ route('supervisor.reports.purchases') }}" id="filterForm" class="space-y-4">
            <!-- Search Bar -->
            <div class="relative flex-1">
                <input type="text" name="supplier" id="supplierInput" value="{{ request('supplier') }}" placeholder="Cari nama supplier..."
                    class="form-input-search" />
                <i class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                @if (request('supplier'))
                    <button type="button" onclick="clearFilter('supplier')"
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 hover:text-gray-600 dark:hover:text-gray-300">
                        <i class="fas fa-times"></i>
                    </button>
                @endif
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                <div class="relative">
                    <input type="date" name="start_date" id="startDateInput" value="{{ request('start_date') }}" onchange="submitFilter()"
                        class="w-full pl-10 pr-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200 text-sm h-10"
                        placeholder="Tanggal Mulai">
                    <i class="fas fa-calendar-alt absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                </div>

                <div class="relative">
                    <input type="date" name="end_date" id="endDateInput" value="{{ request('end_date') }}" onchange="submitFilter()"
                        class="w-full pl-10 pr-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200 text-sm h-10"
                        placeholder="Tanggal Akhir">
                    <i class="fas fa-calendar-alt absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                </div>

                <div class="relative">
                    <select name="purchase_type" id="purchaseTypeFilter" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Tipe</option>
                        <option value="material" {{ request('purchase_type') == 'material' ? 'selected' : '' }}>Bahan</option>
                        <option value="sparepart" {{ request('purchase_type') == 'sparepart' ? 'selected' : '' }}>Sparepart</option>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <div class="flex items-center gap-2">
                    <button type="button" onclick="submitFilter()" class="flex-1 flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 h-10 text-sm">
                        <i class="fas fa-search mr-2 text-xs"></i>
                        Filter
                    </button>
                    @if (request()->hasAny(['start_date', 'end_date', 'supplier', 'purchase_type']))
                        <button type="button" onclick="clearAllFilters()" 
                           class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                           title="Reset filter">
                            <i class="fas fa-redo text-sm"></i>
                        </button>
                    @endif
                </div>
            </div>
        </form>
    </div>

    <!-- Active Filters Info -->
    @if (request()->hasAny(['start_date', 'end_date', 'supplier', 'purchase_type']))
        <div class="mb-4 bg-emerald-50 dark:bg-emerald-900/20 border border-emerald-200 dark:border-emerald-700 rounded-lg p-4">
            <div class="flex flex-wrap items-center gap-2">
                <span class="text-sm font-medium text-emerald-800 dark:text-emerald-200">Filter Aktif:</span>
                
                @if (request('supplier'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-emerald-100 text-emerald-800 dark:bg-emerald-800 dark:text-emerald-200">
                        <i class="fas fa-search mr-1"></i>
                        Supplier: "{{ request('supplier') }}"
                        <button onclick="clearFilter('supplier')" class="ml-2 hover:text-emerald-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                @if (request('start_date') || request('end_date'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800 dark:bg-orange-800 dark:text-orange-200">
                        <i class="fas fa-calendar-alt mr-1"></i>
                        Periode: {{ request('start_date') ? date('d M Y', strtotime(request('start_date'))) : 'Awal' }} - {{ request('end_date') ? date('d M Y', strtotime(request('end_date'))) : 'Akhir' }}
                        <button onclick="clearDateFilter()" class="ml-2 hover:text-orange-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                @if (request('purchase_type'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-200">
                        <i class="fas fa-tag mr-1"></i>
                        Tipe: {{ ucfirst(request('purchase_type')) }}
                        <button onclick="clearFilter('purchase_type')" class="ml-2 hover:text-blue-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                <button onclick="clearAllFilters()" 
                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200 hover:bg-red-200 dark:hover:bg-red-700 transition-colors">
                    <i class="fas fa-times-circle mr-1"></i>
                    Hapus Semua Filter
                </button>
            </div>
        </div>
    @endif

    <!-- Data Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
            <div class="flex items-center">
                <div class="p-2 bg-emerald-100 dark:bg-emerald-900/40 rounded-lg mr-2">
                    <i class="fas fa-table text-emerald-600 dark:text-emerald-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Data Pembelian</h3>
            </div>
        </div>
        <div class="overflow-x-auto custom-scrollbar">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Tanggal</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Kode Pembelian</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Supplier</th>
                        <th class="px-6 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Tipe</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Item Dibeli</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Total Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse($purchases as $purchase)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">{{ $purchase->purchase_date ? $purchase->purchase_date->format('d/m/Y') : '-' }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">{{ $purchase->purchase_code ?? '#' . $purchase->id }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">{{ $purchase->supplier_name ?? '-' }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium border
                                    @if(strtolower($purchase->purchase_type ?? '') === 'material' || strtolower($purchase->purchase_type ?? '') === 'bahan')
                                        bg-emerald-100 text-emerald-700 border-emerald-300 dark:bg-emerald-900/30 dark:text-emerald-300
                                    @elseif(strtolower($purchase->purchase_type ?? '') === 'sparepart' || strtolower($purchase->purchase_type ?? '') === 'spare part')
                                        bg-blue-100 text-blue-700 border-blue-300 dark:bg-blue-900/30 dark:text-blue-300
                                    @else
                                        bg-gray-100 text-gray-700 border-gray-300 dark:bg-gray-700 dark:text-gray-300
                                    @endif">
                                    {{ ucfirst($purchase->purchase_type ?? '-') }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-white">
                                @if($purchase->items && $purchase->items->count() > 0)
                                    <div class="space-y-1">
                                        @foreach($purchase->items->take(3) as $item)
                                            <div class="text-xs">
                                                <span class="font-medium">{{ $item->name ?? $item->item_name ?? '-' }}</span>
                                                <span class="text-gray-500">({{ $item->quantity }} {{ $item->unit ?? 'pcs' }})</span>
                                            </div>
                                        @endforeach
                                        @if($purchase->items->count() > 3)
                                            <div class="text-xs text-gray-500">+{{ $purchase->items->count() - 3 }} item lainnya</div>
                                        @endif
                                    </div>
                                @else
                                    <span class="text-gray-400">-</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-right font-semibold text-gray-900 dark:text-white">
                                Rp {{ number_format($purchase->total_amount, 0, ',', '.') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium
                                    @if($purchase->status === 'approved') bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300
                                    @elseif($purchase->status === 'pending') bg-yellow-100 dark:bg-yellow-900/40 text-yellow-700 dark:text-yellow-300
                                    @elseif($purchase->status === 'rejected') bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300
                                    @else bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 @endif">
                                    {{ ucfirst($purchase->status ?? '-') }}
                                </span>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3">
                                        <i class="fas fa-inbox text-3xl text-gray-400 dark:text-gray-500"></i>
                                    </div>
                                    <p class="text-gray-500 dark:text-gray-400 font-medium mb-1">Tidak ada data pembelian</p>
                                    <p class="text-gray-400 dark:text-gray-500 text-sm">Belum ada data pembelian yang ditemukan.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    @if ($purchases->hasPages())
        <div class="mt-6 flex justify-center">
            {{ $purchases->onEachSide(1)->links() }}
        </div>
    @endif
</div>

<script>
    function submitFilter() {
        const params = new URLSearchParams();
        
        const supplier = document.getElementById('supplierInput')?.value?.trim() || '';
        const startDate = document.getElementById('startDateInput')?.value || '';
        const endDate = document.getElementById('endDateInput')?.value || '';
        const purchaseType = document.getElementById('purchaseTypeFilter')?.value || '';
        
        if (supplier) {
            params.append('supplier', supplier);
        }
        if (startDate) {
            params.append('start_date', startDate);
        }
        if (endDate) {
            params.append('end_date', endDate);
        }
        if (purchaseType) {
            params.append('purchase_type', purchaseType);
        }
        
        const url = '{{ route("supervisor.reports.purchases") }}' + (params.toString() ? '?' + params.toString() : '');
        window.location.href = url;
    }

    function clearFilter(filterName) {
        const url = new URL(window.location);
        url.searchParams.delete(filterName);
        window.location.href = url.toString();
    }

    function clearDateFilter() {
        const url = new URL(window.location);
        url.searchParams.delete('start_date');
        url.searchParams.delete('end_date');
        window.location.href = url.toString();
    }

    function clearAllFilters() {
        window.location.href = '{{ route("supervisor.reports.purchases") }}';
    }
</script>

<style>
    .form-input-search,
    .form-select {
        height: 40px !important;
        min-height: 40px !important;
        max-height: 40px !important;
        box-sizing: border-box !important;
        line-height: 1.5 !important;
        padding: 0 2.5rem 0 2.5rem !important;
        margin: 0 !important;
    }
    
    .form-input-search {
        width: 100%;
        padding-left: 2.5rem !important;
        padding-right: 2.5rem !important;
        border: 1px solid rgb(209 213 219);
        border-radius: 0.5rem;
        background-color: white;
        color: rgb(17 24 39);
        font-size: 0.875rem;
        transition: all 0.2s;
    }
    
    .dark .form-input-search {
        border-color: rgb(75 85 99);
        background-color: rgb(55 65 81);
        color: white;
    }
    
    .form-input-search:focus {
        outline: none;
        ring: 2px;
        ring-color: rgb(59 130 246);
    }
    
    .form-select {
        width: 100%;
        padding-left: 1rem !important;
        padding-right: 2.5rem !important;
        border: 1px solid rgb(209 213 219);
        border-radius: 0.5rem;
        background-color: white;
        color: rgb(17 24 39);
        font-size: 0.875rem;
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        transition: all 0.2s;
    }
    
    .dark .form-select {
        border-color: rgb(75 85 99);
        background-color: rgb(55 65 81);
        color: white;
    }
    
    .form-select:focus {
        outline: none;
        ring: 2px;
        ring-color: rgb(59 130 246);
    }
</style>
@endsection

