@extends('layouts.supervisor')

@section('title', 'Persetujuan Planning - Supervisor')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white">Persetujuan Planning</h1>
            <p class="text-sm sm:text-base text-gray-600 dark:text-gray-400 mt-1">Review dan setujui planning produksi dari teknisi</p>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide">Menunggu Persetujuan</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1">{{ $pendingPlanning->count() }}</p>
                </div>
                <div class="p-3 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-clipboard-list text-blue-600 dark:text-blue-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-red-200 dark:border-red-800 p-4 border-l-4 border-l-red-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide">Terlambat > 24 Jam</p>
                    <p class="text-2xl font-bold text-red-600 dark:text-red-400 mt-1">{{ $pendingPlanningOverdue->count() }}</p>
                </div>
                <div class="p-3 bg-red-100 dark:bg-red-900/40 rounded-lg">
                    <i class="fas fa-exclamation-triangle text-red-600 dark:text-red-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-amber-200 dark:border-amber-800 p-4 border-l-4 border-l-amber-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide">Melewati Estimasi</p>
                    <p class="text-2xl font-bold text-amber-600 dark:text-amber-400 mt-1">{{ $overdueProductions->count() }}</p>
                </div>
                <div class="p-3 bg-amber-100 dark:bg-amber-900/40 rounded-lg">
                    <i class="fas fa-clock text-amber-600 dark:text-amber-400 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Alert: Planning Pending > 24 Jam -->
    @if($pendingPlanningOverdue->count() > 0)
    <div class="bg-red-50 dark:bg-red-900/20 border-l-4 border-red-500 p-4 rounded-r-lg">
        <div class="flex items-start gap-3">
            <div class="w-8 h-8 bg-red-100 dark:bg-red-900/40 rounded-full flex items-center justify-center flex-shrink-0">
                <i class="fas fa-exclamation-triangle text-red-600 dark:text-red-400"></i>
            </div>
            <div class="flex-1">
                <h3 class="text-sm font-semibold text-red-800 dark:text-red-200 mb-1">
                    Peringatan: {{ $pendingPlanningOverdue->count() }} Planning Menunggu Lebih dari 24 Jam
                </h3>
                <p class="text-sm text-red-700 dark:text-red-300 mb-2">
                    Terdapat planning yang sudah menunggu persetujuan lebih dari 24 jam. Mohon segera ditinjau.
                </p>
                <div class="flex flex-wrap gap-2">
                    @foreach($pendingPlanningOverdue->take(5) as $overdue)
                    <a href="{{ route('supervisor.productions.show', $overdue) }}" 
                       class="text-xs text-red-600 dark:text-red-400 hover:text-red-800 dark:hover:text-red-200 underline">
                        #{{ $overdue->id }} ({{ $overdue->submitted_at->diffForHumans() }})
                    </a>
                    @endforeach
                    @if($pendingPlanningOverdue->count() > 5)
                    <span class="text-xs text-red-600 dark:text-red-400">dan {{ $pendingPlanningOverdue->count() - 5 }} lainnya...</span>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Alert: Produksi Melewati Estimasi -->
    @if($overdueProductions->count() > 0)
    <div class="bg-amber-50 dark:bg-amber-900/20 border-l-4 border-amber-500 p-4 rounded-r-lg">
        <div class="flex items-start gap-3">
            <div class="w-8 h-8 bg-amber-100 dark:bg-amber-900/40 rounded-full flex items-center justify-center flex-shrink-0">
                <i class="fas fa-clock text-amber-600 dark:text-amber-400"></i>
            </div>
            <div class="flex-1">
                <h3 class="text-sm font-semibold text-amber-800 dark:text-amber-200 mb-1">
                    Peringatan: {{ $overdueProductions->count() }} Produksi Melewati Estimasi
                </h3>
                <p class="text-sm text-amber-700 dark:text-amber-300 mb-2">
                    Terdapat produksi yang sudah melewati estimasi waktu selesai. Mohon ditinjau.
                </p>
                <div class="flex flex-wrap gap-2">
                    @foreach($overdueProductions->take(5) as $overdue)
                    <a href="{{ route('supervisor.productions.show', $overdue) }}" 
                       class="text-xs text-amber-600 dark:text-amber-400 hover:text-amber-800 dark:hover:text-amber-200 underline">
                        #{{ $overdue->id }} - {{ Str::limit($overdue->product->product_title ?? 'N/A', 20) }}
                    </a>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Pending Planning Table -->
    @if($pendingPlanning->count() > 0)
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
        <div class="px-6 py-4 bg-gradient-to-r from-blue-50 to-indigo-50 dark:from-gray-700 dark:to-gray-700 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center gap-2.5">
                <div class="w-9 h-9 bg-blue-100 dark:bg-blue-900/30 rounded-lg flex items-center justify-center">
                    <i class="fas fa-clipboard-list text-blue-600 dark:text-blue-400"></i>
                </div>
                Menunggu Persetujuan Planning
                <span class="ml-auto px-3 py-1 bg-blue-600 text-white text-xs font-bold rounded-full">{{ $pendingPlanning->count() }}</span>
            </h2>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">ID</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Produk</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Pesanan</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Teknisi</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Total Biaya</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Diajukan</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                @foreach($pendingPlanning as $production)
                @php
                    $orderQty = $production->quantity ?? $production->order->quantity ?? 1;
                    $materialTotal = $production->total_material_cost ?? 0;
                    $sparepartTotal = $production->total_sparepart_cost ?? 0;
                    $directTotal = $materialTotal + $sparepartTotal;
                    $laborTotal = $production->labor_cost ?? 0;
                    $actualTotal = $directTotal + $laborTotal;
                    $isOverdue = $production->submitted_at && $production->submitted_at->lt(now()->subDay());
                @endphp
                    <tr class="hover:bg-gray-50/50 dark:hover:bg-gray-700/30 transition-colors {{ $isOverdue ? 'bg-red-50/30 dark:bg-red-900/10' : '' }}">
                        <td class="px-4 py-3">
                            <div class="flex items-center gap-2">
                                <span class="font-bold text-gray-900 dark:text-white">#{{ $production->id }}</span>
                                @if($isOverdue)
                                <span class="px-1.5 py-0.5 text-[10px] font-bold bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300 rounded">
                                    TERLAMBAT
                                </span>
                                @endif
                            </div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="font-medium text-gray-900 dark:text-white text-sm">
                                {{ Str::limit($production->product->product_title ?? 'N/A', 30) }}
                            </div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">{{ $orderQty }} unit</div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-sm text-gray-900 dark:text-white">#{{ $production->order->id ?? 'N/A' }}</div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">{{ Str::limit($production->order->customer_name ?? 'N/A', 15) }}</div>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-sm text-gray-900 dark:text-white">{{ Str::limit($production->teknisi->name ?? 'N/A', 18) }}</div>
                        </td>
                        <td class="px-4 py-3 text-center">
                            <div class="text-sm font-semibold text-gray-900 dark:text-white">Rp {{ number_format($actualTotal, 0, ',', '.') }}</div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">{{ $production->productionMaterials->count() + $production->productionSpareparts->count() }} item</div>
                        </td>
                        <td class="px-4 py-3 text-center">
                            <div class="text-xs text-gray-600 dark:text-gray-400">{{ $production->submitted_at?->format('d/m/Y') ?? '-' }}</div>
                            @if($production->submitted_at)
                            <div class="text-xs text-gray-400 dark:text-gray-500">{{ $production->submitted_at->diffForHumans() }}</div>
                            @endif
                        </td>
                        <td class="px-4 py-3">
                            <div class="flex justify-center items-center gap-2">
                                <a href="{{ route('supervisor.productions.show', $production->id) }}" 
                                   class="w-9 h-9 flex items-center justify-center text-blue-600 bg-blue-50 dark:bg-blue-900/30 hover:bg-blue-100 dark:hover:bg-blue-900/50 rounded-lg transition-colors border border-blue-200 dark:border-blue-700"
                                   title="Lihat Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <button type="button" data-id="{{ $production->id }}" onclick="approveProductionFromBtn(this)"
                                        class="w-9 h-9 flex items-center justify-center bg-green-500 hover:bg-green-600 text-white rounded-lg transition-colors shadow-sm"
                                        title="Setujui">
                                    <i class="fas fa-check"></i>
                                </button>
                                <button type="button" data-id="{{ $production->id }}" onclick="rejectProductionFromBtn(this)"
                                        class="w-9 h-9 flex items-center justify-center bg-orange-500 hover:bg-orange-600 text-white rounded-lg transition-colors shadow-sm"
                                        title="Revisi">
                                    <i class="fas fa-undo"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @else
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-8 text-center">
        <div class="w-14 h-14 bg-emerald-100 dark:bg-emerald-900/30 rounded-full flex items-center justify-center mx-auto mb-3">
            <i class="fas fa-clipboard-check text-2xl text-emerald-500 dark:text-emerald-400"></i>
        </div>
        <h3 class="text-base font-semibold text-gray-900 dark:text-white mb-1">Tidak Ada Planning Menunggu</h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">Semua planning produksi sudah diproses</p>
    </div>
    @endif
</div>

<!-- Modal Persetujuan Planning -->
<div id="approvalModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-emerald-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-check-circle"></i> Setujui Planning
                </h3>
            </div>
            <form id="approvalForm" method="POST" class="p-6">
                @csrf
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Catatan (Opsional)</label>
                    <textarea name="feedback" rows="3" 
                        class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-emerald-500 dark:bg-gray-700 dark:text-white"
                        placeholder="Berikan catatan untuk teknisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeApprovalModal()" class="px-4 py-2 bg-gray-100 dark:bg-gray-700 hover:bg-gray-200 dark:hover:bg-gray-600 text-gray-700 dark:text-gray-300 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium">
                        <i class="fas fa-check mr-1"></i> Setujui
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Penolakan Planning -->
<div id="rejectionModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-orange-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-redo"></i> Minta Revisi Planning
                </h3>
            </div>
            <form id="rejectionForm" method="POST" class="p-6">
                @csrf
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Alasan Revisi <span class="text-red-500">*</span></label>
                    <textarea name="feedback" rows="3" required
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Jelaskan alasan mengapa perlu direvisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeRejectionModal()" class="px-4 py-2 bg-gray-100 dark:bg-gray-700 hover:bg-gray-200 dark:hover:bg-gray-600 text-gray-700 dark:text-gray-300 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium">
                        <i class="fas fa-redo mr-1"></i> Minta Revisi
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Toast notification modern
function showToast(message, type = 'success') {
    const styles = {
        success: { border: '#10b981', bg: '#ecfdf5', text: '#065f46', icon: 'check-circle', iconColor: '#10b981' },
        error: { border: '#ef4444', bg: '#fef2f2', text: '#991b1b', icon: 'times-circle', iconColor: '#ef4444' },
        warning: { border: '#f59e0b', bg: '#fffbeb', text: '#92400e', icon: 'exclamation-triangle', iconColor: '#f59e0b' },
        info: { border: '#3b82f6', bg: '#eff6ff', text: '#1e40af', icon: 'info-circle', iconColor: '#3b82f6' }
    };
    const s = styles[type] || styles.success;
    
    const toast = document.createElement('div');
    toast.style.cssText = `
        position: fixed; top: 20px; right: 20px; z-index: 9999;
        display: flex; align-items: center; gap: 12px;
        padding: 14px 20px; border-radius: 12px;
        background: ${s.bg}; border-left: 4px solid ${s.border};
        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        transform: translateX(120%); transition: transform 0.3s ease;
    `;
    toast.innerHTML = `
        <i class="fas fa-${s.icon}" style="color: ${s.iconColor}; font-size: 18px;"></i>
        <span style="color: ${s.text}; font-weight: 500; font-size: 14px;">${message}</span>
        <button onclick="this.parentElement.remove()" style="margin-left: 8px; color: ${s.text}; opacity: 0.5; cursor: pointer; background: none; border: none;">
            <i class="fas fa-times"></i>
        </button>
    `;
    document.body.appendChild(toast);
    
    requestAnimationFrame(() => { toast.style.transform = 'translateX(0)'; });
    setTimeout(() => {
        toast.style.transform = 'translateX(120%)';
        setTimeout(() => toast.remove(), 300);
    }, 3000);
}

// Planning Modal Functions
function approveProductionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('approvalForm').action = `/supervisor/productions/${id}/approve`;
    document.getElementById('approvalModal').classList.remove('hidden');
}

function rejectProductionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return; 
    document.getElementById('rejectionForm').action = `/supervisor/productions/${id}/reject`;
    document.getElementById('rejectionModal').classList.remove('hidden');
}

function closeApprovalModal() {
    document.getElementById('approvalModal').classList.add('hidden');
}

function closeRejectionModal() {
    document.getElementById('rejectionModal').classList.add('hidden');
}

// Close on backdrop click
['approvalModal', 'rejectionModal'].forEach(id => {
    const el = document.getElementById(id);
    if (el) {
        el.addEventListener('click', function(e) {
            if (e.target === this) {
                this.classList.add('hidden');
            }
        });
    }
});

// Form submission dengan notifikasi
document.querySelectorAll('#approvalForm').forEach(form => {
    form.addEventListener('submit', function() {
        setTimeout(() => showToast('Planning berhasil disetujui!', 'success'), 500);
    });
});

document.querySelectorAll('#rejectionForm').forEach(form => {
    form.addEventListener('submit', function() {
        setTimeout(() => showToast('Permintaan revisi berhasil dikirim', 'warning'), 500);
    });
});

// Show flash message if exists
@if(session('success'))
    showToast('{{ session('success') }}', 'success');
@endif
@if(session('error'))
    showToast('{{ session('error') }}', 'error');
@endif
</script>
@endsection

