{{-- 
    Tabel Gabungan Bahan & Sparepart untuk Supervisor (Read-Only)
    Variables: $production, $allItems (dari controller)
--}}

@php
    $orderQty = $production->quantity ?? $production->order->quantity ?? 1;
@endphp

<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border border-slate-200 dark:border-gray-700 overflow-hidden mb-6">
    <div class="px-4 py-3 bg-gradient-to-r from-indigo-600 to-purple-600">
        <div class="flex items-center">
            <div class="w-10 h-10 bg-white/20 rounded-lg flex items-center justify-center mr-3">
                <i class="fas fa-boxes text-white text-lg"></i>
            </div>
            <div>
                <h2 class="text-lg font-bold text-white">Daftar Bahan & Sparepart</h2>
                <p class="text-xs text-indigo-100">Total {{ $allItems->count() }} item untuk {{ $orderQty }} unit produk</p>
            </div>
        </div>
    </div>

    <div class="p-4">
        @if($allItems->count() > 0)
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-slate-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Tipe</th>
                        <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Nama Item</th>
                        <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Jumlah</th>
                        <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Satuan</th>
                        <th class="px-3 py-2 text-right text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Stok</th>
                        <th class="px-3 py-2 text-right text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Harga Satuan</th>
                        <th class="px-3 py-2 text-right text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Total Harga</th>
                        <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Status Stok</th>
                        <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300 uppercase">Diterima</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-200 dark:divide-gray-700">
                    @foreach($allItems as $item)
                    <tr class="hover:bg-slate-50 dark:hover:bg-gray-700/50 transition-colors {{ $item['is_additional'] ? 'bg-amber-50/50 dark:bg-amber-900/10' : '' }}">
                        <td class="px-3 py-2">
                            @if($item['type'] === 'material')
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-emerald-100 dark:bg-emerald-900/30 text-emerald-700 dark:text-emerald-300">
                                <i class="fas fa-box mr-1"></i> Bahan
                            </span>
                            @else
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 dark:bg-blue-900/30 text-blue-700 dark:text-blue-300">
                                <i class="fas fa-cog mr-1"></i> Sparepart
                            </span>
                            @endif
                            @if($item['is_additional'])
                            <span class="ml-1 inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium bg-amber-100 dark:bg-amber-900/30 text-amber-700 dark:text-amber-300">
                                Tambahan
                            </span>
                            @endif
                        </td>
                        <td class="px-3 py-2">
                            <div class="font-medium text-slate-900 dark:text-white">{{ $item['name'] }}</div>
                        </td>
                        <td class="px-3 py-2 text-center font-medium text-slate-900 dark:text-white">
                            {{ $item['quantity'] }}
                        </td>
                        <td class="px-3 py-2 text-center text-slate-600 dark:text-gray-400">
                            {{ $item['unit'] }}
                        </td>
                        <td class="px-3 py-2 text-right text-slate-600 dark:text-gray-400">
                            {{ $item['stock'] }}
                        </td>
                        <td class="px-3 py-2 text-right text-slate-600 dark:text-gray-400">
                            Rp {{ number_format($item['unit_cost'], 0, ',', '.') }}
                        </td>
                        <td class="px-3 py-2 text-right font-semibold text-slate-900 dark:text-white">
                            Rp {{ number_format($item['total_cost'], 0, ',', '.') }}
                        </td>
                        <td class="px-3 py-2 text-center">
                            @if($item['stock_status'] === 'tersedia' || $item['stock'] >= $item['quantity'] * $orderQty)
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-300">
                                <i class="fas fa-check-circle mr-1"></i> Tersedia
                            </span>
                            @else
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-100 dark:bg-red-900/30 text-red-700 dark:text-red-300">
                                <i class="fas fa-exclamation-circle mr-1"></i> Perlu Beli
                            </span>
                            @endif
                        </td>
                        <td class="px-3 py-2 text-center">
                            @if($item['is_received'])
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-300">
                                <i class="fas fa-check mr-1"></i> Ya
                            </span>
                            @else
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-400">
                                <i class="fas fa-clock mr-1"></i> Belum
                            </span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="bg-slate-100 dark:bg-gray-700">
                    <tr>
                        <td colspan="6" class="px-3 py-2 text-right font-semibold text-slate-700 dark:text-gray-300">Total Biaya:</td>
                        <td class="px-3 py-2 text-right font-bold text-indigo-600 dark:text-indigo-400">
                            Rp {{ number_format($allItems->sum('total_cost'), 0, ',', '.') }}
                        </td>
                        <td colspan="2"></td>
                    </tr>
                </tfoot>
            </table>
        </div>
        @else
        <div class="text-center py-8">
            <div class="mx-auto w-16 h-16 bg-slate-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3">
                <i class="fas fa-inbox text-2xl text-slate-400 dark:text-gray-500"></i>
            </div>
            <p class="text-slate-600 dark:text-gray-400 font-medium">Belum ada bahan atau sparepart</p>
        </div>
        @endif
    </div>
</div>

