@extends('layouts.supervisor')

@section('title', 'Monitoring Productions - Supervisor')

@section('content')
@php
    $totalProductions = $productions->total();
    $selesaiCount = $productions->filter(fn($p) => $p->status === 'selesai')->count();
    $dalamProsesCount = $productions->filter(fn($p) => $p->status === 'dalam_proses')->count();
    $pendingPlanningCount = $productions->filter(fn($p) => $p->planning_status === 'pending_approval')->count();
@endphp

<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white tracking-tight">Monitoring Produksi</h1>
            <p class="text-sm sm:text-base text-gray-600 dark:text-gray-400 mt-1.5">Pantau semua produksi aktif dan selesai</p>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Total Produksi</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $totalProductions }}</p>
                </div>
                <div class="p-3 bg-purple-100 dark:bg-purple-900/40 rounded-xl">
                    <i class="fas fa-industry text-purple-600 dark:text-purple-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Selesai</p>
                    <p class="text-2xl font-bold text-emerald-600 dark:text-emerald-400">{{ $selesaiCount }}</p>
                </div>
                <div class="p-3 bg-emerald-100 dark:bg-emerald-900/40 rounded-xl">
                    <i class="fas fa-check-circle text-emerald-600 dark:text-emerald-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Dalam Proses</p>
                    <p class="text-2xl font-bold text-blue-600 dark:text-blue-400">{{ $dalamProsesCount }}</p>
                </div>
                <div class="p-3 bg-blue-100 dark:bg-blue-900/40 rounded-xl">
                    <i class="fas fa-cogs text-blue-600 dark:text-blue-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Pending Planning</p>
                    <p class="text-2xl font-bold text-yellow-600 dark:text-yellow-400">{{ $pendingPlanningCount }}</p>
                </div>
                <div class="p-3 bg-yellow-100 dark:bg-yellow-900/40 rounded-xl">
                    <i class="fas fa-clock text-yellow-600 dark:text-yellow-400 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Productions Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden shadow-sm">
        <div class="px-6 py-4 bg-gradient-to-r from-purple-50 to-indigo-50 dark:from-gray-700 dark:to-gray-700 border-b border-gray-200 dark:border-gray-700">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center gap-3">
                    <div class="w-10 h-10 bg-purple-100 dark:bg-purple-900/30 rounded-lg flex items-center justify-center">
                        <i class="fas fa-industry text-purple-600 dark:text-purple-400"></i>
                    </div>
                    Data Produksi
                </h2>
                <span class="px-3 py-1.5 bg-purple-600 text-white text-xs font-bold rounded-full">{{ $totalProductions }} produksi</span>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full table-auto">
                <thead class="bg-gray-50 dark:bg-gray-700/50">
                    <tr>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Production ID</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Order ID</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Produk</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Teknisi</th>
                        <th class="px-6 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Quantity</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Planning</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Completion</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Tanggal</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse($productions as $production)
                    <tr class="hover:bg-gray-50/50 dark:hover:bg-gray-700/30 transition-colors duration-150">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <a href="{{ route('supervisor.productions.show', $production->id) }}" class="inline-flex items-center px-2.5 py-1 rounded-md text-sm font-semibold bg-gray-100 dark:bg-gray-700 text-gray-900 dark:text-white hover:bg-gray-200 dark:hover:bg-gray-600 transition-colors">
                                #{{ $production->id }}
                            </a>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <a href="{{ route('supervisor.monitoring.orders') }}" class="text-sm text-blue-600 dark:text-blue-400 hover:underline font-medium">
                                #{{ $production->order_id ?? '-' }}
                            </a>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm font-medium text-gray-900 dark:text-white">{{ Str::limit($production->product->product_title ?? '-', 30) }}</div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center gap-2">
                                <div class="w-8 h-8 bg-blue-100 dark:bg-blue-900/40 rounded-full flex items-center justify-center">
                                    <i class="fas fa-user text-blue-600 dark:text-blue-400 text-xs"></i>
                                </div>
                                <div class="text-sm font-medium text-gray-900 dark:text-white">{{ Str::limit($production->teknisi->name ?? '-', 20) }}</div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right">
                            <span class="text-sm text-gray-900 dark:text-white">{{ number_format($production->quantity, 0, ',', '.') }} unit</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <span class="inline-flex items-center px-2.5 py-1 text-xs font-semibold rounded-full
                                @if($production->planning_status === 'approved') bg-emerald-100 text-emerald-700 border border-emerald-300 dark:bg-emerald-900/30 dark:text-emerald-300
                                @elseif($production->planning_status === 'pending_approval') bg-yellow-100 text-yellow-700 border border-yellow-300 dark:bg-yellow-900/30 dark:text-yellow-300
                                @elseif($production->planning_status === 'rejected') bg-red-100 text-red-700 border border-red-300 dark:bg-red-900/30 dark:text-red-300
                                @else bg-blue-100 text-blue-700 border border-blue-300 dark:bg-blue-900/30 dark:text-blue-300 @endif">
                                {{ ucfirst(str_replace('_', ' ', $production->planning_status ?? 'planning')) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <span class="inline-flex items-center px-2.5 py-1 text-xs font-semibold rounded-full
                                @if($production->status === 'selesai') bg-emerald-100 text-emerald-700 border border-emerald-300 dark:bg-emerald-900/30 dark:text-emerald-300
                                @elseif($production->status === 'dalam_proses') bg-blue-100 text-blue-700 border border-blue-300 dark:bg-blue-900/30 dark:text-blue-300
                                @elseif($production->status === 'dibatalkan') bg-red-100 text-red-700 border border-red-300 dark:bg-red-900/30 dark:text-red-300
                                @else bg-yellow-100 text-yellow-700 border border-yellow-300 dark:bg-yellow-900/30 dark:text-yellow-300 @endif">
                                {{ ucfirst(str_replace('_', ' ', $production->status ?? 'menunggu')) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <span class="inline-flex items-center px-2.5 py-1 text-xs font-semibold rounded-full
                                @if($production->completion_status === 'approved') bg-emerald-100 text-emerald-700 border border-emerald-300 dark:bg-emerald-900/30 dark:text-emerald-300
                                @elseif($production->completion_status === 'pending_approval') bg-yellow-100 text-yellow-700 border border-yellow-300 dark:bg-yellow-900/30 dark:text-yellow-300
                                @elseif($production->completion_status === 'rejected') bg-red-100 text-red-700 border border-red-300 dark:bg-red-900/30 dark:text-red-300
                                @else bg-gray-100 text-gray-700 border border-gray-300 dark:bg-gray-700 dark:text-gray-300 @endif">
                                {{ ucfirst(str_replace('_', ' ', $production->completion_status ?? '-')) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <span class="text-sm text-gray-600 dark:text-gray-400">{{ $production->created_at->format('d M Y') }}</span>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="px-6 py-12 text-center">
                            <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mx-auto mb-4">
                                <i class="fas fa-inbox text-3xl text-gray-400 dark:text-gray-500"></i>
                            </div>
                            <h3 class="text-base font-semibold text-gray-900 dark:text-white mb-1">Tidak Ada Data Produksi</h3>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Belum ada produksi yang tercatat</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($productions->hasPages())
        <div class="px-6 py-4 border-t border-gray-200 dark:border-gray-700 bg-gray-50 dark:bg-gray-700/30">
            {{ $productions->links() }}
        </div>
        @endif
    </div>
</div>
@endsection
