@extends('layouts.supervisor')

@section('title', 'Monitoring Orders - Supervisor')

@section('content')
@php
    $totalOrders = $orders->total();
    $diterimaCount = $orders->filter(fn($o) => $o->order_status === 'diterima')->count();
    $menungguCount = $orders->filter(fn($o) => $o->order_status === 'menunggu')->count();
    $totalRevenue = $orders->sum('total_price');
@endphp

<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white tracking-tight">Monitoring Pesanan</h1>
            <p class="text-sm sm:text-base text-gray-600 dark:text-gray-400 mt-1.5">Pantau semua pesanan customer secara real-time</p>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Total Orders</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $totalOrders }}</p>
                </div>
                <div class="p-3 bg-blue-100 dark:bg-blue-900/40 rounded-xl">
                    <i class="fas fa-clipboard-list text-blue-600 dark:text-blue-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Diterima</p>
                    <p class="text-2xl font-bold text-emerald-600 dark:text-emerald-400">{{ $diterimaCount }}</p>
                </div>
                <div class="p-3 bg-emerald-100 dark:bg-emerald-900/40 rounded-xl">
                    <i class="fas fa-check-circle text-emerald-600 dark:text-emerald-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Menunggu</p>
                    <p class="text-2xl font-bold text-yellow-600 dark:text-yellow-400">{{ $menungguCount }}</p>
                </div>
                <div class="p-3 bg-yellow-100 dark:bg-yellow-900/40 rounded-xl">
                    <i class="fas fa-clock text-yellow-600 dark:text-yellow-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Total Revenue</p>
                    <p class="text-lg font-bold text-indigo-600 dark:text-indigo-400">Rp {{ number_format($totalRevenue, 0, ',', '.') }}</p>
                </div>
                <div class="p-3 bg-indigo-100 dark:bg-indigo-900/40 rounded-xl">
                    <i class="fas fa-dollar-sign text-indigo-600 dark:text-indigo-400 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Orders Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden shadow-sm">
        <div class="px-6 py-4 bg-gradient-to-r from-blue-50 to-indigo-50 dark:from-gray-700 dark:to-gray-700 border-b border-gray-200 dark:border-gray-700">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center gap-3">
                    <div class="w-10 h-10 bg-blue-100 dark:bg-blue-900/30 rounded-lg flex items-center justify-center">
                        <i class="fas fa-clipboard-list text-blue-600 dark:text-blue-400"></i>
                    </div>
                    Data Pesanan
                </h2>
                <span class="px-3 py-1.5 bg-blue-600 text-white text-xs font-bold rounded-full">{{ $totalOrders }} orders</span>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full table-auto">
                <thead class="bg-gray-50 dark:bg-gray-700/50">
                    <tr>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Order ID</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Customer</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Produk</th>
                        <th class="px-6 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Quantity</th>
                        <th class="px-6 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Total</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Order Status</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Payment</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Production</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Tanggal</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse($orders as $order)
                    <tr class="hover:bg-gray-50/50 dark:hover:bg-gray-700/30 transition-colors duration-150">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-2.5 py-1 rounded-md text-sm font-semibold bg-gray-100 dark:bg-gray-700 text-gray-900 dark:text-white">
                                #{{ $order->id }}
                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center gap-2">
                                <div class="w-8 h-8 bg-blue-100 dark:bg-blue-900/40 rounded-full flex items-center justify-center">
                                    <i class="fas fa-user text-blue-600 dark:text-blue-400 text-xs"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-gray-900 dark:text-white">{{ $order->customer_name ?? $order->user->name ?? '-' }}</p>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">{{ Str::limit($order->customer_email ?? $order->user->email ?? '-', 25) }}</p>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm font-medium text-gray-900 dark:text-white">{{ Str::limit($order->product->product_title ?? '-', 30) }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right">
                            <span class="text-sm text-gray-900 dark:text-white">{{ number_format($order->quantity, 0, ',', '.') }} unit</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right">
                            <span class="text-sm font-semibold text-gray-900 dark:text-white">Rp {{ number_format($order->total_price, 0, ',', '.') }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <span class="inline-flex items-center px-2.5 py-1 text-xs font-semibold rounded-full
                                @if($order->order_status === 'diterima') bg-emerald-100 text-emerald-700 border border-emerald-300 dark:bg-emerald-900/30 dark:text-emerald-300
                                @elseif($order->order_status === 'menunggu') bg-yellow-100 text-yellow-700 border border-yellow-300 dark:bg-yellow-900/30 dark:text-yellow-300
                                @elseif($order->order_status === 'ditolak') bg-red-100 text-red-700 border border-red-300 dark:bg-red-900/30 dark:text-red-300
                                @else bg-gray-100 text-gray-700 border border-gray-300 dark:bg-gray-700 dark:text-gray-300 @endif">
                                {{ ucfirst(str_replace('_', ' ', $order->order_status ?? '-')) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <span class="inline-flex items-center px-2.5 py-1 text-xs font-semibold rounded-full
                                @if($order->status === 'selesai') bg-emerald-100 text-emerald-700 border border-emerald-300 dark:bg-emerald-900/30 dark:text-emerald-300
                                @elseif($order->status === 'diproses') bg-blue-100 text-blue-700 border border-blue-300 dark:bg-blue-900/30 dark:text-blue-300
                                @elseif($order->status === 'gagal' || $order->status === 'dibatalkan') bg-red-100 text-red-700 border border-red-300 dark:bg-red-900/30 dark:text-red-300
                                @else bg-yellow-100 text-yellow-700 border border-yellow-300 dark:bg-yellow-900/30 dark:text-yellow-300 @endif">
                                {{ ucfirst($order->status ?? '-') }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <span class="inline-flex items-center px-2.5 py-1 text-xs font-semibold rounded-full
                                @if($order->production_status === 'selesai') bg-emerald-100 text-emerald-700 border border-emerald-300 dark:bg-emerald-900/30 dark:text-emerald-300
                                @elseif($order->production_status === 'dalam_proses') bg-blue-100 text-blue-700 border border-blue-300 dark:bg-blue-900/30 dark:text-blue-300
                                @elseif($order->production_status === 'dibatalkan') bg-red-100 text-red-700 border border-red-300 dark:bg-red-900/30 dark:text-red-300
                                @else bg-yellow-100 text-yellow-700 border border-yellow-300 dark:bg-yellow-900/30 dark:text-yellow-300 @endif">
                                {{ ucfirst(str_replace('_', ' ', $order->production_status ?? 'menunggu')) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <span class="text-sm text-gray-600 dark:text-gray-400">{{ $order->created_at->format('d M Y') }}</span>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="px-6 py-12 text-center">
                            <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mx-auto mb-4">
                                <i class="fas fa-inbox text-3xl text-gray-400 dark:text-gray-500"></i>
                            </div>
                            <h3 class="text-base font-semibold text-gray-900 dark:text-white mb-1">Tidak Ada Data Pesanan</h3>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Belum ada pesanan yang tercatat</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($orders->hasPages())
        <div class="px-6 py-4 border-t border-gray-200 dark:border-gray-700 bg-gray-50 dark:bg-gray-700/30">
            {{ $orders->links() }}
        </div>
        @endif
    </div>
</div>
@endsection
