@extends('layouts.supervisor')

@section('title', 'Dashboard Persetujuan - Supervisor')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Dashboard Persetujuan</h1>
            <p class="text-gray-600 dark:text-gray-400 mt-1">Ringkasan semua persetujuan tertunda yang perlu ditinjau</p>
        </div>
    </div>


    <!-- Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Production Approvals Card -->
        <a href="{{ route('supervisor.productions.index') }}" 
           class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6 hover:shadow-lg transition-all duration-200 group cursor-pointer">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-indigo-600 rounded-lg flex items-center justify-center text-white text-xl group-hover:scale-110 transition-transform">
                    <i class="fas fa-cogs"></i>
                </div>
                <div class="text-right">
                    <p class="text-3xl font-bold text-gray-900 dark:text-white">{{ $stats['total_productions'] }}</p>
                    <p class="text-sm text-gray-500 dark:text-gray-400">
                        {{ $stats['pending_planning_count'] }} Perencanaan
                        @if($stats['pending_completion_count'] > 0)
                            <span class="mx-1">+</span> {{ $stats['pending_completion_count'] }} Penyelesaian
                        @endif
                    </p>
                </div>
            </div>
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Persetujuan Produksi</h3>
            <p class="text-sm text-gray-600 dark:text-gray-400">Tinjau dan setujui perencanaan & penyelesaian produksi dari teknisi</p>
            <div class="mt-4 flex items-center text-blue-600 dark:text-blue-400 group-hover:text-blue-700 dark:group-hover:text-blue-300">
                <span class="text-sm font-medium">Lihat Detail</span>
                <i class="fas fa-arrow-right ml-2 group-hover:translate-x-1 transition-transform"></i>
            </div>
        </a>

        <!-- Purchase Approvals Card -->
        <a href="{{ route('supervisor.purchases.index') }}" 
           class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6 hover:shadow-lg transition-all duration-200 group cursor-pointer">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-emerald-600 rounded-lg flex items-center justify-center text-white text-xl group-hover:scale-110 transition-transform">
                    <i class="fas fa-shopping-cart"></i>
                </div>
                <div class="text-right">
                    <p class="text-3xl font-bold text-gray-900 dark:text-white">{{ $stats['pending_purchases_count'] }}</p>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Tertunda</p>
                </div>
            </div>
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Persetujuan Pembelian</h3>
            <p class="text-sm text-gray-600 dark:text-gray-400">Tinjau dan setujui pesanan pembelian dari admin</p>
            <div class="mt-4 flex items-center text-blue-600 dark:text-blue-400 group-hover:text-blue-700 dark:group-hover:text-blue-300">
                <span class="text-sm font-medium">Lihat Detail</span>
                <i class="fas fa-arrow-right ml-2 group-hover:translate-x-1 transition-transform"></i>
            </div>
        </a>
    </div>

    <!-- Quick Stats -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
        <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Statistik Cepat</h2>
        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
            <div class="bg-blue-50 dark:bg-blue-900/20 rounded-lg p-4 border border-blue-200 dark:border-blue-800">
                <p class="text-sm text-blue-600 dark:text-blue-400 mb-1">Persetujuan Perencanaan</p>
                <p class="text-2xl font-bold text-blue-700 dark:text-blue-300">{{ $stats['pending_planning_count'] }}</p>
            </div>
            <div class="bg-purple-50 dark:bg-purple-900/20 rounded-lg p-4 border border-purple-200 dark:border-purple-800">
                <p class="text-sm text-purple-600 dark:text-purple-400 mb-1">Persetujuan Penyelesaian</p>
                <p class="text-2xl font-bold text-purple-700 dark:text-purple-300">{{ $stats['pending_completion_count'] }}</p>
            </div>
            <div class="bg-green-50 dark:bg-green-900/20 rounded-lg p-4 border border-green-200 dark:border-green-800">
                <p class="text-sm text-green-600 dark:text-green-400 mb-1">Persetujuan Pembelian</p>
                <p class="text-2xl font-bold text-green-700 dark:text-green-300">{{ $stats['pending_purchases_count'] }}</p>
            </div>
        </div>
        <div class="mt-4 p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
            <p class="text-sm text-gray-600 dark:text-gray-400">
                <i class="fas fa-info-circle mr-2 text-blue-500"></i>
                <strong>Catatan:</strong> Persetujuan pesanan dilakukan oleh Admin. Supervisor hanya menangani persetujuan Perencanaan Produksi dan Pembelian.
            </p>
        </div>
    </div>

    <!-- Empty State -->
    @if($stats['total_productions'] == 0 && $stats['pending_purchases_count'] == 0)
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-12 text-center">
        <div class="w-16 h-16 bg-green-100 dark:bg-green-900/20 rounded-full flex items-center justify-center mx-auto mb-4">
            <i class="fas fa-check-circle text-2xl text-green-600 dark:text-green-400"></i>
        </div>
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Tidak Ada Persetujuan Tertunda</h3>
        <p class="text-gray-600 dark:text-gray-400">Semua permintaan sudah diproses. Kerja bagus! 🎉</p>
    </div>
    @endif
</div>
@endsection
