<div class="flex items-center gap-3 mb-6 pb-4 border-b border-gray-200 dark:border-gray-700">
    <div class="p-2 bg-purple-100 dark:bg-purple-900/30 rounded-lg">
        <i class="fas fa-lock text-purple-600 dark:text-purple-400"></i>
    </div>
    <div>
        <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Ubah Password</h2>
        <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Ubah password untuk menjaga keamanan akun Anda</p>
    </div>
</div>

<form method="post" action="{{ route('password.update') }}" class="space-y-6" id="passwordForm">
    @csrf
    @method('put')

    <div>
        <label for="update_password_current_password" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
            <i class="fas fa-lock mr-2 text-purple-600 dark:text-purple-400"></i>
            Password Saat Ini
        </label>
        <div class="relative">
            <i class="fas fa-lock absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
            <input type="password" 
                   id="update_password_current_password" 
                   name="current_password" 
                   autocomplete="current-password"
                   class="w-full pl-10 pr-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
        </div>
        @error('current_password', 'updatePassword')
            <p class="mt-2 text-sm text-red-600 dark:text-red-400 flex items-center">
                <i class="fas fa-exclamation-circle mr-2"></i>
                {{ $message }}
            </p>
        @enderror
    </div>

    <div>
        <label for="update_password_password" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
            <i class="fas fa-key mr-2 text-purple-600 dark:text-purple-400"></i>
            Password Baru
        </label>
        <div class="relative">
            <i class="fas fa-key absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
            <input type="password" 
                   id="update_password_password" 
                   name="password" 
                   autocomplete="new-password"
                   class="w-full pl-10 pr-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
        </div>
        @error('password', 'updatePassword')
            <p class="mt-2 text-sm text-red-600 dark:text-red-400 flex items-center">
                <i class="fas fa-exclamation-circle mr-2"></i>
                {{ $message }}
            </p>
        @enderror
    </div>

    <div>
        <label for="update_password_password_confirmation" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
            <i class="fas fa-check-circle mr-2 text-purple-600 dark:text-purple-400"></i>
            Konfirmasi Password Baru
        </label>
        <div class="relative">
            <i class="fas fa-check-circle absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
            <input type="password" 
                   id="update_password_password_confirmation" 
                   name="password_confirmation" 
                   autocomplete="new-password"
                   class="w-full pl-10 pr-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
        </div>
    </div>

    <div class="flex items-center justify-end gap-3 pt-4 border-t border-gray-200 dark:border-gray-700">
        <button type="submit" 
                id="passwordSubmitBtn" 
                class="px-6 py-2.5 bg-purple-600 hover:bg-purple-700 text-white font-medium rounded-lg transition-colors duration-200 flex items-center">
            <i class="fas fa-save mr-2"></i>
            Simpan Password
        </button>
    </div>
</form>

