@extends('layouts.main')

@section('title', $product->product_title)

@section('content')
    <div class="container mx-auto px-4 py-8 max-w-4xl">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Image -->
            <div>
                <img src="{{ asset('uploads/products/' . $product->product_image) }}" alt="{{ $product->product_title }}"
                    class="w-full h-96 object-cover rounded-lg">
            </div>

            <!-- Detail -->
            <div class="space-y-4">
                <h1 class="text-3xl font-bold text-gray-800">{{ $product->product_title }}</h1>
                <p class="text-xl font-bold text-blue-600">Rp{{ number_format($product->product_prices, 0, ',', '.') }}</p>
                <p class="text-gray-700">{{ $product->description ?? 'Deskripsi produk...' }}</p>
                <a href="{{ route('checkout.form', $product) }}"
                    class="block w-full bg-green-600 hover:bg-green-700 text-white font-semibold py-3 px-6 rounded-lg text-center">
                    Beli Sekarang
                </a>
            </div>
        </div>
    </div>
@endsection
