@extends('layouts.main')

@section('title', 'Daftar Produk')

@section('content')
    <div class="container mx-auto px-4 py-8 max-w-7xl">
        <!-- Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-800 mb-2">Daftar Produk</h1>
            <p class="text-gray-600">Pilih produk favorit Anda</p>
        </div>

        @if (session('error'))
            <div class="mb-6 p-4 bg-red-100 border border-red-400 text-red-700 rounded-lg">
                {{ session('error') }}
            </div>
        @endif

        <!-- Grid Produk -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
            @forelse($products as $product)
                <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow flex flex-col">
                    <!-- Image Container -->
                    <div class="w-full h-64 bg-gray-50 flex items-center justify-center p-4">
                        <img src="{{ asset('uploads/products/' . $product->product_image) }}" alt="{{ $product->product_title }}"
                            class="max-w-full max-h-full w-auto h-auto object-contain rounded-lg">
                    </div>
                    <div class="p-4 flex-1 flex flex-col">
                        <h3 class="text-lg font-semibold text-gray-800 mb-2 line-clamp-2">
                            {{ $product->product_title }}
                        </h3>
                        <p class="text-xl font-bold text-blue-600 mb-4">
                            Rp{{ number_format($product->product_prices, 0, ',', '.') }}
                        </p>
                        <a href="{{ route('checkout.form', $product) }}"
                            class="block w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg text-center transition duration-200">
                            Beli Sekarang
                        </a>
                    </div>
                </div>
            @empty
                <div class="col-span-full text-center py-12">
                    <p class="text-gray-500 text-lg">Belum ada produk tersedia.</p>
                </div>
            @endforelse
        </div>

        <!-- Pagination -->
        <div class="mt-8 flex justify-center">
            {{ $products->links() }}
        </div>
    </div>
@endsection
