<header class="bg-white shadow-md sticky top-0 z-40">
    <div class="container mx-auto px-4 py-3">
        <!-- Mobile: Stacked Layout -->
        <div class="flex flex-col gap-3 md:hidden">
            <!-- Logo Top Left (Small) -->
            <div class="flex justify-start items-center">
                <a href="{{ url('/') }}" class="flex-shrink-0">
                    @if(!empty($companyLogo))
                        <img src="{{ asset('uploads/' . $companyLogo) }}" alt="{{ $companyName }}" class="h-5 w-auto" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                        <h3 class="text-2xl font-extrabold bg-gradient-to-r from-blue-400 to-cyan-400 bg-clip-text text-transparent" style="display: none;">{{ $companyName }}</h3>
                    @else
                        <h3 class="text-2xl font-extrabold bg-gradient-to-r from-blue-400 to-cyan-400 bg-clip-text text-transparent">{{ $companyName }}</h3>
                    @endif
                </a>
            </div>

            <!-- Search Bar -->
            <div class="w-full">
                <form method="GET" action="{{ route('all') }}" class="relative">
                    <span class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400">
                        <i class="lni lni-search-alt"></i>
                    </span>
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Cari Mesin..."
                        class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-full text-gray-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-400 transition duration-200 ease-in-out shadow-sm">
                </form>
            </div>

            <!-- Navigation Links -->
            <div class="flex justify-center items-center space-x-2">
                <a href="{{ route('guest.contact') }}" @class([
                    'flex flex-col items-center gap-1 px-2 py-1.5 rounded-md transition-all duration-200 text-xs',
                    'text-gray-600 hover:text-blue-600' => !request()->routeIs('guest.contact'),
                    'text-blue-600 font-semibold' => request()->routeIs('guest.contact'),
                ]) title="Kontak">
                    <span class="font-medium text-[10px]">Kontak</span>
                </a>

                <a href="{{ route('konsultasi') }}" @class([
                    'flex flex-col items-center gap-1 px-2 py-1.5 rounded-md transition-all duration-200 text-xs',
                    'text-gray-600 hover:text-blue-600' => !request()->routeIs('konsultasi'),
                    'text-blue-600 font-semibold' => request()->routeIs('konsultasi'),
                ]) title="Konsultasi">
                    <span class="font-medium text-[10px]">Konsultasi</span>
                </a>

                <a href="{{ route('kebijakan') }}" @class([
                    'flex flex-col items-center gap-1 px-2 py-1.5 rounded-md transition-all duration-200 text-xs',
                    'text-gray-600 hover:text-blue-600' => !request()->routeIs('kebijakan'),
                    'text-blue-600 font-semibold' => request()->routeIs('kebijakan'),
                ]) title="Kebijakan">
                    <span class="font-medium text-[10px]">Kebijakan</span>
                </a>
            </div>
        </div>

        <!-- Tablet/Desktop: Grid Layout -->
        <div class="hidden md:grid md:grid-cols-3 items-center gap-4">
            <!-- Search Bar (Left) -->
            <div class="flex justify-start">
                <form method="GET" action="{{ route('all') }}" class="relative w-full max-w-sm">
                    <span class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400">
                        <i class="lni lni-search-alt"></i>
                    </span>
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Cari Mesin..."
                        class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-full text-gray-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-400 transition duration-200 ease-in-out shadow-sm">
                </form>
            </div>

            <!-- Logo Center -->
            <div class="flex justify-center">
                <a href="{{ url('/') }}" class="flex-shrink-0">
                    @if(!empty($companyLogo))
                        <img src="{{ asset('uploads/' . $companyLogo) }}" alt="{{ $companyName }}" class="h-7 w-auto" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                        <h3 class="text-3xl lg:text-4xl font-extrabold bg-gradient-to-r from-blue-400 to-cyan-400 bg-clip-text text-transparent" style="display: none;">{{ $companyName }}</h3>
                    @else
                        <h3 class="text-3xl lg:text-4xl font-extrabold bg-gradient-to-r from-blue-400 to-cyan-400 bg-clip-text text-transparent">{{ $companyName }}</h3>
                    @endif
                </a>
            </div>

            <!-- Navigation Links (Right) -->
            <div class="flex justify-end items-center space-x-2 lg:space-x-4">
                <a href="{{ route('index') }}" @class([
                    'flex items-center gap-2 px-3 lg:px-4 py-2 rounded-md transition-all duration-200 text-sm lg:text-base',
                    'text-gray-600 hover:text-blue-600' => !request()->routeIs('index'),
                    'text-blue-600 font-semibold' => request()->routeIs('index'),
                ]) title="Beranda">
                    <span>Beranda</span>
                </a>

                <a href="{{ route('guest.contact') }}" @class([
                    'flex items-center gap-2 px-3 lg:px-4 py-2 rounded-md transition-all duration-200 text-sm lg:text-base',
                    'text-gray-600 hover:text-blue-600' => !request()->routeIs('guest.contact'),
                    'text-blue-600 font-semibold' => request()->routeIs('guest.contact'),
                ]) title="Kontak">
                    <span>Kontak</span>
                </a>

                <a href="{{ route('konsultasi') }}" @class([
                    'flex items-center gap-2 px-3 lg:px-4 py-2 rounded-md transition-all duration-200 text-sm lg:text-base',
                    'text-gray-600 hover:text-blue-600' => !request()->routeIs('konsultasi'),
                    'text-blue-600 font-semibold' => request()->routeIs('konsultasi'),
                ]) title="Konsultasi">
                    <span>Konsultasi</span>
                </a>

                <a href="{{ route('kebijakan') }}" @class([
                    'flex items-center gap-2 px-3 lg:px-4 py-2 rounded-md transition-all duration-200 text-sm lg:text-base',
                    'text-gray-600 hover:text-blue-600' => !request()->routeIs('kebijakan'),
                    'text-blue-600 font-semibold' => request()->routeIs('kebijakan'),
                ]) title="Kebijakan">
                    <span>Kebijakan</span>
                </a>
            </div>
        </div>
    </div>
</header>
