<!-- Bottom Navigation Bar (Mobile Only) -->
<nav class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 shadow-lg z-50 md:hidden">
    <div class="flex items-center justify-around px-2 py-2">
        <!-- Home -->
        <a href="{{ route('index') }}" @class([
            'flex flex-col items-center justify-center gap-1 px-3 py-2 rounded-lg transition-all duration-200 min-w-[60px]',
            'text-blue-600' => request()->routeIs('index'),
            'text-gray-600 hover:text-blue-600' => !request()->routeIs('index'),
        ]) title="Beranda">
            <i class="lni lni-home text-xl"></i>
            <span class="text-[10px] font-medium">Beranda</span>
        </a>

        <!-- Katalog/Produk -->
        <a href="{{ route('all') }}" @class([
            'flex flex-col items-center justify-center gap-1 px-3 py-2 rounded-lg transition-all duration-200 min-w-[60px]',
            'text-blue-600' => request()->routeIs('all') || request()->routeIs('product_details') || request()->routeIs('katalog.kategori'),
            'text-gray-600 hover:text-blue-600' => !request()->routeIs('all') && !request()->routeIs('product_details') && !request()->routeIs('katalog.kategori'),
        ]) title="Katalog">
            <i class="lni lni-grid-alt text-xl"></i>
            <span class="text-[10px] font-medium">Katalog</span>
        </a>

        @auth
            <!-- Pesanan (Hanya untuk user yang sudah login) -->
            <a href="{{ route('my.orders.index') }}" @class([
                'flex flex-col items-center justify-center gap-1 px-3 py-2 rounded-lg transition-all duration-200 min-w-[60px] relative',
                'text-blue-600' => request()->routeIs('my.orders.*') || request()->routeIs('checkout.*') || request()->routeIs('orders.*'),
                'text-gray-600 hover:text-blue-600' => !request()->routeIs('my.orders.*') && !request()->routeIs('checkout.*') && !request()->routeIs('orders.*'),
            ]) title="Pesanan">
                <i class="lni lni-shopping-basket text-xl"></i>
                <span class="text-[10px] font-medium">Pesanan</span>
            </a>

            <!-- Profil -->
            <a href="{{ route('profile.edit') }}" @class([
                'flex flex-col items-center justify-center gap-1 px-3 py-2 rounded-lg transition-all duration-200 min-w-[60px]',
                'text-blue-600' => request()->routeIs('profile.*') || request()->routeIs('user.dashboard') || request()->routeIs('user.*'),
                'text-gray-600 hover:text-blue-600' => !request()->routeIs('profile.*') && !request()->routeIs('user.dashboard') && !request()->routeIs('user.*'),
            ]) title="Profil">
                <i class="lni lni-user text-xl"></i>
                <span class="text-[10px] font-medium">Profil</span>
            </a>
        @else
            <!-- Kontak (Untuk guest) -->
            <a href="{{ route('guest.contact') }}" @class([
                'flex flex-col items-center justify-center gap-1 px-3 py-2 rounded-lg transition-all duration-200 min-w-[60px]',
                'text-blue-600' => request()->routeIs('guest.contact'),
                'text-gray-600 hover:text-blue-600' => !request()->routeIs('guest.contact'),
            ]) title="Kontak">
                <i class="lni lni-phone text-xl"></i>
                <span class="text-[10px] font-medium">Kontak</span>
            </a>

            <!-- Login/Profil (Untuk guest) -->
            <a href="{{ route('login') }}" @class([
                'flex flex-col items-center justify-center gap-1 px-3 py-2 rounded-lg transition-all duration-200 min-w-[60px]',
                'text-blue-600' => request()->routeIs('login') || request()->routeIs('register'),
                'text-gray-600 hover:text-blue-600' => !request()->routeIs('login') && !request()->routeIs('register'),
            ]) title="Masuk">
                <i class="lni lni-user text-xl"></i>
                <span class="text-[10px] font-medium">Masuk</span>
            </a>
        @endauth
    </div>
</nav>

