@extends('layouts.main')

@section('content')
    <section class="py-6 sm:py-8 lg:py-12">
        <div class="max-w-5xl mx-auto px-4">
            <!-- Header -->
            <div class="text-center mb-8 sm:mb-10">
                <h2 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-2 sm:mb-3">Syarat dan Ketentuan</h2>
                <p class="text-sm sm:text-base text-gray-600">
                    Informasi penting yang perlu Anda ketahui
                </p>
            </div>

            <!-- Kebijakan Accordion -->
            <div class="space-y-3 sm:space-y-4" x-data="{ open: null }">
                @php
                    $kebijakans = [
                        [
                            'title' => '1. Pengantar',
                            'content' =>
                                'Dengan mengakses dan menggunakan website serta layanan kami, Anda dianggap telah memahami dan menyetujui syarat dan ketentuan yang berlaku. Ketentuan ini bertujuan untuk mengatur penggunaan layanan agar berjalan dengan baik dan saling menguntungkan.',
                        ],
                        [
                            'title' => '2. Layanan Kami',
                            'content' =>
                                '<p>Kami menyediakan layanan di bidang pembuatan dan penyediaan mesin sesuai kebutuhan pengguna, termasuk namun tidak terbatas pada:</p>
                                <ul class="mt-2 ml-4 space-y-1 list-disc">
                                    <li>Mesin produksi dan pengolahan</li>
                                    <li>Mesin pendukung operasional industri dan usaha</li>
                                    <li>Mesin custom sesuai kebutuhan pengguna</li>
                                    <li>Layanan konsultasi dan pendampingan teknis</li>
                                </ul>
                                <p class="mt-3">Jenis dan spesifikasi layanan akan disesuaikan berdasarkan kesepakatan bersama.</p>',
                        ],
                        [
                            'title' => '3. Hak dan Kewajiban Pengguna',
                            'content' =>
                                '<p class="font-semibold text-gray-800 mb-2"><strong>Hak Pengguna:</strong></p>
                                <ul class="ml-4 space-y-1 list-disc mb-4">
                                    <li>Mendapatkan informasi terkait layanan yang tersedia</li>
                                    <li>Melakukan konsultasi mengenai kebutuhan yang diinginkan</li>
                                    <li>Mendapatkan dukungan sesuai kesepakatan</li>
                                </ul>
                                <p class="font-semibold text-gray-800 mb-2"><strong>Kewajiban Pengguna:</strong></p>
                                <ul class="ml-4 space-y-1 list-disc">
                                    <li>Memberikan informasi yang benar dan jelas</li>
                                    <li>Mematuhi kesepakatan yang telah disetujui</li>
                                    <li>Menggunakan produk atau layanan sesuai fungsinya</li>
                                </ul>',
                        ],
                        [
                            'title' => '4. Pembayaran dan Biaya',
                            'content' =>
                                '<ul class="space-y-2 list-none">
                                    <li class="border-l-4 border-blue-500 pl-3"><strong>Pembayaran:</strong> Ketentuan pembayaran akan disepakati bersama sebelum layanan dimulai</li>
                                    <li class="border-l-4 border-blue-500 pl-3"><strong>Tahapan Pembayaran:</strong> Dapat dilakukan secara bertahap sesuai kesepakatan</li>
                                    <li class="border-l-4 border-blue-500 pl-3"><strong>Pelunasan:</strong> Dilakukan sesuai dengan kesepakatan sebelum layanan dinyatakan selesai</li>
                                    <li class="border-l-4 border-blue-500 pl-3"><strong>Biaya Tambahan:</strong> Dapat berlaku sesuai kebutuhan dan akan diinformasikan sebelumnya</li>
                                </ul>',
                        ],
                        [
                            'title' => '5. Kebijakan Komplain',
                            'content' =>
                                '<p>Kami terbuka terhadap masukan dan komplain dari pengguna layanan.</p>
                                <ul class="mt-2 ml-4 space-y-1 list-disc">
                                    <li>Komplain dapat disampaikan melalui media komunikasi resmi kami</li>
                                    <li>Mohon sertakan informasi yang jelas terkait kendala yang dialami</li>
                                    <li>Setiap komplain akan ditindaklanjuti sesuai prosedur yang berlaku</li>
                                </ul>',
                        ],
                        [
                            'title' => '6. Kebijakan Pengembalian',
                            'content' =>
                                '<p>Produk atau layanan yang disediakan umumnya bersifat khusus sesuai kebutuhan pengguna.</p>
                                <ul class="mt-2 ml-4 space-y-1 list-disc">
                                    <li>Pengembalian atau pembatalan akan dibahas berdasarkan kesepakatan</li>
                                    <li>Ketentuan lebih lanjut akan dijelaskan pada saat proses pemesanan</li>
                                </ul>',
                        ],
                        [
                            'title' => '7. Pembatasan Tanggung Jawab',
                            'content' =>
                                '<p>Kami tidak bertanggung jawab atas kerugian yang timbul akibat:</p>
                                <ul class="mt-2 ml-4 space-y-1 list-disc">
                                    <li>Penggunaan layanan yang tidak sesuai kesepakatan</li>
                                    <li>Kelalaian pengguna dalam pengoperasian</li>
                                    <li>Kondisi di luar kendali kami</li>
                                </ul>
                                <p class="mt-3">Tanggung jawab kami terbatas sesuai dengan kesepakatan yang telah dibuat.</p>',
                        ],
                        [
                            'title' => '8. Perubahan Syarat dan Ketentuan',
                            'content' =>
                                'Kami dapat melakukan perubahan terhadap syarat dan ketentuan ini sewaktu-waktu. Perubahan akan berlaku setelah ditampilkan pada halaman ini. Pengguna disarankan untuk memeriksa halaman ini secara berkala.',
                        ],
                        [
                            'title' => '9. Kontak',
                            'content' =>
                                '<p>Untuk pertanyaan atau informasi lebih lanjut, silakan hubungi kami melalui:</p>
                                <ul class="mt-3 ml-4 space-y-2 list-none">
                                    <li class="border-l-4 border-blue-500 pl-3"><strong>Email:</strong> info@perusahaan.com</li>
                                    <li class="border-l-4 border-blue-500 pl-3"><strong>Telepon:</strong> (021) 1234-5678</li>
                                    <li class="border-l-4 border-blue-500 pl-3"><strong>WhatsApp:</strong> +62 812-3456-7890</li>
                                    <li class="border-l-4 border-blue-500 pl-3"><strong>Alamat:</strong> Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi</li>
                                </ul>
                                <p class="mt-3">Kami siap membantu Anda dengan informasi yang dibutuhkan.</p>',
                        ],
                    ];
                @endphp

                @foreach ($kebijakans as $index => $kebijakan)
                    <div class="bg-white rounded-lg border border-gray-200 overflow-hidden">
                        <button @click="open === {{ $index }} ? open = null : open = {{ $index }}"
                            class="w-full flex justify-between items-center text-left px-4 sm:px-5 py-3 sm:py-4 transition-colors duration-200"
                            :class="open === {{ $index }} ? 'text-blue-600 font-semibold bg-blue-50' : 'text-gray-800 font-medium hover:bg-gray-50'">
                            <span class="text-sm sm:text-base">{{ $kebijakan['title'] }}</span>
                            <svg x-show="open !== {{ $index }}" xmlns="http://www.w3.org/2000/svg"
                                class="w-5 h-5 text-gray-500 transition-transform duration-300 flex-shrink-0" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
                            </svg>
                            <svg x-show="open === {{ $index }}" xmlns="http://www.w3.org/2000/svg"
                                class="w-5 h-5 text-blue-600 transition-transform duration-300 flex-shrink-0" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M20 12H4" />
                            </svg>
                        </button>
                        <div x-show="open === {{ $index }}" x-collapse
                            class="px-4 sm:px-5 pb-4 sm:pb-5 text-sm sm:text-base text-gray-600 leading-relaxed border-t border-gray-200">
                            {!! $kebijakan['content'] !!}
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Call to Action -->
            <div class="text-center mt-8 sm:mt-12">
                <p class="text-sm sm:text-base text-gray-600 mb-3">Ada pertanyaan mengenai syarat dan ketentuan?</p>
                <a href="{{ route('kontak') }}"
                    class="inline-flex items-center gap-2 bg-blue-600 text-white font-medium px-5 sm:px-6 py-2.5 sm:py-3 rounded-lg hover:bg-blue-700 transition-colors duration-200">
                    <svg class="w-4 h-4 sm:w-5 sm:h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                    </svg>
                    Hubungi Kami
                </a>
            </div>
        </div>
    </section>
@endsection
