<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title }}</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            color: white;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .content {
            padding: 30px 20px;
        }
        .notification-type {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            margin-bottom: 20px;
        }
        .type-order { background-color: #fef3c7; color: #92400e; }
        .type-inquiry { background-color: #ddd6fe; color: #5b21b6; }
        .type-contact { background-color: #dbeafe; color: #1e40af; }
        .type-production { background-color: #d1fae5; color: #065f46; }
        .title {
            font-size: 20px;
            font-weight: 600;
            color: #1f2937;
            margin: 0 0 15px 0;
        }
        .message {
            font-size: 16px;
            color: #4b5563;
            margin: 0 0 20px 0;
            line-height: 1.6;
        }
        .data-section {
            background-color: #f9fafb;
            border-left: 4px solid #3b82f6;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .data-item {
            margin: 8px 0;
            font-size: 14px;
        }
        .data-label {
            font-weight: 600;
            color: #374151;
            display: inline-block;
            min-width: 120px;
        }
        .data-value {
            color: #6b7280;
        }
        .footer {
            background-color: #f9fafb;
            padding: 20px;
            text-align: center;
            border-top: 1px solid #e5e7eb;
            font-size: 12px;
            color: #6b7280;
        }
        .button {
            display: inline-block;
            padding: 12px 24px;
            background-color: #3b82f6;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            margin-top: 20px;
        }
        .button:hover {
            background-color: #2563eb;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>POLJAM TECH</h1>
        </div>
        <div class="content">
            <span class="notification-type type-{{ $type }}">{{ ucfirst($type) }}</span>
            <h2 class="title">{{ $title }}</h2>
            <p class="message">{{ $message }}</p>
            
            @if(!empty($data))
            <div class="data-section">
                <h3 style="margin-top: 0; font-size: 14px; font-weight: 600; color: #374151;">Detail:</h3>
                @if(isset($data['order_id']))
                    <div class="data-item">
                        <span class="data-label">Order ID:</span>
                        <span class="data-value">#{{ $data['order_id'] }}</span>
                    </div>
                @endif
                @if(isset($data['inquiry_id']))
                    <div class="data-item">
                        <span class="data-label">Inquiry ID:</span>
                        <span class="data-value">#{{ $data['inquiry_id'] }}</span>
                    </div>
                @endif
                @if(isset($data['contact_id']))
                    <div class="data-item">
                        <span class="data-label">Contact ID:</span>
                        <span class="data-value">#{{ $data['contact_id'] }}</span>
                    </div>
                @endif
                @if(isset($data['production_id']))
                    <div class="data-item">
                        <span class="data-label">Production ID:</span>
                        <span class="data-value">#{{ $data['production_id'] }}</span>
                    </div>
                @endif
                @if(isset($data['customer_name']))
                    <div class="data-item">
                        <span class="data-label">Customer:</span>
                        <span class="data-value">{{ $data['customer_name'] }}</span>
                    </div>
                @endif
                @if(isset($data['name']))
                    <div class="data-item">
                        <span class="data-label">Nama:</span>
                        <span class="data-value">{{ $data['name'] }}</span>
                    </div>
                @endif
                @if(isset($data['product_title']))
                    <div class="data-item">
                        <span class="data-label">Produk:</span>
                        <span class="data-value">{{ $data['product_title'] }}</span>
                    </div>
                @endif
                @if(isset($data['total_price']))
                    <div class="data-item">
                        <span class="data-label">Total Harga:</span>
                        <span class="data-value">Rp {{ number_format($data['total_price'], 0, ',', '.') }}</span>
                    </div>
                @endif
                @if(isset($data['payment_method']))
                    <div class="data-item">
                        <span class="data-label">Metode Pembayaran:</span>
                        <span class="data-value">{{ ucfirst($data['payment_method']) }}</span>
                    </div>
                @endif
            </div>
            @endif
        </div>
        <div class="footer">
            <p>Email ini dikirim secara otomatis dari sistem POLJAM TECH.</p>
            <p>Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi</p>
            <p>&copy; {{ date('Y') }} POLJAM TECH. All rights reserved.</p>
        </div>
    </div>
</body>
</html>

