<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Pesanan Baru - POLJAM TECH</title>
    <style>
        /* Reset styles */
        body, table, td, p, a, li, blockquote {
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
        table, td {
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }
        img {
            -ms-interpolation-mode: bicubic;
            border: 0;
            outline: none;
            text-decoration: none;
        }
        
        /* Main styles */
        body {
            margin: 0;
            padding: 0;
            width: 100% !important;
            height: 100% !important;
            background-color: #f3f4f6;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
        }
        
        .email-wrapper {
            width: 100%;
            background-color: #f3f4f6;
            padding: 20px 0;
        }
        
        .email-container {
            max-width: 650px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        
        /* Header */
        .email-header {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            padding: 40px 30px;
            text-align: center;
        }
        
        .email-header h1 {
            margin: 0;
            color: #ffffff;
            font-size: 28px;
            font-weight: 700;
            letter-spacing: -0.5px;
        }
        
        .email-header .badge {
            display: inline-block;
            margin-top: 15px;
            padding: 8px 16px;
            background-color: rgba(255, 255, 255, 0.2);
            color: #ffffff;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        /* Content */
        .email-content {
            padding: 40px 30px;
        }
        
        .email-title {
            font-size: 24px;
            font-weight: 700;
            color: #111827;
            margin: 0 0 10px 0;
            line-height: 1.3;
        }
        
        .email-subtitle {
            font-size: 16px;
            color: #6b7280;
            margin: 0 0 30px 0;
            line-height: 1.5;
        }
        
        /* Info Card */
        .info-card {
            background-color: #f9fafb;
            border-left: 4px solid #3b82f6;
            border-radius: 8px;
            padding: 24px;
            margin: 25px 0;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        
        .info-row:last-child {
            border-bottom: none;
        }
        
        .info-label {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            min-width: 140px;
        }
        
        .info-value {
            font-size: 14px;
            color: #111827;
            text-align: right;
            font-weight: 500;
        }
        
        .info-value.highlight {
            color: #3b82f6;
            font-weight: 700;
            font-size: 18px;
        }
        
        .info-value.price {
            color: #059669;
            font-weight: 700;
            font-size: 18px;
        }
        
        /* Status Badge */
        .status-badge {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .status-badge.menunggu {
            background-color: #fef3c7;
            color: #92400e;
        }
        
        .status-badge.diterima {
            background-color: #d1fae5;
            color: #065f46;
        }
        
        .status-badge.ditolak {
            background-color: #fee2e2;
            color: #991b1b;
        }
        
        .status-badge.diproses {
            background-color: #dbeafe;
            color: #1e40af;
        }
        
        /* Button */
        .email-button {
            display: inline-block;
            margin-top: 30px;
            padding: 14px 32px;
            background-color: #3b82f6;
            color: #ffffff !important;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            font-size: 16px;
            text-align: center;
        }
        
        .email-button:hover {
            background-color: #2563eb;
        }
        
        /* Footer */
        .email-footer {
            background-color: #f9fafb;
            padding: 30px;
            text-align: center;
            border-top: 1px solid #e5e7eb;
        }
        
        .email-footer p {
            margin: 8px 0;
            font-size: 13px;
            color: #6b7280;
            line-height: 1.6;
        }
        
        .email-footer .company-name {
            font-weight: 600;
            color: #374151;
            font-size: 14px;
        }
        
        /* Mobile Responsive */
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                border-radius: 0 !important;
            }
            
            .email-header,
            .email-content,
            .email-footer {
                padding: 25px 20px !important;
            }
            
            .email-header h1 {
                font-size: 24px !important;
            }
            
            .email-title {
                font-size: 20px !important;
            }
            
            .info-row {
                flex-direction: column;
                gap: 5px;
            }
            
            .info-label {
                min-width: auto;
            }
            
            .info-value {
                text-align: left;
            }
            
            .email-button {
                display: block;
                width: 100%;
                padding: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="email-container">
            <!-- Header -->
            <div class="email-header">
                <h1>POLJAM TECH</h1>
                <span class="badge">Pesanan Baru</span>
            </div>
            
            <!-- Content -->
            <div class="email-content">
                <h2 class="email-title">Ada Pesanan Baru Masuk!</h2>
                <p class="email-subtitle">Seseorang telah melakukan pemesanan produk di website Anda.</p>
                
                <!-- Order Info Card -->
                <div class="info-card">
                    <div class="info-row">
                        <span class="info-label">ID Pesanan</span>
                        <span class="info-value highlight">#{{ $order->id }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Nama Customer</span>
                        <span class="info-value">{{ $order->customer_name }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Email</span>
                        <span class="info-value">{{ $order->customer_email }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Telepon</span>
                        <span class="info-value">{{ $order->phone_number ?? '-' }}</span>
                    </div>
                    @if($order->address)
                    <div class="info-row">
                        <span class="info-label">Alamat</span>
                        <span class="info-value" style="text-align: right; max-width: 60%;">{{ $order->address }}</span>
                    </div>
                    @endif
                    <div class="info-row">
                        <span class="info-label">Produk</span>
                        <span class="info-value">{{ $order->product->product_title ?? 'N/A' }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Jumlah</span>
                        <span class="info-value">{{ $order->quantity }} unit</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Harga per Unit</span>
                        <span class="info-value">Rp {{ number_format($order->price, 0, ',', '.') }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Metode Pembayaran</span>
                        <span class="info-value">
                            @php
                                $paymentMethods = [
                                    'transfer' => 'Transfer Bank',
                                    'cod' => 'Cash on Delivery',
                                    'dp' => 'Down Payment',
                                    'midtrans' => 'Midtrans'
                                ];
                            @endphp
                            {{ $paymentMethods[$order->payment_method] ?? strtoupper($order->payment_method) }}
                        </span>
                    </div>
                    @if($order->dp_percentage)
                    <div class="info-row">
                        <span class="info-label">DP Percentage</span>
                        <span class="info-value">{{ number_format($order->dp_percentage, 0) }}%</span>
                    </div>
                    @endif
                    <div class="info-row">
                        <span class="info-label">Total Harga</span>
                        <span class="info-value price">Rp {{ number_format($order->total_price, 0, ',', '.') }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Status Pesanan</span>
                        <span class="info-value">
                            <span class="status-badge {{ strtolower($order->order_status ?? 'menunggu') }}">
                                {{ ucfirst($order->order_status ?? 'Menunggu') }}
                            </span>
                        </span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Status Pembayaran</span>
                        <span class="info-value">
                            <span class="status-badge {{ strtolower($order->status ?? 'menunggu') }}">
                                {{ ucfirst($order->status ?? 'Menunggu') }}
                            </span>
                        </span>
                    </div>
                    @if($order->order_type)
                    <div class="info-row">
                        <span class="info-label">Tipe Pesanan</span>
                        <span class="info-value">{{ ucfirst($order->order_type) }}</span>
                    </div>
                    @endif
                    <div class="info-row">
                        <span class="info-label">Tanggal</span>
                        <span class="info-value">{{ $order->created_at->format('d/m/Y H:i') }}</span>
                    </div>
                </div>
                
                <!-- Action Button -->
                <div style="text-align: center;">
                    <a href="{{ route('admin.master.orders.show', $order->id) }}" class="email-button">
                        Lihat Detail Pesanan
                    </a>
                </div>
            </div>
            
            <!-- Footer -->
            <div class="email-footer">
                <p class="company-name">POLJAM TECH</p>
                <p>Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi</p>
                <p>Email ini dikirim secara otomatis dari sistem. Jangan balas email ini.</p>
                <p style="margin-top: 15px; color: #9ca3af; font-size: 12px;">
                    &copy; {{ date('Y') }} POLJAM TECH. All rights reserved.
                </p>
            </div>
        </div>
    </div>
</body>
</html>
