@props(['icon' => 'fas fa-inbox', 'title', 'message', 'action' => null, 'image' => null])

<div class="text-center py-12 px-4">
    @if($image)
        <img src="{{ $image }}" alt="Empty State" class="w-32 h-32 mx-auto mb-4 opacity-50">
    @else
        <div class="w-20 h-20 mx-auto bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-4">
            <i class="{{ $icon }} text-4xl text-gray-400 dark:text-gray-500"></i>
        </div>
    @endif
    
    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">{{ $title }}</h3>
    <p class="text-gray-600 dark:text-gray-400 mb-6 max-w-md mx-auto">{{ $message }}</p>
    
    @if($action)
        <div class="flex flex-col sm:flex-row gap-3 justify-center items-center">
            @if(isset($action['primary']))
                <a href="{{ $action['primary']['url'] }}" 
                   class="inline-flex items-center px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg font-medium transition-all duration-200 shadow-md hover:shadow-lg transform hover:-translate-y-0.5">
                    <i class="{{ $action['primary']['icon'] ?? 'fas fa-plus' }} mr-2"></i>
                    {{ $action['primary']['label'] }}
                </a>
            @endif
            @if(isset($action['secondary']))
                <a href="{{ $action['secondary']['url'] }}" 
                   class="inline-flex items-center px-6 py-3 bg-gray-100 hover:bg-gray-200 dark:bg-gray-700 dark:hover:bg-gray-600 text-gray-900 dark:text-white rounded-lg font-medium transition-all duration-200">
                    <i class="{{ $action['secondary']['icon'] ?? 'fas fa-info' }} mr-2"></i>
                    {{ $action['secondary']['label'] }}
                </a>
            @endif
        </div>
    @endif
</div>

