@extends('layouts.auth')

@section('title', __('Create New Password'))
@section('subtitle', __('Enter your new password to regain access'))

@section('content')
    <!-- Session Status -->
    <x-auth-session-status
        class="mb-3 bg-emerald-50 border border-emerald-200 text-emerald-800 px-2 py-1.5 rounded-lg text-xs flex items-center"
        :status="session('status')" />

    <form method="POST" action="{{ route('password.store') }}" class="space-y-4">
        @csrf

        <!-- Password Reset Token -->
        <input type="hidden" name="token" value="{{ $request->route('token') }}">

        <!-- Email Address -->
        <div>
            <x-input-label for="email" :value="__('Email')" class="block text-xs font-semibold text-gray-800 mb-1" />
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-2.5 flex items-center pointer-events-none">
                    <svg class="h-3.5 w-3.5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                        </path>
                    </svg>
                </div>
                <x-text-input id="email"
                    class="block w-full pl-8 pr-3 py-2 rounded-lg border-2 border-gray-200 text-gray-900 placeholder-gray-400 transition duration-200 focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-200 text-xs bg-gray-50"
                    type="email" name="email" :value="old('email', $request->email)" placeholder="email@example.com" required autofocus
                    autocomplete="username" readonly />
            </div>
            <x-input-error :messages="$errors->get('email')" class="mt-0.5 text-xs text-red-600 font-medium" />
        </div>

        <!-- Password -->
        <div>
            <x-input-label for="password" :value="__('New Password')" class="block text-xs font-semibold text-gray-800 mb-1" />
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-2.5 flex items-center pointer-events-none">
                    <svg class="h-3.5 w-3.5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                        </path>
                    </svg>
                </div>
                <x-text-input id="password"
                    class="block w-full pl-8 pr-3 py-2 rounded-lg border-2 border-gray-200 text-gray-900 placeholder-gray-400 transition duration-200 focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-200 text-xs"
                    type="password" name="password" placeholder="••••••••" required autocomplete="new-password" />
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-0.5 text-xs text-red-600 font-medium" />
        </div>

        <!-- Confirm Password -->
        <div>
            <x-input-label for="password_confirmation" :value="__('Confirm Password')"
                class="block text-xs font-semibold text-gray-800 mb-1" />
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-2.5 flex items-center pointer-events-none">
                    <svg class="h-3.5 w-3.5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <x-text-input id="password_confirmation"
                    class="block w-full pl-8 pr-3 py-2 rounded-lg border-2 border-gray-200 text-gray-900 placeholder-gray-400 transition duration-200 focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-200 text-xs"
                    type="password" name="password_confirmation" placeholder="••••••••" required
                    autocomplete="new-password" />
            </div>
            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-0.5 text-xs text-red-600 font-medium" />
        </div>

        <!-- Submit Button -->
        <button type="submit"
            class="w-full mt-4 bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-bold py-2 px-4 rounded-lg transition duration-300 transform hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 shadow-md text-xs">
            {{ __('Reset Password') }}
        </button>
    </form>
@endsection

@section('footer_links')
    <div class="border-t border-gray-200 pt-3 text-center">
        <p class="text-gray-700 text-xs">
            {{ __('Remembered your password?') }}
            <a href="{{ route('login') }}"
                class="text-blue-600 hover:text-blue-800 font-bold transition duration-200 hover:underline">
                {{ __('Sign in') }}
            </a>
        </p>
    </div>
@endsection

@section('additional_info')
    🔒 Enterprise-Grade Security
@endsection
