@extends('layouts.auth')

@section('title', 'Ganti Password Wajib')
@section('subtitle', 'Anda wajib mengganti password sebelum melanjutkan')

@section('content')
    <!-- Warning Message -->
    @if (session('warning'))
        <div class="mb-4 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
            <div class="flex items-start">
                <i class="fas fa-exclamation-triangle text-yellow-600 mr-2 mt-0.5"></i>
                <p class="text-xs text-yellow-800 leading-relaxed">{{ session('warning') }}</p>
            </div>
        </div>
    @endif

    <!-- Info Message -->
    <div class="mb-4 p-4 bg-blue-50 border border-blue-200 rounded-lg">
        <div class="flex items-start">
            <i class="fas fa-info-circle text-blue-600 mr-2 mt-0.5"></i>
            <div>
                <p class="text-xs font-semibold text-blue-900 mb-1">Password Anda Telah Direset</p>
                <p class="text-xs text-blue-800 leading-relaxed">
                    Administrator telah mereset password akun Anda. Untuk keamanan, Anda <strong>wajib</strong> mengganti password ini dengan password baru yang Anda pilih sendiri.
                </p>
            </div>
        </div>
    </div>

    <!-- Security Tips -->
    <div class="mb-6 p-4 bg-gray-50 border border-gray-200 rounded-lg">
        <p class="text-xs font-semibold text-gray-900 mb-2">💡 Tips Password yang Kuat:</p>
        <ul class="text-xs text-gray-700 space-y-1 list-disc list-inside">
            <li>Minimal 8 karakter</li>
            <li>Kombinasi huruf besar, huruf kecil, dan angka</li>
            <li>Gunakan karakter khusus jika memungkinkan</li>
            <li>Jangan gunakan informasi pribadi (nama, tanggal lahir, dll)</li>
            <li>Jangan gunakan password yang sama dengan akun lain</li>
        </ul>
    </div>

    <form method="POST" action="{{ route('password.force-change.store') }}" class="space-y-4">
        @csrf

        <!-- Password -->
        <div>
            <x-input-label for="password" :value="__('Password Baru')" class="block text-xs font-semibold text-gray-800 mb-1" />
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-2.5 flex items-center pointer-events-none">
                    <svg class="h-3.5 w-3.5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                        </path>
                    </svg>
                </div>
                <x-text-input id="password"
                    class="block w-full pl-8 pr-3 py-2 rounded-lg border-2 border-gray-200 text-gray-900 placeholder-gray-400 transition duration-200 focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-200 text-xs"
                    type="password" name="password" placeholder="Masukkan password baru" required autofocus
                    autocomplete="new-password" />
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-0.5 text-xs text-red-600 font-medium" />
            <p class="mt-1 text-xs text-gray-500">Minimal 8 karakter</p>
        </div>

        <!-- Confirm Password -->
        <div>
            <x-input-label for="password_confirmation" :value="__('Konfirmasi Password Baru')"
                class="block text-xs font-semibold text-gray-800 mb-1" />
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-2.5 flex items-center pointer-events-none">
                    <svg class="h-3.5 w-3.5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <x-text-input id="password_confirmation"
                    class="block w-full pl-8 pr-3 py-2 rounded-lg border-2 border-gray-200 text-gray-900 placeholder-gray-400 transition duration-200 focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-200 text-xs"
                    type="password" name="password_confirmation" placeholder="Ulangi password baru" required
                    autocomplete="new-password" />
            </div>
            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-0.5 text-xs text-red-600 font-medium" />
        </div>

        <!-- Submit Button -->
        <button type="submit"
            class="w-full mt-4 bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-bold py-2.5 px-4 rounded-lg transition duration-300 transform hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 shadow-md text-xs">
            <i class="fas fa-key mr-2"></i>
            Ganti Password dan Lanjutkan
        </button>
    </form>
@endsection

@section('footer_links')
    <div class="border-t border-gray-200 pt-3 text-center">
        <p class="text-gray-700 text-xs">
            <i class="fas fa-shield-alt mr-1"></i>
            Password Anda akan dienkripsi dengan teknologi keamanan tingkat enterprise
        </p>
    </div>
@endsection

@section('additional_info')
    🔒 Keamanan adalah Prioritas Utama
@endsection

