@extends('layouts.auth')

@section('title', __('Confirm Password'))
@section('subtitle', __('For security, please confirm your password'))

@section('content')
    <!-- Info Message -->
    <div class="mb-4 p-3 bg-yellow-50 border border-yellow-200 rounded-lg flex items-start">
        <svg class="h-4 w-4 text-yellow-600 mt-0.5 mr-2 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd"
                d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z"
                clip-rule="evenodd"></path>
        </svg>
        <p class="text-xs text-yellow-800 leading-relaxed">
            {{ __('This is a secure area of the application. Please confirm your password before continuing.') }}
        </p>
    </div>

    <!-- Session Status -->
    <x-auth-session-status
        class="mb-3 bg-emerald-50 border border-emerald-200 text-emerald-800 px-2 py-1.5 rounded-lg text-xs flex items-center"
        :status="session('status')" />

    <form method="POST" action="{{ route('password.confirm') }}" class="space-y-4">
        @csrf

        <!-- Password -->
        <div>
            <x-input-label for="password" :value="__('Password')" class="block text-xs font-semibold text-gray-800 mb-1" />
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-2.5 flex items-center pointer-events-none">
                    <svg class="h-3.5 w-3.5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                        </path>
                    </svg>
                </div>
                <x-text-input id="password"
                    class="block w-full pl-8 pr-3 py-2 rounded-lg border-2 border-gray-200 text-gray-900 placeholder-gray-400 transition duration-200 focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-200 text-xs"
                    type="password" name="password" placeholder="••••••••" required autocomplete="current-password" />
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-0.5 text-xs text-red-600 font-medium" />
        </div>

        <!-- Submit Button -->
        <button type="submit"
            class="w-full mt-4 bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-bold py-2 px-4 rounded-lg transition duration-300 transform hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 shadow-md text-xs">
            {{ __('Confirm Password') }}
        </button>
    </form>
@endsection

@section('footer_links')
    <div class="border-t border-gray-200 pt-3 text-center">
        <p class="text-gray-700 text-xs">
            {{ __('Need help?') }}
            <a href="{{ route('login') }}"
                class="text-blue-600 hover:text-blue-800 font-bold transition duration-200 hover:underline">
                {{ __('Back to login') }}
            </a>
        </p>
    </div>
@endsection

@section('additional_info')
    🔒 Enterprise-Grade Security
@endsection
