@extends('layouts.admin')

@section('title', 'Edit User')

@section('content')
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.users.index') }}" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Edit User</h1>
        </div>
    </div>

    <!-- Form Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
        <div class="p-6">

        <form action="{{ route('admin.users.update', $user->id) }}" method="POST" enctype="multipart/form-data" class="space-y-6">
            @csrf
            @method('PUT')

            <!-- Nama -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Nama Lengkap <span class="text-red-500">*</span>
                </label>
                <input type="text" name="name" id="name" value="{{ old('name', $user->name) }}" required
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('name') border-red-500 dark:border-red-500 @enderror"
                    placeholder="Masukkan nama lengkap">
                @error('name')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Email -->
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Email <span class="text-red-500">*</span>
                </label>
                <input type="email" name="email" id="email" value="{{ old('email', $user->email) }}" required
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('email') border-red-500 dark:border-red-500 @enderror"
                    placeholder="Masukkan email">
                @error('email')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Password Info -->
            <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-700 rounded-lg p-4">
                <div class="flex items-start">
                    <i class="fas fa-info-circle text-yellow-600 dark:text-yellow-400 mr-2 mt-0.5"></i>
                    <div>
                        <p class="text-sm font-medium text-yellow-900 dark:text-yellow-200 mb-1">Password Management</p>
                        <p class="text-xs text-yellow-800 dark:text-yellow-300">
                            Admin tidak dapat mengubah password langsung melalui form ini untuk keamanan. 
                            Gunakan tombol <strong>"Reset Password"</strong> di halaman daftar user untuk mereset password user. 
                            User akan menerima email notifikasi dan wajib mengganti password saat login pertama kali.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Role -->
            <div>
                <label for="user_type" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Role <span class="text-red-500">*</span>
                </label>
                <select name="user_type" id="user_type" required
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('user_type') border-red-500 dark:border-red-500 @enderror">
                    <option value="">-- Pilih Role --</option>
                    <option value="user" {{ old('user_type', $user->user_type) == 'user' ? 'selected' : '' }}>User</option>
                    <option value="teknisi" {{ old('user_type', $user->user_type) == 'teknisi' ? 'selected' : '' }}>Teknisi</option>
                    <option value="supervisor" {{ old('user_type', $user->user_type) == 'supervisor' ? 'selected' : '' }}>Supervisor</option>
                </select>
                <p class="mt-2 text-xs text-gray-500 dark:text-gray-400">
                    <i class="fas fa-info-circle mr-1"></i>
                    Role Admin tidak dapat diubah melalui menu ini.
                </p>
                @error('user_type')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Info Box -->
            <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4">
                <div class="flex items-start">
                    <i class="fas fa-info-circle text-blue-600 dark:text-blue-400 mr-2 mt-0.5"></i>
                    <div>
                        <p class="text-sm font-medium text-blue-900 dark:text-blue-200 mb-1">Informasi Tambahan</p>
                        <p class="text-xs text-blue-800 dark:text-blue-300">
                            Field di bawah ini (Telepon, Alamat, Kode Pos, Foto Profil) bersifat opsional. 
                            User juga dapat mengisi informasi lengkap mereka sendiri melalui menu Edit Profile setelah login.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Phone -->
            <div>
                <label for="phone" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Telepon <span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>
                </label>
                <input type="text" name="phone" id="phone" value="{{ old('phone', $user->phone) }}"
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('phone') border-red-500 dark:border-red-500 @enderror"
                    placeholder="Masukkan nomor telepon">
                @error('phone')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Address -->
            <div>
                <label for="address" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Alamat <span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>
                </label>
                <textarea name="address" id="address" rows="3"
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('address') border-red-500 dark:border-red-500 @enderror"
                    placeholder="Masukkan alamat lengkap">{{ old('address', $user->address) }}</textarea>
                @error('address')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Postal Code -->
            <div>
                <label for="postal_code" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Kode Pos <span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>
                </label>
                <input type="text" name="postal_code" id="postal_code" value="{{ old('postal_code', $user->postal_code) }}"
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('postal_code') border-red-500 dark:border-red-500 @enderror"
                    placeholder="Masukkan kode pos">
                @error('postal_code')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Photo -->
            <div>
                <label for="photo" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Foto Profil <span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>
                </label>
                <div class="relative">
                    <input type="file" name="photo" id="photo" accept="image/*"
                        class="w-full px-4 py-3 text-sm text-gray-700 dark:text-gray-300 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 rounded-lg cursor-pointer focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 dark:file:bg-blue-900 dark:file:text-blue-200 @error('photo') border-red-500 dark:border-red-500 @enderror">
                </div>
                <p class="mt-2 text-xs text-gray-500 dark:text-gray-400">
                    <i class="fas fa-info-circle mr-1"></i>
                    Format: JPG, PNG, GIF, WEBP. Maksimal 2MB. Upload foto baru untuk menggantinya.
                </p>
                @if($user->photo && \Storage::disk('uploads')->exists('profiles/' . $user->photo))
                    <p class="mt-1 text-xs text-green-600 dark:text-green-400">
                        <i class="fas fa-check-circle mr-1"></i>
                        Foto saat ini sudah ada. Upload foto baru untuk menggantinya.
                    </p>
                @endif
                @error('photo')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror

                <!-- Preview -->
                <div class="mt-4">
                    @php
                        $hasPhoto = false;
                        $photoUrl = '';
                        if ($user->photo) {
                            // Handle jika photo sudah berisi path 'profiles/' atau hanya filename
                            $photoPath = (strpos($user->photo, 'profiles/') === 0) 
                                ? $user->photo 
                                : 'profiles/' . $user->photo;
                            
                            // Cek apakah file exists
                            if (\Storage::disk('uploads')->exists($photoPath)) {
                                $hasPhoto = true;
                                // Untuk URL, gunakan path yang benar
                                $photoFileName = (strpos($user->photo, 'profiles/') === 0) 
                                    ? $user->photo 
                                    : 'profiles/' . $user->photo;
                                $photoUrl = asset('uploads/' . $photoFileName);
                            }
                        }
                    @endphp
                    <div class="flex items-center justify-center w-32 h-32 bg-gray-50 dark:bg-gray-700/50 rounded-lg border-2 {{ $hasPhoto ? 'border-solid border-gray-200 dark:border-gray-600' : 'border-dashed border-gray-300 dark:border-gray-600' }} overflow-hidden" id="previewContainer">
                        <img id="previewImage" class="w-full h-full object-contain rounded-lg" 
                             src="{{ $photoUrl }}"
                             alt="Preview foto profil"
                             style="{{ $hasPhoto ? 'display: block;' : 'display: none;' }} background: transparent;"
                             onerror="this.style.display='none'; document.getElementById('previewPlaceholder').style.display='block';">
                        <div id="previewPlaceholder" class="text-center" style="{{ $hasPhoto ? 'display: none;' : 'display: block;' }}">
                            <i class="fas fa-user text-4xl text-gray-400 dark:text-gray-500 mb-2"></i>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Preview foto</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Buttons -->
            <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200 dark:border-gray-700">
                <a href="{{ route('admin.users.index') }}"
                    class="px-6 py-3 text-gray-600 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200 font-medium">
                    Batal
                </a>
                <button type="submit"
                    class="px-6 py-3 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200 flex items-center space-x-2">
                    <i class="fas fa-save"></i>
                    <span>Perbarui User</span>
                </button>
            </div>
        </form>
    </div>
    </div>

    <!-- Script Preview Foto -->
    <script>
        const photoInput = document.getElementById('photo');
        const preview = document.getElementById('previewImage');
        const placeholder = document.getElementById('previewPlaceholder');
        const container = document.getElementById('previewContainer');
        const originalImage = '{{ $photoUrl }}';

        // Inisialisasi saat halaman dimuat - pastikan foto yang sudah ada ditampilkan
        document.addEventListener('DOMContentLoaded', function() {
            if (originalImage && originalImage.trim() !== '' && preview.src !== originalImage) {
                preview.src = originalImage;
                preview.style.display = 'block';
                preview.style.background = 'transparent';
                preview.classList.add('rounded-lg');
                placeholder.style.display = 'none';
                container.classList.remove('border-dashed');
                container.classList.add('border-solid', 'border-gray-200', 'dark:border-gray-600');
            }
        });

        photoInput.addEventListener('change', function(event) {
            const file = event.target.files[0];
            
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                    preview.style.background = 'transparent';
                    preview.classList.add('rounded-lg');
                    placeholder.style.display = 'none';
                    container.classList.remove('border-dashed');
                    container.classList.add('border-solid', 'border-gray-200', 'dark:border-gray-600');
                };
                reader.readAsDataURL(file);
            } else {
                // Jika tidak ada file yang dipilih, kembali ke gambar asli atau placeholder
                if (originalImage) {
                    preview.src = originalImage;
                    preview.style.display = 'block';
                    preview.style.background = 'transparent';
                    preview.classList.add('rounded-lg');
                    placeholder.style.display = 'none';
                    container.classList.remove('border-dashed');
                    container.classList.add('border-solid', 'border-gray-200', 'dark:border-gray-600');
                } else {
                    preview.src = '';
                    preview.style.display = 'none';
                    preview.classList.remove('rounded-lg');
                    placeholder.style.display = 'block';
                    container.classList.add('border-dashed');
                    container.classList.remove('border-solid');
                }
            }
        });
    </script>
@endsection

