@extends('layouts.admin')

@section('title', 'Daftar Pembelian - ' . $purchase->purchase_code)

@section('content')
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.transaksi.purchases.index') }}" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Daftar Pembelian</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    {{ $purchase->purchase_code }} • {{ \Carbon\Carbon::parse($purchase->purchase_date)->format('d M Y') }}
                </p>
            </div>
        </div>
        <div class="flex items-center space-x-2">
            <!-- Dropdown Cetak PDF -->
            <div class="relative group">
                <button class="flex items-center bg-blue-500 hover:bg-blue-600 text-white font-medium py-2 px-4 rounded-lg transition-colors duration-200">
                    <i class="fas fa-file-pdf mr-2 text-sm"></i>
                    <span>Cetak PDF</span>
                    <i class="fas fa-chevron-down ml-2 text-xs"></i>
                </button>
                <div class="absolute right-0 mt-2 w-56 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 shadow-lg opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                    <div class="py-2">
                        <a href="{{ route('admin.transaksi.purchases.preview-pdf', $purchase->id) }}" target="_blank"
                            class="flex items-center px-4 py-2.5 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <i class="fas fa-eye mr-3 text-blue-600 dark:text-blue-400"></i>
                            <div>
                                <div class="font-medium">Preview PDF</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">Lihat sebelum cetak</div>
                            </div>
                        </a>
                        <a href="{{ route('admin.transaksi.purchases.download-pdf', $purchase->id) }}"
                            class="flex items-center px-4 py-2.5 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <i class="fas fa-file-download mr-3 text-green-600 dark:text-green-400"></i>
                            <div>
                                <div class="font-medium">Download PDF</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">Simpan file PDF</div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
            <button onclick="confirmDelete({{ $purchase->id }})"
                class="inline-flex items-center px-4 py-2 bg-red-500 hover:bg-red-600 text-white font-medium rounded-lg transition-colors duration-200">
                <i class="fas fa-trash mr-2"></i>
                Hapus
            </button>
        </div>
    </div>

    <!-- Main Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 mb-4">
        <!-- Supplier Information -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                    <i class="fas fa-store text-green-600 dark:text-green-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Supplier</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Nama:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ $purchase->supplier_name ?? 'Tidak disebutkan' }}</span>
                </div>
            </div>
        </div>

        <!-- Purchase Date & Type -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                    <i class="fas fa-calendar-alt text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Tanggal Pembelian</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Tanggal:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100">{{ \Carbon\Carbon::parse($purchase->purchase_date)->format('d M Y') }}</span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Tipe:</span>
                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium
                        {{ $purchase->purchase_type === 'material' ? 'bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300' : 'bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300' }}">
                        <i class="fas {{ $purchase->purchase_type === 'material' ? 'fa-cube' : 'fa-cog' }} mr-1 text-[10px]"></i>
                        {{ $purchase->purchase_type === 'material' ? 'Material' : 'Sparepart' }}
                    </span>
                </div>
            </div>
        </div>

        <!-- Total Amount -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-emerald-100 dark:bg-emerald-900/40 rounded-lg mr-2">
                    <i class="fas fa-money-bill-wave text-emerald-600 dark:text-emerald-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Total Pembelian</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Total:</span>
                    <span class="text-base font-bold text-emerald-600 dark:text-emerald-400">Rp {{ number_format($purchase->total_amount, 0, ',', '.') }}</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Items Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-base font-semibold text-gray-800 dark:text-white flex items-center">
                <i class="fas fa-list-ul mr-2 text-blue-600 dark:text-blue-400"></i>
                Daftar Item Pembelian
            </h3>
            <span class="px-2.5 py-1 bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300 rounded-md text-xs font-medium">
                {{ $purchase->items->count() }} item
            </span>
        </div>
        
        <div class="overflow-x-auto rounded-lg border border-gray-200 dark:border-gray-600">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">No</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Item</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Unit</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Quantity</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Harga Satuan</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Total</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-600">
                    @foreach ($purchase->items as $item)
                        @php
                            $itemData = null;
                            $imageUrl = asset('images/no-image.png');

                            if ($item->item_type === 'material' && $item->item_id) {
                                $itemData = \App\Models\Material::find($item->item_id);
                                if ($itemData && $itemData->image) {
                                    $imageUrl = asset('uploads/materials/' . $itemData->image);
                                }
                            } elseif ($item->item_type === 'sparepart' && $item->item_id) {
                                $itemData = \App\Models\Sparepart::find($item->item_id);
                                if ($itemData && $itemData->image) {
                                    $imageUrl = asset('uploads/spareparts/' . $itemData->image);
                                }
                            }
                        @endphp
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors duration-150">
                            <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-gray-100">
                                {{ $loop->iteration }}
                            </td>
                            <td class="px-4 py-3">
                                <div class="flex items-center">
                                    <img src="{{ $imageUrl }}" alt="{{ $item->item_name }}"
                                        class="h-12 w-12 object-contain rounded-lg border border-gray-200 dark:border-gray-600 mr-3"
                                        style="background: transparent;"
                                        onerror="this.src='{{ asset('images/no-image.png') }}'">
                                    <div>
                                        <p class="font-semibold text-gray-900 dark:text-white text-sm">{{ $item->item_name }}</p>
                                        <div class="flex items-center gap-2 mt-1">
                                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium
                                                {{ $item->item_type === 'material' ? 'bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300' : 'bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300' }}">
                                                <i class="fas {{ $item->item_type === 'material' ? 'fa-cube' : 'fa-cog' }} mr-1 text-[10px]"></i>
                                                {{ ucfirst($item->item_type) }}
                                            </span>
                                            @if ($itemData)
                                                <span class="text-xs text-gray-500 dark:text-gray-400">
                                                    @if ($item->item_type === 'material')
                                                        {{ $itemData->material_code ?? '-' }}
                                                        @if($itemData->category) • {{ $itemData->category }} @endif
                                                    @else
                                                        {{ $itemData->part_code ?? '-' }}
                                                        @if($itemData->brand) • {{ $itemData->brand }} @endif
                                                    @endif
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-4 py-3 text-center text-sm text-gray-700 dark:text-gray-300">
                                {{ $item->unit ?? '-' }}
                            </td>
                            <td class="px-4 py-3 text-right text-sm font-semibold text-gray-900 dark:text-gray-100">
                                {{ number_format($item->quantity, 0, ',', '.') }}
                            </td>
                            <td class="px-4 py-3 text-right text-sm text-gray-700 dark:text-gray-300">
                                Rp {{ number_format($item->unit_price, 0, ',', '.') }}
                            </td>
                            <td class="px-4 py-3 text-right text-sm font-bold text-gray-900 dark:text-gray-100">
                                Rp {{ number_format($item->total_price, 0, ',', '.') }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot class="bg-gray-50 dark:bg-gray-700 border-t-2 border-gray-300 dark:border-gray-600">
                    <tr>
                        <td colspan="5" class="px-4 py-3 text-right text-sm font-bold text-gray-800 dark:text-gray-200 uppercase">
                            Total Pembelian:
                        </td>
                        <td class="px-4 py-3 text-right text-base font-bold text-emerald-600 dark:text-emerald-400">
                            Rp {{ number_format($purchase->total_amount, 0, ',', '.') }}
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <!-- Notes Section -->
    @if ($purchase->notes)
        <div class="mt-4 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg mr-2">
                    <i class="fas fa-sticky-note text-yellow-600 dark:text-yellow-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Catatan Pembelian</h3>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700/50 rounded-lg p-3 border border-gray-200 dark:border-gray-600">
                <p class="text-xs text-gray-700 dark:text-gray-300 leading-relaxed">{{ $purchase->notes }}</p>
            </div>
        </div>
    @endif

    <!-- Document Footer Info -->
    <div class="mt-4 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm text-gray-600 dark:text-gray-400">
            <div>
                <p class="font-medium mb-1 text-gray-700 dark:text-gray-300">Dibuat pada:</p>
                <p class="text-xs">{{ \Carbon\Carbon::parse($purchase->created_at)->format('d F Y, H:i') }} WIB</p>
            </div>
            <div>
                <p class="font-medium mb-1 text-gray-700 dark:text-gray-300">Terakhir diperbarui:</p>
                <p class="text-xs">{{ \Carbon\Carbon::parse($purchase->updated_at)->format('d F Y, H:i') }} WIB</p>
            </div>
        </div>
    </div>

    <!-- Delete Form (Hidden) -->
    <form id="delete-form-{{ $purchase->id }}" action="{{ route('admin.transaksi.purchases.destroy', $purchase->id) }}"
        method="POST" class="hidden">
        @csrf
        @method('DELETE')
    </form>

    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Hapus Daftar Pembelian?',
                html: '<p class="text-sm text-gray-600 dark:text-gray-400">Data pembelian ini akan dihapus secara permanen!</p><p class="text-xs text-red-600 dark:text-red-400 mt-2"><i class="fas fa-exclamation-triangle mr-1"></i>Tindakan ini tidak dapat dibatalkan.</p>',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc2626',
                cancelButtonColor: '#6b7280',
                confirmButtonText: '<i class="fas fa-trash mr-2"></i>Ya, Hapus',
                cancelButtonText: '<i class="fas fa-times mr-2"></i>Batal',
                reverseButtons: true,
                customClass: {
                    popup: 'rounded-lg',
                    confirmButton: 'px-4 py-2 rounded-md font-medium',
                    cancelButton: 'px-4 py-2 rounded-md font-medium'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
@endsection
