@extends('layouts.admin')

@section('title', 'Pengaturan Sistem')

@section('content')
    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Pengaturan Sistem</h1>
        <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">Kelola pengaturan aplikasi, perusahaan, email, pembayaran,
            dan sistem</p>
    </div>

    <!-- Notifikasi Modern -->
    <x-admin-notification />

    <!-- Tab Navigation -->
    <div class="mb-6">
        <div class="border-b border-gray-200 dark:border-gray-700">
            <nav class="-mb-px flex space-x-8 overflow-x-auto">
                <button onclick="switchTab('company')" id="tab-company"
                    class="tab-button py-2 px-1 border-b-2 font-medium text-sm transition-colors duration-200 border-blue-500 text-blue-600 dark:text-blue-400 whitespace-nowrap">
                    <i class="fas fa-building mr-2"></i>Informasi Perusahaan
                </button>
                <button onclick="switchTab('email')" id="tab-email"
                    class="tab-button py-2 px-1 border-b-2 font-medium text-sm transition-colors duration-200 border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300 whitespace-nowrap">
                    <i class="fas fa-envelope mr-2"></i>Pengaturan Email
                </button>
                <button onclick="switchTab('payment')" id="tab-payment"
                    class="tab-button py-2 px-1 border-b-2 font-medium text-sm transition-colors duration-200 border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300 whitespace-nowrap">
                    <i class="fas fa-credit-card mr-2"></i>Pembayaran
                </button>
                <button onclick="switchTab('system')" id="tab-system"
                    class="tab-button py-2 px-1 border-b-2 font-medium text-sm transition-colors duration-200 border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300 whitespace-nowrap">
                    <i class="fas fa-cog mr-2"></i>Sistem
                </button>
            </nav>
        </div>
    </div>

    <!-- Tab Content -->
    <!-- Company Information Tab -->
    <div id="content-company" class="tab-content">
        <form action="{{ route('admin.settings.update') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="group" value="company">

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white mb-4 flex items-center">
                    <i class="fas fa-building mr-2 text-blue-600 dark:text-blue-400"></i>
                    Informasi Perusahaan
                </h2>

                <div class="space-y-4">
                    <!-- Company Logo -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Logo Perusahaan
                        </label>
                        @if (isset($companySettings['company_logo']) && $companySettings['company_logo'])
                            <div class="mb-3">
                                <img src="{{ asset('uploads/' . $companySettings['company_logo']) }}" alt="Company Logo"
                                    class="h-20 w-auto rounded-lg border border-gray-200 dark:border-gray-600">
                            </div>
                        @endif
                        <input type="file" name="company_logo" accept="image/*"
                            class="block w-full text-sm text-gray-500 dark:text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 dark:file:bg-blue-900/40 dark:file:text-blue-300">
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Format: JPG, PNG, GIF, WEBP. Maksimal 2MB
                        </p>
                    </div>

                    <!-- Company Name -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Nama Perusahaan <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="company_name" value="{{ $companySettings['company_name'] ?? '' }}"
                            class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <!-- Company Address -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Alamat Perusahaan
                        </label>
                        <textarea name="company_address" rows="3"
                            class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">{{ $companySettings['company_address'] ?? '' }}</textarea>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Company Phone -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Telepon
                            </label>
                            <input type="text" name="company_phone" value="{{ $companySettings['company_phone'] ?? '' }}"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- Company Email -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Email
                            </label>
                            <input type="email" name="company_email" value="{{ $companySettings['company_email'] ?? '' }}"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <!-- Company Website -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Website
                        </label>
                        <input type="url" name="company_website" value="{{ $companySettings['company_website'] ?? '' }}"
                            placeholder="https://example.com"
                            class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <!-- Company Description -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Deskripsi Perusahaan
                        </label>
                        <textarea name="company_description" rows="4"
                            class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">{{ $companySettings['company_description'] ?? '' }}</textarea>
                    </div>
                </div>

                <div class="mt-6 flex justify-end">
                    <button type="submit"
                        class="px-6 py-2 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-save mr-2"></i>Simpan Perubahan
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Email Settings Tab -->
    <div id="content-email" class="tab-content hidden">
        <form action="{{ route('admin.settings.update') }}" method="POST">
            @csrf
            <input type="hidden" name="group" value="email">

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white mb-4 flex items-center">
                    <i class="fas fa-envelope mr-2 text-green-600 dark:text-green-400"></i>
                    Pengaturan Email
                </h2>

                <div class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- From Name -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Nama Pengirim
                            </label>
                            <input type="text" name="mail_from_name"
                                value="{{ $emailSettings['mail_from_name'] ?? env('MAIL_FROM_NAME', 'POLJAM TECH') }}"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- From Address -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Email Pengirim
                            </label>
                            <input type="email" name="mail_from_address"
                                value="{{ $emailSettings['mail_from_address'] ?? env('MAIL_FROM_ADDRESS', '') }}"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- SMTP Host -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                SMTP Host
                            </label>
                            <input type="text" name="mail_host"
                                value="{{ $emailSettings['mail_host'] ?? env('MAIL_HOST', '') }}"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- SMTP Port -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                SMTP Port
                            </label>
                            <input type="number" name="mail_port"
                                value="{{ $emailSettings['mail_port'] ?? env('MAIL_PORT', '587') }}"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- SMTP Username -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                SMTP Username
                            </label>
                            <input type="text" name="mail_username"
                                value="{{ $emailSettings['mail_username'] ?? env('MAIL_USERNAME', '') }}"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- SMTP Password -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                SMTP Password
                            </label>
                            <input type="password" name="mail_password"
                                value="{{ $emailSettings['mail_password'] ?? '' }}"
                                placeholder="Kosongkan jika tidak ingin mengubah"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <!-- Encryption -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Enkripsi
                        </label>
                        <select name="mail_encryption"
                            class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                            <option value="">Tidak Ada</option>
                            <option value="tls"
                                {{ ($emailSettings['mail_encryption'] ?? env('MAIL_ENCRYPTION', '')) === 'tls' ? 'selected' : '' }}>
                                TLS</option>
                            <option value="ssl"
                                {{ ($emailSettings['mail_encryption'] ?? env('MAIL_ENCRYPTION', '')) === 'ssl' ? 'selected' : '' }}>
                                SSL</option>
                        </select>
                    </div>
                </div>

                <div class="mt-6 flex justify-end">
                    <button type="submit"
                        class="px-6 py-2 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-save mr-2"></i>Simpan Perubahan
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Payment Settings Tab -->
    <div id="content-payment" class="tab-content hidden">
        <form action="{{ route('admin.settings.update') }}" method="POST">
            @csrf
            <input type="hidden" name="group" value="payment">

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white mb-4 flex items-center">
                    <i class="fas fa-credit-card mr-2 text-purple-600 dark:text-purple-400"></i>
                    Pengaturan Pembayaran
                </h2>

                <div class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Midtrans Server Key -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Midtrans Server Key
                            </label>
                            <input type="text" name="midtrans_server_key"
                                value="{{ $paymentSettings['midtrans_server_key'] ?? env('MIDTRANS_SERVER_KEY', '') }}"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- Midtrans Client Key -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Midtrans Client Key
                            </label>
                            <input type="text" name="midtrans_client_key"
                                value="{{ $paymentSettings['midtrans_client_key'] ?? env('MIDTRANS_CLIENT_KEY', '') }}"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <!-- Production Mode -->
                    <div>
                        <label class="flex items-center">
                            <input type="checkbox" name="midtrans_is_production" value="1"
                                {{ ($paymentSettings['midtrans_is_production'] ?? '0') === '1' ? 'checked' : '' }}
                                class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                            <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Mode Production (Aktifkan untuk
                                transaksi real)</span>
                        </label>
                    </div>

                    <div class="border-t border-gray-200 dark:border-gray-700 pt-4 mt-4">
                        <h3 class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-3">Metode Pembayaran</h3>

                        <div class="space-y-2">
                            <label class="flex items-center">
                                <input type="checkbox" name="payment_method_bank_transfer" value="1"
                                    {{ ($paymentSettings['payment_method_bank_transfer'] ?? '1') === '1' ? 'checked' : '' }}
                                    class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Transfer Bank</span>
                            </label>

                            <label class="flex items-center">
                                <input type="checkbox" name="payment_method_credit_card" value="1"
                                    {{ ($paymentSettings['payment_method_credit_card'] ?? '1') === '1' ? 'checked' : '' }}
                                    class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Kartu Kredit</span>
                            </label>

                            <label class="flex items-center">
                                <input type="checkbox" name="payment_method_ewallet" value="1"
                                    {{ ($paymentSettings['payment_method_ewallet'] ?? '1') === '1' ? 'checked' : '' }}
                                    class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">E-Wallet</span>
                            </label>
                        </div>
                    </div>
                </div>

                <div class="mt-6 flex justify-end">
                    <button type="submit"
                        class="px-6 py-2 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-save mr-2"></i>Simpan Perubahan
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- System Settings Tab -->
    <div id="content-system" class="tab-content hidden">
        <form action="{{ route('admin.settings.update') }}" method="POST">
            @csrf
            <input type="hidden" name="group" value="system">

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white mb-4 flex items-center">
                    <i class="fas fa-cog mr-2 text-indigo-600 dark:text-indigo-400"></i>
                    Pengaturan Sistem
                </h2>

                <div class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Timezone -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Timezone
                            </label>
                            <select name="timezone"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                                <option value="Asia/Jakarta"
                                    {{ ($systemSettings['timezone'] ?? 'Asia/Jakarta') === 'Asia/Jakarta' ? 'selected' : '' }}>
                                    Asia/Jakarta (WIB)</option>
                                <option value="Asia/Makassar"
                                    {{ ($systemSettings['timezone'] ?? '') === 'Asia/Makassar' ? 'selected' : '' }}>
                                    Asia/Makassar (WITA)</option>
                                <option value="Asia/Jayapura"
                                    {{ ($systemSettings['timezone'] ?? '') === 'Asia/Jayapura' ? 'selected' : '' }}>
                                    Asia/Jayapura (WIT)</option>
                            </select>
                        </div>

                        <!-- Currency -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Mata Uang
                            </label>
                            <input type="text" name="currency" value="{{ $systemSettings['currency'] ?? 'IDR' }}"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Currency Symbol -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Simbol Mata Uang
                            </label>
                            <input type="text" name="currency_symbol"
                                value="{{ $systemSettings['currency_symbol'] ?? 'Rp' }}"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- Items Per Page -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Item Per Halaman
                            </label>
                            <input type="number" name="items_per_page"
                                value="{{ $systemSettings['items_per_page'] ?? '10' }}" min="5" max="100"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                                Jumlah item yang ditampilkan per halaman di semua menu admin (5-100). Default: 10
                            </p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Date Format -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Format Tanggal
                            </label>
                            <select name="date_format"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                                <option value="d/m/Y"
                                    {{ ($systemSettings['date_format'] ?? 'd/m/Y') === 'd/m/Y' ? 'selected' : '' }}>
                                    DD/MM/YYYY</option>
                                <option value="Y-m-d"
                                    {{ ($systemSettings['date_format'] ?? '') === 'Y-m-d' ? 'selected' : '' }}>YYYY-MM-DD
                                </option>
                                <option value="d-m-Y"
                                    {{ ($systemSettings['date_format'] ?? '') === 'd-m-Y' ? 'selected' : '' }}>DD-MM-YYYY
                                </option>
                            </select>
                        </div>

                        <!-- Time Format -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Format Waktu
                            </label>
                            <select name="time_format"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                                <option value="H:i"
                                    {{ ($systemSettings['time_format'] ?? 'H:i') === 'H:i' ? 'selected' : '' }}>24 Jam
                                    (HH:MM)</option>
                                <option value="h:i A"
                                    {{ ($systemSettings['time_format'] ?? '') === 'h:i A' ? 'selected' : '' }}>12 Jam
                                    (HH:MM AM/PM)</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="mt-6 flex justify-end">
                    <button type="submit"
                        class="px-6 py-2 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-save mr-2"></i>Simpan Perubahan
                    </button>
                </div>
            </div>
        </form>
    </div>

    <script>
        function switchTab(tabName) {
            // Hide all tab contents
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.add('hidden');
            });

            // Remove active class from all tabs
            document.querySelectorAll('.tab-button').forEach(button => {
                button.classList.remove('border-blue-500', 'text-blue-600', 'dark:text-blue-400');
                button.classList.add('border-transparent', 'text-gray-500', 'dark:text-gray-400');
            });

            // Show selected tab content
            document.getElementById('content-' + tabName).classList.remove('hidden');

            // Add active class to selected tab
            const activeTab = document.getElementById('tab-' + tabName);
            activeTab.classList.remove('border-transparent', 'text-gray-500', 'dark:text-gray-400');
            activeTab.classList.add('border-blue-500', 'text-blue-600', 'dark:text-blue-400');
        }
    </script>
@endsection
