@extends('layouts.admin')

@section('title', 'Service Package')

@section('content')

    <!-- Notifikasi -->
    <x-admin-notification />

    <!-- Header -->
    <div class="mb-8">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">
            <div>
                <div class="flex items-center gap-3 mb-2">
                    <div>
                        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">
                            Service Package
                        </h1>
                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                            Kelola upah jasa per paket
                        </p>
                    </div>
                </div>
            </div>

            <a href="{{ route('admin.service-packages.create') }}"
                class="inline-flex items-center gap-2 px-5 py-2.5 rounded-lg
                       bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700
                       text-white text-sm font-semibold shadow-lg hover:shadow-xl
                       transition-all duration-200 transform hover:scale-105">
                <i class="fas fa-plus text-sm"></i>
                <span>Tambah Paket</span>
            </a>
        </div>
    </div>

    <!-- Content -->
    @if ($servicePackages->count())
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach ($servicePackages as $item)
                <div class="group relative bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700
                           rounded-lg overflow-hidden shadow-sm hover:shadow-xl
                           transition-shadow duration-200">
                    
                    <!-- Gradient Accent Bar -->
                    <div class="absolute top-0 left-0 right-0 h-1.5 
                               {{ $item->is_active ? 'bg-gradient-to-r from-green-400 to-emerald-500' : 'bg-gradient-to-r from-gray-300 to-gray-400' }}">
                    </div>

                    <!-- Card Content -->
                    <div class="p-6">
                        <!-- Header -->
                        <div class="flex items-start justify-between mb-5">
                            <div class="flex-1">
                                <div class="flex items-center gap-3 mb-2">
                                    <div class="w-10 h-10 bg-gradient-to-br from-blue-100 to-indigo-100 dark:from-blue-900/30 dark:to-indigo-900/30
                                               rounded-lg flex items-center justify-center">
                                        <i class="fas fa-box text-blue-600 dark:text-blue-400 text-sm"></i>
                                    </div>
                                    <h3 class="text-xl font-bold text-gray-900 dark:text-white">
                                        {{ $item->name }}
                                    </h3>
                                </div>
                                <div class="ml-12">
                                    <p class="text-2xl font-bold text-gray-900 dark:text-white mb-0.5">
                                        Rp {{ number_format($item->price, 0, ',', '.') }}
                                    </p>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">
                                        Harga per paket
                                    </p>
                                </div>
                            </div>

                            <!-- Status Badge -->
                            @if ($item->is_active)
                                <span class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-semibold
                                           bg-green-50 dark:bg-green-900/30 text-green-700 dark:text-green-300
                                           border border-green-200 dark:border-green-800">
                                    <span class="w-1.5 h-1.5 bg-green-500 rounded-full animate-pulse"></span>
                                    Aktif
                                </span>
                            @else
                                <span class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-semibold
                                           bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-400
                                           border border-gray-200 dark:border-gray-600">
                                    <span class="w-1.5 h-1.5 bg-gray-400 rounded-full"></span>
                                    Nonaktif
                                </span>
                            @endif
                        </div>

                        <!-- Description -->
                        <div class="mb-5">
                            <p class="text-sm text-gray-600 dark:text-gray-300 leading-relaxed line-clamp-2">
                                {{ $item->description ?: 'Tidak ada deskripsi paket.' }}
                            </p>
                        </div>

                        <!-- Usage Stats -->
                        <div class="mb-5 pb-5 border-b border-gray-100 dark:border-gray-700">
                            <div class="flex items-center gap-2.5 px-3 py-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                <div class="w-8 h-8 bg-indigo-100 dark:bg-indigo-900/30 rounded-lg flex items-center justify-center">
                                    <i class="fas fa-industry text-indigo-600 dark:text-indigo-400 text-xs"></i>
                                </div>
                                <div class="flex-1">
                                    <p class="text-xs text-gray-500 dark:text-gray-400">Digunakan di</p>
                                    <p class="text-sm font-semibold text-gray-900 dark:text-white">
                                        <span class="text-indigo-600 dark:text-indigo-400">{{ $item->productions_count ?? 0 }}</span> produksi
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="flex items-center justify-between gap-2">
                            <div class="flex items-center gap-2">
                                <!-- Detail Button -->
                                <a href="{{ route('admin.service-packages.show', $item->id) }}"
                                    class="flex items-center justify-center w-9 h-9 rounded-lg
                                           text-gray-600 dark:text-gray-300
                                           hover:bg-blue-50 dark:hover:bg-blue-900/20
                                           hover:text-blue-600 dark:hover:text-blue-400
                                           transition-all duration-200"
                                    title="Detail">
                                    <i class="fas fa-eye text-sm"></i>
                                </a>

                                <!-- Edit Button -->
                                <a href="{{ route('admin.service-packages.edit', $item->id) }}"
                                    class="flex items-center justify-center w-9 h-9 rounded-lg
                                           text-gray-600 dark:text-gray-300
                                           hover:bg-indigo-50 dark:hover:bg-indigo-900/20
                                           hover:text-indigo-600 dark:hover:text-indigo-400
                                           transition-all duration-200"
                                    title="Edit">
                                    <i class="fas fa-edit text-sm"></i>
                                </a>
                            </div>

                            <!-- Delete Button -->
                            <form action="{{ route('admin.service-packages.destroy', $item->id) }}" method="POST"
                                onsubmit="return confirm('Yakin ingin menghapus service package \"{{ $item->name }}\"?')"
                                class="inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit"
                                    class="flex items-center justify-center w-9 h-9 rounded-lg
                                           text-gray-600 dark:text-gray-300
                                           hover:bg-red-50 dark:hover:bg-red-900/20
                                           hover:text-red-600 dark:hover:text-red-400
                                           transition-all duration-200"
                                    title="Hapus">
                                    <i class="fas fa-trash text-sm"></i>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Pagination -->
        @if ($servicePackages->hasPages())
            <div class="mt-10 flex justify-center">
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-2">
                    {{ $servicePackages->onEachSide(1)->links() }}
                </div>
            </div>
        @endif
    @else
        <!-- Empty State -->
        <div class="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700
                   rounded-lg p-12 flex flex-col items-center justify-center text-center
                   shadow-sm">
            
            <!-- Icon -->
            <div class="relative mb-6">
                <div class="w-24 h-24 bg-gradient-to-br from-blue-100 to-indigo-100 dark:from-blue-900/30 dark:to-indigo-900/30
                           rounded-lg flex items-center justify-center mb-4 shadow-lg">
                    <i class="fas fa-box-open text-4xl text-blue-600 dark:text-blue-400"></i>
                </div>
                <div class="absolute -top-2 -right-2 w-8 h-8 bg-yellow-400 rounded-full flex items-center justify-center shadow-lg">
                    <i class="fas fa-exclamation text-yellow-800 text-xs"></i>
                </div>
            </div>

            <!-- Text -->
            <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">
                Belum ada Service Package
            </h3>
            <p class="text-sm text-gray-500 dark:text-gray-400 mb-8 max-w-md">
                Mulai dengan menambahkan paket jasa pertama untuk mengelola upah jasa per paket
            </p>

            <!-- CTA Button -->
            <a href="{{ route('admin.service-packages.create') }}"
                class="inline-flex items-center gap-2 px-6 py-3 rounded-lg
                       bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700
                       text-white text-sm font-semibold shadow-lg hover:shadow-xl
                       transition-all duration-200 transform hover:scale-105">
                <i class="fas fa-plus"></i>
                <span>Tambah Paket Pertama</span>
            </a>
        </div>
    @endif

@endsection
