@extends('layouts.admin')

@section('title', 'Tambah Service Package')

@section('content')
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.service-packages.index') }}"
               class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300
                      hover:text-gray-900 dark:hover:text-white
                      hover:bg-gray-100 dark:hover:bg-gray-700
                      rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white">
                Tambah Service Package
            </h1>
        </div>
    </div>

    <!-- Form Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
        <form action="{{ route('admin.service-packages.store') }}" method="POST" class="p-6 space-y-6">
            @csrf

            <!-- Nama Paket -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Nama Paket <span class="text-red-500">*</span>
                </label>
                <input type="text" name="name" required
                       value="{{ old('name') }}"
                       placeholder="Contoh: Paket Service Ringan"
                       class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg
                              focus:ring-2 focus:ring-blue-500 focus:border-blue-500
                              bg-white dark:bg-gray-700 text-gray-900 dark:text-white
                              transition duration-200 text-sm">
                @error('name')
                    <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                @enderror
            </div>

            <!-- Harga -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Harga (Rp) <span class="text-red-500">*</span>
                </label>
                <input type="number" name="price" min="0" required
                       value="{{ old('price') }}"
                       placeholder="Contoh: 150000"
                       class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg
                              focus:ring-2 focus:ring-blue-500 focus:border-blue-500
                              bg-white dark:bg-gray-700 text-gray-900 dark:text-white
                              transition duration-200 text-sm">
                @error('price')
                    <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                @enderror
            </div>

            <!-- Deskripsi -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Deskripsi
                </label>
                <textarea name="description" rows="4"
                          placeholder="Jelaskan isi dari service package ini..."
                          class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg
                                 focus:ring-2 focus:ring-blue-500 focus:border-blue-500
                                 bg-white dark:bg-gray-700 text-gray-900 dark:text-white
                                 transition duration-200 resize-none text-sm">{{ old('description') }}</textarea>
            </div>

            <!-- Status -->
            <div class="flex items-center">
                <input type="checkbox" name="is_active" value="1"
                       {{ old('is_active', true) ? 'checked' : '' }}
                       class="h-4 w-4 text-blue-600 focus:ring-blue-500
                              border-gray-300 dark:border-gray-600
                              rounded bg-white dark:bg-gray-700">
                <label class="ml-3 block text-sm font-medium text-gray-700 dark:text-gray-300">
                    Aktif
                </label>
            </div>

            <!-- Action Buttons -->
            <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200 dark:border-gray-700">
                <a href="{{ route('admin.service-packages.index') }}"
                   class="px-6 py-3 text-gray-600 dark:text-gray-300
                          border border-gray-300 dark:border-gray-600
                          rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700
                          transition-colors duration-200 font-medium">
                    Batal
                </a>

                <button type="submit"
                        class="px-6 py-3 bg-blue-500 hover:bg-blue-600
                               text-white font-medium rounded-lg
                               transition-colors duration-200
                               flex items-center space-x-2">
                    <i class="fas fa-save"></i>
                    <span>Simpan</span>
                </button>
            </div>
        </form>
    </div>
@endsection
