<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LAPORAN PEMBELIAN - {{ date('d M Y') }}</title>
    <style>
        @page {
            margin: 20mm;
            size: A4;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background-color: white;
            color: #1f2937;
            font-size: 11px;
            line-height: 1.4;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #1f2937;
            padding-bottom: 20px;
        }
        
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 5px;
            letter-spacing: 1px;
        }
        
        .company-address {
            font-size: 12px;
            color: #6b7280;
            margin-bottom: 10px;
        }
        
        .report-title {
            font-size: 18px;
            font-weight: bold;
            color: #1f2937;
            margin-top: 15px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .report-period {
            font-size: 12px;
            color: #6b7280;
            margin-top: 5px;
        }
        
        .info-section {
            margin-bottom: 25px;
            background: #f8fafc;
            padding: 15px;
            border-radius: 5px;
            border-left: 4px solid #10b981;
        }
        
        .info-grid {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }
        
        .info-row {
            display: table-row;
        }
        
        .info-label {
            display: table-cell;
            width: 30%;
            font-weight: bold;
            color: #374151;
            padding: 5px 0;
        }
        
        .info-value {
            display: table-cell;
            color: #1f2937;
            padding: 5px 0;
        }
        
        .summary-section {
            margin-bottom: 25px;
        }
        
        .summary-title {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 15px;
            text-transform: uppercase;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 5px;
        }
        
        .summary-grid {
            display: table;
            width: 100%;
            border-collapse: collapse;
        }
        
        .summary-row {
            display: table-row;
        }
        
        .summary-cell {
            display: table-cell;
            width: 25%;
            padding: 10px;
            text-align: center;
            border: 1px solid #d1d5db;
            background: #f9fafb;
        }
        
        .summary-cell.primary {
            background: #d1fae5;
            font-weight: bold;
        }
        
        .summary-label {
            font-size: 10px;
            color: #6b7280;
            text-transform: uppercase;
            margin-bottom: 5px;
        }
        
        .summary-value {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
        }
        
        .data-section {
            margin-bottom: 25px;
        }
        
        .data-title {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 15px;
            text-transform: uppercase;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 5px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 10px;
        }
        
        th {
            background: #374151;
            color: white;
            font-weight: bold;
            font-size: 10px;
            text-transform: uppercase;
            padding: 8px 6px;
            text-align: left;
            border: 1px solid #1f2937;
        }
        
        td {
            padding: 6px;
            border: 1px solid #d1d5db;
            font-size: 10px;
            vertical-align: top;
        }
        
        tr:nth-child(even) {
            background: #f9fafb;
        }
        
        tr:nth-child(odd) {
            background: white;
        }
        
        .type-badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .type-material {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .type-sparepart {
            background: #dcfce7;
            color: #166534;
        }
        
        .type-other {
            background: #f3e8ff;
            color: #7c3aed;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .font-bold {
            font-weight: bold;
        }
        
        .footer {
            margin-top: 30px;
            border-top: 2px solid #e5e7eb;
            padding-top: 15px;
            display: table;
            width: 100%;
        }
        
        .footer-left {
            display: table-cell;
            width: 50%;
            font-size: 10px;
            color: #6b7280;
        }
        
        .footer-right {
            display: table-cell;
            width: 50%;
            text-align: right;
            font-size: 10px;
            color: #6b7280;
        }
        
        .signature-section {
            margin-top: 40px;
            display: table;
            width: 100%;
        }
        
        .signature-left {
            display: table-cell;
            width: 50%;
            text-align: center;
        }
        
        .signature-right {
            display: table-cell;
            width: 50%;
            text-align: center;
        }
        
        .signature-line {
            border-bottom: 1px solid #374151;
            width: 200px;
            margin: 0 auto 5px auto;
            height: 40px;
        }
        
        .signature-label {
            font-size: 10px;
            color: #6b7280;
            margin-top: 5px;
        }
        
        .page-break {
            page-break-before: always;
        }
        
        .no-data {
            text-align: center;
            padding: 30px;
            color: #6b7280;
            font-style: italic;
        }
        
        .item-list {
            font-size: 9px;
            line-height: 1.3;
        }
        
        .item-name {
            font-weight: bold;
            color: #1f2937;
        }
        
        .item-detail {
            color: #6b7280;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="company-name">PT. POLJAM TECH</div>
        <div class="company-address">
            Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi
        </div>
        <div class="report-title">Laporan Pembelian</div>
        <div class="report-period">
            Periode: {{ request('start_date') ? \Carbon\Carbon::parse(request('start_date'))->format('d M Y') : 'Semua' }} 
            {{ request('end_date') ? ' - ' . \Carbon\Carbon::parse(request('end_date'))->format('d M Y') : '' }}
        </div>
    </div>

    <!-- Info Section -->
    <div class="info-section">
        <div class="info-grid">
            <div class="info-row">
                <div class="info-label">Tanggal Laporan:</div>
                <div class="info-value">{{ now()->format('d M Y H:i') }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Supplier Filter:</div>
                <div class="info-value">{{ request('supplier') ?: 'Semua Supplier' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Tipe Pembelian:</div>
                <div class="info-value">{{ request('purchase_type') ? ucfirst(request('purchase_type')) : 'Semua Tipe' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Total Data:</div>
                <div class="info-value">{{ $purchases->count() }} transaksi</div>
            </div>
        </div>
    </div>

    <!-- Summary Section -->
    <div class="summary-section">
        <div class="summary-title">Ringkasan Pembelian</div>
        <div class="summary-grid">
            <div class="summary-row">
                <div class="summary-cell primary">
                    <div class="summary-label">Total Pembelian</div>
                    <div class="summary-value">Rp {{ number_format($totalAmount, 0, ',', '.') }}</div>
                </div>
                <div class="summary-cell">
                    <div class="summary-label">Total Transaksi</div>
                    <div class="summary-value">{{ number_format($totalTransactions, 0, ',', '.') }}</div>
                </div>
                <div class="summary-cell">
                    <div class="summary-label">Total Item</div>
                    <div class="summary-value">{{ number_format($totalItems, 0, ',', '.') }}</div>
                </div>
                <div class="summary-cell">
                    <div class="summary-label">Rata-rata per Transaksi</div>
                    <div class="summary-value">Rp {{ $totalTransactions > 0 ? number_format($totalAmount / $totalTransactions, 0, ',', '.') : '0' }}</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Data Section -->
    <div class="data-section">
        <div class="data-title">Detail Transaksi Pembelian</div>
        
        @if($purchases->count() > 0)
        <table>
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 10%;">Tanggal</th>
                    <th style="width: 12%;">Kode Pembelian</th>
                    <th style="width: 15%;">Supplier</th>
                    <th style="width: 10%;">Tipe</th>
                    <th style="width: 25%;">Item Dibeli</th>
                    <th style="width: 12%;">Total Amount</th>
                    <th style="width: 11%;">Catatan</th>
                </tr>
            </thead>
            <tbody>
                @foreach($purchases as $index => $purchase)
                <tr>
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td>{{ $purchase->purchase_date ? $purchase->purchase_date->format('d/m/Y') : '-' }}</td>
                    <td class="text-center font-bold">{{ $purchase->purchase_code }}</td>
                    <td>{{ $purchase->supplier_name }}</td>
                    <td class="text-center">
                        <span class="type-badge {{ $purchase->purchase_type == 'material' ? 'type-material' : ($purchase->purchase_type == 'sparepart' ? 'type-sparepart' : 'type-other') }}">
                            {{ ucfirst($purchase->purchase_type) }}
                        </span>
                    </td>
                    <td>
                        @if($purchase->items && $purchase->items->count() > 0)
                            <div class="item-list">
                                @foreach($purchase->items as $item)
                                    <div>
                                        <span class="item-name">{{ $item->item_name ?? '-' }}</span>
                                        <span class="item-detail">({{ $item->quantity }} {{ $item->unit ?? 'pcs' }})</span>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <span class="text-center">-</span>
                        @endif
                    </td>
                    <td class="text-right font-bold">Rp {{ number_format($purchase->total_amount, 0, ',', '.') }}</td>
                    <td>{{ $purchase->notes ?? '-' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @else
        <div class="no-data">
            <p>Tidak ada data pembelian untuk periode yang dipilih.</p>
        </div>
        @endif
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="footer-left">
            <p><strong>PT. POLJAM TECH</strong></p>
            <p>Laporan ini dibuat secara otomatis oleh sistem</p>
        </div>
        <div class="footer-right">
            <p>Halaman 1 dari 1</p>
            <p>Dicetak pada: {{ now()->format('d M Y H:i') }}</p>
        </div>
    </div>

    <!-- Signature Section -->
    <div class="signature-section">
        <div class="signature-left">
            <div class="signature-line"></div>
            <div class="signature-label">Mengetahui,<br>Manager Pembelian</div>
        </div>
        <div class="signature-right">
            <div class="signature-line"></div>
            <div class="signature-label">Jakarta, {{ now()->format('d M Y') }}<br>Direktur</div>
        </div>
    </div>
</body>
</html>