<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LAPORAN KEUANGAN - {{ date('d M Y') }}</title>
    <style>
        @page {
            margin: 20mm;
            size: A4;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background-color: white;
            color: #1f2937;
            font-size: 11px;
            line-height: 1.4;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #1f2937;
            padding-bottom: 20px;
        }
        
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 5px;
            letter-spacing: 1px;
        }
        
        .company-address {
            font-size: 12px;
            color: #6b7280;
            margin-bottom: 10px;
        }
        
        .report-title {
            font-size: 18px;
            font-weight: bold;
            color: #1f2937;
            margin-top: 15px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .report-period {
            font-size: 12px;
            color: #6b7280;
            margin-top: 5px;
        }
        
        .info-section {
            margin-bottom: 25px;
            background: #f8fafc;
            padding: 15px;
            border-radius: 5px;
            border-left: 4px solid #3b82f6;
        }
        
        .info-grid {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }
        
        .info-row {
            display: table-row;
        }
        
        .info-label {
            display: table-cell;
            width: 30%;
            font-weight: bold;
            color: #374151;
            padding: 5px 0;
        }
        
        .info-value {
            display: table-cell;
            color: #1f2937;
            padding: 5px 0;
        }
        
        .summary-section {
            margin-bottom: 25px;
        }
        
        .summary-title {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 15px;
            text-transform: uppercase;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 5px;
        }
        
        .summary-grid {
            display: table;
            width: 100%;
            border-collapse: collapse;
        }
        
        .summary-row {
            display: table-row;
        }
        
        .summary-cell {
            display: table-cell;
            width: 25%;
            padding: 10px;
            text-align: center;
            border: 1px solid #d1d5db;
            background: #f9fafb;
        }
        
        .summary-cell.primary {
            background: #dbeafe;
            font-weight: bold;
        }
        
        .summary-cell.income {
            background: #dcfce7;
        }
        
        .summary-cell.expense {
            background: #fef2f2;
        }
        
        .summary-label {
            font-size: 10px;
            color: #6b7280;
            text-transform: uppercase;
            margin-bottom: 5px;
        }
        
        .summary-value {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
        }
        
        .data-section {
            margin-bottom: 25px;
        }
        
        .data-title {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 15px;
            text-transform: uppercase;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 5px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 10px;
        }
        
        th {
            background: #374151;
            color: white;
            font-weight: bold;
            font-size: 10px;
            text-transform: uppercase;
            padding: 8px 6px;
            text-align: left;
            border: 1px solid #1f2937;
        }
        
        td {
            padding: 6px;
            border: 1px solid #d1d5db;
            font-size: 10px;
            vertical-align: top;
        }
        
        tr:nth-child(even) {
            background: #f9fafb;
        }
        
        tr:nth-child(odd) {
            background: white;
        }
        
        .status-badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .status-income {
            background: #dcfce7;
            color: #166534;
        }
        
        .status-expense {
            background: #fef2f2;
            color: #991b1b;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .font-bold {
            font-weight: bold;
        }
        
        .footer {
            margin-top: 30px;
            border-top: 2px solid #e5e7eb;
            padding-top: 15px;
            display: table;
            width: 100%;
        }
        
        .footer-left {
            display: table-cell;
            width: 50%;
            font-size: 10px;
            color: #6b7280;
        }
        
        .footer-right {
            display: table-cell;
            width: 50%;
            text-align: right;
            font-size: 10px;
            color: #6b7280;
        }
        
        .signature-section {
            margin-top: 40px;
            display: table;
            width: 100%;
        }
        
        .signature-left {
            display: table-cell;
            width: 50%;
            text-align: center;
        }
        
        .signature-right {
            display: table-cell;
            width: 50%;
            text-align: center;
        }
        
        .signature-line {
            border-bottom: 1px solid #374151;
            width: 200px;
            margin: 0 auto 5px auto;
            height: 40px;
        }
        
        .signature-label {
            font-size: 10px;
            color: #6b7280;
            margin-top: 5px;
        }
        
        .no-data {
            text-align: center;
            padding: 30px;
            color: #6b7280;
            font-style: italic;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="company-name">PT. POLJAM TECH</div>
        <div class="company-address">
            Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi
        </div>
        <div class="report-title">Laporan Jurnal Umum</div>
        <div class="report-period">
            Periode: {{ request('start_date') ? \Carbon\Carbon::parse(request('start_date'))->format('d M Y') : 'Semua' }} 
            {{ request('end_date') ? ' - ' . \Carbon\Carbon::parse(request('end_date'))->format('d M Y') : '' }}
        </div>
    </div>

    <!-- Info Section -->
    <div class="info-section">
        <div class="info-grid">
            <div class="info-row">
                <div class="info-label">Tanggal Laporan:</div>
                <div class="info-value">{{ now()->format('d M Y H:i') }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Total Data:</div>
                <div class="info-value">{{ $entries->count() }} entries</div>
            </div>
        </div>
    </div>

    <!-- Summary Section -->
    <div class="summary-section">
        <div class="summary-title">Ringkasan Jurnal</div>
        <div class="summary-grid">
            <div class="summary-row">
                <div class="summary-cell income">
                    <div class="summary-label">Total Debit</div>
                    <div class="summary-value">Rp {{ number_format($totalDebit, 0, ',', '.') }}</div>
                </div>
                <div class="summary-cell expense">
                    <div class="summary-label">Total Kredit</div>
                    <div class="summary-value">Rp {{ number_format($totalKredit, 0, ',', '.') }}</div>
                </div>
                <div class="summary-cell primary">
                    <div class="summary-label">Selisih</div>
                    <div class="summary-value">Rp {{ number_format($totalDebit - $totalKredit, 0, ',', '.') }}</div>
                </div>
                <div class="summary-cell">
                    <div class="summary-label">Total Entries</div>
                    <div class="summary-value">{{ number_format($totalEntries, 0, ',', '.') }}</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Data Section -->
    <div class="data-section">
        <div class="data-title">Detail Jurnal Umum</div>
        
        @if($entries->count() > 0)
        <table>
            <thead>
                <tr>
                    <th style="width: 3%;">No</th>
                    <th style="width: 8%;">Tanggal</th>
                    <th style="width: 10%;">Bukti</th>
                    <th style="width: 20%;">Keterangan</th>
                    <th style="width: 12%;">Nama Perkiraan</th>
                    <th style="width: 8%;">Kd_Perk</th>
                    <th style="width: 10%;">Customer</th>
                    <th style="width: 7%;">Kode</th>
                    <th style="width: 10%;">Nama Proyek</th>
                    <th style="width: 10%;">DEBIT</th>
                    <th style="width: 10%;">KREDIT</th>
                </tr>
            </thead>
            <tbody>
                @foreach($entries as $index => $entry)
                <tr>
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td>{{ $entry->tanggal_transaksi ? $entry->tanggal_transaksi->format('d/m/Y') : '-' }}</td>
                    <td>{{ $entry->bukti_transaksi ?? '-' }}</td>
                    <td>{{ $entry->keterangan ?? '-' }}</td>
                    <td>{{ $entry->nama_perkiraan ?? '-' }}</td>
                    <td class="text-center">{{ $entry->kd_perk ?? '-' }}</td>
                    <td>{{ $entry->customer ?? '-' }}</td>
                    <td class="text-center">{{ $entry->kode ?? '-' }}</td>
                    <td>{{ $entry->nama_proyek ?? '-' }}</td>
                    <td class="text-right font-bold">{{ $entry->debit ? 'Rp ' . number_format($entry->debit, 0, ',', '.') : '-' }}</td>
                    <td class="text-right font-bold">{{ $entry->kredit ? 'Rp ' . number_format($entry->kredit, 0, ',', '.') : '-' }}</td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr style="background: #e5e7eb; font-weight: bold;">
                    <td colspan="9" class="text-right">TOTAL:</td>
                    <td class="text-right">Rp {{ number_format($totalDebit, 0, ',', '.') }}</td>
                    <td class="text-right">Rp {{ number_format($totalKredit, 0, ',', '.') }}</td>
                </tr>
            </tfoot>
        </table>
        @else
        <div class="no-data">
            <p>Tidak ada data jurnal untuk periode yang dipilih.</p>
        </div>
        @endif
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="footer-left">
            <p><strong>PT. POLJAM TECH</strong></p>
            <p>Laporan ini dibuat secara otomatis oleh sistem</p>
        </div>
        <div class="footer-right">
            <p>Halaman 1 dari 1</p>
            <p>Dicetak pada: {{ now()->format('d M Y H:i') }}</p>
        </div>
    </div>

    <!-- Signature Section -->
    <div class="signature-section">
        <div class="signature-left">
            <div class="signature-line"></div>
            <div class="signature-label">Mengetahui,<br>Manager Keuangan</div>
        </div>
        <div class="signature-right">
            <div class="signature-line"></div>
            <div class="signature-label">Jakarta, {{ now()->format('d M Y') }}<br>Direktur</div>
        </div>
    </div>
</body>
</html>

