@extends('layouts.admin')

@section('title', 'Catatan Piutang')

@section('content')
    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Catatan Piutang</h1>
        <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">Kelola pembayaran DP dan piutang pelanggan</p>
    </div>

    <!-- Notifikasi Modern -->
    <x-admin-notification />

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Piutang</p>
                    <h2 class="text-xl font-bold text-gray-800 dark:text-white">{{ $stats['total'] }}</h2>
                </div>
                <div class="p-2.5 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-file-invoice-dollar text-blue-600 dark:text-blue-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Belum Bayar</p>
                    <h2 class="text-xl font-bold text-yellow-600 dark:text-yellow-400">{{ $stats['pending'] }}</h2>
                </div>
                <div class="p-2.5 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg">
                    <i class="fas fa-clock text-yellow-600 dark:text-yellow-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Bayar Sebagian</p>
                    <h2 class="text-xl font-bold text-blue-600 dark:text-blue-400">{{ $stats['partial'] }}</h2>
                </div>
                <div class="p-2.5 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-percentage text-blue-600 dark:text-blue-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Jatuh Tempo</p>
                    <h2 class="text-xl font-bold text-red-600 dark:text-red-400">{{ $stats['overdue'] }}</h2>
                </div>
                <div class="p-2.5 bg-red-100 dark:bg-red-900/40 rounded-lg">
                    <i class="fas fa-exclamation-triangle text-red-600 dark:text-red-400 text-lg"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-4">
        <form method="GET" action="{{ route('admin.receivables.index') }}" id="filterForm" class="space-y-4">
            <!-- Search Bar -->
            <div class="relative flex-1">
                <input type="text" name="search" id="searchInput" value="{{ request('search') }}" placeholder="Cari no. piutang, customer, produk..."
                    class="form-input-search" />
                <i class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                @if (request('search'))
                    <button type="button" onclick="clearFilter('search')"
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 hover:text-gray-600 dark:hover:text-gray-300">
                        <i class="fas fa-times"></i>
                    </button>
                @endif
            </div>

            <!-- Filter Row -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-4">
                <!-- Status Pembayaran -->
                <div class="relative">
                    <select name="payment_status" id="paymentStatusFilter" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Status Pembayaran</option>
                        <option value="pending" {{ request('payment_status') == 'pending' ? 'selected' : '' }}>Belum Bayar</option>
                        <option value="partial" {{ request('payment_status') == 'partial' ? 'selected' : '' }}>Bayar Sebagian</option>
                        <option value="paid" {{ request('payment_status') == 'paid' ? 'selected' : '' }}>Lunas</option>
                        <option value="overdue" {{ request('payment_status') == 'overdue' ? 'selected' : '' }}>Jatuh Tempo</option>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <!-- Status -->
                <div class="relative">
                    <select name="status" id="statusFilter" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Status</option>
                        <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Aktif</option>
                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Selesai</option>
                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Dibatalkan</option>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <!-- Jatuh Tempo Dari -->
                <div class="relative">
                    <input type="date" name="due_date_from" id="dueDateFromInput" value="{{ request('due_date_from') }}" onchange="submitFilter()"
                        class="w-full pl-10 pr-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200 text-sm h-10">
                    <i class="fas fa-calendar-alt absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                </div>

                <!-- Jatuh Tempo Sampai -->
                <div class="relative">
                    <input type="date" name="due_date_to" id="dueDateToInput" value="{{ request('due_date_to') }}" onchange="submitFilter()"
                        class="w-full pl-10 pr-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200 text-sm h-10">
                    <i class="fas fa-calendar-alt absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-center gap-2">
                    <a href="{{ route('admin.receivables.export', request()->query()) }}"
                        class="flex-1 flex items-center justify-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 h-10 text-sm">
                        <i class="fas fa-download mr-2 text-xs"></i>
                        <span>Export Excel</span>
                    </a>
                    @if (request()->hasAny(['search', 'payment_status', 'status', 'due_date_from', 'due_date_to']))
                        <a href="{{ route('admin.receivables.index') }}"
                            class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                            title="Reset filter">
                            <i class="fas fa-redo text-sm"></i>
                        </a>
                    @endif
                </div>
            </div>
        </form>
    </div>

    <!-- Active Filters Info -->
    @if (request()->hasAny(['search', 'payment_status', 'status', 'due_date_from', 'due_date_to']))
        <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4">
            <div class="flex flex-wrap items-center gap-2">
                <span class="text-sm font-medium text-blue-800 dark:text-blue-200">Filter Aktif:</span>
                
                @if (request('search'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-200">
                        <i class="fas fa-search mr-1"></i>
                        Pencarian: "{{ request('search') }}"
                        <button onclick="clearFilter('search')" class="ml-2 hover:text-blue-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                @if (request('payment_status'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-200">
                        <i class="fas fa-flag mr-1"></i>
                        Status Pembayaran: {{ request('payment_status') == 'pending' ? 'Belum Bayar' : (request('payment_status') == 'partial' ? 'Bayar Sebagian' : (request('payment_status') == 'paid' ? 'Lunas' : 'Jatuh Tempo')) }}
                        <button onclick="clearFilter('payment_status')" class="ml-2 hover:text-green-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                @if (request('status'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800 dark:bg-purple-800 dark:text-purple-200">
                        <i class="fas fa-info-circle mr-1"></i>
                        Status: {{ ucfirst(request('status')) }}
                        <button onclick="clearFilter('status')" class="ml-2 hover:text-purple-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                @if (request('due_date_from') || request('due_date_to'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800 dark:bg-orange-800 dark:text-orange-200">
                        <i class="fas fa-calendar-alt mr-1"></i>
                        Jatuh Tempo: {{ request('due_date_from') ? date('d M Y', strtotime(request('due_date_from'))) : 'Awal' }} - {{ request('due_date_to') ? date('d M Y', strtotime(request('due_date_to'))) : 'Akhir' }}
                        <button onclick="clearDateFilter()" class="ml-2 hover:text-orange-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                <button onclick="clearAllFilters()" 
                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200 hover:bg-red-200 dark:hover:bg-red-700 transition-colors">
                    <i class="fas fa-times-circle mr-1"></i>
                    Hapus Semua Filter
                </button>
            </div>
        </div>
    @endif

    <!-- Table Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="overflow-x-auto custom-scrollbar">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">No. Piutang</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Customer</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Produk</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Total</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Dibayar</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Sisa</th>
                        <th class="px-6 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Jatuh Tempo</th>
                        <th class="px-6 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse($receivables as $receivable)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-semibold text-gray-900 dark:text-white">{{ $receivable->receivable_number }}</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">{{ $receivable->created_at->format('d/m/Y') }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($receivable->order)
                                    <div class="text-sm font-medium text-gray-900 dark:text-white">{{ $receivable->order->customer_name ?? '-' }}</div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400">{{ $receivable->order->customer_email ?? '-' }}</div>
                                @else
                                    <span class="text-xs text-gray-400 dark:text-gray-500">Order tidak ditemukan</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($receivable->order && $receivable->order->product)
                                    <div class="text-sm font-medium text-gray-900 dark:text-white">{{ $receivable->order->product->product_title ?? '-' }}</div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400">Qty: {{ $receivable->order->quantity ?? '-' }}</div>
                                @else
                                    <span class="text-xs text-gray-400 dark:text-gray-500">Produk tidak ditemukan</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right">
                                <div class="text-sm font-semibold text-gray-900 dark:text-white">Rp {{ number_format($receivable->total_amount, 0, ',', '.') }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right">
                                <div class="text-sm font-medium text-green-600 dark:text-green-400">Rp {{ number_format($receivable->paid_amount, 0, ',', '.') }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right">
                                <div class="text-sm font-medium text-red-600 dark:text-red-400">Rp {{ number_format($receivable->remaining_amount, 0, ',', '.') }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                @if($receivable->payment_status == 'pending')
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium bg-yellow-100 dark:bg-yellow-900/40 text-yellow-700 dark:text-yellow-300">
                                        {{ $receivable->payment_status_label ?? 'Belum Bayar' }}
                                    </span>
                                @elseif($receivable->payment_status == 'partial')
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300">
                                        {{ $receivable->payment_status_label ?? 'Bayar Sebagian' }}
                                    </span>
                                @elseif($receivable->payment_status == 'paid')
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300">
                                        {{ $receivable->payment_status_label ?? 'Lunas' }}
                                    </span>
                                @elseif($receivable->payment_status == 'overdue')
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300">
                                        {{ $receivable->payment_status_label ?? 'Jatuh Tempo' }}
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($receivable->due_date)
                                    <div class="text-sm text-gray-900 dark:text-white">{{ $receivable->due_date->format('d/m/Y') }}</div>
                                    @if($receivable->isOverdue())
                                        <div class="text-xs text-red-600 dark:text-red-400">Terlambat</div>
                                    @endif
                                @else
                                    <span class="text-xs text-gray-400 dark:text-gray-500">-</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                <div class="flex justify-center items-center space-x-2">
                                    <a href="{{ route('admin.receivables.show', $receivable) }}" 
                                       class="inline-flex items-center justify-center w-8 h-8 text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded transition-colors duration-200"
                                       title="Detail">
                                        <i class="fas fa-eye text-sm"></i>
                                    </a>
                                    @if($receivable->payment_status != 'paid')
                                        <a href="{{ route('admin.receivables.create-payment', $receivable) }}" 
                                           class="inline-flex items-center justify-center w-8 h-8 text-green-600 dark:text-green-400 hover:text-green-700 dark:hover:text-green-300 hover:bg-green-50 dark:hover:bg-green-900/20 rounded transition-colors duration-200"
                                           title="Bayar">
                                            <i class="fas fa-plus text-sm"></i>
                                        </a>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3">
                                        <i class="fas fa-file-invoice-dollar text-3xl text-gray-400 dark:text-gray-500"></i>
                                    </div>
                                    <p class="text-gray-500 dark:text-gray-400 font-medium mb-1">Tidak ada data piutang</p>
                                    <p class="text-gray-400 dark:text-gray-500 text-sm">Belum ada catatan piutang yang ditemukan.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <!-- Pagination -->
        @if ($receivables->hasPages())
            <div
                class="flex items-center justify-between px-4 py-3 border-t border-gray-200 dark:border-gray-700 text-sm bg-gray-50 dark:bg-gray-800">
        
                <!-- Info -->
                <div class="text-gray-600 dark:text-gray-400">
                    Menampilkan
                    <span class="font-medium">{{ $receivables->firstItem() }}</span>
                    –
                    <span class="font-medium">{{ $receivables->lastItem() }}</span>
                    dari
                    <span class="font-medium">{{ $receivables->total() }}</span>
                    data piutang
                </div>
        
                <!-- Pagination -->
                <div>
                    {{ $receivables->onEachSide(1)->links() }}
                </div>
            </div>
        @endif

    </div>

    <script>
        // Submit filter dengan parameter yang bersih
        function submitFilter() {
            const params = new URLSearchParams();
            
            // Ambil nilai dari setiap input/select
            const search = document.getElementById('searchInput')?.value?.trim() || '';
            const paymentStatus = document.getElementById('paymentStatusFilter')?.value || '';
            const status = document.getElementById('statusFilter')?.value || '';
            const dueDateFrom = document.getElementById('dueDateFromInput')?.value || '';
            const dueDateTo = document.getElementById('dueDateToInput')?.value || '';
            
            // Hanya tambahkan parameter yang memiliki nilai
            if (search) {
                params.append('search', search);
            }
            if (paymentStatus) {
                params.append('payment_status', paymentStatus);
            }
            if (status) {
                params.append('status', status);
            }
            if (dueDateFrom) {
                params.append('due_date_from', dueDateFrom);
            }
            if (dueDateTo) {
                params.append('due_date_to', dueDateTo);
            }
            
            // Redirect dengan parameter yang bersih
            const url = '{{ route("admin.receivables.index") }}' + (params.toString() ? '?' + params.toString() : '');
            window.location.href = url;
        }

        // Clear individual filter
        function clearFilter(filterName) {
            const url = new URL(window.location);
            url.searchParams.delete(filterName);
            window.location.href = url.toString();
        }

        // Clear date filter
        function clearDateFilter() {
            const url = new URL(window.location);
            url.searchParams.delete('due_date_from');
            url.searchParams.delete('due_date_to');
            window.location.href = url.toString();
        }

        // Clear all filters
        function clearAllFilters() {
            window.location.href = '{{ route("admin.receivables.index") }}';
        }

        // Submit form search dengan Enter
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            if (searchInput) {
                searchInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                        submitFilter();
                    }
                });
            }
        });
    </script>

    <style>
        /* Konsisten Style untuk semua Index Pages */
        .form-input-search,
        .form-select {
            height: 40px !important;
            min-height: 40px !important;
            max-height: 40px !important;
            box-sizing: border-box !important;
            line-height: 1.5 !important;
            padding: 0 2.5rem 0 2.5rem !important;
            margin: 0 !important;
        }
        
        .form-input-search {
            width: 100%;
            padding-left: 2.5rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            transition: all 0.2s;
        }
        
        .dark .form-input-search {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-input-search:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
        
        .form-select {
            width: 100%;
            padding-left: 1rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            transition: all 0.2s;
        }
        
        .dark .form-select {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-select:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
    </style>
@endsection
